/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.IPAcl;

import com.sun.jmx.snmp.IPAcl.PrincipalImpl;
import com.sun.jmx.trace.Trace;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Vector;

class NetMaskImpl
extends PrincipalImpl
implements Group,
Serializable {
    protected byte[] subnet = null;
    protected int prefix = -1;
    String dbgTag = "NetMaskImpl";

    public NetMaskImpl() throws UnknownHostException {
    }

    private byte[] extractSubNet(byte[] byArray) {
        int n;
        int n2;
        int n3;
        int n4 = byArray.length;
        byte[] byArray2 = null;
        if (this.isDebugOn()) {
            this.debug("extractSubNet", "BINARY ARRAY :");
            StringBuffer stringBuffer = new StringBuffer();
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuffer.append((byArray[n3] & 0xFF) + ":");
            }
            this.debug("extractSubNet", stringBuffer.toString());
        }
        if ((n2 = this.prefix / 8) == n4) {
            if (this.isDebugOn()) {
                this.debug("extractSubNet", " The mask is the complete address, strange..." + n4);
            }
            byArray2 = byArray;
            return byArray2;
        }
        if (n2 > n4) {
            if (this.isDebugOn()) {
                this.debug("extractSubNet", " The number of covered byte is longer than the address. BUG");
            }
            throw new IllegalArgumentException("The number of covered byte is longer than the address.");
        }
        n3 = n2;
        if (this.isDebugOn()) {
            this.debug("extractSubNet", " Partialy covered index : " + n3);
        }
        byte by = byArray[n3];
        if (this.isDebugOn()) {
            this.debug("extractSubNet", " Partialy covered byte : " + by);
        }
        int n5 = this.prefix % 8;
        int n6 = 0;
        n6 = n5 == 0 ? n3 : n3 + 1;
        if (this.isDebugOn()) {
            this.debug("extractSubNet", " Remains : " + n5);
        }
        byte by2 = 0;
        for (n = 0; n < n5; ++n) {
            by2 = (byte)(by2 | 1 << 7 - n);
        }
        if (this.isDebugOn()) {
            this.debug("extractSubNet", "Mask value" + (by2 & 0xFF));
        }
        n = (byte)(by & by2);
        if (this.isDebugOn()) {
            this.debug("extractSubNet", "Masked byte :" + (n & 0xFF));
        }
        byArray2 = new byte[n6];
        if (this.isDebugOn()) {
            this.debug("extractSubNet", "Resulting subnet : ");
        }
        for (int i = 0; i < n3; ++i) {
            byArray2[i] = byArray[i];
            if (!this.isDebugOn()) continue;
            this.debug("extractSubNet", (byArray2[i] & 0xFF) + ":");
        }
        if (n5 != 0) {
            byArray2[n3] = n;
            if (this.isDebugOn()) {
                this.debug("extractSubNet", " Last subnet byte : " + (byArray2[n3] & 0xFF));
            }
        }
        return byArray2;
    }

    public NetMaskImpl(String string, int n) throws UnknownHostException {
        super(string);
        this.prefix = n;
        this.subnet = this.extractSubNet(this.getAddress().getAddress());
    }

    public boolean addMember(Principal principal) {
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof PrincipalImpl || object instanceof NetMaskImpl) {
            PrincipalImpl principalImpl = (PrincipalImpl)object;
            InetAddress inetAddress = principalImpl.getAddress();
            if (this.isDebugOn()) {
                this.debug("equals", "Received Address : " + inetAddress);
            }
            byte[] byArray = inetAddress.getAddress();
            for (int i = 0; i < this.subnet.length; ++i) {
                if (this.isDebugOn()) {
                    this.debug("equals", "(recAddr[i]) :" + (byArray[i] & 0xFF));
                    this.debug("equals", "(recAddr[i] & subnet[i]) :" + (byArray[i] & this.subnet[i] & 0xFF) + "subnet[i] :" + (this.subnet[i] & 0xFF));
                }
                if ((byArray[i] & this.subnet[i]) == this.subnet[i]) continue;
                if (this.isDebugOn()) {
                    this.debug("equals", "FALSE");
                }
                return false;
            }
            if (this.isDebugOn()) {
                this.debug("equals", "TRUE");
            }
            return true;
        }
        return false;
    }

    public boolean isMember(Principal principal) {
        return (((Object)principal).hashCode() & super.hashCode()) == ((Object)principal).hashCode();
    }

    public Enumeration members() {
        Vector<NetMaskImpl> vector = new Vector<NetMaskImpl>(1);
        vector.addElement(this);
        return vector.elements();
    }

    public boolean removeMember(Principal principal) {
        return true;
    }

    public String toString() {
        return "NetMaskImpl :" + super.getAddress().toString() + "/" + this.prefix;
    }

    boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)512);
    }

    void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)512, (String)string, (String)string2, (String)string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)512);
    }

    void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)512, (String)string, (String)string2, (String)string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send((int)2, (int)512, (String)string, (String)string2, (Throwable)throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

