/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.snmp.daemon.SendQ;
import com.sun.jmx.snmp.daemon.SnmpInformRequest;
import com.sun.jmx.snmp.daemon.SnmpSendServer;
import com.sun.jmx.snmp.daemon.SnmpTimerServer;
import com.sun.jmx.snmp.daemon.WaitQ;
import com.sun.jmx.trace.Trace;
import java.io.Serializable;
import java.util.Vector;

final class SnmpQManager
implements Serializable {
    private SendQ newq = new SendQ(20, 5);
    private WaitQ waitq = new WaitQ(20, 5);
    private ThreadGroup queueThreadGroup = new ThreadGroup("Qmanager Thread Group");
    private Thread requestQThread = null;
    private Thread timerQThread = null;
    static String dbgTag = "SnmpQManager";

    SnmpQManager() {
        this.startQThreads();
    }

    public void startQThreads() {
        if (this.timerQThread == null || !this.timerQThread.isAlive()) {
            this.timerQThread = new SnmpTimerServer(this.queueThreadGroup, this);
        }
        if (this.requestQThread == null || !this.requestQThread.isAlive()) {
            this.requestQThread = new SnmpSendServer(this.queueThreadGroup, this);
        }
    }

    public void stopQThreads() {
        ((SnmpTimerServer)this.timerQThread).isBeingDestroyed = true;
        this.waitq.isBeingDestroyed = true;
        ((SnmpSendServer)this.requestQThread).isBeingDestroyed = true;
        this.newq.isBeingDestroyed = true;
        if (this.timerQThread != null && this.timerQThread.isAlive()) {
            ((SnmpTimerServer)this.timerQThread).stopTimerServer();
        }
        this.waitq = null;
        this.timerQThread = null;
        if (this.requestQThread != null && this.requestQThread.isAlive()) {
            ((SnmpSendServer)this.requestQThread).stopSendServer();
        }
        this.newq = null;
        this.requestQThread = null;
    }

    public void addRequest(SnmpInformRequest snmpInformRequest) {
        this.newq.addRequest(snmpInformRequest);
    }

    public void addWaiting(SnmpInformRequest snmpInformRequest) {
        this.waitq.addWaiting(snmpInformRequest);
    }

    public Vector getAllOutstandingRequest(long l) {
        return this.newq.getAllOutstandingRequest(l);
    }

    public SnmpInformRequest getTimeoutRequests() {
        return this.waitq.getTimeoutRequests();
    }

    public void removeRequest(SnmpInformRequest snmpInformRequest) {
        this.newq.removeElement(snmpInformRequest);
        this.waitq.removeElement(snmpInformRequest);
    }

    public SnmpInformRequest removeRequest(long l) {
        SnmpInformRequest snmpInformRequest = null;
        snmpInformRequest = this.newq.removeRequest(l);
        if (snmpInformRequest == null) {
            snmpInformRequest = this.waitq.removeRequest(l);
        }
        return snmpInformRequest;
    }

    static boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)256);
    }

    static void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)256, (String)string, (String)string2, (String)string3);
    }

    static void trace(String string, String string2) {
        SnmpQManager.trace(dbgTag, string, string2);
    }

    static boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)256);
    }

    static void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)256, (String)string, (String)string2, (String)string3);
    }

    static void debug(String string, String string2, Throwable throwable) {
        Trace.send((int)2, (int)256, (String)string, (String)string2, (Throwable)throwable);
    }

    static void debug(String string, String string2) {
        SnmpQManager.debug(dbgTag, string, string2);
    }

    static void debug(String string, Throwable throwable) {
        SnmpQManager.debug(dbgTag, string, throwable);
    }
}

