/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.snmp.SnmpMessage;
import com.sun.jmx.snmp.SnmpPduFactory;
import com.sun.jmx.snmp.SnmpPduPacket;
import com.sun.jmx.snmp.SnmpPduRequest;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServer;
import com.sun.jmx.snmp.daemon.SnmpInformRequest;
import com.sun.jmx.snmp.daemon.SnmpQManager;
import com.sun.jmx.trace.Trace;
import java.net.DatagramPacket;

class SnmpResponseHandler {
    SnmpAdaptorServer adaptor = null;
    SnmpQManager snmpq = null;
    String dbgTag = "SnmpResponseHandler";

    public SnmpResponseHandler(SnmpAdaptorServer snmpAdaptorServer, SnmpQManager snmpQManager) {
        this.adaptor = snmpAdaptorServer;
        this.snmpq = snmpQManager;
    }

    public synchronized void processDatagram(DatagramPacket datagramPacket) {
        block15: {
            byte[] byArray = datagramPacket.getData();
            int n = datagramPacket.getLength();
            if (this.isTraceOn()) {
                this.trace("processDatagram", "Received from " + datagramPacket.getAddress().toString() + " Length = " + n + "\nDump : \n" + SnmpMessage.dumpHexBuffer(byArray, 0, n));
            }
            try {
                SnmpMessage snmpMessage = new SnmpMessage();
                snmpMessage.decodeMessage(byArray, n);
                snmpMessage.address = datagramPacket.getAddress();
                snmpMessage.port = datagramPacket.getPort();
                SnmpPduFactory snmpPduFactory = this.adaptor.getPduFactory();
                if (snmpPduFactory == null) {
                    if (this.isDebugOn()) {
                        this.debug("processDatagram", "Dropping packet. Unable to find the pdu factory of the SNMP adaptor server");
                    }
                } else {
                    SnmpPduPacket snmpPduPacket = (SnmpPduPacket)snmpPduFactory.decodeSnmpPdu(snmpMessage);
                    if (snmpPduPacket == null) {
                        if (this.isDebugOn()) {
                            this.debug("processDatagram", "Dropping packet. Pdu factory returned a null value");
                        }
                    } else if (snmpPduPacket instanceof SnmpPduRequest) {
                        SnmpPduRequest snmpPduRequest = (SnmpPduRequest)snmpPduPacket;
                        SnmpInformRequest snmpInformRequest = this.snmpq.removeRequest(snmpPduRequest.requestId);
                        if (snmpInformRequest != null) {
                            snmpInformRequest.invokeOnResponse(snmpPduRequest);
                        } else if (this.isDebugOn()) {
                            this.debug("processDatagram", "Dropping packet. Unable to find corresponding for InformRequestId = " + snmpPduRequest.requestId);
                        }
                    } else if (this.isDebugOn()) {
                        this.debug("processDatagram", "Dropping packet. The packet does not contain an inform response");
                    }
                    snmpPduPacket = null;
                }
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block15;
                this.debug("processDatagram", "Exception while processsing");
                this.debug("processDatagram", exception);
            }
        }
    }

    boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)256);
    }

    void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)256, (String)string, (String)string2, (String)string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)256);
    }

    void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)256, (String)string, (String)string2, (String)string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send((int)2, (int)256, (String)string, (String)string2, (Throwable)throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

