/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.snmp.daemon.SnmpInformRequest;
import com.sun.jmx.snmp.daemon.SnmpQManager;
import com.sun.jmx.trace.Trace;

final class SnmpTimerServer
extends Thread {
    private SnmpInformRequest req = null;
    SnmpQManager snmpq = null;
    String dbgTag = "SnmpTimerServer";
    boolean isBeingDestroyed = false;

    public SnmpTimerServer(ThreadGroup threadGroup, SnmpQManager snmpQManager) {
        super(threadGroup, "SnmpTimerServer");
        this.setName(this.dbgTag);
        this.snmpq = snmpQManager;
        this.start();
    }

    public synchronized void stopTimerServer() {
        if (this.isAlive()) {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        Thread.currentThread().setPriority(5);
        if (this.isTraceOn()) {
            this.trace("run", "Timer Thread started");
        }
        while (true) {
            try {
                do {
                    if (this.isTraceOn()) {
                        this.trace("run", "Blocking for inform requests");
                    }
                    if (this.req == null) {
                        this.req = this.snmpq.getTimeoutRequests();
                    }
                    if (this.req == null || !this.req.inProgress()) continue;
                    if (this.isTraceOn()) {
                        this.trace("run", "Handle timeout inform request " + this.req.getRequestId());
                    }
                    this.req.action();
                    this.req = null;
                } while (!this.isBeingDestroyed);
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) continue;
                this.debug("run", exception.getMessage());
                continue;
            }
            catch (ThreadDeath threadDeath) {
                if (this.isDebugOn()) {
                    this.debug("run", "Timer server unexpectedly shutting down");
                    this.debug("run", threadDeath);
                }
                throw threadDeath;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (this.isDebugOn()) {
                    this.debug("run", "Received OutOfMemory");
                }
                SnmpTimerServer.yield();
                continue;
            }
            catch (Error error) {
                if (!this.isDebugOn()) continue;
                this.debug("run", "Received Internal error");
                this.debug("run", error);
                continue;
            }
            break;
        }
    }

    boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)256);
    }

    void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)256, (String)string, (String)string2, (String)string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)256);
    }

    void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)256, (String)string, (String)string2, (String)string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send((int)2, (int)256, (String)string, (String)string2, (Throwable)throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

