/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.streaming;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.streaming.XMLReaderException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.InputSource;

public abstract class XMLStreamReaderFactory {
    @NotNull
    private static volatile XMLStreamReaderFactory theInstance;

    public static void set(XMLStreamReaderFactory xMLStreamReaderFactory) {
        if (xMLStreamReaderFactory == null) {
            throw new IllegalArgumentException();
        }
        theInstance = xMLStreamReaderFactory;
    }

    public static XMLStreamReaderFactory get() {
        return theInstance;
    }

    public static XMLStreamReader create(InputSource inputSource, boolean bl) {
        try {
            if (inputSource.getCharacterStream() != null) {
                return XMLStreamReaderFactory.get().doCreate(inputSource.getSystemId(), inputSource.getCharacterStream(), bl);
            }
            if (inputSource.getByteStream() != null) {
                return XMLStreamReaderFactory.get().doCreate(inputSource.getSystemId(), inputSource.getByteStream(), bl);
            }
            return XMLStreamReaderFactory.get().doCreate(inputSource.getSystemId(), new URL(inputSource.getSystemId()).openStream(), bl);
        }
        catch (IOException iOException) {
            throw new XMLReaderException("stax.cantCreate", new Object[]{iOException});
        }
    }

    public static XMLStreamReader create(@Nullable String string, InputStream inputStream, boolean bl) {
        return XMLStreamReaderFactory.get().doCreate(string, inputStream, bl);
    }

    public static XMLStreamReader create(@Nullable String string, Reader reader, boolean bl) {
        return XMLStreamReaderFactory.get().doCreate(string, reader, bl);
    }

    public static void recycle(XMLStreamReader xMLStreamReader) {
        XMLStreamReaderFactory.get().doRecycle(xMLStreamReader);
    }

    public abstract XMLStreamReader doCreate(String var1, InputStream var2, boolean var3);

    public abstract XMLStreamReader doCreate(String var1, Reader var2, boolean var3);

    public abstract void doRecycle(XMLStreamReader var1);

    static {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        xMLInputFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
        xMLInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReaderFactory xMLStreamReaderFactory = null;
        if (!Boolean.getBoolean(XMLStreamReaderFactory.class.getName() + ".noPool")) {
            xMLStreamReaderFactory = Zephyr.newInstance(xMLInputFactory);
        }
        if (xMLStreamReaderFactory == null && xMLInputFactory.getClass().getName().equals("com.ctc.wstx.stax.WstxInputFactory")) {
            xMLStreamReaderFactory = new Woodstox(xMLInputFactory);
        }
        if (xMLStreamReaderFactory == null) {
            xMLStreamReaderFactory = new Default(xMLInputFactory);
        }
        theInstance = xMLStreamReaderFactory;
    }

    public static final class Default
    extends NoLock {
        public Default(XMLInputFactory xMLInputFactory) {
            super(xMLInputFactory);
        }

        public synchronized XMLStreamReader doCreate(String string, InputStream inputStream, boolean bl) {
            return super.doCreate(string, inputStream, bl);
        }

        public synchronized XMLStreamReader doCreate(String string, Reader reader, boolean bl) {
            return super.doCreate(string, reader, bl);
        }
    }

    public static class NoLock
    extends XMLStreamReaderFactory {
        private final XMLInputFactory xif;

        public NoLock(XMLInputFactory xMLInputFactory) {
            this.xif = xMLInputFactory;
        }

        public XMLStreamReader doCreate(String string, InputStream inputStream, boolean bl) {
            try {
                return this.xif.createXMLStreamReader(string, inputStream);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        public XMLStreamReader doCreate(String string, Reader reader, boolean bl) {
            try {
                return this.xif.createXMLStreamReader(string, reader);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        public void doRecycle(XMLStreamReader xMLStreamReader) {
        }
    }

    public static interface RecycleAware {
        public void onRecycled();
    }

    public static final class Woodstox
    extends NoLock {
        public Woodstox(XMLInputFactory xMLInputFactory) {
            super(xMLInputFactory);
            xMLInputFactory.setProperty("org.codehaus.stax2.internNsUris", true);
        }

        public XMLStreamReader doCreate(String string, InputStream inputStream, boolean bl) {
            return super.doCreate(string, inputStream, bl);
        }

        public XMLStreamReader doCreate(String string, Reader reader, boolean bl) {
            return super.doCreate(string, reader, bl);
        }
    }

    public static final class Zephyr
    extends XMLStreamReaderFactory {
        private final XMLInputFactory xif;
        private final ThreadLocal<XMLStreamReader> pool = new ThreadLocal();
        private final Method setInputSourceMethod;
        private final Method resetMethod;
        private final Class zephyrClass;

        @Nullable
        public static XMLStreamReaderFactory newInstance(XMLInputFactory xMLInputFactory) {
            try {
                Class<?> clazz = xMLInputFactory.createXMLStreamReader(new StringReader("<foo/>")).getClass();
                if (!clazz.getName().startsWith("com.sun.xml.internal.stream.")) {
                    return null;
                }
                return new Zephyr(xMLInputFactory, clazz);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
            catch (XMLStreamException xMLStreamException) {
                return null;
            }
        }

        public Zephyr(XMLInputFactory xMLInputFactory, Class clazz) throws NoSuchMethodException {
            this.zephyrClass = clazz;
            this.setInputSourceMethod = clazz.getMethod("setInputSource", InputSource.class);
            this.resetMethod = clazz.getMethod("reset", new Class[0]);
            try {
                xMLInputFactory.setProperty("reuse-instance", false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.xif = xMLInputFactory;
        }

        @Nullable
        private XMLStreamReader fetch() {
            XMLStreamReader xMLStreamReader = this.pool.get();
            if (xMLStreamReader == null) {
                return null;
            }
            this.pool.set(null);
            return xMLStreamReader;
        }

        public void doRecycle(XMLStreamReader xMLStreamReader) {
            if (this.zephyrClass.isInstance(xMLStreamReader)) {
                this.pool.set(xMLStreamReader);
            }
            if (xMLStreamReader instanceof RecycleAware) {
                ((RecycleAware)((Object)xMLStreamReader)).onRecycled();
            }
        }

        public XMLStreamReader doCreate(String string, InputStream inputStream, boolean bl) {
            try {
                XMLStreamReader xMLStreamReader = this.fetch();
                if (xMLStreamReader == null) {
                    return this.xif.createXMLStreamReader(string, inputStream);
                }
                InputSource inputSource = new InputSource(string);
                inputSource.setByteStream(inputStream);
                this.reuse(xMLStreamReader, inputSource);
                return xMLStreamReader;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{illegalAccessException});
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{invocationTargetException});
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        public XMLStreamReader doCreate(String string, Reader reader, boolean bl) {
            try {
                XMLStreamReader xMLStreamReader = this.fetch();
                if (xMLStreamReader == null) {
                    return this.xif.createXMLStreamReader(string, reader);
                }
                InputSource inputSource = new InputSource(string);
                inputSource.setCharacterStream(reader);
                this.reuse(xMLStreamReader, inputSource);
                return xMLStreamReader;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{illegalAccessException});
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{invocationTargetException});
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        private void reuse(XMLStreamReader xMLStreamReader, InputSource inputSource) throws IllegalAccessException, InvocationTargetException {
            this.resetMethod.invoke((Object)xMLStreamReader, new Object[0]);
            this.setInputSourceMethod.invoke((Object)xMLStreamReader, inputSource);
        }
    }
}

