/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.fault;

import com.sun.xml.internal.bind.marshaller.NamespacePrefixMapper;
import com.sun.xml.internal.ws.developer.ServerSideException;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@XmlRootElement(namespace="http://jax-ws.dev.java.net/", name="exception")
final class ExceptionBean {
    @XmlAttribute(name="class")
    public String className;
    @XmlElement
    public String message;
    @XmlElementWrapper(namespace="http://jax-ws.dev.java.net/", name="stackTrace")
    @XmlElement(namespace="http://jax-ws.dev.java.net/", name="frame")
    public List<StackFrame> stackTrace = new ArrayList<StackFrame>();
    @XmlElement(namespace="http://jax-ws.dev.java.net/", name="cause")
    public ExceptionBean cause;
    @XmlAttribute
    public String note = "To disable this feature, set " + SOAPFaultBuilder.CAPTURE_STACK_TRACE_PROPERTY + " system property to false";
    private static final JAXBContext JAXB_CONTEXT;
    static final String NS = "http://jax-ws.dev.java.net/";
    static final String LOCAL_NAME = "exception";
    private static final NamespacePrefixMapper nsp;

    public static void marshal(Throwable throwable, Node node) throws JAXBException {
        Marshaller marshaller = JAXB_CONTEXT.createMarshaller();
        marshaller.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", (Object)nsp);
        marshaller.marshal((Object)new ExceptionBean(throwable), node);
    }

    public static ServerSideException unmarshal(Node node) throws JAXBException {
        ExceptionBean exceptionBean = (ExceptionBean)JAXB_CONTEXT.createUnmarshaller().unmarshal(node);
        return exceptionBean.toException();
    }

    ExceptionBean() {
    }

    private ExceptionBean(Throwable throwable) {
        this.className = throwable.getClass().getName();
        this.message = throwable.getMessage();
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            this.stackTrace.add(new StackFrame(stackTraceElement));
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable != throwable2 && throwable2 != null) {
            this.cause = new ExceptionBean(throwable2);
        }
    }

    private ServerSideException toException() {
        ServerSideException serverSideException = new ServerSideException(this.className, this.message);
        if (this.stackTrace != null) {
            StackTraceElement[] stackTraceElementArray = new StackTraceElement[this.stackTrace.size()];
            for (int i = 0; i < this.stackTrace.size(); ++i) {
                stackTraceElementArray[i] = this.stackTrace.get(i).toStackTraceElement();
            }
            serverSideException.setStackTrace(stackTraceElementArray);
        }
        if (this.cause != null) {
            serverSideException.initCause(this.cause.toException());
        }
        return serverSideException;
    }

    public static boolean isStackTraceXml(Element element) {
        return element.getLocalName().equals(LOCAL_NAME) && element.getNamespaceURI().equals(NS);
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{ExceptionBean.class});
        }
        catch (JAXBException jAXBException) {
            throw new Error(jAXBException);
        }
        nsp = new NamespacePrefixMapper(){

            public String getPreferredPrefix(String string, String string2, boolean bl) {
                if (string.equals(ExceptionBean.NS)) {
                    return "";
                }
                return string2;
            }
        };
    }

    static final class StackFrame {
        @XmlAttribute(name="class")
        public String declaringClass;
        @XmlAttribute(name="method")
        public String methodName;
        @XmlAttribute(name="file")
        public String fileName;
        @XmlAttribute(name="line")
        public String lineNumber;

        StackFrame() {
        }

        public StackFrame(StackTraceElement stackTraceElement) {
            this.declaringClass = stackTraceElement.getClassName();
            this.methodName = stackTraceElement.getMethodName();
            this.fileName = stackTraceElement.getFileName();
            this.lineNumber = this.box(stackTraceElement.getLineNumber());
        }

        private String box(int n) {
            if (n >= 0) {
                return String.valueOf(n);
            }
            if (n == -2) {
                return "native";
            }
            return "unknown";
        }

        private int unbox(String string) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (string.equals("native")) {
                    return -2;
                }
                return -1;
            }
        }

        private StackTraceElement toStackTraceElement() {
            return new StackTraceElement(this.declaringClass, this.methodName, this.fileName, this.unbox(this.lineNumber));
        }
    }
}

