/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message;

import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.bind.marshaller.SAX2DOMEx;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.message.AttachmentUnmarshallerImpl;
import com.sun.xml.internal.ws.message.XMLReaderImpl;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageImpl
extends Message {
    protected final SOAPVersion soapVersion;
    protected static final AttributesImpl EMPTY_ATTS = new AttributesImpl();
    protected static final LocatorImpl NULL_LOCATOR = new LocatorImpl();

    protected AbstractMessageImpl(SOAPVersion sOAPVersion) {
        this.soapVersion = sOAPVersion;
    }

    protected AbstractMessageImpl(AbstractMessageImpl abstractMessageImpl) {
        this.soapVersion = abstractMessageImpl.soapVersion;
    }

    @Override
    public Source readEnvelopeAsSource() {
        return new SAXSource(new XMLReaderImpl(this), XMLReaderImpl.THE_SOURCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        if (this.hasAttachments()) {
            unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)new AttachmentUnmarshallerImpl(this.getAttachments()));
        }
        try {
            Object object = unmarshaller.unmarshal(this.readPayloadAsSource());
            return (T)object;
        }
        finally {
            unmarshaller.setAttachmentUnmarshaller(null);
        }
    }

    @Override
    public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
        return bridge.unmarshal(this.readPayloadAsSource(), (AttachmentUnmarshaller)(this.hasAttachments() ? new AttachmentUnmarshallerImpl(this.getAttachments()) : null));
    }

    @Override
    public void writeTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        String string = this.soapVersion.nsUri;
        xMLStreamWriter.writeStartDocument();
        xMLStreamWriter.writeStartElement("S", "Envelope", string);
        xMLStreamWriter.writeNamespace("S", string);
        if (this.hasHeaders()) {
            xMLStreamWriter.writeStartElement("S", "Header", string);
            HeaderList headerList = this.getHeaders();
            int n = headerList.size();
            for (int i = 0; i < n; ++i) {
                headerList.get(i).writeTo(xMLStreamWriter);
            }
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeStartElement("S", "Body", string);
        this.writePayloadTo(xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndDocument();
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        String string = this.soapVersion.nsUri;
        contentHandler.setDocumentLocator(NULL_LOCATOR);
        contentHandler.startDocument();
        contentHandler.startPrefixMapping("S", string);
        contentHandler.startElement(string, "Envelope", "S:Envelope", EMPTY_ATTS);
        if (this.hasHeaders()) {
            contentHandler.startElement(string, "Header", "S:Header", EMPTY_ATTS);
            HeaderList headerList = this.getHeaders();
            int n = headerList.size();
            for (int i = 0; i < n; ++i) {
                headerList.get(i).writeTo(contentHandler, errorHandler);
            }
            contentHandler.endElement(string, "Header", "S:Header");
        }
        contentHandler.startElement(string, "Body", "S:Body", EMPTY_ATTS);
        this.writePayloadTo(contentHandler, errorHandler, true);
        contentHandler.endElement(string, "Body", "S:Body");
        contentHandler.endElement(string, "Envelope", "S:Envelope");
    }

    protected abstract void writePayloadTo(ContentHandler var1, ErrorHandler var2, boolean var3) throws SAXException;

    @Override
    public SOAPMessage readAsSOAPMessage() throws SOAPException {
        SOAPMessage sOAPMessage = this.soapVersion.saajMessageFactory.createMessage();
        SAX2DOMEx sAX2DOMEx = new SAX2DOMEx(sOAPMessage.getSOAPPart());
        try {
            this.writeTo(sAX2DOMEx, XmlUtil.DRACONIAN_ERROR_HANDLER);
        }
        catch (SAXException sAXException) {
            throw new SOAPException(sAXException);
        }
        for (Attachment attachment : this.getAttachments()) {
            AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart();
            attachmentPart.setDataHandler(attachment.asDataHandler());
            attachmentPart.setContentId('<' + attachment.getContentId() + '>');
            sOAPMessage.addAttachmentPart(attachmentPart);
        }
        return sOAPMessage;
    }

    @Override
    public SOAPMessage readAsSOAPMessage(Packet packet, boolean bl) throws SOAPException {
        String string;
        SOAPMessage sOAPMessage = this.readAsSOAPMessage();
        Map map = null;
        String string2 = string = bl ? "com.sun.xml.internal.ws.api.message.packet.inbound.transport.headers" : "com.sun.xml.internal.ws.api.message.packet.outbound.transport.headers";
        if (packet.supports(string)) {
            map = (Map)packet.get(string);
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (((String)entry.getKey()).equalsIgnoreCase("Content-Type")) continue;
                for (String string3 : (List)entry.getValue()) {
                    sOAPMessage.getMimeHeaders().addHeader((String)entry.getKey(), string3);
                }
            }
        }
        sOAPMessage.saveChanges();
        return sOAPMessage;
    }
}

