/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message.stream;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.istack.internal.XMLStreamReaderToContentHandler;
import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.encoding.TagInfoset;
import com.sun.xml.internal.ws.message.AbstractMessageImpl;
import com.sun.xml.internal.ws.message.AttachmentUnmarshallerImpl;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.xml.DummyLocation;
import com.sun.xml.internal.ws.util.xml.StAXSource;
import com.sun.xml.internal.ws.util.xml.XMLStreamReaderToXMLStreamWriter;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StreamMessage
extends AbstractMessageImpl {
    @NotNull
    private XMLStreamReader reader;
    @Nullable
    private HeaderList headers;
    private final String payloadLocalName;
    private final String payloadNamespaceURI;
    @NotNull
    private TagInfoset envelopeTag;
    @NotNull
    private TagInfoset headerTag;
    @NotNull
    private TagInfoset bodyTag;
    private Throwable consumedAt;
    private static final TagInfoset[] DEFAULT_TAGS = new TagInfoset[6];

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StreamMessage(@Nullable HeaderList headerList, @NotNull AttachmentSet attachmentSet, @NotNull XMLStreamReader xMLStreamReader, @NotNull SOAPVersion sOAPVersion) {
        super(sOAPVersion);
        this.headers = headerList;
        this.attachmentSet = attachmentSet;
        this.reader = xMLStreamReader;
        if (xMLStreamReader.getEventType() == 7) {
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        }
        if (xMLStreamReader.getEventType() == 2) {
            String string = xMLStreamReader.getLocalName();
            String string2 = xMLStreamReader.getNamespaceURI();
            assert (string != null);
            assert (string2 != null);
            if (!string.equals("Body") || !string2.equals(sOAPVersion.nsUri)) throw new WebServiceException("Malformed stream: {" + string2 + "}" + string);
            this.payloadLocalName = null;
            this.payloadNamespaceURI = null;
        } else {
            this.payloadLocalName = xMLStreamReader.getLocalName();
            this.payloadNamespaceURI = xMLStreamReader.getNamespaceURI();
        }
        int n = sOAPVersion.ordinal() * 3;
        this.envelopeTag = DEFAULT_TAGS[n];
        this.headerTag = DEFAULT_TAGS[n + 1];
        this.bodyTag = DEFAULT_TAGS[n + 2];
    }

    public StreamMessage(@NotNull TagInfoset tagInfoset, @Nullable TagInfoset tagInfoset2, @NotNull AttachmentSet attachmentSet, @Nullable HeaderList headerList, @NotNull TagInfoset tagInfoset3, @NotNull XMLStreamReader xMLStreamReader, @NotNull SOAPVersion sOAPVersion) {
        this(headerList, attachmentSet, xMLStreamReader, sOAPVersion);
        assert (tagInfoset != null && tagInfoset3 != null);
        this.envelopeTag = tagInfoset;
        this.headerTag = tagInfoset2 != null ? tagInfoset2 : new TagInfoset(tagInfoset.nsUri, "Header", tagInfoset.prefix, EMPTY_ATTS, new String[0]);
        this.bodyTag = tagInfoset3;
    }

    @Override
    public boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    @Override
    public HeaderList getHeaders() {
        if (this.headers == null) {
            this.headers = new HeaderList();
        }
        return this.headers;
    }

    @Override
    @NotNull
    public AttachmentSet getAttachments() {
        return this.attachmentSet;
    }

    @Override
    public String getPayloadLocalPart() {
        return this.payloadLocalName;
    }

    @Override
    public String getPayloadNamespaceURI() {
        return this.payloadNamespaceURI;
    }

    @Override
    public boolean hasPayload() {
        return this.payloadLocalName != null;
    }

    @Override
    public Source readPayloadAsSource() {
        if (this.hasPayload()) {
            assert (this.unconsumed());
            return new StAXSource(this.reader, true);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        if (!this.hasPayload()) {
            return null;
        }
        assert (this.unconsumed());
        if (this.hasAttachments()) {
            unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)new AttachmentUnmarshallerImpl(this.getAttachments()));
        }
        try {
            Object object = unmarshaller.unmarshal(this.reader);
            return object;
        }
        finally {
            unmarshaller.setAttachmentUnmarshaller(null);
            XMLStreamReaderUtil.close(this.reader);
            XMLStreamReaderFactory.recycle(this.reader);
        }
    }

    @Override
    public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
        if (!this.hasPayload()) {
            return null;
        }
        assert (this.unconsumed());
        T t = bridge.unmarshal(this.reader, (AttachmentUnmarshaller)(this.hasAttachments() ? new AttachmentUnmarshallerImpl(this.getAttachments()) : null));
        XMLStreamReaderUtil.close(this.reader);
        XMLStreamReaderFactory.recycle(this.reader);
        return t;
    }

    @Override
    public void consume() {
        assert (this.unconsumed());
        XMLStreamReaderFactory.recycle(this.reader);
    }

    @Override
    public XMLStreamReader readPayload() {
        assert (this.unconsumed());
        return this.reader;
    }

    @Override
    public void writePayloadTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        if (this.payloadLocalName == null) {
            return;
        }
        assert (this.unconsumed());
        XMLStreamReaderToXMLStreamWriter xMLStreamReaderToXMLStreamWriter = new XMLStreamReaderToXMLStreamWriter();
        while (this.reader.getEventType() != 8) {
            String string = this.reader.getLocalName();
            String string2 = this.reader.getNamespaceURI();
            if (!(this.reader.getEventType() != 2 || string.equals("Body") && string2.equals(this.soapVersion.nsUri))) {
                XMLStreamReaderUtil.nextElementContent(this.reader);
                if (this.reader.getEventType() == 8) break;
                string = this.reader.getLocalName();
                string2 = this.reader.getNamespaceURI();
            }
            if (string.equals("Body") && string2.equals(this.soapVersion.nsUri) || this.reader.getEventType() == 8) break;
            xMLStreamReaderToXMLStreamWriter.bridge(this.reader, xMLStreamWriter);
        }
        this.reader.close();
        XMLStreamReaderFactory.recycle(this.reader);
    }

    @Override
    public void writeTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        this.writeEnvelope(xMLStreamWriter);
    }

    private void writeEnvelope(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.writeStartDocument();
        this.envelopeTag.writeStart(xMLStreamWriter);
        HeaderList headerList = this.getHeaders();
        if (headerList.size() > 0) {
            this.headerTag.writeStart(xMLStreamWriter);
            for (Header header : headerList) {
                header.writeTo(xMLStreamWriter);
            }
            xMLStreamWriter.writeEndElement();
        }
        this.bodyTag.writeStart(xMLStreamWriter);
        if (this.hasPayload()) {
            this.writePayloadTo(xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndDocument();
    }

    @Override
    public void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean bl) throws SAXException {
        assert (this.unconsumed());
        try {
            if (this.payloadLocalName == null) {
                return;
            }
            XMLStreamReaderToContentHandler xMLStreamReaderToContentHandler = new XMLStreamReaderToContentHandler(this.reader, contentHandler, true, bl);
            while (this.reader.getEventType() != 8) {
                String string = this.reader.getLocalName();
                String string2 = this.reader.getNamespaceURI();
                if (!(this.reader.getEventType() != 2 || string.equals("Body") && string2.equals(this.soapVersion.nsUri))) {
                    XMLStreamReaderUtil.nextElementContent(this.reader);
                    if (this.reader.getEventType() == 8) break;
                    string = this.reader.getLocalName();
                    string2 = this.reader.getNamespaceURI();
                }
                if (string.equals("Body") && string2.equals(this.soapVersion.nsUri) || this.reader.getEventType() == 8) break;
                xMLStreamReaderToContentHandler.bridge();
            }
            this.reader.close();
            XMLStreamReaderFactory.recycle(this.reader);
        }
        catch (XMLStreamException xMLStreamException) {
            Location location = xMLStreamException.getLocation();
            if (location == null) {
                location = DummyLocation.INSTANCE;
            }
            SAXParseException sAXParseException = new SAXParseException(xMLStreamException.getMessage(), location.getPublicId(), location.getSystemId(), location.getLineNumber(), location.getColumnNumber(), xMLStreamException);
            errorHandler.error(sAXParseException);
        }
    }

    @Override
    public Message copy() {
        try {
            XMLStreamReader xMLStreamReader;
            if (this.hasPayload()) {
                assert (this.unconsumed());
                this.consumedAt = null;
                MutableXMLStreamBuffer mutableXMLStreamBuffer = new MutableXMLStreamBuffer();
                StreamReaderBufferCreator streamReaderBufferCreator = new StreamReaderBufferCreator(mutableXMLStreamBuffer);
                while (this.reader.getEventType() != 8) {
                    String string = this.reader.getLocalName();
                    String string2 = this.reader.getNamespaceURI();
                    if (string.equals("Body") && string2.equals(this.soapVersion.nsUri) || this.reader.getEventType() == 8) break;
                    streamReaderBufferCreator.create(this.reader);
                }
                XMLStreamReaderFactory.recycle(this.reader);
                this.reader = mutableXMLStreamBuffer.readAsXMLStreamReader();
                xMLStreamReader = mutableXMLStreamBuffer.readAsXMLStreamReader();
                this.proceedToRootElement(this.reader);
                this.proceedToRootElement(xMLStreamReader);
            } else {
                xMLStreamReader = this.reader;
            }
            return new StreamMessage(this.envelopeTag, this.headerTag, this.attachmentSet, HeaderList.copy(this.headers), this.bodyTag, xMLStreamReader, this.soapVersion);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException("Failed to copy a message", xMLStreamException);
        }
    }

    private void proceedToRootElement(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        assert (xMLStreamReader.getEventType() == 7);
        xMLStreamReader.nextTag();
        assert (xMLStreamReader.getEventType() == 1);
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        contentHandler.setDocumentLocator(NULL_LOCATOR);
        contentHandler.startDocument();
        this.envelopeTag.writeStart(contentHandler);
        this.headerTag.writeStart(contentHandler);
        if (this.hasHeaders()) {
            HeaderList headerList = this.getHeaders();
            int n = headerList.size();
            for (int i = 0; i < n; ++i) {
                headerList.get(i).writeTo(contentHandler, errorHandler);
            }
        }
        this.headerTag.writeEnd(contentHandler);
        this.bodyTag.writeStart(contentHandler);
        this.writePayloadTo(contentHandler, errorHandler, true);
        this.bodyTag.writeEnd(contentHandler);
        this.envelopeTag.writeEnd(contentHandler);
    }

    private boolean unconsumed() {
        if (this.payloadLocalName == null) {
            return true;
        }
        if (this.reader.getEventType() != 1) {
            AssertionError assertionError = new AssertionError((Object)"StreamMessage has been already consumed. See the nested exception for where it's consumed");
            ((Throwable)((Object)assertionError)).initCause(this.consumedAt);
            throw assertionError;
        }
        this.consumedAt = new Exception().fillInStackTrace();
        return true;
    }

    private static void create(SOAPVersion sOAPVersion) {
        int n = sOAPVersion.ordinal() * 3;
        StreamMessage.DEFAULT_TAGS[n] = new TagInfoset(sOAPVersion.nsUri, "Envelope", "S", EMPTY_ATTS, "S", sOAPVersion.nsUri);
        StreamMessage.DEFAULT_TAGS[n + 1] = new TagInfoset(sOAPVersion.nsUri, "Header", "S", EMPTY_ATTS, new String[0]);
        StreamMessage.DEFAULT_TAGS[n + 2] = new TagInfoset(sOAPVersion.nsUri, "Body", "S", EMPTY_ATTS, new String[0]);
    }

    static {
        StreamMessage.create(SOAPVersion.SOAP_11);
        StreamMessage.create(SOAPVersion.SOAP_12);
    }
}

