/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.streaming;

import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.streaming.DOMStreamReader;
import com.sun.xml.internal.ws.streaming.XMLReaderException;
import com.sun.xml.internal.ws.util.FastInfosetUtil;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;

public class SourceReaderFactory {
    static Class fastInfosetSourceClass;
    static Method fastInfosetSource_getInputStream;

    public static XMLStreamReader createSourceReader(Source source, boolean bl) {
        return SourceReaderFactory.createSourceReader(source, bl, null);
    }

    public static XMLStreamReader createSourceReader(Source source, boolean bl, String string) {
        try {
            if (source instanceof StreamSource) {
                StreamSource streamSource = (StreamSource)source;
                InputStream inputStream = streamSource.getInputStream();
                if (inputStream != null) {
                    if (string != null) {
                        return XMLStreamReaderFactory.create(source.getSystemId(), new InputStreamReader(inputStream, string), bl);
                    }
                    return XMLStreamReaderFactory.create(source.getSystemId(), inputStream, bl);
                }
                Reader reader = streamSource.getReader();
                if (reader != null) {
                    return XMLStreamReaderFactory.create(source.getSystemId(), reader, bl);
                }
                return XMLStreamReaderFactory.create(source.getSystemId(), new URL(source.getSystemId()).openStream(), bl);
            }
            if (source.getClass() == fastInfosetSourceClass) {
                return FastInfosetUtil.createFIStreamReader((InputStream)fastInfosetSource_getInputStream.invoke((Object)source, new Object[0]));
            }
            if (source instanceof DOMSource) {
                DOMStreamReader dOMStreamReader = new DOMStreamReader();
                dOMStreamReader.setCurrentNode(((DOMSource)source).getNode());
                return dOMStreamReader;
            }
            if (source instanceof SAXSource) {
                Transformer transformer = XmlUtil.newTransformer();
                DOMResult dOMResult = new DOMResult();
                transformer.transform(source, dOMResult);
                return SourceReaderFactory.createSourceReader(new DOMSource(dOMResult.getNode()), bl);
            }
            throw new XMLReaderException("sourceReader.invalidSource", source.getClass().getName());
        }
        catch (Exception exception) {
            throw new XMLReaderException(exception);
        }
    }

    static {
        try {
            fastInfosetSourceClass = Class.forName("com.sun.xml.internal.org.jvnet.fastinfoset.FastInfosetSource");
            fastInfosetSource_getInputStream = fastInfosetSourceClass.getMethod("getInputStream", new Class[0]);
        }
        catch (Exception exception) {
            fastInfosetSourceClass = null;
        }
    }
}

