/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.helpers;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.bind.helpers.Messages;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMarshallerImpl
implements Marshaller {
    private ValidationEventHandler eventHandler = new DefaultValidationEventHandler();
    private String encoding = "UTF-8";
    private String schemaLocation = null;
    private String noNSSchemaLocation = null;
    private boolean formattedOutput = false;
    private boolean fragment = false;
    static String[] aliases = new String[]{"UTF-8", "UTF8", "UTF-16", "Unicode", "UTF-16BE", "UnicodeBigUnmarked", "UTF-16LE", "UnicodeLittleUnmarked", "US-ASCII", "ASCII", "TIS-620", "TIS620", "ISO-10646-UCS-2", "Unicode", "EBCDIC-CP-US", "cp037", "EBCDIC-CP-CA", "cp037", "EBCDIC-CP-NL", "cp037", "EBCDIC-CP-WT", "cp037", "EBCDIC-CP-DK", "cp277", "EBCDIC-CP-NO", "cp277", "EBCDIC-CP-FI", "cp278", "EBCDIC-CP-SE", "cp278", "EBCDIC-CP-IT", "cp280", "EBCDIC-CP-ES", "cp284", "EBCDIC-CP-GB", "cp285", "EBCDIC-CP-FR", "cp297", "EBCDIC-CP-AR1", "cp420", "EBCDIC-CP-HE", "cp424", "EBCDIC-CP-BE", "cp500", "EBCDIC-CP-CH", "cp500", "EBCDIC-CP-ROECE", "cp870", "EBCDIC-CP-YU", "cp870", "EBCDIC-CP-IS", "cp871", "EBCDIC-CP-AR2", "cp918"};

    public final void marshal(Object object, OutputStream outputStream) throws JAXBException {
        this.checkNotNull(object, "obj", outputStream, "os");
        this.marshal(object, new StreamResult(outputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object object, File file) throws JAXBException {
        this.checkNotNull(object, "jaxbElement", file, "output");
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            try {
                this.marshal(object, new StreamResult(bufferedOutputStream));
            }
            finally {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
        catch (IOException iOException) {
            throw new JAXBException((Throwable)iOException);
        }
    }

    public final void marshal(Object object, Writer writer) throws JAXBException {
        this.checkNotNull(object, "obj", writer, "writer");
        this.marshal(object, new StreamResult(writer));
    }

    public final void marshal(Object object, ContentHandler contentHandler) throws JAXBException {
        this.checkNotNull(object, "obj", contentHandler, "handler");
        this.marshal(object, new SAXResult(contentHandler));
    }

    public final void marshal(Object object, Node node) throws JAXBException {
        this.checkNotNull(object, "obj", node, "node");
        this.marshal(object, new DOMResult(node));
    }

    public Node getNode(Object object) throws JAXBException {
        this.checkNotNull(object, "obj", Boolean.TRUE, "foo");
        throw new UnsupportedOperationException();
    }

    protected String getEncoding() {
        return this.encoding;
    }

    protected void setEncoding(String string) {
        this.encoding = string;
    }

    protected String getSchemaLocation() {
        return this.schemaLocation;
    }

    protected void setSchemaLocation(String string) {
        this.schemaLocation = string;
    }

    protected String getNoNSSchemaLocation() {
        return this.noNSSchemaLocation;
    }

    protected void setNoNSSchemaLocation(String string) {
        this.noNSSchemaLocation = string;
    }

    protected boolean isFormattedOutput() {
        return this.formattedOutput;
    }

    protected void setFormattedOutput(boolean bl) {
        this.formattedOutput = bl;
    }

    protected boolean isFragment() {
        return this.fragment;
    }

    protected void setFragment(boolean bl) {
        this.fragment = bl;
    }

    protected String getJavaEncoding(String string) throws UnsupportedEncodingException {
        try {
            "1".getBytes(string);
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            for (int i = 0; i < aliases.length; i += 2) {
                if (!string.equals(aliases[i])) continue;
                "1".getBytes(aliases[i + 1]);
                return aliases[i + 1];
            }
            throw new UnsupportedEncodingException(string);
        }
    }

    public void setProperty(String string, Object object) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "name"));
        }
        if ("jaxb.encoding".equals(string)) {
            this.checkString(string, object);
            this.setEncoding((String)object);
            return;
        }
        if ("jaxb.formatted.output".equals(string)) {
            this.checkBoolean(string, object);
            this.setFormattedOutput((Boolean)object);
            return;
        }
        if ("jaxb.noNamespaceSchemaLocation".equals(string)) {
            this.checkString(string, object);
            this.setNoNSSchemaLocation((String)object);
            return;
        }
        if ("jaxb.schemaLocation".equals(string)) {
            this.checkString(string, object);
            this.setSchemaLocation((String)object);
            return;
        }
        if ("jaxb.fragment".equals(string)) {
            this.checkBoolean(string, object);
            this.setFragment((Boolean)object);
            return;
        }
        throw new PropertyException(string, object);
    }

    public Object getProperty(String string) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "name"));
        }
        if ("jaxb.encoding".equals(string)) {
            return this.getEncoding();
        }
        if ("jaxb.formatted.output".equals(string)) {
            return this.isFormattedOutput() ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("jaxb.noNamespaceSchemaLocation".equals(string)) {
            return this.getNoNSSchemaLocation();
        }
        if ("jaxb.schemaLocation".equals(string)) {
            return this.getSchemaLocation();
        }
        if ("jaxb.fragment".equals(string)) {
            return this.isFragment() ? Boolean.TRUE : Boolean.FALSE;
        }
        throw new PropertyException(string);
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.eventHandler;
    }

    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        this.eventHandler = validationEventHandler == null ? new DefaultValidationEventHandler() : validationEventHandler;
    }

    private void checkBoolean(String string, Object object) throws PropertyException {
        if (!(object instanceof Boolean)) {
            throw new PropertyException(Messages.format("AbstractMarshallerImpl.MustBeBoolean", string));
        }
    }

    private void checkString(String string, Object object) throws PropertyException {
        if (!(object instanceof String)) {
            throw new PropertyException(Messages.format("AbstractMarshallerImpl.MustBeString", string));
        }
    }

    private void checkNotNull(Object object, String string, Object object2, String string2) {
        if (object == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", string));
        }
        if (object2 == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", string2));
        }
    }

    public void marshal(Object object, XMLEventWriter xMLEventWriter) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public void marshal(Object object, XMLStreamWriter xMLStreamWriter) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public void setSchema(Schema schema) {
        throw new UnsupportedOperationException();
    }

    public Schema getSchema() {
        throw new UnsupportedOperationException();
    }

    public void setAdapter(XmlAdapter xmlAdapter) {
        if (xmlAdapter == null) {
            throw new IllegalArgumentException();
        }
        this.setAdapter(xmlAdapter.getClass(), xmlAdapter);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> clazz, A a) {
        throw new UnsupportedOperationException();
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> clazz) {
        throw new UnsupportedOperationException();
    }

    public void setAttachmentMarshaller(AttachmentMarshaller attachmentMarshaller) {
        throw new UnsupportedOperationException();
    }

    public AttachmentMarshaller getAttachmentMarshaller() {
        throw new UnsupportedOperationException();
    }

    public void setListener(Marshaller.Listener listener) {
        throw new UnsupportedOperationException();
    }

    public Marshaller.Listener getListener() {
        throw new UnsupportedOperationException();
    }
}

