/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.helpers;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.bind.helpers.Messages;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUnmarshallerImpl
implements Unmarshaller {
    private ValidationEventHandler eventHandler = new DefaultValidationEventHandler();
    protected boolean validating = false;
    private XMLReader reader = null;

    protected XMLReader getXMLReader() throws JAXBException {
        if (this.reader == null) {
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(true);
                sAXParserFactory.setValidating(false);
                this.reader = sAXParserFactory.newSAXParser().getXMLReader();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new JAXBException((Throwable)parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new JAXBException((Throwable)sAXException);
            }
        }
        return this.reader;
    }

    public Object unmarshal(Source source) throws JAXBException {
        if (source == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "source"));
        }
        if (source instanceof SAXSource) {
            return this.unmarshal((SAXSource)source);
        }
        if (source instanceof StreamSource) {
            return this.unmarshal(AbstractUnmarshallerImpl.streamSourceToInputSource((StreamSource)source));
        }
        if (source instanceof DOMSource) {
            return this.unmarshal(((DOMSource)source).getNode());
        }
        throw new IllegalArgumentException();
    }

    private Object unmarshal(SAXSource sAXSource) throws JAXBException {
        XMLReader xMLReader = sAXSource.getXMLReader();
        if (xMLReader == null) {
            xMLReader = this.getXMLReader();
        }
        return this.unmarshal(xMLReader, sAXSource.getInputSource());
    }

    protected abstract Object unmarshal(XMLReader var1, InputSource var2) throws JAXBException;

    public final Object unmarshal(InputSource inputSource) throws JAXBException {
        if (inputSource == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "source"));
        }
        return this.unmarshal(this.getXMLReader(), inputSource);
    }

    private Object unmarshal(String string) throws JAXBException {
        return this.unmarshal(new InputSource(string));
    }

    public final Object unmarshal(URL uRL) throws JAXBException {
        if (uRL == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "url"));
        }
        return this.unmarshal(uRL.toExternalForm());
    }

    public final Object unmarshal(File file) throws JAXBException {
        if (file == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "file"));
        }
        try {
            String string = file.getAbsolutePath();
            if (File.separatorChar != '/') {
                string = string.replace(File.separatorChar, '/');
            }
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if (!string.endsWith("/") && file.isDirectory()) {
                string = string + "/";
            }
            return this.unmarshal(new URL("file", "", string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException.getMessage());
        }
    }

    public final Object unmarshal(InputStream inputStream) throws JAXBException {
        if (inputStream == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "is"));
        }
        InputSource inputSource = new InputSource(inputStream);
        return this.unmarshal(inputSource);
    }

    public final Object unmarshal(Reader reader) throws JAXBException {
        if (reader == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "reader"));
        }
        InputSource inputSource = new InputSource(reader);
        return this.unmarshal(inputSource);
    }

    private static InputSource streamSourceToInputSource(StreamSource streamSource) {
        InputSource inputSource = new InputSource();
        inputSource.setSystemId(streamSource.getSystemId());
        inputSource.setByteStream(streamSource.getInputStream());
        inputSource.setCharacterStream(streamSource.getReader());
        return inputSource;
    }

    public boolean isValidating() throws JAXBException {
        return this.validating;
    }

    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        this.eventHandler = validationEventHandler == null ? new DefaultValidationEventHandler() : validationEventHandler;
    }

    public void setValidating(boolean bl) throws JAXBException {
        this.validating = bl;
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.eventHandler;
    }

    protected UnmarshalException createUnmarshalException(SAXException sAXException) {
        Exception exception = sAXException.getException();
        if (exception instanceof UnmarshalException) {
            return (UnmarshalException)((Object)exception);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception != null) {
            return new UnmarshalException(exception);
        }
        return new UnmarshalException(sAXException);
    }

    public void setProperty(String string, Object object) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "name"));
        }
        throw new PropertyException(string, object);
    }

    public Object getProperty(String string) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "name"));
        }
        throw new PropertyException(string);
    }

    public Object unmarshal(XMLEventReader xMLEventReader) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public Object unmarshal(XMLStreamReader xMLStreamReader) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public <T> JAXBElement<T> unmarshal(Node node, Class<T> clazz) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public <T> JAXBElement<T> unmarshal(Source source, Class<T> clazz) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public <T> JAXBElement<T> unmarshal(XMLStreamReader xMLStreamReader, Class<T> clazz) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public <T> JAXBElement<T> unmarshal(XMLEventReader xMLEventReader, Class<T> clazz) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public void setSchema(Schema schema) {
        throw new UnsupportedOperationException();
    }

    public Schema getSchema() {
        throw new UnsupportedOperationException();
    }

    public void setAdapter(XmlAdapter xmlAdapter) {
        if (xmlAdapter == null) {
            throw new IllegalArgumentException();
        }
        this.setAdapter(xmlAdapter.getClass(), xmlAdapter);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> clazz, A a) {
        throw new UnsupportedOperationException();
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> clazz) {
        throw new UnsupportedOperationException();
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller attachmentUnmarshaller) {
        throw new UnsupportedOperationException();
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        throw new UnsupportedOperationException();
    }

    public void setListener(Unmarshaller.Listener listener) {
        throw new UnsupportedOperationException();
    }

    public Unmarshaller.Listener getListener() {
        throw new UnsupportedOperationException();
    }
}

