/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.util;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.util.Messages;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class JAXBSource
extends SAXSource {
    private final Marshaller marshaller;
    private final Object contentObject;
    private final XMLReader pseudoParser = new XMLReader(){
        private LexicalHandler lexicalHandler;
        private EntityResolver entityResolver;
        private DTDHandler dtdHandler;
        private XMLFilterImpl repeater = new XMLFilterImpl();
        private ErrorHandler errorHandler;

        public boolean getFeature(String string) throws SAXNotRecognizedException {
            if (string.equals("http://xml.org/sax/features/namespaces")) {
                return true;
            }
            if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
                return false;
            }
            throw new SAXNotRecognizedException(string);
        }

        public void setFeature(String string, boolean bl) throws SAXNotRecognizedException {
            if (string.equals("http://xml.org/sax/features/namespaces") && bl) {
                return;
            }
            if (string.equals("http://xml.org/sax/features/namespace-prefixes") && !bl) {
                return;
            }
            throw new SAXNotRecognizedException(string);
        }

        public Object getProperty(String string) throws SAXNotRecognizedException {
            if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
                return this.lexicalHandler;
            }
            throw new SAXNotRecognizedException(string);
        }

        public void setProperty(String string, Object object) throws SAXNotRecognizedException {
            if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
                this.lexicalHandler = (LexicalHandler)object;
                return;
            }
            throw new SAXNotRecognizedException(string);
        }

        public void setEntityResolver(EntityResolver entityResolver) {
            this.entityResolver = entityResolver;
        }

        public EntityResolver getEntityResolver() {
            return this.entityResolver;
        }

        public void setDTDHandler(DTDHandler dTDHandler) {
            this.dtdHandler = dTDHandler;
        }

        public DTDHandler getDTDHandler() {
            return this.dtdHandler;
        }

        public void setContentHandler(ContentHandler contentHandler) {
            this.repeater.setContentHandler(contentHandler);
        }

        public ContentHandler getContentHandler() {
            return this.repeater.getContentHandler();
        }

        public void setErrorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
        }

        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        public void parse(InputSource inputSource) throws SAXException {
            this.parse();
        }

        public void parse(String string) throws SAXException {
            this.parse();
        }

        public void parse() throws SAXException {
            try {
                JAXBSource.this.marshaller.marshal(JAXBSource.this.contentObject, (ContentHandler)this.repeater);
            }
            catch (JAXBException jAXBException) {
                SAXParseException sAXParseException = new SAXParseException(jAXBException.getMessage(), null, null, -1, -1, (Exception)((Object)jAXBException));
                if (this.errorHandler != null) {
                    this.errorHandler.fatalError(sAXParseException);
                }
                throw sAXParseException;
            }
        }
    };

    public JAXBSource(JAXBContext jAXBContext, Object object) throws JAXBException {
        this(jAXBContext == null ? JAXBSource.assertionFailed(Messages.format("JAXBSource.NullContext")) : jAXBContext.createMarshaller(), object == null ? JAXBSource.assertionFailed(Messages.format("JAXBSource.NullContent")) : object);
    }

    public JAXBSource(Marshaller marshaller, Object object) throws JAXBException {
        if (marshaller == null) {
            throw new JAXBException(Messages.format("JAXBSource.NullMarshaller"));
        }
        if (object == null) {
            throw new JAXBException(Messages.format("JAXBSource.NullContent"));
        }
        this.marshaller = marshaller;
        this.contentObject = object;
        super.setXMLReader(this.pseudoParser);
        super.setInputSource(new InputSource());
    }

    private static Marshaller assertionFailed(String string) throws JAXBException {
        throw new JAXBException(string);
    }
}

