/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.ScrollPaneAdjustable;
import java.awt.peer.ScrollPanePeer;
import sun.awt.DebugHelper;
import sun.awt.PeerEvent;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WPanelPeer;
import sun.awt.windows.WToolkit;

class WScrollPanePeer
extends WPanelPeer
implements ScrollPanePeer {
    private static final DebugHelper dbg = DebugHelper.create(WScrollPanePeer.class);
    int scrollbarWidth = this._getVScrollbarWidth();
    int scrollbarHeight = this._getHScrollbarHeight();
    int prevx;
    int prevy;

    static native void initIDs();

    native void create(WComponentPeer var1);

    native int getOffset(int var1);

    WScrollPanePeer(Component component) {
        super(component);
    }

    void initialize() {
        super.initialize();
        this.setInsets();
        Insets insets = this.getInsets();
        this.setScrollPosition(-insets.left, -insets.top);
    }

    public void setUnitIncrement(Adjustable adjustable, int n) {
    }

    public Insets insets() {
        return this.getInsets();
    }

    private native void setInsets();

    public synchronized native void setScrollPosition(int var1, int var2);

    public int getHScrollbarHeight() {
        return this.scrollbarHeight;
    }

    private native int _getHScrollbarHeight();

    public int getVScrollbarWidth() {
        return this.scrollbarWidth;
    }

    private native int _getVScrollbarWidth();

    public Point getScrollOffset() {
        int n = this.getOffset(0);
        int n2 = this.getOffset(1);
        return new Point(n, n2);
    }

    public void childResized(int n, int n2) {
        ScrollPane scrollPane = (ScrollPane)this.target;
        Dimension dimension = scrollPane.getSize();
        this.setSpans(dimension.width, dimension.height, n, n2);
        this.setInsets();
    }

    synchronized native void setSpans(int var1, int var2, int var3, int var4);

    public void setValue(Adjustable adjustable, int n) {
        Component component = this.getScrollChild();
        if (component == null) {
            return;
        }
        Point point = component.getLocation();
        switch (adjustable.getOrientation()) {
            case 1: {
                this.setScrollPosition(-point.x, n);
                break;
            }
            case 0: {
                this.setScrollPosition(n, -point.y);
            }
        }
    }

    private Component getScrollChild() {
        ScrollPane scrollPane = (ScrollPane)this.target;
        Component component = null;
        try {
            component = scrollPane.getComponent(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return component;
    }

    private void postScrollEvent(int n, int n2, int n3, boolean bl) {
        Adjustor adjustor = new Adjustor(n, n2, n3, bl);
        WToolkit.executeOnEventHandlerThread((PeerEvent)new ScrollEvent(this.target, adjustor));
    }

    native void setTypedValue(ScrollPaneAdjustable var1, int var2, int var3);

    public void restack() {
    }

    static {
        WScrollPanePeer.initIDs();
    }

    class Adjustor
    implements Runnable {
        int orient;
        int type;
        int pos;
        boolean isAdjusting;

        Adjustor(int n, int n2, int n3, boolean bl) {
            this.orient = n;
            this.type = n2;
            this.pos = n3;
            this.isAdjusting = bl;
        }

        public void run() {
            Component component;
            if (WScrollPanePeer.this.getScrollChild() == null) {
                return;
            }
            ScrollPane scrollPane = (ScrollPane)WScrollPanePeer.this.target;
            ScrollPaneAdjustable scrollPaneAdjustable = null;
            if (this.orient == 1) {
                scrollPaneAdjustable = (ScrollPaneAdjustable)scrollPane.getVAdjustable();
            } else if (this.orient == 0) {
                scrollPaneAdjustable = (ScrollPaneAdjustable)scrollPane.getHAdjustable();
            } else {
                dbg;
            }
            if (scrollPaneAdjustable == null) {
                return;
            }
            int n = scrollPaneAdjustable.getValue();
            switch (this.type) {
                case 2: {
                    n -= scrollPaneAdjustable.getUnitIncrement();
                    break;
                }
                case 1: {
                    n += scrollPaneAdjustable.getUnitIncrement();
                    break;
                }
                case 3: {
                    n -= scrollPaneAdjustable.getBlockIncrement();
                    break;
                }
                case 4: {
                    n += scrollPaneAdjustable.getBlockIncrement();
                    break;
                }
                case 5: {
                    n = this.pos;
                    break;
                }
                default: {
                    dbg;
                    return;
                }
            }
            n = Math.max(scrollPaneAdjustable.getMinimum(), n);
            n = Math.min(scrollPaneAdjustable.getMaximum(), n);
            scrollPaneAdjustable.setValueIsAdjusting(this.isAdjusting);
            WScrollPanePeer.this.setTypedValue(scrollPaneAdjustable, n, this.type);
            for (component = WScrollPanePeer.this.getScrollChild(); component != null && !(component.getPeer() instanceof WComponentPeer); component = component.getParent()) {
            }
            dbg;
            WComponentPeer wComponentPeer = (WComponentPeer)component.getPeer();
            wComponentPeer.paintDamagedAreaImmediately();
        }
    }

    class ScrollEvent
    extends PeerEvent {
        ScrollEvent(Object object, Runnable runnable) {
            super(object, runnable, 0L);
        }

        public PeerEvent coalesceEvents(PeerEvent peerEvent) {
            dbg;
            if (peerEvent instanceof ScrollEvent) {
                return peerEvent;
            }
            return null;
        }
    }
}

