/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import sun.nio.ch.DatagramChannelImpl;
import sun.nio.ch.Net;
import sun.nio.ch.OptionAdaptor;
import sun.nio.ch.Util;

public class DatagramSocketAdaptor
extends DatagramSocket {
    private final DatagramChannelImpl dc;
    private volatile OptionAdaptor opts = null;
    private volatile int timeout = 0;
    private volatile int trafficClass = 0;
    private static final DatagramSocketImpl dummyDatagramSocket = new DatagramSocketImpl(){

        protected void create() throws SocketException {
        }

        protected void bind(int n, InetAddress inetAddress) throws SocketException {
        }

        protected void send(DatagramPacket datagramPacket) throws IOException {
        }

        protected int peek(InetAddress inetAddress) throws IOException {
            return 0;
        }

        protected int peekData(DatagramPacket datagramPacket) throws IOException {
            return 0;
        }

        protected void receive(DatagramPacket datagramPacket) throws IOException {
        }

        protected void setTTL(byte by) throws IOException {
        }

        protected byte getTTL() throws IOException {
            return 0;
        }

        protected void setTimeToLive(int n) throws IOException {
        }

        protected int getTimeToLive() throws IOException {
            return 0;
        }

        protected void join(InetAddress inetAddress) throws IOException {
        }

        protected void leave(InetAddress inetAddress) throws IOException {
        }

        protected void joinGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        }

        protected void leaveGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        }

        protected void close() {
        }

        public Object getOption(int n) throws SocketException {
            return null;
        }

        public void setOption(int n, Object object) throws SocketException {
        }
    };

    private DatagramSocketAdaptor(DatagramChannelImpl datagramChannelImpl) throws IOException {
        super(dummyDatagramSocket);
        this.dc = datagramChannelImpl;
    }

    public static DatagramSocket create(DatagramChannelImpl datagramChannelImpl) {
        try {
            return new DatagramSocketAdaptor(datagramChannelImpl);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    private void connectInternal(SocketAddress socketAddress) throws SocketException {
        InetSocketAddress inetSocketAddress = Net.asInetSocketAddress(socketAddress);
        int n = inetSocketAddress.getPort();
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("connect: " + n);
        }
        if (socketAddress == null) {
            throw new IllegalArgumentException("connect: null address");
        }
        if (!this.isClosed()) {
            return;
        }
        try {
            this.dc.connect(socketAddress);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public void bind(SocketAddress socketAddress) throws SocketException {
        try {
            if (socketAddress == null) {
                socketAddress = new InetSocketAddress(0);
            }
            this.dc.bind(socketAddress);
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public void connect(InetAddress inetAddress, int n) {
        try {
            this.connectInternal(new InetSocketAddress(inetAddress, n));
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public void connect(SocketAddress socketAddress) throws SocketException {
        if (socketAddress == null) {
            throw new IllegalArgumentException("Address can't be null");
        }
        this.connectInternal(socketAddress);
    }

    public void disconnect() {
        try {
            this.dc.disconnect();
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    public boolean isBound() {
        return this.dc.isBound();
    }

    public boolean isConnected() {
        return this.dc.isConnected();
    }

    public InetAddress getInetAddress() {
        return this.isConnected() ? Net.asInetSocketAddress(this.dc.remoteAddress()).getAddress() : null;
    }

    public int getPort() {
        return this.isConnected() ? Net.asInetSocketAddress(this.dc.remoteAddress()).getPort() : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(DatagramPacket datagramPacket) throws IOException {
        Object object = this.dc.blockingLock();
        synchronized (object) {
            if (!this.dc.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            try {
                DatagramPacket datagramPacket2 = datagramPacket;
                synchronized (datagramPacket2) {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
                    if (this.dc.isConnected()) {
                        if (datagramPacket.getAddress() == null) {
                            InetSocketAddress inetSocketAddress = (InetSocketAddress)this.dc.remoteAddress;
                            datagramPacket.setPort(inetSocketAddress.getPort());
                            datagramPacket.setAddress(inetSocketAddress.getAddress());
                            this.dc.write(byteBuffer);
                        } else {
                            this.dc.send(byteBuffer, datagramPacket.getSocketAddress());
                        }
                    } else {
                        this.dc.send(byteBuffer, datagramPacket.getSocketAddress());
                    }
                }
            }
            catch (IOException iOException) {
                Net.translateException(iOException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void receive(ByteBuffer byteBuffer) throws IOException {
        Selector selector;
        SelectionKey selectionKey;
        block14: {
            block13: {
                if (this.timeout == 0) {
                    this.dc.receive(byteBuffer);
                    return;
                }
                selectionKey = null;
                selector = null;
                this.dc.configureBlocking(false);
                try {
                    long l;
                    if (this.dc.receive(byteBuffer) != null) {
                        Object var11_4 = null;
                        if (selectionKey != null) {
                            selectionKey.cancel();
                        }
                        break block13;
                    }
                    selector = Util.getTemporarySelector((SelectableChannel)this.dc);
                    selectionKey = this.dc.register(selector, 1);
                    long l2 = this.timeout;
                    do {
                        if (!this.dc.isOpen()) {
                            throw new ClosedChannelException();
                        }
                        l = System.currentTimeMillis();
                        int n = selector.select(l2);
                        if (n > 0 && selectionKey.isReadable() && this.dc.receive(byteBuffer) != null) {
                            break block14;
                        }
                        selector.selectedKeys().remove(selectionKey);
                    } while ((l2 -= System.currentTimeMillis() - l) > 0L);
                    throw new SocketTimeoutException();
                }
                catch (Throwable throwable) {
                    Object var11_6 = null;
                    if (selectionKey != null) {
                        selectionKey.cancel();
                    }
                    if (this.dc.isOpen()) {
                        this.dc.configureBlocking(true);
                    }
                    if (selector == null) throw throwable;
                    Util.releaseTemporarySelector((Selector)selector);
                    throw throwable;
                }
            }
            if (this.dc.isOpen()) {
                this.dc.configureBlocking(true);
            }
            if (selector == null) return;
            Util.releaseTemporarySelector((Selector)selector);
            return;
        }
        Object var11_5 = null;
        if (selectionKey != null) {
            selectionKey.cancel();
        }
        if (this.dc.isOpen()) {
            this.dc.configureBlocking(true);
        }
        if (selector == null) return;
        Util.releaseTemporarySelector((Selector)selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(DatagramPacket datagramPacket) throws IOException {
        Object object = this.dc.blockingLock();
        synchronized (object) {
            if (!this.dc.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            try {
                DatagramPacket datagramPacket2 = datagramPacket;
                synchronized (datagramPacket2) {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
                    this.receive(byteBuffer);
                    datagramPacket.setLength(byteBuffer.position() - datagramPacket.getOffset());
                }
            }
            catch (IOException iOException) {
                Net.translateException(iOException);
            }
        }
    }

    public InetAddress getLocalAddress() {
        if (this.isClosed()) {
            return null;
        }
        try {
            return Net.asInetSocketAddress(this.dc.localAddress()).getAddress();
        }
        catch (Exception exception) {
            return new InetSocketAddress(0).getAddress();
        }
    }

    public int getLocalPort() {
        if (this.isClosed()) {
            return -1;
        }
        try {
            return Net.asInetSocketAddress(this.dc.localAddress()).getPort();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setSoTimeout(int n) throws SocketException {
        this.timeout = n;
    }

    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    private OptionAdaptor opts() {
        if (this.opts == null) {
            this.opts = new OptionAdaptor(this.dc);
        }
        return this.opts;
    }

    public void setSendBufferSize(int n) throws SocketException {
        this.opts().setSendBufferSize(n);
    }

    public int getSendBufferSize() throws SocketException {
        return this.opts().getSendBufferSize();
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.opts().setReceiveBufferSize(n);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.opts().getReceiveBufferSize();
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.opts().setReuseAddress(bl);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.opts().getReuseAddress();
    }

    public void setBroadcast(boolean bl) throws SocketException {
        this.opts().setBroadcast(bl);
    }

    public boolean getBroadcast() throws SocketException {
        return this.opts().getBroadcast();
    }

    public void setTrafficClass(int n) throws SocketException {
        this.opts().setTrafficClass(n);
        this.trafficClass = n;
    }

    public int getTrafficClass() throws SocketException {
        int n = this.opts().getTrafficClass();
        if (n < 0) {
            n = this.trafficClass;
        }
        return n;
    }

    public void close() {
        try {
            this.dc.close();
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    public boolean isClosed() {
        return !this.dc.isOpen();
    }

    public DatagramChannel getChannel() {
        return this.dc;
    }
}

