/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.AdjacencyList;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.CertPathHelper;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.ForwardBuilder;
import sun.security.provider.certpath.ForwardState;
import sun.security.provider.certpath.PolicyChecker;
import sun.security.provider.certpath.PolicyNodeImpl;
import sun.security.provider.certpath.ReverseBuilder;
import sun.security.provider.certpath.ReverseState;
import sun.security.provider.certpath.SunCertPathBuilderException;
import sun.security.provider.certpath.SunCertPathBuilderParameters;
import sun.security.provider.certpath.SunCertPathBuilderResult;
import sun.security.provider.certpath.Vertex;
import sun.security.util.Debug;
import sun.security.x509.PKIXExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SunCertPathBuilder
extends CertPathBuilderSpi {
    private static final Debug debug = Debug.getInstance("certpath");
    private PKIXBuilderParameters buildParams;
    private CertificateFactory cf;
    private boolean pathCompleted = false;
    private X500Principal targetSubjectDN;
    private PolicyNode policyTreeResult;
    private TrustAnchor trustAnchor;
    private PublicKey finalPublicKey;
    private X509CertSelector targetSel;
    private List<CertStore> orderedCertStores;

    public SunCertPathBuilder() throws CertPathBuilderException {
        try {
            this.cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new CertPathBuilderException(certificateException);
        }
    }

    @Override
    public CertPathBuilderResult engineBuild(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        X509Certificate x509Certificate;
        if (debug != null) {
            debug.println("SunCertPathBuilder.engineBuild(" + certPathParameters + ")");
        }
        if (!(certPathParameters instanceof PKIXBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("inappropriate parameter type, must be an instance of PKIXBuilderParameters");
        }
        boolean bl = true;
        if (certPathParameters instanceof SunCertPathBuilderParameters) {
            bl = ((SunCertPathBuilderParameters)certPathParameters).getBuildForward();
        }
        this.buildParams = (PKIXBuilderParameters)certPathParameters;
        for (TrustAnchor arrayList2 : this.buildParams.getTrustAnchors()) {
            if (arrayList2.getNameConstraints() == null) continue;
            throw new InvalidAlgorithmParameterException("name constraints in trust anchor not supported");
        }
        CertSelector certSelector = this.buildParams.getTargetCertConstraints();
        if (!(certSelector instanceof X509CertSelector)) {
            throw new InvalidAlgorithmParameterException("the targetCertConstraints parameter must be an X509CertSelector");
        }
        this.targetSel = (X509CertSelector)certSelector;
        this.targetSubjectDN = CertPathHelper.getSubject((X509CertSelector)this.targetSel);
        if (this.targetSubjectDN == null && (x509Certificate = this.targetSel.getCertificate()) != null) {
            this.targetSubjectDN = x509Certificate.getSubjectX500Principal();
        }
        this.orderedCertStores = new ArrayList<CertStore>(this.buildParams.getCertStores());
        Collections.sort(this.orderedCertStores, new CertStoreComparator());
        if (this.targetSubjectDN == null) {
            this.targetSubjectDN = this.getTargetSubjectDN(this.orderedCertStores, this.targetSel);
        }
        if (this.targetSubjectDN == null) {
            throw new InvalidAlgorithmParameterException("Could not determine unique target subject");
        }
        ArrayList<List<Vertex>> arrayList = new ArrayList<List<Vertex>>();
        CertPathBuilderResult certPathBuilderResult = this.buildCertPath(bl, false, arrayList);
        if (certPathBuilderResult == null) {
            if (debug != null) {
                debug.println("SunCertPathBuilder.engineBuild: 2nd pass");
            }
            arrayList.clear();
            certPathBuilderResult = this.buildCertPath(bl, true, arrayList);
            if (certPathBuilderResult == null) {
                throw new SunCertPathBuilderException("unable to find valid certification path to requested target", new AdjacencyList(arrayList));
            }
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult buildCertPath(boolean bl, boolean bl2, List<List<Vertex>> list) throws CertPathBuilderException {
        this.pathCompleted = false;
        this.trustAnchor = null;
        this.finalPublicKey = null;
        this.policyTreeResult = null;
        LinkedList<X509Certificate> linkedList = new LinkedList<X509Certificate>();
        try {
            if (bl) {
                this.buildForward(list, linkedList, bl2);
            } else {
                this.buildReverse(list, linkedList);
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("SunCertPathBuilder.engineBuild() exception in build");
                exception.printStackTrace();
            }
            throw new SunCertPathBuilderException("unable to find valid certification path to requested target", exception, new AdjacencyList(list));
        }
        try {
            if (this.pathCompleted) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.engineBuild() pathCompleted");
                }
                Collections.reverse(linkedList);
                return new SunCertPathBuilderResult(this.cf.generateCertPath(linkedList), this.trustAnchor, this.policyTreeResult, this.finalPublicKey, new AdjacencyList(list));
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("SunCertPathBuilder.engineBuild() exception in wrap-up");
                exception.printStackTrace();
            }
            throw new SunCertPathBuilderException("unable to find valid certification path to requested target", exception, new AdjacencyList(list));
        }
        return null;
    }

    private void buildReverse(List<List<Vertex>> list, LinkedList<X509Certificate> linkedList) throws Exception {
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildReverse()...");
            debug.println("SunCertPathBuilder.buildReverse() InitialPolicies: " + this.buildParams.getInitialPolicies());
        }
        ReverseState reverseState = new ReverseState();
        list.clear();
        list.add(new LinkedList());
        Iterator<TrustAnchor> iterator = this.buildParams.getTrustAnchors().iterator();
        while (iterator.hasNext()) {
            TrustAnchor trustAnchor = iterator.next();
            if (this.anchorIsTarget(trustAnchor, this.targetSel)) {
                this.trustAnchor = trustAnchor;
                this.pathCompleted = true;
                this.finalPublicKey = trustAnchor.getTrustedCert().getPublicKey();
                break;
            }
            reverseState.initState(this.buildParams.getMaxPathLength(), this.buildParams.isExplicitPolicyRequired(), this.buildParams.isPolicyMappingInhibited(), this.buildParams.isAnyPolicyInhibited(), this.buildParams.getCertPathCheckers());
            reverseState.updateState(trustAnchor);
            reverseState.crlChecker = new CrlRevocationChecker(null, this.buildParams);
            try {
                this.depthFirstSearchReverse(null, reverseState, new ReverseBuilder(this.buildParams, this.targetSubjectDN), list, linkedList);
                break;
            }
            catch (Exception exception) {
                if (iterator.hasNext()) continue;
                throw exception;
            }
        }
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildReverse() returned from depthFirstSearchReverse()");
            debug.println("SunCertPathBuilder.buildReverse() certPathList.size: " + linkedList.size());
        }
    }

    private void buildForward(List<List<Vertex>> list, LinkedList<X509Certificate> linkedList, boolean bl) throws GeneralSecurityException, IOException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildForward()...");
        }
        ForwardState forwardState = new ForwardState();
        forwardState.initState(this.buildParams.getCertPathCheckers());
        list.clear();
        list.add(new LinkedList());
        forwardState.crlChecker = new CrlRevocationChecker(null, this.buildParams);
        this.depthFirstSearchForward(this.targetSubjectDN, forwardState, new ForwardBuilder(this.buildParams, this.targetSubjectDN, bl), list, linkedList);
    }

    void depthFirstSearchForward(X500Principal x500Principal, ForwardState forwardState, ForwardBuilder forwardBuilder, List<List<Vertex>> list, LinkedList<X509Certificate> linkedList) throws GeneralSecurityException, IOException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchForward(" + x500Principal + ", " + forwardState.toString() + ")");
        }
        List<Vertex> list2 = this.addVertices(forwardBuilder.getMatchingCerts(forwardState, this.orderedCertStores), list);
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchForward(): certs.size=" + list2.size());
        }
        block4: for (Vertex vertex : list2) {
            ForwardState forwardState2 = (ForwardState)forwardState.clone();
            X509Certificate x509Certificate = (X509Certificate)vertex.getCertificate();
            try {
                forwardBuilder.verifyCert(x509Certificate, forwardState2, linkedList);
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): validation failed: " + generalSecurityException);
                    generalSecurityException.printStackTrace();
                }
                vertex.setThrowable(generalSecurityException);
                continue;
            }
            if (forwardBuilder.isPathCompleted(x509Certificate)) {
                BasicChecker basicChecker = null;
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): commencing final verification");
                }
                ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(linkedList);
                if (forwardBuilder.trustAnchor.getTrustedCert() == null) {
                    arrayList.add(0, x509Certificate);
                }
                HashSet<String> hashSet = new HashSet<String>(1);
                hashSet.add("2.5.29.32.0");
                PolicyNodeImpl policyNodeImpl = new PolicyNodeImpl(null, "2.5.29.32.0", null, false, hashSet, false);
                PolicyChecker policyChecker = new PolicyChecker(this.buildParams.getInitialPolicies(), arrayList.size(), this.buildParams.isExplicitPolicyRequired(), this.buildParams.isPolicyMappingInhibited(), this.buildParams.isAnyPolicyInhibited(), this.buildParams.getPolicyQualifiersRejected(), policyNodeImpl);
                ArrayList<PKIXCertPathChecker> arrayList2 = new ArrayList<PKIXCertPathChecker>(this.buildParams.getCertPathCheckers());
                int n = 0;
                arrayList2.add(n, policyChecker);
                ++n;
                if (forwardState2.keyParamsNeeded()) {
                    PublicKey publicKey = x509Certificate.getPublicKey();
                    if (forwardBuilder.trustAnchor.getTrustedCert() == null) {
                        publicKey = forwardBuilder.trustAnchor.getCAPublicKey();
                        if (debug != null) {
                            debug.println("SunCertPathBuilder.depthFirstSearchForward using buildParams public key: " + publicKey.toString());
                        }
                    }
                    basicChecker = new BasicChecker(publicKey, x509Certificate.getSubjectX500Principal(), this.buildParams.getDate(), this.buildParams.getSigProvider(), true);
                    arrayList2.add(n, basicChecker);
                    ++n;
                    if (this.buildParams.isRevocationEnabled()) {
                        arrayList2.add(n, new CrlRevocationChecker(publicKey, this.buildParams));
                        ++n;
                    }
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    Set<String> set;
                    X509Certificate x509Certificate2 = arrayList.get(i);
                    if (debug != null) {
                        debug.println("current subject = " + x509Certificate2.getSubjectX500Principal());
                    }
                    if ((set = x509Certificate2.getCriticalExtensionOIDs()) == null) {
                        set = Collections.emptySet();
                    }
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        PKIXCertPathChecker pKIXCertPathChecker = (PKIXCertPathChecker)arrayList2.get(j);
                        if (j >= n && pKIXCertPathChecker.isForwardCheckingSupported()) continue;
                        if (i == 0) {
                            pKIXCertPathChecker.init(false);
                        }
                        try {
                            pKIXCertPathChecker.check(x509Certificate2, set);
                            continue;
                        }
                        catch (CertPathValidatorException certPathValidatorException) {
                            if (debug != null) {
                                debug.println("SunCertPathBuilder.depthFirstSearchForward(): final verification failed: " + certPathValidatorException);
                            }
                            vertex.setThrowable(certPathValidatorException);
                            continue block4;
                        }
                    }
                    for (PKIXCertPathChecker pKIXCertPathChecker : this.buildParams.getCertPathCheckers()) {
                        Set<String> set2;
                        if (!pKIXCertPathChecker.isForwardCheckingSupported() || (set2 = pKIXCertPathChecker.getSupportedExtensions()) == null) continue;
                        set.removeAll(set2);
                    }
                    if (set.isEmpty()) continue;
                    set.remove(PKIXExtensions.BasicConstraints_Id.toString());
                    set.remove(PKIXExtensions.NameConstraints_Id.toString());
                    set.remove(PKIXExtensions.CertificatePolicies_Id.toString());
                    set.remove(PKIXExtensions.PolicyMappings_Id.toString());
                    set.remove(PKIXExtensions.PolicyConstraints_Id.toString());
                    set.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
                    set.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
                    set.remove(PKIXExtensions.KeyUsage_Id.toString());
                    set.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
                    if (set.isEmpty()) continue;
                    throw new CertPathValidatorException("unrecognized critical extension(s)");
                }
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): final verification succeeded - path completed!");
                }
                this.pathCompleted = true;
                if (forwardBuilder.trustAnchor.getTrustedCert() == null) {
                    forwardBuilder.addCertToPath(x509Certificate, linkedList);
                }
                this.trustAnchor = forwardBuilder.trustAnchor;
                if (basicChecker != null) {
                    this.finalPublicKey = basicChecker.getPublicKey();
                } else {
                    Certificate certificate = linkedList.size() == 0 ? forwardBuilder.trustAnchor.getTrustedCert() : (Certificate)linkedList.get(linkedList.size() - 1);
                    this.finalPublicKey = certificate.getPublicKey();
                }
                this.policyTreeResult = policyChecker.getPolicyTree();
                return;
            }
            forwardBuilder.addCertToPath(x509Certificate, linkedList);
            forwardState2.updateState(x509Certificate);
            list.add(new LinkedList());
            vertex.setIndex(list.size() - 1);
            this.depthFirstSearchForward(x509Certificate.getIssuerX500Principal(), forwardState2, forwardBuilder, list, linkedList);
            if (this.pathCompleted) {
                return;
            }
            if (debug != null) {
                debug.println("SunCertPathBuilder.depthFirstSearchForward(): backtracking");
            }
            forwardBuilder.removeFinalCertFromPath(linkedList);
        }
    }

    void depthFirstSearchReverse(X500Principal x500Principal, ReverseState reverseState, ReverseBuilder reverseBuilder, List<List<Vertex>> list, LinkedList<X509Certificate> linkedList) throws GeneralSecurityException, IOException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchReverse(" + x500Principal + ", " + reverseState.toString() + ")");
        }
        List<Vertex> list2 = this.addVertices(reverseBuilder.getMatchingCerts(reverseState, this.orderedCertStores), list);
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchReverse(): certs.size=" + list2.size());
        }
        for (Vertex vertex : list2) {
            ReverseState reverseState2 = (ReverseState)reverseState.clone();
            X509Certificate x509Certificate = (X509Certificate)vertex.getCertificate();
            try {
                reverseBuilder.verifyCert(x509Certificate, reverseState2, linkedList);
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchReverse(): validation failed: " + generalSecurityException);
                }
                vertex.setThrowable(generalSecurityException);
                continue;
            }
            if (!reverseState.isInitial()) {
                reverseBuilder.addCertToPath(x509Certificate, linkedList);
            }
            this.trustAnchor = reverseState.trustAnchor;
            if (reverseBuilder.isPathCompleted(x509Certificate)) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchReverse(): path completed!");
                }
                this.pathCompleted = true;
                PolicyNodeImpl policyNodeImpl = reverseState2.rootNode;
                if (policyNodeImpl == null) {
                    this.policyTreeResult = null;
                } else {
                    this.policyTreeResult = policyNodeImpl.copyTree();
                    ((PolicyNodeImpl)this.policyTreeResult).setImmutable();
                }
                this.finalPublicKey = x509Certificate.getPublicKey();
                if (this.finalPublicKey instanceof DSAPublicKey && ((DSAPublicKey)this.finalPublicKey).getParams() == null) {
                    this.finalPublicKey = BasicChecker.makeInheritedParamsKey(this.finalPublicKey, reverseState.pubKey);
                }
                return;
            }
            reverseState2.updateState(x509Certificate);
            list.add(new LinkedList());
            vertex.setIndex(list.size() - 1);
            this.depthFirstSearchReverse(x509Certificate.getSubjectX500Principal(), reverseState2, reverseBuilder, list, linkedList);
            if (this.pathCompleted) {
                return;
            }
            if (debug != null) {
                debug.println("SunCertPathBuilder.depthFirstSearchReverse(): backtracking");
            }
            if (reverseState.isInitial()) continue;
            reverseBuilder.removeFinalCertFromPath(linkedList);
        }
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchReverse() all certs in this adjacency list checked");
        }
    }

    private List<Vertex> addVertices(Collection<X509Certificate> collection, List<List<Vertex>> list) {
        List<Vertex> list2 = list.get(list.size() - 1);
        for (X509Certificate x509Certificate : collection) {
            Vertex vertex = new Vertex(x509Certificate);
            list2.add(vertex);
        }
        return list2;
    }

    private boolean anchorIsTarget(TrustAnchor trustAnchor, X509CertSelector x509CertSelector) {
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        if (x509Certificate != null) {
            return x509CertSelector.match(x509Certificate);
        }
        return false;
    }

    private X500Principal getTargetSubjectDN(List<CertStore> list, X509CertSelector x509CertSelector) {
        for (CertStore certStore : list) {
            try {
                Collection<? extends Certificate> collection = certStore.getCertificates(x509CertSelector);
                if (collection.isEmpty()) continue;
                X509Certificate x509Certificate = (X509Certificate)collection.iterator().next();
                return x509Certificate.getSubjectX500Principal();
            }
            catch (CertStoreException certStoreException) {
                if (debug == null) continue;
                debug.println("SunCertPathBuilder.getTargetSubjectDN: non-fatal exception retrieving certs: " + certStoreException);
                certStoreException.printStackTrace();
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CertStoreComparator
    implements Comparator<CertStore> {
        private CertStoreComparator() {
        }

        @Override
        public int compare(CertStore certStore, CertStore certStore2) {
            if (Builder.isLocalCertStore(certStore)) {
                return -1;
            }
            return 1;
        }
    }
}

