/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Permission;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.security.auth.login.LoginException;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.PolicyParser;
import sun.security.tools.PolicyEntry;
import sun.security.tools.ToolWindow;
import sun.security.util.PolicyUtil;
import sun.security.util.PropertyExpander;

public class PolicyTool {
    static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.util.Resources");
    static final Collator collator = Collator.getInstance();
    Vector warnings;
    boolean newWarning = false;
    boolean modified = false;
    private static final boolean testing = false;
    private static final Class[] TWOPARAMS;
    private static final Class[] ONEPARAMS;
    private static final Class[] NOPARAMS;
    private static String policyFileName;
    private Vector policyEntries = new Vector();
    private PolicyParser parser = new PolicyParser();
    private KeyStore keyStore = null;
    private String keyStoreName = " ";
    private String keyStoreType = " ";
    private String keyStoreProvider = " ";
    private String keyStorePwdURL = " ";
    private static final String P11KEYSTORE = "PKCS11";
    private static final String NONE = "NONE";

    private PolicyTool() {
        this.warnings = new Vector();
    }

    String getPolicyFileName() {
        return policyFileName;
    }

    void setPolicyFileName(String string) {
        policyFileName = string;
    }

    void clearKeyStoreInfo() {
        this.keyStoreName = null;
        this.keyStoreType = null;
        this.keyStoreProvider = null;
        this.keyStorePwdURL = null;
        this.keyStore = null;
    }

    String getKeyStoreName() {
        return this.keyStoreName;
    }

    String getKeyStoreType() {
        return this.keyStoreType;
    }

    String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    String getKeyStorePwdURL() {
        return this.keyStorePwdURL;
    }

    void openPolicy(String string) throws FileNotFoundException, PolicyParser.ParsingException, KeyStoreException, CertificateException, InstantiationException, MalformedURLException, IOException, NoSuchAlgorithmException, IllegalAccessException, NoSuchMethodException, UnrecoverableKeyException, NoSuchProviderException, ClassNotFoundException, PropertyExpander.ExpandException, InvocationTargetException {
        this.newWarning = false;
        this.policyEntries = new Vector();
        this.parser = new PolicyParser();
        this.warnings = new Vector();
        this.setPolicyFileName(null);
        this.clearKeyStoreInfo();
        if (string == null) {
            this.modified = false;
            return;
        }
        this.setPolicyFileName(string);
        this.parser.read(new FileReader(string));
        this.openKeyStore(this.parser.getKeyStoreUrl(), this.parser.getKeyStoreType(), this.parser.getKeyStoreProvider(), this.parser.getStorePassURL());
        Enumeration<PolicyParser.GrantEntry> enumeration = this.parser.grantElements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray;
            String[] stringArray;
            Object object;
            Object object2;
            PolicyParser.GrantEntry grantEntry = enumeration.nextElement();
            if (grantEntry.signedBy != null) {
                object2 = this.parseSigners(grantEntry.signedBy);
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    object = this.getPublicKeyAlias((String)object2[i]);
                    if (object != null) continue;
                    this.newWarning = true;
                    stringArray = new MessageFormat(rb.getString("Warning: A public key for alias 'signers[i]' does not exist.  Make sure a KeyStore is properly configured."));
                    objectArray = new Object[]{object2[i]};
                    this.warnings.addElement(stringArray.format(objectArray));
                }
            }
            object2 = grantEntry.principals.listIterator(0);
            while (object2.hasNext()) {
                PolicyParser.PrincipalEntry principalEntry = (PolicyParser.PrincipalEntry)object2.next();
                try {
                    this.verifyPrincipal(principalEntry.getPrincipalClass(), principalEntry.getPrincipalName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.newWarning = true;
                    stringArray = new MessageFormat(rb.getString("Warning: Class not found: class"));
                    objectArray = new Object[]{principalEntry.getPrincipalClass()};
                    this.warnings.addElement(stringArray.format(objectArray));
                }
            }
            Enumeration<PolicyParser.PermissionEntry> enumeration2 = grantEntry.permissionElements();
            while (enumeration2.hasMoreElements()) {
                Object object3;
                object = enumeration2.nextElement();
                try {
                    this.verifyPermission(((PolicyParser.PermissionEntry)object).permission, ((PolicyParser.PermissionEntry)object).name, ((PolicyParser.PermissionEntry)object).action);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.newWarning = true;
                    MessageFormat messageFormat = new MessageFormat(rb.getString("Warning: Class not found: class"));
                    object3 = new Object[]{((PolicyParser.PermissionEntry)object).permission};
                    this.warnings.addElement(messageFormat.format(object3));
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.newWarning = true;
                    MessageFormat messageFormat = new MessageFormat(rb.getString("Warning: Invalid argument(s) for constructor: arg"));
                    object3 = new Object[]{((PolicyParser.PermissionEntry)object).permission};
                    this.warnings.addElement(messageFormat.format(object3));
                }
                if (((PolicyParser.PermissionEntry)object).signedBy == null) continue;
                stringArray = this.parseSigners(((PolicyParser.PermissionEntry)object).signedBy);
                for (int i = 0; i < stringArray.length; ++i) {
                    object3 = this.getPublicKeyAlias(stringArray[i]);
                    if (object3 != null) continue;
                    this.newWarning = true;
                    MessageFormat messageFormat = new MessageFormat(rb.getString("Warning: A public key for alias 'signers[i]' does not exist.  Make sure a KeyStore is properly configured."));
                    Object[] objectArray2 = new Object[]{stringArray[i]};
                    this.warnings.addElement(messageFormat.format(objectArray2));
                }
            }
            object = new PolicyEntry(this, grantEntry);
            this.policyEntries.addElement(object);
        }
        this.modified = false;
    }

    void savePolicy(String string) throws FileNotFoundException, IOException {
        this.parser.setKeyStoreUrl(this.keyStoreName);
        this.parser.setKeyStoreType(this.keyStoreType);
        this.parser.setKeyStoreProvider(this.keyStoreProvider);
        this.parser.setStorePassURL(this.keyStorePwdURL);
        this.parser.write(new FileWriter(string));
        this.modified = false;
    }

    void openKeyStore(String string, String string2, String string3, String string4) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, CertificateException, NoSuchProviderException, PropertyExpander.ExpandException {
        if (string == null && string2 == null && string3 == null && string4 == null) {
            this.keyStoreName = null;
            this.keyStoreType = null;
            this.keyStoreProvider = null;
            this.keyStorePwdURL = null;
            return;
        }
        URL uRL = null;
        if (policyFileName != null) {
            File file = new File(policyFileName);
            uRL = new URL("file:" + file.getCanonicalPath());
        }
        if (string != null && string.length() > 0) {
            string = PropertyExpander.expand(string).replace(File.separatorChar, '/');
        }
        if (string2 == null || string2.length() == 0) {
            string2 = KeyStore.getDefaultType();
        }
        if (string4 != null && string4.length() > 0) {
            string4 = PropertyExpander.expand(string4).replace(File.separatorChar, '/');
        }
        try {
            this.keyStore = PolicyUtil.getKeyStore(uRL, string, string2, string3, string4, null);
        }
        catch (IOException iOException) {
            String string5 = "no password provided, and no callback handler available for retrieving password";
            Throwable throwable = iOException.getCause();
            if (throwable != null && throwable instanceof LoginException && string5.equals(throwable.getMessage())) {
                throw new IOException(string5);
            }
            throw iOException;
        }
        this.keyStoreName = string;
        this.keyStoreType = string2;
        this.keyStoreProvider = string3;
        this.keyStorePwdURL = string4;
    }

    boolean addEntry(PolicyEntry policyEntry, int n) {
        if (n < 0) {
            this.policyEntries.addElement(policyEntry);
            this.parser.add(policyEntry.getGrantEntry());
        } else {
            PolicyEntry policyEntry2 = (PolicyEntry)this.policyEntries.elementAt(n);
            this.parser.replace(policyEntry2.getGrantEntry(), policyEntry.getGrantEntry());
            this.policyEntries.setElementAt(policyEntry, n);
        }
        return true;
    }

    boolean addPrinEntry(PolicyEntry policyEntry, PolicyParser.PrincipalEntry principalEntry, int n) {
        PolicyParser.GrantEntry grantEntry = policyEntry.getGrantEntry();
        if (grantEntry.contains(principalEntry)) {
            return false;
        }
        LinkedList<PolicyParser.PrincipalEntry> linkedList = grantEntry.principals;
        if (n != -1) {
            linkedList.set(n, principalEntry);
        } else {
            linkedList.add(principalEntry);
        }
        this.modified = true;
        return true;
    }

    boolean addPermEntry(PolicyEntry policyEntry, PolicyParser.PermissionEntry permissionEntry, int n) {
        PolicyParser.GrantEntry grantEntry = policyEntry.getGrantEntry();
        if (grantEntry.contains(permissionEntry)) {
            return false;
        }
        Vector<PolicyParser.PermissionEntry> vector = grantEntry.permissionEntries;
        if (n != -1) {
            vector.setElementAt(permissionEntry, n);
        } else {
            vector.addElement(permissionEntry);
        }
        this.modified = true;
        return true;
    }

    boolean removePermEntry(PolicyEntry policyEntry, PolicyParser.PermissionEntry permissionEntry) {
        PolicyParser.GrantEntry grantEntry = policyEntry.getGrantEntry();
        this.modified = grantEntry.remove(permissionEntry);
        return this.modified;
    }

    boolean removeEntry(PolicyEntry policyEntry) {
        this.parser.remove(policyEntry.getGrantEntry());
        this.modified = true;
        return this.policyEntries.removeElement(policyEntry);
    }

    PolicyEntry[] getEntry() {
        if (this.policyEntries.size() > 0) {
            PolicyEntry[] policyEntryArray = new PolicyEntry[this.policyEntries.size()];
            for (int i = 0; i < this.policyEntries.size(); ++i) {
                policyEntryArray[i] = (PolicyEntry)this.policyEntries.elementAt(i);
            }
            return policyEntryArray;
        }
        return null;
    }

    PublicKey getPublicKeyAlias(String string) throws KeyStoreException {
        if (this.keyStore == null) {
            return null;
        }
        Certificate certificate = this.keyStore.getCertificate(string);
        if (certificate == null) {
            return null;
        }
        PublicKey publicKey = certificate.getPublicKey();
        return publicKey;
    }

    String[] getPublicKeyAlias() throws KeyStoreException {
        int n = 0;
        String[] stringArray = null;
        if (this.keyStore == null) {
            return null;
        }
        Enumeration<String> enumeration = this.keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++n;
        }
        if (n > 0) {
            stringArray = new String[n];
            n = 0;
            enumeration = this.keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                stringArray[n] = new String(enumeration.nextElement());
                ++n;
            }
        }
        return stringArray;
    }

    String[] parseSigners(String string) {
        String[] stringArray = null;
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 >= 0) {
            n3 = string.indexOf(44, n2);
            if (n3 < 0) continue;
            ++n;
            n2 = n3 + 1;
        }
        stringArray = new String[n];
        n3 = 0;
        n2 = 0;
        while (n3 >= 0) {
            n3 = string.indexOf(44, n2);
            if (n3 >= 0) {
                stringArray[n4] = string.substring(n2, n3).trim();
                ++n4;
                n2 = n3 + 1;
                continue;
            }
            stringArray[n4] = string.substring(n2).trim();
        }
        return stringArray;
    }

    void verifyPrincipal(String string, String string2) throws ClassNotFoundException, InstantiationException {
        Class<?> clazz;
        if (string.equals("WILDCARD_PRINCIPAL_CLASS") || string.equals("PolicyParser.REPLACE_NAME")) {
            return;
        }
        Class<?> clazz2 = Class.forName("java.security.Principal");
        if (!clazz2.isAssignableFrom(clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader()))) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Illegal Principal Type: type"));
            Object[] objectArray = new Object[]{string};
            throw new InstantiationException(messageFormat.format(objectArray));
        }
        if ("javax.security.auth.x500.X500Principal".equals(clazz.getName())) {
            X500Principal x500Principal = new X500Principal(string2);
        }
    }

    void verifyPermission(String string, String string2, String string3) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        Constructor<?> constructor = null;
        Vector<String> vector = new Vector<String>(2);
        if (string2 != null) {
            vector.add(string2);
        }
        if (string3 != null) {
            vector.add(string3);
        }
        switch (vector.size()) {
            case 0: {
                try {
                    constructor = clazz.getConstructor(NOPARAMS);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    vector.add(null);
                }
            }
            case 1: {
                try {
                    constructor = clazz.getConstructor(ONEPARAMS);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    vector.add(null);
                }
            }
            case 2: {
                constructor = clazz.getConstructor(TWOPARAMS);
            }
        }
        Object[] objectArray = vector.toArray();
        Permission permission = (Permission)constructor.newInstance(objectArray);
    }

    static void parseArgs(String[] stringArray) {
        int n = 0;
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            String string = stringArray[n];
            if (collator.compare(string, "-file") == 0) {
                if (++n == stringArray.length) {
                    PolicyTool.usage();
                }
                policyFileName = stringArray[n];
                continue;
            }
            MessageFormat messageFormat = new MessageFormat(rb.getString("Illegal option: option"));
            Object[] objectArray = new Object[]{string};
            System.err.println(messageFormat.format(objectArray));
            PolicyTool.usage();
        }
    }

    static void usage() {
        System.out.println(rb.getString("Usage: policytool [options]"));
        System.out.println();
        System.out.println(rb.getString("  [-file <file>]    policy file location"));
        System.out.println();
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        PolicyTool.parseArgs(stringArray);
        ToolWindow toolWindow = new ToolWindow(new PolicyTool());
        toolWindow.displayToolWindow(stringArray);
    }

    static String splitToWords(String string) {
        return string.replaceAll("([A-Z])", " $1");
    }

    static {
        collator.setStrength(0);
        TWOPARAMS = new Class[]{String.class, String.class};
        ONEPARAMS = new Class[]{String.class};
        NOPARAMS = new Class[0];
        policyFileName = null;
    }
}

