/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import net.sf.jasperreports.engine.util.JEditorPaneMarkupProcessor;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JEditorPaneRtfMarkupProcessor
extends JEditorPaneMarkupProcessor {
    private static final Log log = LogFactory.getLog(JEditorPaneRtfMarkupProcessor.class);
    private static JEditorPaneRtfMarkupProcessor instance;

    public static JEditorPaneRtfMarkupProcessor getInstance() {
        if (instance == null) {
            instance = new JEditorPaneRtfMarkupProcessor();
        }
        return instance;
    }

    public String convert(String srcText) {
        JEditorPane editorPane = new JEditorPane("text/rtf", srcText);
        editorPane.setEditable(false);
        ArrayList elements = new ArrayList();
        Document document = editorPane.getDocument();
        Element root = document.getDefaultRootElement();
        if (root != null) {
            this.addElements(elements, root);
        }
        String chunk = null;
        Element element = null;
        int startOffset = 0;
        int endOffset = 0;
        JRStyledText styledText = new JRStyledText();
        styledText.setGlobalAttributes(new HashMap());
        for (int i = 0; i < elements.size(); ++i) {
            if (chunk != null) {
                styledText.append(chunk);
                styledText.addRun(new JRStyledText.Run(this.getAttributes(element.getAttributes()), startOffset, endOffset));
            }
            chunk = null;
            element = (Element)elements.get(i);
            startOffset = element.getStartOffset();
            endOffset = element.getEndOffset();
            try {
                chunk = document.getText(startOffset, endOffset - startOffset);
                continue;
            }
            catch (BadLocationException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Error converting markup.", (Throwable)e);
            }
        }
        if (chunk != null && !"\n".equals(chunk)) {
            styledText.append(chunk);
            styledText.addRun(new JRStyledText.Run(this.getAttributes(element.getAttributes()), startOffset, endOffset));
        }
        return JRStyledTextParser.getInstance().write(styledText);
    }

    protected void addElements(List elements, Element element) {
        if (element instanceof AbstractDocument.LeafElement) {
            elements.add(element);
        }
        for (int i = 0; i < element.getElementCount(); ++i) {
            Element child = element.getElement(i);
            this.addElements(elements, child);
        }
    }
}

