/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.jni;

import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.impl.jni.JniGDSImpl;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class NativeGDSImpl
extends JniGDSImpl {
    private static Logger log = LoggerFactory.getLogger(NativeGDSImpl.class, false);
    private static final String[] CLIENT_LIBRARIES_TO_TRY = new String[]{"fbclient.dll", "libfbclient.so"};
    public static final String NATIVE_TYPE_NAME = "NATIVE";

    public NativeGDSImpl() {
        this(GDSType.getType(NATIVE_TYPE_NAME));
    }

    public NativeGDSImpl(GDSType gdsType) {
        super(gdsType);
        boolean logging;
        boolean bl = logging = log != null;
        if (logging) {
            log.info("Attempting to initilize native library.");
        }
        this.attemptToLoadAClientLibraryFromList(CLIENT_LIBRARIES_TO_TRY);
        if (logging) {
            log.info("Initilized native library OK.");
        }
    }

    @Override
    protected String getServerUrl(String file_name) throws GDSException {
        DbAttachInfo dbai;
        if (log != null) {
            log.debug("Original file name: " + file_name);
        }
        String fileName = (dbai = new DbAttachInfo(file_name)).getFileName().indexOf(58) == -1 && !dbai.getFileName().startsWith("/") ? dbai.getServer() + "/" + dbai.getPort() + ":" + "/" + dbai.getFileName() : dbai.getServer() + "/" + dbai.getPort() + ":" + dbai.getFileName();
        if (log != null) {
            log.debug("File name for native code: " + fileName);
        }
        return fileName;
    }

    protected static class DbAttachInfo {
        private String server = "localhost";
        private int port = 3050;
        private String fileName;

        public String getConnectionString() {
            if (this.getServer().compareToIgnoreCase("loopback") == 0 || this.getServer().compareToIgnoreCase("localhost") == 0) {
                return this.getFileName();
            }
            return this.getServer() + "/" + this.getPort() + ":" + this.getFileName();
        }

        public DbAttachInfo(String connectInfo) throws GDSException {
            char portSepChar;
            char hostSepChar;
            if (connectInfo == null) {
                throw new GDSException("Connection string missing");
            }
            if ((connectInfo = connectInfo.trim()).startsWith("//")) {
                connectInfo = connectInfo.substring(2);
                hostSepChar = '/';
                portSepChar = ':';
            } else {
                hostSepChar = ':';
                portSepChar = '/';
            }
            int sep = connectInfo.indexOf(hostSepChar);
            if (sep == 0 || sep == connectInfo.length() - 1) {
                throw new GDSException("Bad connection string: '" + hostSepChar + "' at beginning or end of:" + connectInfo + 335544323);
            }
            if (sep > 0) {
                this.server = connectInfo.substring(0, sep);
                this.fileName = connectInfo.substring(sep + 1);
                int portSep = this.server.indexOf(portSepChar);
                if (portSep == 0 || portSep == this.server.length() - 1) {
                    throw new GDSException("Bad server string: '" + portSepChar + "' at beginning or end of: " + this.server + 335544323);
                }
                if (portSep > 0) {
                    this.port = Integer.parseInt(this.server.substring(portSep + 1));
                    this.server = this.server.substring(0, portSep);
                }
            } else if (sep == -1) {
                this.fileName = connectInfo;
            }
        }

        public DbAttachInfo(String server, Integer port, String fileName) throws GDSException {
            if (fileName == null || fileName.equals("")) {
                throw new GDSException("null filename in DbAttachInfo");
            }
            if (server != null) {
                this.server = server;
            }
            if (port != null) {
                this.port = port;
            }
            this.fileName = fileName;
            if (fileName == null || fileName.equals("")) {
                throw new GDSException("null filename in DbAttachInfo");
            }
        }

        public String getServer() {
            return this.server;
        }

        public int getPort() {
            return this.port;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

