/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.IscBlobHandle;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdBlob;
import org.firebirdsql.jdbc.Synchronizable;

public class FBBlob
implements FirebirdBlob,
Synchronizable {
    public static final boolean SEGMENTED = true;
    public static final int READ_FULLY_BUFFER_SIZE = 16384;
    private int bufferlength;
    private boolean isNew;
    private long blob_id;
    private GDSHelper gdsHelper;
    private FBObjectListener.BlobListener blobListener;
    private Collection inputStreams = new HashSet();
    private FBBlobOutputStream blobOut = null;
    public static final byte[] BLOB_LENGTH_REQUEST = new byte[]{6};

    private FBBlob(GDSHelper c, boolean isNew, FBObjectListener.BlobListener blobListener) {
        this.gdsHelper = c;
        this.isNew = isNew;
        this.bufferlength = c.getBlobBufferLength();
        this.blobListener = blobListener;
    }

    public FBBlob(GDSHelper c, FBObjectListener.BlobListener blobListener) {
        this(c, true, blobListener);
    }

    public FBBlob(GDSHelper c) {
        this(c, null);
    }

    public FBBlob(GDSHelper c, long blob_id, FBObjectListener.BlobListener blobListener) {
        this(c, false, blobListener);
        this.blob_id = blob_id;
    }

    public FBBlob(GDSHelper c, long blob_id) {
        this(c, blob_id, null);
    }

    @Override
    public Object getSynchronizationObject() {
        return this.gdsHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            IOException error = null;
            Iterator i = this.inputStreams.iterator();
            while (i.hasNext()) {
                try {
                    ((FBBlobInputStream)i.next()).close();
                }
                catch (IOException ex) {
                    error = ex;
                }
            }
            this.inputStreams.clear();
            if (error != null) {
                throw error;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public byte[] getInfo(byte[] items, int buffer_length) throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            try {
                byte[] byArray;
                if (this.blobListener != null) {
                    this.blobListener.executionStarted(this);
                }
                IscBlobHandle blob = this.gdsHelper.openBlob(this.blob_id, true);
                try {
                    byArray = this.gdsHelper.getBlobInfo(blob, items, buffer_length);
                }
                catch (Throwable throwable) {
                    try {
                        this.gdsHelper.closeBlob(blob);
                        throw throwable;
                    }
                    catch (GDSException ex) {
                        throw new FBSQLException(ex);
                    }
                }
                this.gdsHelper.closeBlob(blob);
                return byArray;
            }
            finally {
                if (this.blobListener != null) {
                    this.blobListener.executionCompleted(this);
                }
            }
        }
    }

    @Override
    public long length() throws SQLException {
        byte[] info = this.getInfo(BLOB_LENGTH_REQUEST, 20);
        return this.interpretLength(info, 0);
    }

    public static long interpretLength(GDSHelper gdsHelper, byte[] info, int position) throws SQLException {
        if (info[position] != 6) {
            throw new FBSQLException("Length is not available.");
        }
        int dataLength = gdsHelper.iscVaxInteger(info, position + 1, 2);
        return gdsHelper.iscVaxInteger(info, position + 3, dataLength);
    }

    private long interpretLength(byte[] info, int position) throws SQLException {
        return FBBlob.interpretLength(this.gdsHelper, info, position);
    }

    @Override
    public boolean isSegmented() throws SQLException {
        byte[] info = this.getInfo(new byte[]{7}, 20);
        if (info[0] != 7) {
            throw new FBSQLException("Cannot determine BLOB type");
        }
        int dataLength = this.gdsHelper.iscVaxInteger(info, 1, 2);
        int type = this.gdsHelper.iscVaxInteger(info, 3, dataLength);
        return type == 0;
    }

    @Override
    public FirebirdBlob detach() throws SQLException {
        return new FBBlob(this.gdsHelper, this.blob_id, this.blobListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        Object syncObject;
        if (pos < 1L) {
            throw new FBSQLException("Blob position should be >= 1");
        }
        if (pos > Integer.MAX_VALUE) {
            throw new FBSQLException("Blob position is limited to 2^31 - 1 due to isc_seek_blob limitations.", "HY009");
        }
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            if (this.blobListener != null) {
                this.blobListener.executionStarted(this);
            }
            try {
                byte[] byArray;
                FirebirdBlob.BlobInputStream in = (FirebirdBlob.BlobInputStream)((Object)this.getBinaryStream());
                try {
                    byte[] result = new byte[length];
                    if (pos != 1L) {
                        in.seek((int)pos - 1);
                    }
                    in.readFully(result);
                    byArray = result;
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new FBSQLException(ex);
                    }
                }
                in.close();
                return byArray;
            }
            finally {
                if (this.blobListener != null) {
                    this.blobListener.executionCompleted(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            FBBlobInputStream blobstream = new FBBlobInputStream(this);
            this.inputStreams.add(blobstream);
            return blobstream;
        }
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void truncate(long param1) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public int setBytes(long param1, byte[] param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public int setBytes(long param1, byte[] param2, int param3, int param4) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        if (this.blobListener != null) {
            this.blobListener.executionStarted(this);
        }
        if (this.blobOut != null) {
            throw new FBSQLException("Only one blob output stream open at a time!");
        }
        if (pos < 0L) {
            throw new FBSQLException("You can't start before the beginning of the blob", "HY009");
        }
        if (this.isNew && pos > 0L) {
            throw new FBSQLException("Previous value was null, you must start at position 0", "HY009");
        }
        this.blobOut = new FBBlobOutputStream();
        if (pos > 0L) {
            throw new FBDriverNotCapableException("Non-null positions are not yet supported.");
        }
        return this.blobOut;
    }

    public long getBlobId() throws SQLException {
        if (this.isNew) {
            throw new FBSQLException("No Blob ID is available in new Blob object.");
        }
        return this.blob_id;
    }

    void setBlobId(long blob_id) {
        this.blob_id = blob_id;
        this.isNew = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyBytes(byte[] bytes, int pos, int len) throws SQLException {
        OutputStream out = this.setBinaryStream(0L);
        try {
            try {
                out.write(bytes, pos, len);
            }
            finally {
                out.close();
            }
        }
        catch (IOException ex) {
            throw new FBSQLException(ex);
        }
    }

    public void copyStream(InputStream inputStream, int length) throws SQLException {
        OutputStream os = this.setBinaryStream(0L);
        byte[] buffer = new byte[Math.min(this.bufferlength, length)];
        try {
            int chunk;
            while (length > 0 && (chunk = inputStream.read(buffer, 0, length < this.bufferlength ? length : this.bufferlength)) != -1) {
                os.write(buffer, 0, chunk);
                length -= chunk;
            }
            os.flush();
            os.close();
        }
        catch (IOException ioe) {
            throw new FBSQLException(ioe);
        }
    }

    public void copyStream(InputStream inputStream) throws SQLException {
        OutputStream os = this.setBinaryStream(0L);
        try {
            int chunk = 0;
            byte[] buffer = new byte[this.bufferlength];
            while ((chunk = inputStream.read(buffer)) != -1) {
                os.write(buffer, 0, chunk);
            }
            os.flush();
            os.close();
        }
        catch (IOException ioe) {
            throw new FBSQLException(ioe);
        }
    }

    public void copyCharacterStream(Reader inputStream, int length, String encoding) throws SQLException {
        OutputStream os = this.setBinaryStream(0L);
        try {
            OutputStreamWriter osw = encoding != null ? new OutputStreamWriter(os, encoding) : new OutputStreamWriter(os);
            char[] buffer = new char[Math.min(this.bufferlength, length)];
            try {
                int chunk;
                while (length > 0 && (chunk = inputStream.read(buffer, 0, length < this.bufferlength ? length : this.bufferlength)) != -1) {
                    osw.write(buffer, 0, chunk);
                    length -= chunk;
                }
                osw.flush();
                os.flush();
                os.close();
            }
            catch (IOException ioe) {
                throw new FBSQLException(ioe);
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new FBSQLException("Cannot set character stream because the unsupported encoding is detected in the JVM: " + encoding + ". Please report this to the driver developers.");
        }
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public class FBBlobOutputStream
    extends OutputStream
    implements FirebirdBlob.BlobOutputStream {
        private IscBlobHandle blob;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FBBlobOutputStream() throws SQLException {
            Object syncObject;
            Object object = syncObject = FBBlob.this.getSynchronizationObject();
            synchronized (object) {
                try {
                    DatabaseParameterBuffer dpb = FBBlob.this.gdsHelper.getDatabaseParameterBuffer();
                    boolean useStreamBlobs = dpb.hasArgument(131);
                    this.blob = FBBlob.this.gdsHelper.createBlob(!useStreamBlobs);
                }
                catch (GDSException ge) {
                    throw new FBSQLException(ge);
                }
            }
            if (FBBlob.this.isNew) {
                FBBlob.this.setBlobId(this.blob.getBlobId());
            }
        }

        public void seek(int position, int seekMode) throws SQLException {
            try {
                FBBlob.this.gdsHelper.seekBlob(this.blob, position, seekMode);
            }
            catch (GDSException ex) {
                throw new FBSQLException(ex);
            }
        }

        @Override
        public long length() throws IOException {
            Object syncObject;
            Object object = syncObject = FBBlob.this.getSynchronizationObject();
            synchronized (object) {
                try {
                    byte[] info = FBBlob.this.gdsHelper.getBlobInfo(this.blob, new byte[]{6}, 20);
                    return FBBlob.this.interpretLength(info, 0);
                }
                catch (GDSException ex) {
                    throw new IOException(ex.getMessage());
                }
                catch (SQLException ex) {
                    throw new IOException(ex.getMessage());
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            throw new IOException("FBBlobOutputStream.write(int b) not implemented");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeSegment(byte[] buf) throws GDSException {
            Object syncObject;
            Object object = syncObject = FBBlob.this.getSynchronizationObject();
            synchronized (object) {
                FBBlob.this.gdsHelper.putBlobSegment(this.blob, buf);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                if (off == 0 && len == b.length && len < FBBlob.this.bufferlength) {
                    this.writeSegment(b);
                } else {
                    int chunk = FBBlob.this.bufferlength;
                    int lastChunk = 0;
                    byte[] buf = null;
                    while (len > 0) {
                        if (len < chunk) {
                            chunk = len;
                        }
                        if (chunk != lastChunk) {
                            buf = new byte[chunk];
                            lastChunk = chunk;
                        }
                        System.arraycopy(b, off, buf, 0, chunk);
                        this.writeSegment(buf);
                        len -= chunk;
                        off += chunk;
                    }
                }
            }
            catch (GDSException ge) {
                throw new IOException("Problem writing to FBBlobOutputStream: " + ge);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.blob != null) {
                try {
                    Object syncObject;
                    Object object = syncObject = FBBlob.this.getSynchronizationObject();
                    synchronized (object) {
                        FBBlob.this.gdsHelper.closeBlob(this.blob);
                    }
                    FBBlob.this.setBlobId(this.blob.getBlobId());
                }
                catch (GDSException ge) {
                    throw new IOException("could not close blob: " + ge);
                }
                this.blob = null;
            }
        }
    }

    public class FBBlobInputStream
    extends InputStream
    implements FirebirdBlob.BlobInputStream {
        private byte[] buffer = null;
        private IscBlobHandle blob;
        private int pos = 0;
        private boolean closed;
        private FBBlob owner;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FBBlobInputStream(FBBlob owner) throws SQLException {
            Object syncObject;
            this.owner = owner;
            this.closed = false;
            if (FBBlob.this.isNew) {
                throw new FBSQLException("You can't read a new blob");
            }
            Object object = syncObject = FBBlob.this.getSynchronizationObject();
            synchronized (object) {
                try {
                    this.blob = FBBlob.this.gdsHelper.openBlob(FBBlob.this.blob_id, true);
                }
                catch (GDSException ge) {
                    throw new FBSQLException(ge);
                }
            }
        }

        @Override
        public FirebirdBlob getBlob() {
            return this.owner;
        }

        @Override
        public void seek(int position) throws IOException {
            this.seek(position, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void seek(int position, int seekMode) throws IOException {
            Object syncObject;
            Object object = syncObject = FBBlob.this.getSynchronizationObject();
            synchronized (object) {
                this.checkClosed();
                try {
                    FBBlob.this.gdsHelper.seekBlob(this.blob, position, seekMode);
                }
                catch (GDSException ex) {
                    throw new IOException(ex.getMessage());
                }
            }
        }

        @Override
        public long length() throws IOException {
            Object syncObject;
            Object object = syncObject = FBBlob.this.getSynchronizationObject();
            synchronized (object) {
                this.checkClosed();
                try {
                    byte[] info = FBBlob.this.gdsHelper.getBlobInfo(this.blob, new byte[]{6}, 20);
                    return FBBlob.this.interpretLength(info, 0);
                }
                catch (GDSException ex) {
                    throw new IOException(ex.getMessage());
                }
                catch (SQLException ex) {
                    throw new IOException(ex.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            Object syncObject;
            Object object = syncObject = FBBlob.this.getSynchronizationObject();
            synchronized (object) {
                this.checkClosed();
                if (this.buffer == null) {
                    if (this.blob.isEof()) {
                        return -1;
                    }
                    try {
                        this.buffer = FBBlob.this.gdsHelper.getBlobSegment(this.blob, FBBlob.this.bufferlength);
                    }
                    catch (GDSException ge) {
                        throw new IOException("Blob read problem: " + ge.toString());
                    }
                    this.pos = 0;
                    if (this.buffer.length == 0) {
                        return -1;
                    }
                }
                return this.buffer.length - this.pos;
            }
        }

        @Override
        public int read() throws IOException {
            if (this.available() <= 0) {
                return -1;
            }
            int result = this.buffer[this.pos++] & 0xFF;
            if (this.pos == this.buffer.length) {
                this.buffer = null;
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.available();
            if (result <= 0) {
                return -1;
            }
            if (result > len) {
                System.arraycopy(this.buffer, this.pos, b, off, len);
                this.pos += len;
                return len;
            }
            System.arraycopy(this.buffer, this.pos, b, off, result);
            this.buffer = null;
            this.pos = 0;
            return result;
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            int counter = 0;
            int pos = 0;
            byte[] buffer = new byte[Math.min(16384, len)];
            for (int toRead = len; toRead > 0 && (counter = this.read(buffer, 0, toRead)) != -1; toRead -= counter) {
                System.arraycopy(buffer, 0, b, pos, counter);
                pos += counter;
            }
            if (counter == -1) {
                throw new EOFException();
            }
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object syncObject;
            Object object = syncObject = FBBlob.this.getSynchronizationObject();
            synchronized (object) {
                if (this.blob != null) {
                    try {
                        FBBlob.this.gdsHelper.closeBlob(this.blob);
                        FBBlob.this.inputStreams.remove(this);
                    }
                    catch (GDSException ge) {
                        throw new IOException("couldn't close blob: " + ge);
                    }
                    this.blob = null;
                    this.closed = true;
                }
            }
        }

        private void checkClosed() throws IOException {
            if (this.closed) {
                throw new IOException("Input stream is already closed.");
            }
        }
    }
}

