/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EnvProperties {
    public static String FILE_SEPARETOR = System.getProperty("file.separator");
    public static String LINE_SEPARETOR = System.getProperty("line.separator");
    public static String PROP_FILE_NAME = "f2.propFileName";
    public static String DEFAULT_LANGUAGE = "f2.language.file";
    public static String LOOK = "f2.lookandfeel";
    public static String WIDTH = "f2.width";
    public static String HEIGHT = "f2.height";
    public static String FILELOGO = "f2.filelogo.file";
    public static String APPNAME = "f2.app.name";
    public static String VERSION = "f2.app.version";
    public static String DB_DRIVER = "f2.db.driver";
    public static String DB_URL = "f2.db.url";
    public static String DB_USER = "f2.db.user";
    public static String DB_PASSW = "f2.db.passw";
    public static String DB_ISEMBEDDED = "f2.db.embedded";
    public static String DB_FDBFILE = "f2.db.fdbfile";
    public static String START_CMD = "f2.start.cmd";
    public static String SERVER_PROCESS = "f2.server.process";
    public static String INDIRIZZO = "f2.indirizzo";
    public static String INFOCLIENTE = "f2.infocliente";
    public static String DOPPIACOPIA = "f2.doppiaCopia";
    public static String LANGUAGE = "f2.language";
    public static String LOCALE = "f2.locale";
    public static String PREFIX_NUM = "f2.prefix.num";
    private Properties properties;
    private static EnvProperties instance;

    public Properties getProperties() {
        if (this.properties == null) {
            this.loadProperties();
        }
        return this.properties;
    }

    public String getProperty(String propName) {
        String result = this.getProperties().getProperty(propName);
        if (result != null) {
            if (result.indexOf("\\") > 0 || result.indexOf("/") > 0) {
                return result.replace("\\", FILE_SEPARETOR);
            }
        } else {
            this.setProperty(propName, "");
            result = "";
        }
        return result;
    }

    public static EnvProperties getInstance() {
        if (instance == null) {
            instance = new EnvProperties();
        }
        return instance;
    }

    public void loadProperties() {
        this.properties = new Properties();
        try {
            this.properties.put("f2.propFileName", "conf" + FILE_SEPARETOR + "f2.properties");
            this.properties.load(new FileInputStream(this.getProperty(PROP_FILE_NAME)));
        }
        catch (IOException e) {
            Logger.getRootLogger().error((Object)("Exception in loadProperties \n" + e + "\n"));
        }
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void saveFileProperty() {
        try {
            FileOutputStream fileProp = new FileOutputStream(this.getProperty(PROP_FILE_NAME));
            this.properties.store(fileProp, null);
        }
        catch (FileNotFoundException fnf) {
            Logger.getRootLogger().error((Object)("Exception in saveFileProperty \n" + fnf + "\n"));
        }
        catch (IOException io) {
            Logger.getRootLogger().error((Object)("Exception in saveFileProperty \n" + io + "\n"));
        }
    }

    private EnvProperties() {
    }

    public void clear() {
        this.properties = null;
    }

    public void println() {
        Properties property = EnvProperties.getInstance().getProperties();
        Enumeration<?> enumeration = property.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propName = (String)enumeration.nextElement();
            System.out.println(String.valueOf(propName) + "=" + property.getProperty(propName));
        }
    }

    public static void main(String[] args) {
        EnvProperties.getInstance().println();
    }
}

