/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip;

import it.f2.gestRip.EnvProperties;
import it.f2.gestRip.control.CommonMetodBin;
import it.f2.gestRip.ui.VcMainFrame;
import it.f2.gestRip.ui.VcSplashScreen;
import it.f2.util.ui.WindowUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JWindow;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class StartApp {
    private static Logger logger = Logger.getLogger(StartApp.class);
    private static VcSplashScreen splash;

    public static void main(String[] args) {
        StartApp.initLog4j();
        try {
            logger.debug((Object)"Loading look&feel");
            UIManager.setLookAndFeel(EnvProperties.getInstance().getProperty(EnvProperties.LOOK));
        }
        catch (Exception e) {
            logger.error((Object)("Exception in Loading look&feel\n" + e + "\n"));
        }
        StartApp.showSplash();
        splash.setStatus("Starting...", 10);
        splash.setStatus("Setting locale", 30);
        String selVal = EnvProperties.getInstance().getProperty(EnvProperties.LOCALE);
        Locale.setDefault(new Locale(selVal.split("-")[0], selVal.split("-")[1]));
        if (!StartApp.checkProcess(EnvProperties.getInstance().getProperty(EnvProperties.SERVER_PROCESS))) {
            splash.setStatus("Start Server...", 50);
            StartApp.startServer();
        }
        splash.setStatus("Testing Connection...", 70);
        StartApp.testConn();
        splash.setStatus("Loading App...", 90);
        VcMainFrame frame = new VcMainFrame();
        logger.debug((Object)"Application loaded...");
        CommonMetodBin.getInstance().setMainFrame(frame);
        splash.setStatus("Started...", 100);
        frame.setVisible(true);
        StartApp.hideSplash();
    }

    private static void initLog4j() {
        String configFile = EnvProperties.getInstance().getProperty("Log4jConfig");
        String logFile = EnvProperties.getInstance().getProperty("Log4jLogFile");
        try {
            System.setProperty("Log4jLogFile", logFile);
            System.out.println("LogFile di Log4j: " + logFile);
        }
        catch (Exception ex) {
            System.out.println("Eccezione : " + ex.getMessage());
            return;
        }
        if (configFile != null) {
            PropertyConfigurator.configure((String)configFile);
            System.out.println("Configurazione Log4j: " + configFile);
        }
        logger.info((Object)"File di log inizializzato con successo....");
    }

    private static void testConn() {
        Connection con = CommonMetodBin.getConn();
        CommonMetodBin.closeConn(con);
    }

    private static void startServer() {
        final String cmd = EnvProperties.getInstance().getProperty(EnvProperties.START_CMD);
        if (cmd != null && !cmd.equals("")) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Runtime rt = Runtime.getRuntime();
                        Process proc = rt.exec(cmd);
                        splash.setStatus("Server Started...", 70);
                        proc.waitFor();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public static VcSplashScreen showSplash() {
        if (splash != null) {
            if (splash.isShowing()) {
                return splash;
            }
            splash = null;
        }
        splash = new VcSplashScreen();
        WindowUtil.centerWindow((JWindow)splash);
        splash.setVisible(true);
        return splash;
    }

    public static void hideSplash() {
        if (splash != null) {
            splash.dispose();
            splash = null;
        }
    }

    public static void runInitializer(Runnable r) {
        Thread t = new Thread(r);
        t.start();
    }

    public static boolean checkProcess(String process) {
        if (process != null && process.equals("")) {
            return false;
        }
        boolean result = false;
        List<String> processes = StartApp.listRunningProcesses();
        for (String pr : processes) {
            if (!pr.equalsIgnoreCase(process)) continue;
            return true;
        }
        return result;
    }

    public static List<String> listRunningProcesses() {
        ArrayList<String> processes = new ArrayList<String>();
        try {
            String line;
            Process p = Runtime.getRuntime().exec("tasklist.exe /nh");
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                if (line.trim().equals("")) continue;
                processes.add(line.substring(0, line.indexOf("  ")));
            }
            input.close();
        }
        catch (Exception err) {
            logger.error((Object)("Exception in Remove process running \n" + err + "\n"));
        }
        return processes;
    }
}

