/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip.control;

import it.f2.gestRip.EnvProperties;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class CommonMetodBin {
    private static CommonMetodBin instance;
    private JFrame mainFrame;

    private CommonMetodBin() {
    }

    public static CommonMetodBin getInstance() {
        if (instance == null) {
            instance = new CommonMetodBin();
        }
        return instance;
    }

    public static Connection getConn() {
        Connection con = null;
        try {
            Logger.getRootLogger().debug((Object)"Connecting DB...");
            if (EnvProperties.getInstance().getProperty(EnvProperties.DB_ISEMBEDDED).endsWith("S")) {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
                con = DriverManager.getConnection("jdbc:derby:db/derby/gestrip");
                con.setAutoCommit(false);
            } else {
                Class.forName(EnvProperties.getInstance().getProperty(EnvProperties.DB_DRIVER)).newInstance();
                con = DriverManager.getConnection(EnvProperties.getInstance().getProperty(EnvProperties.DB_URL), EnvProperties.getInstance().getProperty(EnvProperties.DB_USER), EnvProperties.getInstance().getProperty(EnvProperties.DB_PASSW));
                con.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            Logger.getRootLogger().error((Object)("Exception in Connecting DB \n" + e + "\n"));
            JOptionPane.showMessageDialog(CommonMetodBin.getInstance().mainFrame, "Errore durante la connsessione al server: " + e.getMessage(), "Errore...", 0);
        }
        catch (InstantiationException e) {
            Logger.getRootLogger().error((Object)("Exception in Connecting DB \n" + e + "\n"));
            JOptionPane.showMessageDialog(CommonMetodBin.getInstance().mainFrame, "Errore durante la connsessione al server: " + e.getMessage(), "Errore...", 0);
        }
        catch (IllegalAccessException e) {
            Logger.getRootLogger().error((Object)("Exception in Connecting DB \n" + e + "\n"));
            JOptionPane.showMessageDialog(CommonMetodBin.getInstance().mainFrame, "Errore durante la connsessione al server: " + e.getMessage(), "Errore...", 0);
        }
        catch (ClassNotFoundException e) {
            Logger.getRootLogger().error((Object)("Exception in Connecting DB \n" + e + "\n"));
            JOptionPane.showMessageDialog(CommonMetodBin.getInstance().mainFrame, "Errore durante la connsessione al server: " + e.getMessage(), "Errore...", 0);
        }
        return con;
    }

    public String testServerConn(String driver, String url, String user, String psw) {
        String result = "Non Connesso";
        try {
            Logger.getRootLogger().debug((Object)"Testing Connection DB...");
            Class.forName(driver).newInstance();
            Connection testCon = DriverManager.getConnection(url, user, psw);
            Statement smtp = testCon.createStatement();
            ResultSet rs = smtp.executeQuery("select count(*) as countSchede from schede");
            while (rs.next()) {
                System.out.println(rs.getInt("countSchede"));
            }
            rs.close();
            smtp.close();
            testCon.close();
            result = "Ok";
        }
        catch (SQLException e) {
            result = "Errore:" + e.getErrorCode() + ":" + e.getMessage();
        }
        catch (InstantiationException e) {
            result = e.getMessage();
        }
        catch (IllegalAccessException e) {
            result = e.getMessage();
        }
        catch (ClassNotFoundException e) {
            result = e.getMessage();
        }
        catch (Exception e) {
            result = e.getMessage();
        }
        return result;
    }

    public String testEmbConn() {
        String result = "Non Connesso";
        try {
            Logger.getRootLogger().debug((Object)"Testing Connection Embedded DB...");
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            Connection testCon = DriverManager.getConnection("jdbc:derby:db/derby/gestrip");
            Statement smtp = testCon.createStatement();
            ResultSet rs = smtp.executeQuery("select count(*) as countSchede from schede");
            while (rs.next()) {
                System.out.println(rs.getInt("countSchede"));
            }
            rs.close();
            smtp.close();
            testCon.close();
            result = "Ok";
        }
        catch (SQLException e) {
            result = "Errore:" + e.getErrorCode() + ":" + e.getMessage();
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            result = e.getMessage();
        }
        catch (IllegalAccessException e) {
            result = e.getMessage();
        }
        catch (ClassNotFoundException e) {
            result = e.getMessage();
        }
        catch (Exception e) {
            result = e.getMessage();
        }
        return result;
    }

    public static void closeConn(Connection con) {
        try {
            Logger.getRootLogger().debug((Object)"Closing Connection DB...");
            if (con != null && !con.isClosed()) {
                con.commit();
                con.close();
            }
        }
        catch (SQLException e) {
            Logger.getRootLogger().error((Object)("Exception in Closing Connection DB \n" + e + "\n"));
            JOptionPane.showMessageDialog(CommonMetodBin.getInstance().mainFrame, "Errore durante la chiusura del server: " + e.getMessage(), "Errore...", 0);
            e.printStackTrace();
        }
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setMainFrame(JFrame value) {
        this.mainFrame = value;
    }
}

