/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip.control;

import it.f2.gestRip.EnvProperties;
import it.f2.gestRip.control.CommonMetodBin;
import it.f2.gestRip.ui.messages.Messages;
import it.f2.util.ui.WindowUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.InputStream;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JRViewer;
import org.apache.log4j.Logger;

public class PrintAction {
    private int nScheda;
    private JDialog dialog = null;
    private JFrame frame = null;
    private Connection con = null;

    private JasperReport getReportRicevuta() throws JRException {
        InputStream rep = this.getClass().getResourceAsStream("/it/f2/gestRip/report/RicevutaConsegnaApparato.jasper");
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)rep);
        return jasperReport;
    }

    public void callReportRicevuta(JDialog parent, int nScheda, Connection con) {
        this.nScheda = nScheda;
        this.dialog = parent;
        this.con = con;
        this.initialize();
    }

    public void callReportRicevuta(JFrame parent, int nScheda, Connection con) {
        this.nScheda = nScheda;
        this.frame = parent;
        this.con = con;
        this.initialize();
    }

    private void initialize() {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("idScheda", this.nScheda);
            parameters.put("prefixNum", EnvProperties.getInstance().getProperty(EnvProperties.PREFIX_NUM));
            parameters.put("infoCliente", EnvProperties.getInstance().getProperty(EnvProperties.INFOCLIENTE));
            parameters.put("indirizzoRivenditore", EnvProperties.getInstance().getProperty(EnvProperties.INDIRIZZO));
            parameters.put("logo", EnvProperties.getInstance().getProperty(EnvProperties.FILELOGO));
            boolean doppiaCopia = false;
            String optDC = EnvProperties.getInstance().getProperty(EnvProperties.DOPPIACOPIA);
            if (optDC.equals("S")) {
                doppiaCopia = true;
            }
            parameters.put("stampaDoppia", doppiaCopia);
            parameters.put("REPORT_LOCALE", Locale.getDefault());
            parameters.put("REPORT_RESOURCE_BUNDLE", Messages.getRESOURCE_BUNDLE());
            JasperPrint jp = JasperFillManager.fillReport((JasperReport)this.getReportRicevuta(), parameters, (Connection)this.con);
            if (jp.getPages() != null && jp.getPages().size() > 0) {
                JRViewer aViewer = new JRViewer(jp, Locale.getDefault());
                JDialog repDlg = this.dialog != null ? new JDialog(this.dialog) : new JDialog(this.frame);
                repDlg.setModal(true);
                repDlg.setTitle(Messages.getString("PrintAction.7"));
                repDlg.getContentPane().add((Component)aViewer);
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                repDlg.setSize(1080, screenSize.height - 80);
                Insets insets = repDlg.getInsets();
                repDlg.setSize(repDlg.getWidth() + insets.left + insets.right, repDlg.getHeight() + insets.top + insets.bottom + 20);
                WindowUtil.centerWindow((JDialog)repDlg);
                repDlg.setVisible(true);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(CommonMetodBin.getInstance().getMainFrame(), String.valueOf(Messages.getString("PrintAction.8")) + (Object)((Object)e) + "\n", Messages.getString("PrintAction.10"), 2);
            Logger.getRootLogger().error((Object)(String.valueOf(Messages.getString("PrintAction.11")) + (Object)((Object)e) + "\n"));
        }
    }
}

