/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip.ui;

import it.f2.gestRip.EnvProperties;
import it.f2.gestRip.control.CommonMetodBin;
import it.f2.gestRip.ui.messages.Messages;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class VcDlgAdvancedOptions
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JTextField txpJdbcDriver = null;
    private JTextField txpJdbcUrl = null;
    private JTextField txpJdbcUser = null;
    private JPasswordField txpJdbcPsw = null;
    private JLabel lblGenerali = null;
    private JLabel lblJdbcDriver = null;
    private JLabel lblJdbcUrl = null;
    private JLabel lblJdbcUser = null;
    private JLabel LblJdbcPsw = null;
    private JLabel lblDBOptions = null;
    private JButton btnCanc = null;
    private JButton btnOk = null;
    private JLabel lblStartCmd = null;
    private JTextField txfStartCmd = null;
    private JTextField txfServeProc = null;
    private JLabel lblServerProc = null;
    private JCheckBox ckbEmbedded = null;
    private JButton btnTestConn = null;

    public VcDlgAdvancedOptions(Frame owner) {
        super(owner, true);
        Logger.getRootLogger().debug((Object)"VcDlgAdvancedOptions constructor...");
        this.initialize();
        if (EnvProperties.getInstance().getProperty(EnvProperties.DB_ISEMBEDDED).equalsIgnoreCase("S")) {
            this.setEmbedded();
        } else {
            this.setNonEmbedded();
        }
    }

    private void initialize() {
        this.setSize(524, 398);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.lblServerProc = new JLabel();
            this.lblServerProc.setBounds(new Rectangle(7, 63, 132, 15));
            this.lblServerProc.setText("Processo Server");
            this.lblStartCmd = new JLabel();
            this.lblStartCmd.setBounds(new Rectangle(8, 13, 126, 16));
            this.lblStartCmd.setText("Comando di avvio");
            this.lblDBOptions = new JLabel();
            this.lblDBOptions.setBounds(new Rectangle(46, 126, 119, 16));
            this.lblDBOptions.setText(Messages.getString("VcDlgAdvancedOptions.lblDbConfig"));
            this.LblJdbcPsw = new JLabel();
            this.LblJdbcPsw.setBounds(new Rectangle(7, 249, 90, 16));
            this.LblJdbcPsw.setText(Messages.getString("VcDlgAdvancedOptions.lblJDBCPassw"));
            this.lblJdbcUser = new JLabel();
            this.lblJdbcUser.setBounds(new Rectangle(7, 219, 90, 16));
            this.lblJdbcUser.setText(Messages.getString("VcDlgAdvancedOptions.lblJDBCUser"));
            this.lblJdbcUrl = new JLabel();
            this.lblJdbcUrl.setBounds(new Rectangle(7, 189, 90, 16));
            this.lblJdbcUrl.setText(Messages.getString("VcDlgAdvancedOptions.lblJDBCUrl"));
            this.lblJdbcDriver = new JLabel();
            this.lblJdbcDriver.setBounds(new Rectangle(7, 159, 90, 16));
            this.lblJdbcDriver.setText(Messages.getString("VcDlgAdvancedOptions.lblJDBCDriver"));
            this.lblGenerali = new JLabel();
            this.lblGenerali.setBounds(new Rectangle(8, 120, 30, 30));
            this.lblGenerali.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/Options30.png")));
            this.lblGenerali.setText("");
            this.lblGenerali.setHorizontalAlignment(0);
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getTxpJdbcDriver(), null);
            this.jContentPane.add((Component)this.getTxpJdbcUrl(), null);
            this.jContentPane.add((Component)this.getTxpJdbcUser(), null);
            this.jContentPane.add((Component)this.getTxpJdbcPsw(), null);
            this.jContentPane.add((Component)this.lblGenerali, null);
            this.jContentPane.add((Component)this.lblJdbcDriver, null);
            this.jContentPane.add((Component)this.lblJdbcUrl, null);
            this.jContentPane.add((Component)this.lblJdbcUser, null);
            this.jContentPane.add((Component)this.LblJdbcPsw, null);
            this.jContentPane.add((Component)this.lblDBOptions, null);
            this.jContentPane.add((Component)this.getBtnCanc(), null);
            this.jContentPane.add((Component)this.getBtnOk(), null);
            this.jContentPane.add((Component)this.lblStartCmd, null);
            this.jContentPane.add((Component)this.getTxfStartCmd(), null);
            this.jContentPane.add((Component)this.getTxfServeProc(), null);
            this.jContentPane.add((Component)this.lblServerProc, null);
            this.jContentPane.add((Component)this.getCkbEmbedded(), null);
            this.jContentPane.add((Component)this.getBtnTestConn(), null);
        }
        return this.jContentPane;
    }

    private JTextField getTxpJdbcDriver() {
        if (this.txpJdbcDriver == null) {
            this.txpJdbcDriver = new JTextField();
            this.txpJdbcDriver.setBounds(new Rectangle(100, 158, 409, 25));
            this.txpJdbcDriver.setText(EnvProperties.getInstance().getProperty(EnvProperties.DB_DRIVER));
        }
        return this.txpJdbcDriver;
    }

    private JTextField getTxpJdbcUrl() {
        if (this.txpJdbcUrl == null) {
            this.txpJdbcUrl = new JTextField();
            this.txpJdbcUrl.setBounds(new Rectangle(100, 188, 409, 25));
            this.txpJdbcUrl.setText(EnvProperties.getInstance().getProperty(EnvProperties.DB_URL));
        }
        return this.txpJdbcUrl;
    }

    private JTextField getTxpJdbcUser() {
        if (this.txpJdbcUser == null) {
            this.txpJdbcUser = new JTextField();
            this.txpJdbcUser.setBounds(new Rectangle(100, 218, 191, 25));
            this.txpJdbcUser.setText(EnvProperties.getInstance().getProperty(EnvProperties.DB_USER));
        }
        return this.txpJdbcUser;
    }

    private JPasswordField getTxpJdbcPsw() {
        if (this.txpJdbcPsw == null) {
            this.txpJdbcPsw = new JPasswordField();
            this.txpJdbcPsw.setBounds(new Rectangle(100, 248, 191, 25));
            this.txpJdbcPsw.setText(EnvProperties.getInstance().getProperty(EnvProperties.DB_PASSW));
        }
        return this.txpJdbcPsw;
    }

    private JButton getBtnCanc() {
        if (this.btnCanc == null) {
            this.btnCanc = new JButton();
            this.btnCanc.setBounds(new Rectangle(210, 328, 96, 25));
            this.btnCanc.setText(Messages.getString("VcDlgAdvancedOptions.btnCanc"));
            this.btnCanc.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/button_cancel.png")));
            this.btnCanc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcDlgAdvancedOptions.this.dispose();
                }
            });
        }
        return this.btnCanc;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setBounds(new Rectangle(310, 328, 85, 25));
            this.btnOk.setText(Messages.getString("VcDlgAdvancedOptions.btnSave"));
            this.btnOk.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/filesave.png")));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcDlgAdvancedOptions.this.save();
                }
            });
        }
        return this.btnOk;
    }

    private void save() {
        this.updateConf();
        this.dispose();
    }

    private void test() {
        String testConnection = "";
        testConnection = this.getCkbEmbedded().isSelected() ? CommonMetodBin.getInstance().testEmbConn() : CommonMetodBin.getInstance().testServerConn(this.getTxpJdbcDriver().getText(), this.getTxpJdbcUrl().getText(), this.getTxpJdbcUser().getText(), this.getTxpJdbcPsw().getText());
        String msg = "";
        int confirm = 0;
        if (testConnection.equals(Messages.getString("VcDlgAdvancedOptions.btnOk"))) {
            msg = String.valueOf(Messages.getString("VcDlgAdvancedOptions.msgTestOk1")) + Messages.getString("VcDlgAdvancedOptions.msgTestOk2");
            confirm = JOptionPane.showConfirmDialog(this.getParent(), msg, Messages.getString("VcDlgAdvancedOptions.msgTitleInfo"), 0, 1);
        } else {
            msg = String.valueOf(Messages.getString("VcDlgAdvancedOptions.msgTestFailed1")) + testConnection + Messages.getString("VcDlgAdvancedOptions.msgTestFailed2");
            confirm = JOptionPane.showConfirmDialog(this.getParent(), msg, Messages.getString("VcDlgAdvancedOptions.msgTitleWarning"), 0, 2);
        }
        if (confirm == 0) {
            this.updateConf();
        }
    }

    private void updateConf() {
        EnvProperties.getInstance().setProperty(EnvProperties.START_CMD, this.getTxfStartCmd().getText());
        EnvProperties.getInstance().setProperty(EnvProperties.SERVER_PROCESS, this.getTxfServeProc().getText());
        EnvProperties.getInstance().setProperty(EnvProperties.DB_DRIVER, this.getTxpJdbcDriver().getText());
        EnvProperties.getInstance().setProperty(EnvProperties.DB_URL, this.getTxpJdbcUrl().getText());
        EnvProperties.getInstance().setProperty(EnvProperties.DB_USER, this.getTxpJdbcUser().getText());
        String psw = this.getTxpJdbcPsw().getText();
        if (psw == null) {
            psw = "";
        }
        EnvProperties.getInstance().setProperty(EnvProperties.DB_PASSW, psw);
        String emb = "N";
        if (this.getCkbEmbedded().isSelected()) {
            emb = "S";
        }
        EnvProperties.getInstance().setProperty(EnvProperties.DB_ISEMBEDDED, emb);
        EnvProperties.getInstance().saveFileProperty();
        JOptionPane.showMessageDialog(this.getParent(), Messages.getString("VcDlgAdvancedOptions.msgRestart"), Messages.getString("VcDlgAdvancedOptions.msgTitleInfo"), 1);
    }

    private JTextField getTxfStartCmd() {
        if (this.txfStartCmd == null) {
            this.txfStartCmd = new JTextField();
            this.txfStartCmd.setBounds(new Rectangle(8, 32, 500, 25));
            this.txfStartCmd.setText(EnvProperties.getInstance().getProperty(EnvProperties.START_CMD));
        }
        return this.txfStartCmd;
    }

    private JTextField getTxfServeProc() {
        if (this.txfServeProc == null) {
            this.txfServeProc = new JTextField();
            this.txfServeProc.setBounds(new Rectangle(8, 83, 500, 25));
            this.txfServeProc.setText(EnvProperties.getInstance().getProperty(EnvProperties.SERVER_PROCESS));
        }
        return this.txfServeProc;
    }

    private JCheckBox getCkbEmbedded() {
        if (this.ckbEmbedded == null) {
            this.ckbEmbedded = new JCheckBox();
            this.ckbEmbedded.setBounds(new Rectangle(6, 285, 178, 24));
            this.ckbEmbedded.setText(Messages.getString("VcDlgAdvancedOptions.lblEmbeddedServer"));
            this.ckbEmbedded.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (VcDlgAdvancedOptions.this.ckbEmbedded.isSelected()) {
                        VcDlgAdvancedOptions.this.setEmbedded();
                    } else {
                        VcDlgAdvancedOptions.this.setNonEmbedded();
                    }
                }
            });
        }
        return this.ckbEmbedded;
    }

    private JButton getBtnTestConn() {
        if (this.btnTestConn == null) {
            this.btnTestConn = new JButton();
            this.btnTestConn.setBounds(new Rectangle(91, 328, 87, 25));
            this.btnTestConn.setText(Messages.getString("VcDlgAdvancedOptions.btnlTest"));
            this.btnTestConn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcDlgAdvancedOptions.this.test();
                }
            });
        }
        return this.btnTestConn;
    }

    private void setEmbedded() {
        this.getTxpJdbcDriver().setEnabled(false);
        this.getTxpJdbcUrl().setEnabled(false);
        this.getTxpJdbcPsw().setEnabled(false);
        this.getTxpJdbcUser().setEnabled(false);
        this.getCkbEmbedded().setSelected(true);
    }

    private void setNonEmbedded() {
        this.getTxpJdbcDriver().setEnabled(true);
        this.getTxpJdbcUrl().setEnabled(true);
        this.getTxpJdbcPsw().setEnabled(true);
        this.getTxpJdbcUser().setEnabled(true);
        this.getCkbEmbedded().setSelected(false);
    }
}

