/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip.ui;

import com.toedter.calendar.JDateChooser;
import it.f2.gestRip.EnvProperties;
import it.f2.gestRip.control.CommonMetodBin;
import it.f2.gestRip.control.DbSchedaAction;
import it.f2.gestRip.control.PrintAction;
import it.f2.gestRip.model.BinScheda;
import it.f2.gestRip.ui.VcIfrListaSchede;
import it.f2.gestRip.ui.VcMainFrame;
import it.f2.gestRip.ui.VcPnlApparecchio;
import it.f2.gestRip.ui.VcPnlCostiNote;
import it.f2.gestRip.ui.VcPnlDatiCLiente;
import it.f2.gestRip.ui.VcPnlRiparazione;
import it.f2.gestRip.ui.messages.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.apache.log4j.Logger;

public class VcDlgDetailScheda
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JTabbedPane tbpSchedaApp = null;
    private VcPnlApparecchio pnlApparecchio = null;
    private VcPnlDatiCLiente pnlDatiCliente = null;
    private VcPnlCostiNote pnlCostiNote = null;
    private VcPnlRiparazione pnlRiparazione = null;
    private JPanel pnlTesta = null;
    private JLabel lblSchedaN = null;
    private JFormattedTextField txfNumScheda = null;
    private JLabel lblDataApertura = null;
    private JDateChooser txfDataApertura = null;
    private mode modality = null;
    private BinScheda scheda = null;
    private BinScheda schedaLastSavepoint = null;
    private JLabel lblDataChiusura = null;
    private JDateChooser txfDataChiusura = null;
    private JPanel pnlNavig = null;
    private JButton btnNext = null;
    private JButton btnSalva = null;
    private JButton btnPrint = null;
    private JButton btnPrev = null;
    private JButton btnCanc = null;
    private VcIfrListaSchede listaSchede = null;
    private JCheckBox chbRiconsegnato = null;
    private JLabel lblRiconsegnato = null;
    private Connection con = null;

    public VcDlgDetailScheda(VcMainFrame parent, VcIfrListaSchede listaSchede, mode modality, int idScheda) {
        super((Frame)parent, true);
        Logger.getRootLogger().debug((Object)"VcDlgDetailScheda constructor...");
        this.modality = modality;
        this.listaSchede = listaSchede;
        this.con = CommonMetodBin.getConn();
        DbSchedaAction lsa = new DbSchedaAction();
        try {
            Logger.getRootLogger().debug((Object)"Set modality...");
            this.scheda = modality == mode.insert || idScheda == 0 ? lsa.addScheda(this.con) : lsa.getScheda(this.con, idScheda);
        }
        catch (SQLException e) {
            Logger.getRootLogger().error((Object)("Exception in Set modality \n" + e + "\n"));
            e.printStackTrace();
        }
        this.schedaLastSavepoint = this.scheda.clone();
        this.initialize();
    }

    private void close() {
        boolean datiClienteToSave;
        boolean disposing = false;
        boolean schedaToSave = this.modality != mode.view && !this.scheda.sameData(this.schedaLastSavepoint);
        boolean bl = datiClienteToSave = this.getPnlDatiCliente().getModalityCliente() != VcPnlDatiCLiente.modeCliente.view;
        if (schedaToSave || datiClienteToSave) {
            int confirm = JOptionPane.showConfirmDialog(this.getParent(), Messages.getString("VcDlgDetailScheda.msgSave"), Messages.getString("VcDlgDetailScheda.msgTitleInfo"), 1);
            if (confirm == 0) {
                try {
                    Logger.getRootLogger().debug((Object)"Closing 1...");
                    if (datiClienteToSave) {
                        this.getPnlDatiCliente().save();
                    }
                    this.save();
                    this.con.commit();
                    if (this.listaSchede != null) {
                        this.listaSchede.getTblList().refresh();
                    }
                }
                catch (SQLException e1) {
                    Logger.getRootLogger().error((Object)("Exception in Closing 1 \n" + e1 + "\n"));
                }
                disposing = true;
            } else if (confirm == 1) {
                try {
                    Logger.getRootLogger().debug((Object)"Closing 2...");
                    this.con.rollback();
                    if (this.listaSchede != null) {
                        this.listaSchede.getTblList().refresh();
                    }
                }
                catch (SQLException e1) {
                    Logger.getRootLogger().error((Object)("Exception in Closing 2 \n" + e1 + "\n"));
                }
                this.setVisible(false);
                this.dispose();
            }
        } else {
            try {
                Logger.getRootLogger().debug((Object)"Closing 3...");
                this.con.rollback();
                if (this.listaSchede != null) {
                    this.listaSchede.getTblList().refresh();
                }
            }
            catch (SQLException e1) {
                Logger.getRootLogger().error((Object)("Exception in Closing 3 \n" + e1 + "\n"));
            }
            disposing = true;
        }
        CommonMetodBin.closeConn(this.con);
        if (disposing) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void initialize() {
        this.setSize(831, 600);
        this.setDefaultCloseOperation(0);
        this.setTitle(Messages.getString("VcDlgDetailScheda.titleDetailSheet"));
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                VcDlgDetailScheda.this.close();
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getPnlTesta(), "North");
            this.jContentPane.add((Component)this.getTbpSchedaApp(), "Center");
            this.jContentPane.add((Component)this.getPnlNavig(), "South");
        }
        return this.jContentPane;
    }

    private JTabbedPane getTbpSchedaApp() {
        if (this.tbpSchedaApp == null) {
            this.tbpSchedaApp = new JTabbedPane();
            this.tbpSchedaApp.addTab(Messages.getString("VcDlgDetailScheda.tabEqp"), null, this.getPnlApparecchio(), null);
            this.tbpSchedaApp.addTab(Messages.getString("VcDlgDetailScheda.tabCustomer"), null, this.getPnlDatiCliente(), null);
            this.tbpSchedaApp.addTab(Messages.getString("VcDlgDetailScheda.tabCostNote"), null, this.getPnlCostiNote(), null);
            this.tbpSchedaApp.addTab(Messages.getString("VcDlgDetailScheda.tabRepairDetail"), null, this.getPnlRiparazione(), null);
            this.tbpSchedaApp.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (VcDlgDetailScheda.this.tbpSchedaApp.getSelectedIndex() < 1) {
                        VcDlgDetailScheda.this.getBtnPrev().setEnabled(false);
                        VcDlgDetailScheda.this.getBtnNext().setEnabled(true);
                    } else if (VcDlgDetailScheda.this.tbpSchedaApp.getSelectedIndex() > 2) {
                        VcDlgDetailScheda.this.getBtnPrev().setEnabled(true);
                        VcDlgDetailScheda.this.getBtnNext().setEnabled(false);
                    } else {
                        VcDlgDetailScheda.this.getBtnPrev().setEnabled(true);
                        VcDlgDetailScheda.this.getBtnNext().setEnabled(true);
                    }
                }
            });
        }
        return this.tbpSchedaApp;
    }

    private VcPnlApparecchio getPnlApparecchio() {
        if (this.pnlApparecchio == null) {
            this.pnlApparecchio = new VcPnlApparecchio(this.modality, this.scheda, this, this.con);
        }
        return this.pnlApparecchio;
    }

    private VcPnlDatiCLiente getPnlDatiCliente() {
        if (this.pnlDatiCliente == null) {
            this.pnlDatiCliente = new VcPnlDatiCLiente(this.modality, this.scheda, this, this.con);
        }
        return this.pnlDatiCliente;
    }

    private VcPnlCostiNote getPnlCostiNote() {
        if (this.pnlCostiNote == null) {
            this.pnlCostiNote = new VcPnlCostiNote(this.modality, this.scheda);
        }
        return this.pnlCostiNote;
    }

    private JPanel getPnlRiparazione() {
        if (this.pnlRiparazione == null) {
            this.pnlRiparazione = new VcPnlRiparazione(this.modality, this.scheda);
        }
        return this.pnlRiparazione;
    }

    private JPanel getPnlTesta() {
        if (this.pnlTesta == null) {
            this.lblRiconsegnato = new JLabel();
            this.lblRiconsegnato.setBounds(new Rectangle(720, 14, 98, 16));
            this.lblRiconsegnato.setText(Messages.getString("VcDlgDetailScheda.lblReturned"));
            this.lblDataChiusura = new JLabel();
            this.lblDataChiusura.setBounds(new Rectangle(460, 14, 102, 16));
            this.lblDataChiusura.setHorizontalAlignment(4);
            this.lblDataChiusura.setText(Messages.getString("VcDlgDetailScheda.lblReturnedDate"));
            this.lblDataApertura = new JLabel();
            this.lblDataApertura.setBounds(new Rectangle(231, 11, 90, 16));
            this.lblDataApertura.setHorizontalAlignment(4);
            this.lblDataApertura.setText(Messages.getString("VcDlgDetailScheda.lblEntryDate"));
            this.lblSchedaN = new JLabel();
            this.lblSchedaN.setText(String.valueOf(Messages.getString("VcDlgDetailScheda.lblSheetNum")) + EnvProperties.getInstance().getProperty(EnvProperties.PREFIX_NUM));
            this.lblSchedaN.setHorizontalAlignment(4);
            this.lblSchedaN.setBounds(new Rectangle(3, 11, 155, 16));
            this.pnlTesta = new JPanel();
            this.pnlTesta.setLayout(null);
            this.pnlTesta.setSize(800, 200);
            this.pnlTesta.setPreferredSize(new Dimension(800, 40));
            this.pnlTesta.add((Component)this.lblSchedaN, null);
            this.pnlTesta.add((Component)this.getTxfNumScheda(), null);
            this.pnlTesta.add((Component)this.lblDataApertura, null);
            this.pnlTesta.add((Component)this.getTxfDataApertura(), null);
            this.pnlTesta.add((Component)this.lblDataChiusura, null);
            this.pnlTesta.add((Component)this.getTxfDataChiusura(), null);
            this.pnlTesta.add((Component)this.getChbRiconsegnato(), null);
            this.pnlTesta.add((Component)this.lblRiconsegnato, null);
        }
        return this.pnlTesta;
    }

    private JFormattedTextField getTxfNumScheda() {
        if (this.txfNumScheda == null) {
            this.txfNumScheda = new JFormattedTextField((Object)this.scheda.getId());
            NumberFormatter fmt = new NumberFormatter(new DecimalFormat("###0"));
            fmt.setValueClass(Integer.class);
            DefaultFormatterFactory fmtFactory = new DefaultFormatterFactory(fmt, fmt, fmt);
            this.txfNumScheda.setFormatterFactory(fmtFactory);
            this.txfNumScheda.setBounds(new Rectangle(160, 9, 72, 25));
            this.txfNumScheda.setText(String.valueOf(this.scheda.getId()));
            if (this.modality == mode.view) {
                this.txfNumScheda.setEditable(false);
            }
            this.txfNumScheda.setFocusLostBehavior(3);
            this.txfNumScheda.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        VcDlgDetailScheda.this.txfNumScheda.commitEdit();
                        int val = (Integer)VcDlgDetailScheda.this.txfNumScheda.getValue();
                        if (val != VcDlgDetailScheda.this.scheda.getId()) {
                            Logger.getRootLogger().debug((Object)"getTxfNumScheda focus listener...");
                            boolean existScheda = DbSchedaAction.existScheda(VcDlgDetailScheda.this.con, val);
                            if (existScheda) {
                                JOptionPane.showMessageDialog(VcDlgDetailScheda.this.getParent(), Messages.getString("VcDlgDetailScheda.msgNumberExist"), Messages.getString("VcDlgDetailScheda.msgTitleError"), 0);
                                VcDlgDetailScheda.this.txfNumScheda.setValue(VcDlgDetailScheda.this.scheda.getId());
                            } else {
                                VcDlgDetailScheda.this.scheda.setId(val);
                            }
                        }
                    }
                    catch (ParseException e1) {
                        JOptionPane.showMessageDialog(VcDlgDetailScheda.this.getParent(), Messages.getString("VcDlgDetailScheda.msgValueError"), Messages.getString("VcDlgDetailScheda.msgTitleWarning"), 2);
                        VcDlgDetailScheda.this.txfNumScheda.setValue(VcDlgDetailScheda.this.scheda.getId());
                    }
                    catch (SQLException e1) {
                        Logger.getRootLogger().error((Object)("Exception in getTxfNumScheda focus listener \n" + e1 + "\n"));
                        VcDlgDetailScheda.this.txfNumScheda.setValue(VcDlgDetailScheda.this.scheda.getId());
                    }
                }
            });
        }
        return this.txfNumScheda;
    }

    private JDateChooser getTxfDataApertura() {
        if (this.txfDataApertura == null) {
            this.txfDataApertura = new JDateChooser();
            this.txfDataApertura.setBounds(new Rectangle(329, 9, 128, 25));
            this.txfDataApertura.setDate(this.scheda.getDataInserimento());
            if (this.modality == mode.view) {
                this.txfDataApertura.setEnabled(false);
            }
            this.txfDataApertura.addPropertyChangeListener("date", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    VcDlgDetailScheda.this.scheda.setDataInserimento(new Date(VcDlgDetailScheda.this.txfDataApertura.getDate().getTime()));
                }
            });
        }
        return this.txfDataApertura;
    }

    private JDateChooser getTxfDataChiusura() {
        if (this.txfDataChiusura == null) {
            this.txfDataChiusura = new JDateChooser();
            this.txfDataChiusura.setBounds(new Rectangle(567, 9, 128, 25));
            this.txfDataChiusura.setDate((java.util.Date)this.scheda.getDataChiusura());
            if (this.modality == mode.view) {
                this.txfDataChiusura.setEnabled(false);
            }
            this.txfDataChiusura.addPropertyChangeListener("date", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (VcDlgDetailScheda.this.txfDataChiusura.getDate() == null) {
                        VcDlgDetailScheda.this.scheda.setDataChiusura(null);
                    } else {
                        VcDlgDetailScheda.this.scheda.setDataChiusura(new Date(VcDlgDetailScheda.this.txfDataChiusura.getDate().getTime()));
                    }
                }
            });
        }
        return this.txfDataChiusura;
    }

    private JPanel getPnlNavig() {
        if (this.pnlNavig == null) {
            this.pnlNavig = new JPanel();
            this.pnlNavig.setLayout(new FlowLayout());
            this.pnlNavig.add((Component)this.getBtnPrev(), null);
            this.pnlNavig.add((Component)this.getBtnNext(), null);
            this.pnlNavig.add((Component)this.getBtnSalva(), null);
            this.pnlNavig.add((Component)this.getBtnPrint(), null);
            this.pnlNavig.add((Component)this.getBtnCanc(), null);
        }
        return this.pnlNavig;
    }

    private JButton getBtnNext() {
        if (this.btnNext == null) {
            this.btnNext = new JButton();
            this.btnNext.setText(Messages.getString("VcDlgDetailScheda.btnNext"));
            this.btnNext.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/forward.png")));
            this.btnNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcDlgDetailScheda.this.getTbpSchedaApp().setSelectedIndex(VcDlgDetailScheda.this.getTbpSchedaApp().getSelectedIndex() + 1);
                }
            });
            if (this.getTbpSchedaApp().getSelectedIndex() > 2) {
                this.btnPrev.setEnabled(false);
            }
        }
        return this.btnNext;
    }

    private JButton getBtnSalva() {
        if (this.btnSalva == null) {
            this.btnSalva = new JButton();
            this.btnSalva.setText(Messages.getString("VcDlgDetailScheda.btnSave"));
            this.btnSalva.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/filesave.png")));
            if (this.modality == mode.view) {
                this.btnSalva.setEnabled(false);
            }
            this.btnSalva.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcDlgDetailScheda.this.save();
                }
            });
        }
        return this.btnSalva;
    }

    private void save() {
        try {
            Logger.getRootLogger().debug((Object)"Saving...");
            DbSchedaAction.saveScheda(this.con, this.scheda);
            this.schedaLastSavepoint = this.scheda.clone();
        }
        catch (SQLException e1) {
            Logger.getRootLogger().error((Object)("Exception in Saving \n" + e1 + "\n"));
            JOptionPane.showMessageDialog(CommonMetodBin.getInstance().getMainFrame(), "Errore: " + e1.getMessage(), "Errore...", 0);
        }
    }

    private JButton getBtnPrint() {
        if (this.btnPrint == null) {
            this.btnPrint = new JButton();
            this.btnPrint.setText(Messages.getString("VcDlgDetailScheda.btnPrint"));
            this.btnPrint.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/fileprint.png")));
            this.btnPrint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcDlgDetailScheda.this.print();
                }
            });
        }
        return this.btnPrint;
    }

    private void print() {
        Logger.getRootLogger().debug((Object)"printing");
        PrintAction pa = new PrintAction();
        if (this.modality != mode.view && !this.scheda.sameData(this.schedaLastSavepoint)) {
            int confirm = JOptionPane.showConfirmDialog(this.getParent(), Messages.getString("VcDlgDetailScheda.msgSaving"), Messages.getString("VcDlgDetailScheda.msgTitleInfo"), 1);
            if (confirm == 0) {
                try {
                    Logger.getRootLogger().debug((Object)"Print Save...");
                    this.save();
                    this.con.commit();
                    pa.callReportRicevuta(this, this.scheda.getId(), this.con);
                }
                catch (SQLException e1) {
                    Logger.getRootLogger().error((Object)("Exception in Closing 1 \n" + e1 + "\n"));
                }
            } else if (confirm == 1) {
                Logger.getRootLogger().debug((Object)"Print No Save...");
                pa.callReportRicevuta(this, this.scheda.getId(), this.con);
            }
        } else {
            Logger.getRootLogger().debug((Object)"Print No Save...");
            pa.callReportRicevuta(this, this.scheda.getId(), this.con);
        }
    }

    private JButton getBtnPrev() {
        if (this.btnPrev == null) {
            this.btnPrev = new JButton();
            this.btnPrev.setText(Messages.getString("VcDlgDetailScheda.btnPrev"));
            this.btnPrev.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/back.png")));
            this.btnPrev.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcDlgDetailScheda.this.getTbpSchedaApp().setSelectedIndex(VcDlgDetailScheda.this.getTbpSchedaApp().getSelectedIndex() - 1);
                }
            });
            if (this.getTbpSchedaApp().getSelectedIndex() == 0) {
                this.btnPrev.setEnabled(false);
            }
        }
        return this.btnPrev;
    }

    private JButton getBtnCanc() {
        if (this.btnCanc == null) {
            this.btnCanc = new JButton();
            this.btnCanc.setText(Messages.getString("VcDlgDetailScheda.btnClose"));
            this.btnCanc.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/button_cancel.png")));
            this.btnCanc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcDlgDetailScheda.this.close();
                }
            });
        }
        return this.btnCanc;
    }

    private JCheckBox getChbRiconsegnato() {
        if (this.chbRiconsegnato == null) {
            this.chbRiconsegnato = new JCheckBox();
            this.chbRiconsegnato.setBounds(new Rectangle(695, 12, 21, 21));
            if (this.scheda.getDataChiusura() != null) {
                this.chbRiconsegnato.setSelected(true);
            }
            if (this.modality == mode.view) {
                this.chbRiconsegnato.setEnabled(false);
            }
            this.chbRiconsegnato.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (VcDlgDetailScheda.this.chbRiconsegnato.isSelected()) {
                        VcDlgDetailScheda.this.getTxfDataChiusura().setDate((java.util.Date)new Date(new java.util.Date().getTime()));
                    } else {
                        VcDlgDetailScheda.this.getTxfDataChiusura().setDate(null);
                    }
                }
            });
        }
        return this.chbRiconsegnato;
    }

    public static enum mode {
        insert,
        update,
        view;

    }
}

