/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip.ui;

import it.f2.gestRip.EnvProperties;
import it.f2.gestRip.ui.VcDlgAdvancedOptions;
import it.f2.gestRip.ui.messages.Messages;
import it.f2.util.ui.WindowUtil;
import it.f2.util.ui.cmb.TypeCmb;
import it.f2.util.ui.textField.JTextFieldLimit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.Document;
import org.apache.log4j.Logger;

public class VcDlgOptions
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlSettings = null;
    private JLabel lblFileLogo = null;
    private JButton btnDefDir = null;
    private File fileLogo = null;
    private JButton btnOk = null;
    private JButton btnCanc = null;
    private JLabel lblImgStyle = null;
    private JLabel lblLookAndFeel = null;
    private JComboBox cmbLookAndFeel = null;
    private boolean loadCmbFlag = false;
    private JTextPane txpFileLogo = null;
    private JLabel lblLogo = null;
    private JScrollPane scpInfoCliente = null;
    private JScrollPane scpIndirizzo = null;
    private JTextPane txpInfoCliente = null;
    private JTextPane txpIndirizzo = null;
    private JLabel lblInfoCliente = null;
    private JLabel lblIndirizzo = null;
    private JButton btnAdvOpt = null;
    private Frame parent = null;
    private JCheckBox chbNoDoppiaCopia = null;
    private JLabel lblNoDoppiaCopia = null;
    private JComboBox cmbLanguage = null;
    private JComboBox cmbLocale = null;
    private JLabel lblLanguage = null;
    private JLabel lblPrefixNumber = null;
    private JTextField txfPrefixNumber = null;
    private JLabel lblLocale = null;

    public VcDlgOptions(Frame owner) {
        super(owner, true);
        Logger.getRootLogger().debug((Object)"VcDlgOptions constructor...");
        this.parent = owner;
        this.initialize();
    }

    private void initialize() {
        this.setSize(612, 564);
        this.setTitle(Messages.getString("VcDlgOptions.titleOptions"));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getPnlSettings(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getPnlSettings() {
        if (this.pnlSettings == null) {
            this.lblPrefixNumber = new JLabel();
            this.lblPrefixNumber.setBounds(new Rectangle(11, 146, 156, 16));
            this.lblPrefixNumber.setText("Prefix sheet number");
            this.lblLanguage = new JLabel();
            this.lblLanguage.setBounds(new Rectangle(250, 431, 162, 16));
            this.lblLanguage.setText(Messages.getString("VcDlgOptions.language"));
            this.lblLocale = new JLabel();
            this.lblLocale.setBounds(new Rectangle(430, 431, 162, 16));
            this.lblLocale.setText(Messages.getString("VcDlgOptions.locale"));
            this.lblNoDoppiaCopia = new JLabel();
            this.lblNoDoppiaCopia.setBounds(new Rectangle(44, 389, 358, 20));
            this.lblNoDoppiaCopia.setText(Messages.getString("VcDlgOptions.lblDuplicatePrint"));
            this.lblIndirizzo = new JLabel();
            this.lblIndirizzo.setBounds(new Rectangle(9, 281, 460, 18));
            this.lblIndirizzo.setText(Messages.getString("VcDlgOptions.lblInfoAddress"));
            this.lblInfoCliente = new JLabel();
            this.lblInfoCliente.setBounds(new Rectangle(10, 174, 430, 18));
            this.lblInfoCliente.setText(Messages.getString("VcDlgOptions.lblInfoCustomer"));
            this.lblLogo = new JLabel();
            this.lblLogo.setBounds(new Rectangle(10, 10, 238, 125));
            this.lblLogo.setHorizontalAlignment(0);
            this.lblLogo.setDisplayedMnemonic(0);
            try {
                ImageIcon img = new ImageIcon(this.getFileLogo().getPath());
                this.lblLogo.setIcon(this.scale(img, this.lblLogo.getWidth(), this.lblLogo.getHeight()));
            }
            catch (NullPointerException e) {
                this.lblLogo.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/logo64.png")));
            }
            this.lblLookAndFeel = new JLabel();
            this.lblLookAndFeel.setBounds(new Rectangle(72, 431, 135, 16));
            this.lblLookAndFeel.setFont(new Font("Dialog", 1, 12));
            this.lblLookAndFeel.setText(Messages.getString("VcDlgOptions.lblLookAndFeel"));
            this.lblImgStyle = new JLabel();
            this.lblImgStyle.setBounds(new Rectangle(14, 431, 51, 44));
            this.lblImgStyle.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/style.png")));
            this.lblImgStyle.setHorizontalAlignment(0);
            this.lblImgStyle.setText("");
            this.lblFileLogo = new JLabel();
            this.lblFileLogo.setBounds(new Rectangle(255, 13, 138, 16));
            this.lblFileLogo.setFont(new Font("Dialog", 1, 12));
            this.lblFileLogo.setText(Messages.getString("VcDlgOptions.lblLogo"));
            this.pnlSettings = new JPanel();
            this.pnlSettings.setLayout(null);
            this.pnlSettings.add((Component)this.lblFileLogo, null);
            this.pnlSettings.add((Component)this.getBtnDefDir(), null);
            this.pnlSettings.add((Component)this.getBtnOk(), null);
            this.pnlSettings.add((Component)this.getBtnCanc(), null);
            this.pnlSettings.add((Component)this.lblImgStyle, null);
            this.pnlSettings.add((Component)this.lblLookAndFeel, null);
            this.pnlSettings.add((Component)this.getCmbLookAndFeel(), null);
            this.pnlSettings.add((Component)this.getTxpFileLogo(), null);
            this.pnlSettings.add((Component)this.lblLogo, null);
            this.pnlSettings.add((Component)this.getScpInfoCliente(), null);
            this.pnlSettings.add((Component)this.getScpIndirizzo(), null);
            this.pnlSettings.add((Component)this.lblInfoCliente, null);
            this.pnlSettings.add((Component)this.lblIndirizzo, null);
            this.pnlSettings.add((Component)this.getBtnAdvOpt(), null);
            this.pnlSettings.add((Component)this.getChbNoDoppiaCopia(), null);
            this.pnlSettings.add((Component)this.lblNoDoppiaCopia, null);
            this.pnlSettings.add((Component)this.getCmbLanguage(), null);
            this.pnlSettings.add((Component)this.getCmbLocale(), null);
            this.pnlSettings.add((Component)this.lblLanguage, null);
            this.pnlSettings.add((Component)this.lblPrefixNumber, null);
            this.pnlSettings.add((Component)this.getTxfPrefixNumber(), null);
            this.pnlSettings.add((Component)this.lblLocale, null);
        }
        return this.pnlSettings;
    }

    private ImageIcon scale(ImageIcon srcIcon, int lblWidth, int lblHeight) {
        double percentH;
        Image src = srcIcon.getImage();
        if (src.getWidth(this) <= lblWidth && src.getHeight(this) <= lblHeight) {
            return srcIcon;
        }
        double percentW = (double)lblWidth / (double)src.getWidth(this);
        if (percentW > 1.0) {
            percentW = 0.0;
        }
        if ((percentH = (double)lblHeight / (double)src.getHeight(this)) > 1.0) {
            percentH = 0.0;
        }
        double scale = percentH;
        if (percentW > percentH) {
            scale = percentW;
        }
        if (scale <= 0.0) {
            return srcIcon;
        }
        int w = (int)(scale * (double)src.getWidth(this));
        int h = (int)(scale * (double)src.getHeight(this));
        int type = 3;
        BufferedImage dst = new BufferedImage(w, h, type);
        Graphics2D g2 = dst.createGraphics();
        g2.drawImage(src, 0, 0, w, h, this);
        g2.dispose();
        return new ImageIcon(dst);
    }

    private JButton getBtnDefDir() {
        if (this.btnDefDir == null) {
            this.btnDefDir = new JButton();
            this.btnDefDir.setBounds(new Rectangle(496, 100, 94, 25));
            this.btnDefDir.setText(Messages.getString("VcDlgOptions.btnSelect"));
            this.btnDefDir.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcDlgOptions.this.selectFileLogo();
                }
            });
        }
        return this.btnDefDir;
    }

    private void selectFileLogo() {
        File file;
        JFileChooser jfc = null;
        jfc = this.getFileLogo() == null ? new JFileChooser() : new JFileChooser(this.getFileLogo());
        jfc.setAcceptAllFileFilterUsed(false);
        jfc.setFileSelectionMode(0);
        int response = jfc.showDialog(this, Messages.getString("VcDlgOptions.dlgTitleSelect"));
        if (response == 0 && (file = jfc.getSelectedFile()) != null && file.isFile()) {
            this.setFileLogo(file);
            String curPath = new File("").getAbsolutePath();
            String filePath = this.getFileLogo().getAbsolutePath();
            try {
                if (filePath.substring(0, curPath.length()).equalsIgnoreCase(curPath)) {
                    filePath = filePath.substring(curPath.length() + 1);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            EnvProperties.getInstance().setProperty(EnvProperties.FILELOGO, filePath);
            this.getTxpFileLogo().setText(filePath);
            this.lblLogo.setIcon(this.scale(new ImageIcon(filePath), this.lblLogo.getWidth(), this.lblLogo.getHeight()));
        }
    }

    private File getFileLogo() {
        if (this.fileLogo == null) {
            this.fileLogo = new File(EnvProperties.getInstance().getProperty(EnvProperties.FILELOGO));
            if (!this.fileLogo.isFile()) {
                this.fileLogo = null;
            }
        }
        return this.fileLogo;
    }

    private void setFileLogo(File _value) {
        this.fileLogo = _value;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setBounds(new Rectangle(231, 495, 93, 29));
            this.btnOk.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/filesave.png")));
            this.btnOk.setText(Messages.getString("VcDlgOptions.btnSave"));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcDlgOptions.this.save();
                }
            });
        }
        return this.btnOk;
    }

    private JButton getBtnCanc() {
        if (this.btnCanc == null) {
            this.btnCanc = new JButton();
            this.btnCanc.setBounds(new Rectangle(126, 495, 99, 29));
            this.btnCanc.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/button_cancel.png")));
            this.btnCanc.setText(Messages.getString("VcDlgOptions.btnCanc"));
            this.btnCanc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcDlgOptions.this.close();
                }
            });
        }
        return this.btnCanc;
    }

    private void close() {
        this.dispose();
    }

    private void save() {
        EnvProperties.getInstance().saveFileProperty();
        this.close();
    }

    private JComboBox getCmbLookAndFeel() {
        if (this.cmbLookAndFeel == null) {
            this.cmbLookAndFeel = new JComboBox();
            this.cmbLookAndFeel.setBounds(new Rectangle(70, 448, 150, 24));
            this.cmbLookAndFeel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcDlgOptions.this.setLookAndFeel((TypeCmb)VcDlgOptions.this.cmbLookAndFeel.getSelectedItem());
                }
            });
            Properties looks = new Properties();
            try {
                Logger.getRootLogger().debug((Object)"getCmbLookAndFeel...");
                TypeCmb seledted = null;
                String path = "conf" + EnvProperties.FILE_SEPARETOR + "LookAndFeel.properties";
                FileInputStream in = new FileInputStream(path);
                looks.load(in);
                Enumeration<?> enumeration = looks.propertyNames();
                this.loadCmbFlag = true;
                while (enumeration.hasMoreElements()) {
                    String propName = (String)enumeration.nextElement();
                    String[] propVals = looks.getProperty(propName).split("~");
                    TypeCmb cmb1 = new TypeCmb();
                    cmb1.setDesc(propVals[0]);
                    cmb1.setValue(propVals[1]);
                    this.cmbLookAndFeel.addItem(cmb1);
                    if (!EnvProperties.getInstance().getProperty(EnvProperties.LOOK).equals(cmb1.getValue())) continue;
                    seledted = cmb1;
                }
                UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
                int i = 0;
                while (i < info.length) {
                    TypeCmb cmb2 = new TypeCmb();
                    cmb2.setDesc(info[i].getName());
                    cmb2.setValue(info[i].getClassName());
                    if (EnvProperties.getInstance().getProperty(EnvProperties.LOOK).equals(cmb2.getValue())) {
                        seledted = cmb2;
                    }
                    this.cmbLookAndFeel.addItem(cmb2);
                    ++i;
                }
                if (seledted != null) {
                    this.cmbLookAndFeel.setSelectedItem(seledted);
                }
                this.loadCmbFlag = false;
            }
            catch (FileNotFoundException e) {
                Logger.getRootLogger().error((Object)("Exception getCmbLookAndFeel \n" + e + "\n"));
            }
            catch (IOException e) {
                Logger.getRootLogger().error((Object)("Exception getCmbLookAndFeel \n" + e + "\n"));
            }
        }
        return this.cmbLookAndFeel;
    }

    private void setLookAndFeel(TypeCmb cmb) {
        if (!this.loadCmbFlag && !EnvProperties.getInstance().getProperty(EnvProperties.LOOK).equals(cmb.getValue())) {
            EnvProperties.getInstance().setProperty(EnvProperties.LOOK, cmb.getValue());
            JOptionPane.showMessageDialog(this.getParent(), String.valueOf(Messages.getString("VcDlgOptions.msgRestart1")) + EnvProperties.getInstance().getProperty(EnvProperties.APPNAME) + Messages.getString("VcDlgOptions.msgRestart2"), Messages.getString("VcDlgOptions.msgTitleWarning"), 2);
        }
    }

    private JTextPane getTxpFileLogo() {
        if (this.txpFileLogo == null) {
            this.txpFileLogo = new JTextPane();
            this.txpFileLogo.setBounds(new Rectangle(255, 33, 332, 62));
            this.txpFileLogo.setFont(new Font("Dialog", 0, 12));
            this.txpFileLogo.setEditable(false);
            this.txpFileLogo.setText(EnvProperties.getInstance().getProperty(EnvProperties.FILELOGO));
        }
        return this.txpFileLogo;
    }

    private JScrollPane getScpInfoCliente() {
        if (this.scpInfoCliente == null) {
            this.scpInfoCliente = new JScrollPane();
            this.scpInfoCliente.setBounds(new Rectangle(9, 195, 587, 69));
            this.scpInfoCliente.setViewportView(this.getTxpInfoCliente());
        }
        return this.scpInfoCliente;
    }

    private JScrollPane getScpIndirizzo() {
        if (this.scpIndirizzo == null) {
            this.scpIndirizzo = new JScrollPane();
            this.scpIndirizzo.setBounds(new Rectangle(9, 301, 589, 74));
            this.scpIndirizzo.setViewportView(this.getTxpIndirizzo());
        }
        return this.scpIndirizzo;
    }

    private JTextPane getTxpInfoCliente() {
        if (this.txpInfoCliente == null) {
            this.txpInfoCliente = new JTextPane();
            this.txpInfoCliente.setText(EnvProperties.getInstance().getProperty(EnvProperties.INFOCLIENTE));
            this.txpInfoCliente.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    EnvProperties.getInstance().setProperty(EnvProperties.INFOCLIENTE, VcDlgOptions.this.txpInfoCliente.getText());
                }
            });
        }
        return this.txpInfoCliente;
    }

    private JTextPane getTxpIndirizzo() {
        if (this.txpIndirizzo == null) {
            this.txpIndirizzo = new JTextPane();
            this.txpIndirizzo.setText(EnvProperties.getInstance().getProperty(EnvProperties.INDIRIZZO));
            this.txpIndirizzo.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    EnvProperties.getInstance().setProperty(EnvProperties.INDIRIZZO, VcDlgOptions.this.txpIndirizzo.getText());
                }
            });
        }
        return this.txpIndirizzo;
    }

    private JButton getBtnAdvOpt() {
        if (this.btnAdvOpt == null) {
            this.btnAdvOpt = new JButton();
            this.btnAdvOpt.setBounds(new Rectangle(333, 495, 140, 29));
            this.btnAdvOpt.setText(Messages.getString("VcDlgOptions.btnAdvOpt"));
            this.btnAdvOpt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcDlgAdvancedOptions dlgAo = new VcDlgAdvancedOptions(VcDlgOptions.this.parent);
                    WindowUtil.centerWindow((JDialog)dlgAo);
                    dlgAo.setVisible(true);
                }
            });
        }
        return this.btnAdvOpt;
    }

    private JCheckBox getChbNoDoppiaCopia() {
        if (this.chbNoDoppiaCopia == null) {
            this.chbNoDoppiaCopia = new JCheckBox();
            this.chbNoDoppiaCopia.setBounds(new Rectangle(14, 390, 24, 21));
            String ck = EnvProperties.getInstance().getProperty(EnvProperties.DOPPIACOPIA);
            if (ck.equals("N")) {
                this.chbNoDoppiaCopia.setSelected(true);
            }
            this.chbNoDoppiaCopia.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (VcDlgOptions.this.chbNoDoppiaCopia.isSelected()) {
                        EnvProperties.getInstance().setProperty(EnvProperties.DOPPIACOPIA, "N");
                    } else {
                        EnvProperties.getInstance().setProperty(EnvProperties.DOPPIACOPIA, "S");
                    }
                }
            });
        }
        return this.chbNoDoppiaCopia;
    }

    private JComboBox getCmbLanguage() {
        if (this.cmbLanguage == null) {
            this.cmbLanguage = new JComboBox();
            this.cmbLanguage.setBounds(new Rectangle(250, 448, 150, 24));
            String selVal = EnvProperties.getInstance().getProperty(EnvProperties.LANGUAGE);
            for (String key : Messages.getLanguageMaps().keySet()) {
                TypeCmb cmb = new TypeCmb();
                cmb.setValue(key);
                cmb.setDesc(Messages.getLanguageMaps().get(key));
                this.cmbLanguage.addItem(cmb);
                if (!selVal.equals(key)) continue;
                this.cmbLanguage.setSelectedItem(cmb);
            }
            this.cmbLanguage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EnvProperties.getInstance().setProperty(EnvProperties.LANGUAGE, ((TypeCmb)VcDlgOptions.this.cmbLanguage.getSelectedItem()).getValue());
                }
            });
        }
        return this.cmbLanguage;
    }

    private JComboBox getCmbLocale() {
        if (this.cmbLocale == null) {
            this.cmbLocale = new JComboBox();
            this.cmbLocale.setBounds(new Rectangle(430, 448, 150, 24));
            String selVal = EnvProperties.getInstance().getProperty(EnvProperties.LOCALE);
            Locale[] locales = Locale.getAvailableLocales();
            Comparator<Locale> localeComparator = new Comparator<Locale>(){

                @Override
                public int compare(Locale locale1, Locale locale2) {
                    return locale1.toString().compareTo(locale2.toString());
                }
            };
            Arrays.sort(locales, localeComparator);
            Locale[] localeArray = locales;
            int n = locales.length;
            int n2 = 0;
            while (n2 < n) {
                Locale loc = localeArray[n2];
                TypeCmb cmb = new TypeCmb();
                if (!loc.getCountry().equals("") && !loc.getLanguage().equals("")) {
                    String locId = String.valueOf(loc.getLanguage()) + "-" + loc.getCountry();
                    cmb.setValue(locId);
                    cmb.setDesc(loc.getDisplayName());
                    this.cmbLocale.addItem(cmb);
                    if (selVal.equals(locId)) {
                        this.cmbLocale.setSelectedItem(cmb);
                    }
                }
                ++n2;
            }
            this.cmbLocale.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EnvProperties.getInstance().setProperty(EnvProperties.LOCALE, ((TypeCmb)VcDlgOptions.this.cmbLocale.getSelectedItem()).getValue());
                }
            });
        }
        return this.cmbLocale;
    }

    private JTextField getTxfPrefixNumber() {
        if (this.txfPrefixNumber == null) {
            this.txfPrefixNumber = new JTextField();
            this.txfPrefixNumber.setDocument((Document)new JTextFieldLimit(7));
            String pref = EnvProperties.getInstance().getProperty(EnvProperties.PREFIX_NUM);
            if (pref != null && pref.length() > 7) {
                pref = pref.substring(0, 7);
                EnvProperties.getInstance().setProperty(EnvProperties.PREFIX_NUM, pref);
            }
            this.txfPrefixNumber.setText(pref);
            this.txfPrefixNumber.setBounds(new Rectangle(397, 144, 200, 25));
            this.txfPrefixNumber.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    EnvProperties.getInstance().setProperty(EnvProperties.PREFIX_NUM, VcDlgOptions.this.txfPrefixNumber.getText());
                }
            });
        }
        return this.txfPrefixNumber;
    }
}

