/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip.ui;

import com.toedter.calendar.JDateChooser;
import it.f2.gestRip.control.CommonMetodBin;
import it.f2.gestRip.control.DbSchedaAction;
import it.f2.gestRip.control.QryUtil;
import it.f2.gestRip.ui.VcDlgDetailScheda;
import it.f2.gestRip.ui.VcMainFrame;
import it.f2.gestRip.ui.messages.Messages;
import it.f2.gestRip.util.JDBCComboBoxModel;
import it.f2.gestRip.util.VcJDBCTablePanel;
import it.f2.util.ui.WindowUtil;
import it.f2.util.ui.cmb.TypeCmb;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.apache.log4j.Logger;

public class VcIfrDeletedSchede
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JToolBar tldCommands = null;
    private JButton btnView = null;
    private JScrollPane ScpList = null;
    private VcJDBCTablePanel tblList = null;
    private VcMainFrame parent = null;
    private JButton btnDelete = null;
    private JPanel pnlFilter = null;
    private JButton btnFind = null;
    private JLabel lblStatoRip = null;
    private JComboBox cmbStato = null;
    private JButton btnReset = null;
    private JTextField txfCognome = null;
    private JTextField txfNome = null;
    private JLabel lblNomeCogn = null;
    private JTextField txfNumeroScheda = null;
    private JLabel lblNum = null;
    private JDateChooser txfDataIngresso = null;
    private JDateChooser txfDataUscita = null;
    private JLabel lblParRic = null;
    private JLabel lblDataIng = null;
    private JLabel lblDIA = null;
    private JTextField txfSerial = null;
    private JLabel lblSerial = null;
    private JComboBox cmbTipoAppa = null;
    private JLabel lblTipoAppa = null;
    private JPanel pnlList = null;
    private Connection con = null;
    private JButton btnRipristina = null;
    private JButton btnSvuota = null;

    public VcIfrDeletedSchede(VcMainFrame parent) {
        Logger.getRootLogger().debug((Object)"VcIfrListaSchede constructor...");
        this.parent = parent;
        this.con = CommonMetodBin.getConn();
        this.initialize();
    }

    private void initialize() {
        this.setSize(901, 571);
        this.setClosable(true);
        this.setTitle(Messages.getString("VcIfrDeletedSchede.titleDeletedListSheet"));
        this.setContentPane(this.getJContentPane());
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                try {
                    Logger.getRootLogger().debug((Object)"Closing...");
                    VcIfrDeletedSchede.this.close();
                }
                catch (Exception e1) {
                    Logger.getRootLogger().error((Object)("Exception in Closing \n" + e + "\n"));
                }
            }
        });
    }

    private void close() {
        CommonMetodBin.closeConn(this.con);
        this.parent.closeTab(this);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getPnlFilter(), "North");
            this.jContentPane.add((Component)this.getPnlList(), "Center");
        }
        return this.jContentPane;
    }

    private JToolBar getTldCommands() {
        if (this.tldCommands == null) {
            this.tldCommands = new JToolBar();
            this.tldCommands.setOrientation(0);
            this.tldCommands.add(this.getBtnView());
            this.tldCommands.add(this.getBtnRipristina());
            this.tldCommands.add(this.getBtnDelete());
            this.tldCommands.add(this.getBtnSvuota());
        }
        return this.tldCommands;
    }

    private JButton getBtnView() {
        if (this.btnView == null) {
            this.btnView = new JButton();
            this.btnView.setText(Messages.getString("VcIfrDeletedSchede.btnShowSheet"));
            this.btnView.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/view_remove.png")));
            this.btnView.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        int id_scheda = (Integer)VcIfrDeletedSchede.this.getTblList().getValueAt(VcIfrDeletedSchede.this.getTblList().currentRow(), 0);
                        VcIfrDeletedSchede.this.openDetail(VcDlgDetailScheda.mode.view, id_scheda);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            });
        }
        return this.btnView;
    }

    private JScrollPane getScpList() {
        if (this.ScpList == null) {
            this.ScpList = new JScrollPane();
            this.ScpList.setViewportView(this.getTblList());
        }
        return this.ScpList;
    }

    public VcJDBCTablePanel getTblList() {
        if (this.tblList == null) {
            this.tblList = new VcJDBCTablePanel(this.con, QryUtil.QRY_LISTA_SCHEDE_DEL_ALL, false, null, null);
            this.tblList.createControlPanel();
        }
        return this.tblList;
    }

    private void openDetail(VcDlgDetailScheda.mode modality, int id_scheda) {
        VcDlgDetailScheda dialog = new VcDlgDetailScheda(this.parent, null, modality, id_scheda);
        WindowUtil.centerWindow((JDialog)dialog);
        dialog.setVisible(true);
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton();
            this.btnDelete.setText(Messages.getString("VcIfrDeletedSchede.btnDelSheet"));
            this.btnDelete.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/delete_table_row.png")));
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcIfrDeletedSchede.this.deleteScheda();
                }
            });
        }
        return this.btnDelete;
    }

    private void deleteScheda() {
        try {
            int id_scheda = (Integer)this.getTblList().getValueAt(this.getTblList().currentRow(), 0);
            int confirm = JOptionPane.showConfirmDialog(this.getParent(), String.valueOf(Messages.getString("VcIfrDeletedSchede.msgDelSheet1")) + id_scheda + Messages.getString("VcIfrDeletedSchede.msgDelSheet2"), Messages.getString("VcIfrDeletedSchede.msgTitleInfo"), 2);
            if (confirm == 0) {
                try {
                    Logger.getRootLogger().debug((Object)"Removing...");
                    DbSchedaAction.removeScheda(this.con, id_scheda);
                    this.con.commit();
                    this.getTblList().refresh();
                }
                catch (SQLException e) {
                    Logger.getRootLogger().error((Object)("Exception in Removing \n" + e + "\n"));
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private JPanel getPnlFilter() {
        if (this.pnlFilter == null) {
            this.lblTipoAppa = new JLabel();
            this.lblTipoAppa.setBounds(new Rectangle(609, 53, 124, 16));
            this.lblTipoAppa.setHorizontalAlignment(4);
            this.lblTipoAppa.setText(Messages.getString("VcIfrDeletedSchede.lblFilterEqp"));
            this.lblSerial = new JLabel();
            this.lblSerial.setBounds(new Rectangle(643, 27, 89, 16));
            this.lblSerial.setHorizontalAlignment(4);
            this.lblSerial.setText(Messages.getString("VcIfrDeletedSchede.lblFilterSerial"));
            this.lblDIA = new JLabel();
            this.lblDIA.setBounds(new Rectangle(452, 27, 38, 16));
            this.lblDIA.setHorizontalAlignment(4);
            this.lblDIA.setText(Messages.getString("VcIfrDeletedSchede.lblFilterTo"));
            this.lblDataIng = new JLabel();
            this.lblDataIng.setBounds(new Rectangle(182, 28, 132, 16));
            this.lblDataIng.setHorizontalAlignment(4);
            this.lblDataIng.setText(Messages.getString("VcIfrDeletedSchede.lblFilterEntryDate"));
            this.lblParRic = new JLabel();
            this.lblParRic.setBounds(new Rectangle(6, 6, 157, 16));
            this.lblParRic.setText(Messages.getString("VcIfrDeletedSchede.lblFilterSearchParam"));
            this.lblNum = new JLabel();
            this.lblNum.setBounds(new Rectangle(6, 28, 76, 12));
            this.lblNum.setHorizontalAlignment(4);
            this.lblNum.setText(Messages.getString("VcIfrDeletedSchede.lblFilterSheetNum"));
            this.lblNomeCogn = new JLabel();
            this.lblNomeCogn.setBounds(new Rectangle(218, 53, 121, 20));
            this.lblNomeCogn.setHorizontalAlignment(4);
            this.lblNomeCogn.setText(Messages.getString("VcIfrDeletedSchede.lblFilterNameSur"));
            this.lblStatoRip = new JLabel();
            this.lblStatoRip.setText(Messages.getString("VcIfrDeletedSchede.lblFilterState"));
            this.lblStatoRip.setHorizontalAlignment(4);
            this.lblStatoRip.setBounds(new Rectangle(8, 55, 111, 16));
            this.pnlFilter = new JPanel();
            this.pnlFilter.setSize(100, 100);
            this.pnlFilter.setLayout(null);
            this.pnlFilter.setPreferredSize(new Dimension(100, 110));
            this.pnlFilter.add((Component)this.lblStatoRip, null);
            this.pnlFilter.add((Component)this.getCmbStato(), null);
            this.pnlFilter.add((Component)this.getTxfCognome(), null);
            this.pnlFilter.add((Component)this.getBtnFind(), null);
            this.pnlFilter.add((Component)this.getBtnReset(), null);
            this.pnlFilter.add((Component)this.getTxfNome(), null);
            this.pnlFilter.add((Component)this.lblNomeCogn, null);
            this.pnlFilter.add((Component)this.getTxfNumeroScheda(), null);
            this.pnlFilter.add((Component)this.lblNum, null);
            this.pnlFilter.add((Component)this.getTxfDataIngresso(), null);
            this.pnlFilter.add((Component)this.getTxfDataUscita(), null);
            this.pnlFilter.add((Component)this.lblParRic, null);
            this.pnlFilter.add((Component)this.lblDataIng, null);
            this.pnlFilter.add((Component)this.lblDIA, null);
            this.pnlFilter.add((Component)this.getTxfSerial(), null);
            this.pnlFilter.add((Component)this.lblSerial, null);
            this.pnlFilter.add((Component)this.getCmbTipoAppa(), null);
            this.pnlFilter.add((Component)this.lblTipoAppa, null);
        }
        return this.pnlFilter;
    }

    private JButton getBtnFind() {
        if (this.btnFind == null) {
            this.btnFind = new JButton();
            this.btnFind.setText(Messages.getString("VcIfrDeletedSchede.btnlFilterApply"));
            this.btnFind.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/button_ok.png")));
            this.btnFind.setBounds(new Rectangle(6, 80, 135, 26));
            this.btnFind.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int nScheda = 0;
                    try {
                        nScheda = Integer.parseInt(VcIfrDeletedSchede.this.getTxfNumeroScheda().getText());
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    int idStato = 999;
                    try {
                        idStato = Integer.parseInt(((TypeCmb)VcIfrDeletedSchede.this.getCmbStato().getSelectedItem()).getValue());
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    Date dataIns = null;
                    try {
                        dataIns = new Date(VcIfrDeletedSchede.this.getTxfDataIngresso().getDate().getTime());
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    Date dataUsc = null;
                    try {
                        dataUsc = new Date(VcIfrDeletedSchede.this.getTxfDataUscita().getDate().getTime());
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    int idTipoAppa = 999;
                    try {
                        idTipoAppa = Integer.parseInt(((TypeCmb)VcIfrDeletedSchede.this.getCmbTipoAppa().getSelectedItem()).getValue());
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    boolean filterNScheda = nScheda != 0;
                    boolean filterIdstato = idStato != 999;
                    boolean filterCognome = !VcIfrDeletedSchede.this.getTxfCognome().getText().equals("");
                    boolean filterNome = !VcIfrDeletedSchede.this.getTxfNome().getText().equals("");
                    boolean filterDataIng = dataIns != null;
                    boolean filterDataUsc = dataUsc != null;
                    boolean filterSerial = !VcIfrDeletedSchede.this.getTxfSerial().getText().equals("");
                    boolean filterIdTipoAppa = idTipoAppa != 999;
                    String qry = String.valueOf(QryUtil.QRY_LISTA_SCHEDE_DEL_ALL) + (filterNScheda ? " AND schede.id = :id " : "") + (filterIdstato ? " AND schede.idStato = :idSta " : "") + (filterCognome ? " AND clienti.cognome like :cognome " : "") + (filterNome ? " AND clienti.nome like :nome " : "") + (filterDataIng ? " AND schede.dataInserimento >= :dataIns " : "") + (filterDataUsc ? " AND schede.dataInserimento <= :dataUsc " : "") + (filterSerial ? " AND schede.serial like :serial " : "") + (filterIdTipoAppa ? " AND schede.idTipoApparecchiatura = :idTipoAppa " : "");
                    VcIfrDeletedSchede.this.getTblList().setQuery(qry);
                    ArrayList<Object[]> params1 = new ArrayList<Object[]>();
                    if (filterNScheda) {
                        Object[] pId = new Object[]{"id", nScheda};
                        params1.add(pId);
                    }
                    if (filterIdstato) {
                        Object[] pStato = new Object[]{"idSta", idStato};
                        params1.add(pStato);
                    }
                    if (filterCognome) {
                        Object[] pCognome = new Object[]{"cognome", VcIfrDeletedSchede.this.getTxfCognome().getText()};
                        params1.add(pCognome);
                    }
                    if (filterNome) {
                        Object[] pNome = new Object[]{"nome", VcIfrDeletedSchede.this.getTxfNome().getText()};
                        params1.add(pNome);
                    }
                    if (filterDataIng) {
                        Object[] pDi = new Object[]{"dataIns", dataIns};
                        params1.add(pDi);
                    }
                    if (filterDataUsc) {
                        Object[] pDu = new Object[]{"dataUsc", dataUsc};
                        params1.add(pDu);
                    }
                    if (filterSerial) {
                        Object[] pSer = new Object[]{"serial", VcIfrDeletedSchede.this.getTxfSerial().getText()};
                        params1.add(pSer);
                    }
                    if (filterIdTipoAppa) {
                        Object[] pTa = new Object[]{"idTipoAppa", idTipoAppa};
                        params1.add(pTa);
                    }
                    VcIfrDeletedSchede.this.getTblList().setParameters(params1);
                    VcIfrDeletedSchede.this.getTblList().refresh();
                }
            });
        }
        return this.btnFind;
    }

    private JComboBox getCmbStato() {
        if (this.cmbStato == null) {
            this.cmbStato = new JComboBox();
            String qry = "select id,nomeStato,flagAttivo from anastati";
            this.cmbStato.setModel(new JDBCComboBoxModel(this.con, qry, "0", "S"));
            this.cmbStato.setBounds(new Rectangle(123, 50, 87, 25));
            TypeCmb tAll = new TypeCmb();
            tAll.setValue("999");
            tAll.setDesc(Messages.getString("VcIfrDeletedSchede.cmbStatusAll"));
            this.cmbStato.addItem(tAll);
            this.cmbStato.setSelectedItem(tAll);
        }
        return this.cmbStato;
    }

    private JButton getBtnReset() {
        if (this.btnReset == null) {
            this.btnReset = new JButton();
            this.btnReset.setText(Messages.getString("VcIfrDeletedSchede.btnFilterReset"));
            this.btnReset.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/button_cancel.png")));
            this.btnReset.setBounds(new Rectangle(150, 80, 135, 26));
            this.btnReset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcIfrDeletedSchede.this.getTblList().setQuery(QryUtil.QRY_LISTA_SCHEDE_DEL_ALL);
                    VcIfrDeletedSchede.this.getTblList().setParameters(null);
                    VcIfrDeletedSchede.this.getTblList().refresh();
                    VcIfrDeletedSchede.this.getTxfNumeroScheda().setText("");
                    VcIfrDeletedSchede.this.getCmbStato().setSelectedIndex(VcIfrDeletedSchede.this.getCmbStato().getModel().getSize() - 1);
                    VcIfrDeletedSchede.this.getTxfDataIngresso().setDate(null);
                    VcIfrDeletedSchede.this.getTxfDataUscita().setDate(null);
                    VcIfrDeletedSchede.this.getTxfCognome().setText("");
                    VcIfrDeletedSchede.this.getTxfNome().setText("");
                    VcIfrDeletedSchede.this.getTxfSerial().setText("");
                    VcIfrDeletedSchede.this.getCmbTipoAppa().setSelectedIndex(VcIfrDeletedSchede.this.getCmbTipoAppa().getModel().getSize() - 1);
                }
            });
        }
        return this.btnReset;
    }

    private JTextField getTxfCognome() {
        if (this.txfCognome == null) {
            this.txfCognome = new JTextField();
            this.txfCognome.setSize(152, 25);
            this.txfCognome.setText("");
            this.txfCognome.setLocation(new Point(446, 50));
        }
        return this.txfCognome;
    }

    private JTextField getTxfNome() {
        if (this.txfNome == null) {
            this.txfNome = new JTextField();
            this.txfNome.setBounds(new Rectangle(342, 50, 104, 25));
        }
        return this.txfNome;
    }

    private JTextField getTxfNumeroScheda() {
        if (this.txfNumeroScheda == null) {
            this.txfNumeroScheda = new JTextField();
            this.txfNumeroScheda.setBounds(new Rectangle(85, 23, 81, 25));
        }
        return this.txfNumeroScheda;
    }

    private JDateChooser getTxfDataIngresso() {
        if (this.txfDataIngresso == null) {
            this.txfDataIngresso = new JDateChooser();
            this.txfDataIngresso.setBounds(new Rectangle(315, 23, 128, 25));
        }
        return this.txfDataIngresso;
    }

    private JDateChooser getTxfDataUscita() {
        if (this.txfDataUscita == null) {
            this.txfDataUscita = new JDateChooser();
            this.txfDataUscita.setBounds(new Rectangle(490, 23, 128, 25));
        }
        return this.txfDataUscita;
    }

    private JTextField getTxfSerial() {
        if (this.txfSerial == null) {
            this.txfSerial = new JTextField();
            this.txfSerial.setBounds(new Rectangle(733, 23, 120, 25));
        }
        return this.txfSerial;
    }

    private JComboBox getCmbTipoAppa() {
        if (this.cmbTipoAppa == null) {
            this.cmbTipoAppa = new JComboBox();
            this.cmbTipoAppa.setBounds(new Rectangle(733, 50, 120, 25));
            String qry = "select id,nome,flagAttivo from tipoapparecchiature";
            this.cmbTipoAppa.setModel(new JDBCComboBoxModel(this.con, qry, "", "S"));
            TypeCmb tAll = new TypeCmb();
            tAll.setValue("999");
            tAll.setDesc(Messages.getString("VcIfrDeletedSchede.cmbTypeEqpAll"));
            this.cmbTipoAppa.addItem(tAll);
            this.cmbTipoAppa.setSelectedItem(tAll);
        }
        return this.cmbTipoAppa;
    }

    private JPanel getPnlList() {
        if (this.pnlList == null) {
            this.pnlList = new JPanel();
            this.pnlList.setLayout(new BorderLayout());
            this.pnlList.add((Component)this.getTldCommands(), "North");
            this.pnlList.add((Component)this.getScpList(), "Center");
        }
        return this.pnlList;
    }

    private JButton getBtnRipristina() {
        if (this.btnRipristina == null) {
            this.btnRipristina = new JButton();
            this.btnRipristina.setText(Messages.getString("VcIfrDeletedSchede.btnRestoreSheet"));
            this.btnRipristina.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/undo.png")));
            this.btnRipristina.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcIfrDeletedSchede.this.ripristinaScheda();
                }
            });
        }
        return this.btnRipristina;
    }

    private void ripristinaScheda() {
        try {
            int id_scheda = (Integer)this.getTblList().getValueAt(this.getTblList().currentRow(), 0);
            int confirm = JOptionPane.showConfirmDialog(this.getParent(), String.valueOf(Messages.getString("VcIfrDeletedSchede.msgRestoreSheet1")) + id_scheda + Messages.getString("VcIfrDeletedSchede.msgRestoreSheet2"), Messages.getString("VcIfrDeletedSchede.msgTitleInfo"), 2);
            if (confirm == 0) {
                try {
                    Logger.getRootLogger().debug((Object)"Removing...");
                    DbSchedaAction.ripristinaScheda(this.con, id_scheda);
                    this.con.commit();
                    this.getTblList().refresh();
                }
                catch (SQLException e) {
                    Logger.getRootLogger().error((Object)("Exception in Removing \n" + e + "\n"));
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private JButton getBtnSvuota() {
        if (this.btnSvuota == null) {
            this.btnSvuota = new JButton();
            this.btnSvuota.setText(Messages.getString("VcIfrDeletedSchede.msgEmptySheet"));
            this.btnSvuota.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/trashcan_empty.png")));
            this.btnSvuota.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcIfrDeletedSchede.this.svuota();
                }
            });
        }
        return this.btnSvuota;
    }

    private void svuota() {
        int confirm = JOptionPane.showConfirmDialog(this.getParent(), Messages.getString("VcIfrDeletedSchede.msgEnptySheet1"), Messages.getString("VcIfrDeletedSchede.msgEnptySheet2"), 2);
        if (confirm == 0) {
            try {
                Logger.getRootLogger().debug((Object)"Removing...");
                DbSchedaAction.svuotaCestinoScheda(this.con);
                this.con.commit();
                this.getTblList().refresh();
            }
            catch (SQLException e) {
                Logger.getRootLogger().error((Object)("Exception in Removing \n" + e + "\n"));
            }
        }
    }
}

