/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip.ui;

import it.f2.gestRip.EnvConstants;
import it.f2.gestRip.EnvProperties;
import it.f2.gestRip.control.CommonMetodBin;
import it.f2.gestRip.control.DbSchedaAction;
import it.f2.gestRip.control.PrintAction;
import it.f2.gestRip.ui.VcDlgDetailScheda;
import it.f2.gestRip.ui.VcIfrListaSchede;
import it.f2.gestRip.ui.VcMainFrame;
import it.f2.gestRip.ui.messages.Messages;
import it.f2.gestRip.util.LinksUtils;
import it.f2.util.ui.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.apache.log4j.Logger;

public class VcIfrMain
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private VcMainFrame parent = null;
    private JButton btnInsScheda = null;
    private JButton btnListaSchede = null;
    private JToolBar tlbFunctions = null;
    private JButton btnViewScheda = null;
    private JButton btnModScheda = null;
    private JButton brnStampaScheda = null;
    private JEditorPane edpMainScreen = null;
    private Connection con = null;

    public VcIfrMain(VcMainFrame parent) {
        Logger.getRootLogger().debug((Object)"Loading Main..");
        this.parent = parent;
        this.con = CommonMetodBin.getConn();
        this.initialize();
    }

    private void initialize() {
        this.setSize(793, 516);
        this.setContentPane(this.getJContentPane());
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                VcIfrMain.this.close();
            }
        });
    }

    private void close() {
        CommonMetodBin.closeConn(this.con);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getTlbFunctions(), "North");
            this.jContentPane.add((Component)this.getEdpMainScreen(), "Center");
        }
        return this.jContentPane;
    }

    private JButton getBtnInsScheda() {
        if (this.btnInsScheda == null) {
            this.btnInsScheda = new JButton();
            this.btnInsScheda.setText(Messages.getString("VcIfrMain.btnNewSheet"));
            this.btnInsScheda.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/newtodo.png")));
            this.btnInsScheda.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcDlgDetailScheda dialog = new VcDlgDetailScheda(VcIfrMain.this.parent, null, VcDlgDetailScheda.mode.insert, 0);
                    WindowUtil.centerWindow((JDialog)dialog);
                    dialog.setVisible(true);
                }
            });
        }
        return this.btnInsScheda;
    }

    private JButton getBtnListaSchede() {
        if (this.btnListaSchede == null) {
            this.btnListaSchede = new JButton();
            this.btnListaSchede.setText(Messages.getString("VcIfrMain.btnListSheet"));
            this.btnListaSchede.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/view_detailed.png")));
            this.btnListaSchede.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcIfrListaSchede iframe = new VcIfrListaSchede(VcIfrMain.this.parent);
                    if (!VcIfrMain.this.parent.isJitOpen(iframe.getClass())) {
                        VcIfrMain.this.parent.addTab(Messages.getString("VcIfrMain.tabListSheet"), iframe);
                        VcIfrMain.this.parent.selectTab(iframe);
                    } else {
                        iframe.hide();
                    }
                }
            });
        }
        return this.btnListaSchede;
    }

    private JToolBar getTlbFunctions() {
        if (this.tlbFunctions == null) {
            this.tlbFunctions = new JToolBar();
            this.tlbFunctions.add(this.getBtnListaSchede());
            this.tlbFunctions.add(this.getBtnInsScheda());
            this.tlbFunctions.add(this.getBtnViewScheda());
            this.tlbFunctions.add(this.getBtnModScheda());
            this.tlbFunctions.add(this.getBrnStampaScheda());
        }
        return this.tlbFunctions;
    }

    private JButton getBtnViewScheda() {
        if (this.btnViewScheda == null) {
            this.btnViewScheda = new JButton();
            this.btnViewScheda.setText(Messages.getString("VcIfrMain.btnShowSheet"));
            this.btnViewScheda.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/fileopen.png")));
            this.btnViewScheda.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block5: {
                        String mes = JOptionPane.showInputDialog(VcIfrMain.this.getParent(), (Object)Messages.getString("VcIfrMain.msgIsnNumberSheet"));
                        int num = 0;
                        try {
                            num = Integer.parseInt(mes);
                            try {
                                if (DbSchedaAction.existScheda(VcIfrMain.this.con, num)) {
                                    VcIfrMain.this.openDetail(VcDlgDetailScheda.mode.view, num);
                                    break block5;
                                }
                                JOptionPane.showMessageDialog(VcIfrMain.this.getParent(), Messages.getString("VcIfrMain.msgSheetNotExist"), Messages.getString("VcIfrMain.msgWarningTit"), 2);
                            }
                            catch (SQLException e1) {
                                Logger.getRootLogger().error((Object)("Exception in Connectiond DB \n" + e + "\n"));
                            }
                        }
                        catch (NumberFormatException ex) {
                            JOptionPane.showMessageDialog(VcIfrMain.this.getParent(), Messages.getString("VcIfrMain.msgSheetNumberNotValid"), Messages.getString("VcIfrMain.msgWarningTit"), 2);
                        }
                    }
                }
            });
        }
        return this.btnViewScheda;
    }

    private void openDetail(VcDlgDetailScheda.mode modality, int id_scheda) {
        VcDlgDetailScheda dialog = new VcDlgDetailScheda(this.parent, null, modality, id_scheda);
        WindowUtil.centerWindow((JDialog)dialog);
        dialog.setVisible(true);
        dialog.setVisible(this.closable);
    }

    private JButton getBtnModScheda() {
        if (this.btnModScheda == null) {
            this.btnModScheda = new JButton();
            this.btnModScheda.setText(Messages.getString("VcIfrMain.btnUpdSheet"));
            this.btnModScheda.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/kate.png")));
            this.btnModScheda.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block5: {
                        String mes = JOptionPane.showInputDialog(VcIfrMain.this.getParent(), (Object)Messages.getString("VcIfrMain.msgIsnNumberSheet"));
                        int num = 0;
                        try {
                            num = Integer.parseInt(mes);
                            try {
                                if (DbSchedaAction.existScheda(VcIfrMain.this.con, num)) {
                                    VcIfrMain.this.openDetail(VcDlgDetailScheda.mode.update, num);
                                    break block5;
                                }
                                JOptionPane.showMessageDialog(VcIfrMain.this.getParent(), Messages.getString("VcIfrMain.msgSheetNotExist"), Messages.getString("VcIfrMain.msgWarningTit"), 2);
                            }
                            catch (SQLException e1) {
                                Logger.getRootLogger().error((Object)("Exception in Connectiond DB \n" + e + "\n"));
                            }
                        }
                        catch (NumberFormatException ex) {
                            JOptionPane.showMessageDialog(VcIfrMain.this.getParent(), Messages.getString("VcIfrMain.msgSheetNumberNotValid"), Messages.getString("VcIfrMain.msgWarningTit"), 2);
                        }
                    }
                }
            });
        }
        return this.btnModScheda;
    }

    private JButton getBrnStampaScheda() {
        if (this.brnStampaScheda == null) {
            this.brnStampaScheda = new JButton();
            this.brnStampaScheda.setText(Messages.getString("VcIfrMain.btnPrintSheet"));
            this.brnStampaScheda.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/fileprint_.png")));
            this.brnStampaScheda.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block5: {
                        String mes = JOptionPane.showInputDialog(VcIfrMain.this.getParent(), (Object)Messages.getString("VcIfrMain.msgIsnNumberSheet"));
                        int num = 0;
                        try {
                            num = Integer.parseInt(mes);
                            try {
                                if (DbSchedaAction.existScheda(VcIfrMain.this.con, num)) {
                                    VcIfrMain.this.print(num);
                                    break block5;
                                }
                                JOptionPane.showMessageDialog(VcIfrMain.this.getParent(), Messages.getString("VcIfrMain.msgSheetNotExist"), Messages.getString("VcIfrMain.msgWarningTit"), 2);
                            }
                            catch (SQLException e1) {
                                Logger.getRootLogger().error((Object)("Exception in Connectiond DB \n" + e + "\n"));
                            }
                        }
                        catch (NumberFormatException ex) {
                            JOptionPane.showMessageDialog(VcIfrMain.this.getParent(), Messages.getString("VcIfrMain.msgSheetNumberNotValid"), Messages.getString("VcIfrMain.msgWarningTit"), 2);
                        }
                    }
                }
            });
        }
        return this.brnStampaScheda;
    }

    private void print(int nScheda) {
        Logger.getRootLogger().debug((Object)"printing");
        PrintAction pa = new PrintAction();
        pa.callReportRicevuta(this.parent, nScheda, this.con);
    }

    private JEditorPane getEdpMainScreen() {
        if (this.edpMainScreen == null) {
            String mainScreenFile = "mainScreen_en.html";
            if (Locale.getDefault().equals(Locale.ITALY)) {
                mainScreenFile = "mainScreen_it.html";
            }
            File html = new File("resource" + EnvProperties.FILE_SEPARETOR + mainScreenFile);
            this.edpMainScreen = new JEditorPane();
            this.edpMainScreen.setContentType("text/html");
            this.edpMainScreen.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (Locale.getDefault().equals(Locale.ITALY)) {
                            LinksUtils.openUrl(VcIfrMain.this.edpMainScreen.getParent(), EnvConstants.LINK_DONATE_IT);
                        } else {
                            LinksUtils.openUrl(VcIfrMain.this.edpMainScreen.getParent(), EnvConstants.LINK_DONATE_EN);
                        }
                    }
                }
            });
            try {
                Logger.getRootLogger().debug((Object)"Setting main html page...");
                this.edpMainScreen.setPage(html.toURI().toURL());
            }
            catch (MalformedURLException e) {
                Logger.getRootLogger().error((Object)("Exception in Setting main html page\n" + e + "\n"));
            }
            catch (IOException e) {
                Logger.getRootLogger().error((Object)("Exception in Setting main html page\n" + e + "\n"));
            }
            this.edpMainScreen.setEditable(false);
        }
        return this.edpMainScreen;
    }
}

