/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip.ui;

import it.f2.gestRip.EnvConstants;
import it.f2.gestRip.EnvProperties;
import it.f2.gestRip.ui.VcDlgAbout;
import it.f2.gestRip.ui.VcDlgOptions;
import it.f2.gestRip.ui.VcIfrDeletedSchede;
import it.f2.gestRip.ui.VcIfrListaSchede;
import it.f2.gestRip.ui.VcIfrMain;
import it.f2.gestRip.ui.anagraf.VcIfrAnaClienti;
import it.f2.gestRip.ui.anagraf.VcIfrAnaMarche;
import it.f2.gestRip.ui.anagraf.VcIfrAnaModelli;
import it.f2.gestRip.ui.anagraf.VcIfrAnaStati;
import it.f2.gestRip.ui.anagraf.VcIfrAnaTipoDatiAcq;
import it.f2.gestRip.ui.anagraf.VcIfrAnaTipoOggetto;
import it.f2.gestRip.ui.anagraf.VcIfrAnaTipoRip;
import it.f2.gestRip.ui.messages.Messages;
import it.f2.gestRip.util.LinksUtils;
import it.f2.util.ui.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class VcMainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JMenuBar jJMenuBar = null;
    private JMenu fileMenu = null;
    private JMenu helpMenu = null;
    private JMenuItem exitMenuItem = null;
    private JMenuItem aboutMenuItem = null;
    private JTabbedPane tbpMain = null;
    private JMenu settingMenu = null;
    private JMenuItem optionsMenuItem = null;
    private JMenu gestMenu = null;
    private JMenuItem mniStati = null;
    private JMenuItem mniModelli = null;
    private JMenuItem mniTipoOggetto = null;
    private JMenuItem mniMarche = null;
    private JMenuItem mniAnaClienti = null;
    private JMenuItem mniTipoRip = null;
    private JMenuItem mniTipoDatiAcq = null;
    private int lastSelectedIndex = 0;
    private boolean checking = false;
    private VcIfrAnaClienti anaClienti = null;
    private JMenuItem mniSchedeDeleted = null;
    private JMenuItem mniSupportRequest = null;
    private JMenuItem mnuBugs = null;
    private JMenuItem mniWebSite = null;
    private JMenuItem mniHelpContent = null;

    public VcMainFrame() {
        Logger.getRootLogger().debug((Object)"VcMainFrame constructor...");
        this.initialize();
    }

    private void initialize() {
        this.setDefaultCloseOperation(0);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/it/f2/gestRip/ui/img/logo64.png")));
        this.setJMenuBar(this.getJJMenuBar());
        this.setSize(442, 300);
        this.setSize(Integer.parseInt(EnvProperties.getInstance().getProperty(EnvProperties.WIDTH)), Integer.parseInt(EnvProperties.getInstance().getProperty(EnvProperties.HEIGHT)));
        this.setContentPane(this.getJContentPane());
        this.setTitle(EnvProperties.getInstance().getProperty(EnvProperties.APPNAME));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                VcMainFrame.this.onClosing();
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getTbpMain(), "Center");
        }
        return this.jContentPane;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
            this.jJMenuBar.add(this.getGestMenu());
            this.jJMenuBar.add(this.getSettingMenu());
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText(Messages.getString("VcMainFrame.mnuFile"));
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getExitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText(Messages.getString("VcMainFrame.mnuHelp"));
            this.helpMenu.add(this.getMniHelpContent());
            this.helpMenu.addSeparator();
            this.helpMenu.add(this.getMniSupportRequest());
            this.helpMenu.add(this.getMnuBugs());
            this.helpMenu.add(this.getMniWebSite());
            this.helpMenu.addSeparator();
            this.helpMenu.add(this.getAboutMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText(Messages.getString("VcMainFrame.mnuExit"));
            this.exitMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcMainFrame.this.onClosing();
                }
            });
        }
        return this.exitMenuItem;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText(Messages.getString("VcMainFrame.mnuAbout"));
            this.aboutMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcMainFrame.this.openDlgAbout();
                }
            });
        }
        return this.aboutMenuItem;
    }

    private void openDlgAbout() {
        VcDlgAbout d = new VcDlgAbout(this);
        WindowUtil.centerWindow((JDialog)d);
        d.setVisible(true);
    }

    public void setTabTitle(String txt) {
        this.getTbpMain().setTitleAt(this.getTbpMain().getSelectedIndex(), txt);
    }

    private JTabbedPane getTbpMain() {
        if (this.tbpMain == null) {
            this.tbpMain = new JTabbedPane();
            VcIfrMain ifr = new VcIfrMain(this);
            ifr.setTitle(Messages.getString("VcMainFrame.ifrTitMain"));
            this.tbpMain.addTab(Messages.getString("VcMainFrame.ifrTabMain"), ifr);
            this.tbpMain.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    VcMainFrame.this.lastSelectedIndex = VcMainFrame.this.getTbpMain().getSelectedIndex();
                    if (VcMainFrame.this.getTbpMain().getSelectedIndex() != -1) {
                        JInternalFrame ifr = (JInternalFrame)VcMainFrame.this.getTbpMain().getSelectedComponent();
                        try {
                            ((VcIfrListaSchede)ifr).getTblList().refresh();
                        }
                        catch (ClassCastException classCastException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        return this.tbpMain;
    }

    public boolean isJitOpen(Class<?> className) {
        boolean result = false;
        Component[] cm = this.getTbpMain().getComponents();
        int i = 0;
        while (i < cm.length) {
            try {
                JInternalFrame jit = (JInternalFrame)cm[i];
                if (jit.getClass() == className) {
                    result = true;
                    this.selectTab(jit);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++i;
        }
        return result;
    }

    public void addTab(String title, JInternalFrame iframe) {
        this.getTbpMain().addTab(title, iframe);
    }

    public void selectTab(JInternalFrame iframe) {
        this.getTbpMain().setSelectedComponent(iframe);
    }

    public void closeTab(JInternalFrame iframe) {
        if (this.isJitOpen(iframe.getClass())) {
            this.getTbpMain().remove(iframe);
            iframe.dispose();
        }
    }

    private void onClosing() {
        Component[] cm = this.getTbpMain().getComponents();
        int i = 0;
        while (i < cm.length) {
            try {
                JInternalFrame jit = (JInternalFrame)cm[i];
                jit.doDefaultCloseAction();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++i;
        }
        EnvProperties.getInstance().setProperty(EnvProperties.WIDTH, "" + this.getWidth());
        EnvProperties.getInstance().setProperty(EnvProperties.HEIGHT, "" + this.getHeight());
        EnvProperties.getInstance().saveFileProperty();
        System.exit(0);
    }

    private JMenu getSettingMenu() {
        if (this.settingMenu == null) {
            this.settingMenu = new JMenu();
            this.settingMenu.setText(Messages.getString("VcMainFrame.mnuTools"));
            this.settingMenu.add(this.getMniSchedeDeleted());
            this.settingMenu.add(this.getOptionsMenuItem());
        }
        return this.settingMenu;
    }

    private JMenuItem getOptionsMenuItem() {
        if (this.optionsMenuItem == null) {
            this.optionsMenuItem = new JMenuItem();
            this.optionsMenuItem.setText(Messages.getString("VcMainFrame.mnuOptions"));
            this.optionsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/Options16.png")));
            this.optionsMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcMainFrame.this.openDialogOptions();
                }
            });
        }
        return this.optionsMenuItem;
    }

    private void openDialogOptions() {
        VcDlgOptions d = new VcDlgOptions(this);
        WindowUtil.centerWindow((JDialog)d);
        d.setVisible(true);
    }

    private JMenu getGestMenu() {
        if (this.gestMenu == null) {
            this.gestMenu = new JMenu();
            this.gestMenu.setText(Messages.getString("VcMainFrame.mnuManage"));
            this.gestMenu.add(this.getMniAnaClienti());
            this.gestMenu.add(this.getMniStati());
            this.gestMenu.add(this.getMniTipoRip());
            this.gestMenu.add(this.getMniTipoDatiAcq());
            this.gestMenu.add(this.getMniTipoOggetto());
            this.gestMenu.add(this.getMniMarche());
            this.gestMenu.add(this.getMniModelli());
        }
        return this.gestMenu;
    }

    private JMenuItem getMniStati() {
        if (this.mniStati == null) {
            this.mniStati = new JMenuItem();
            this.mniStati.setText(Messages.getString("VcMainFrame.mnuState"));
            this.mniStati.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcMainFrame.this.openAnaStati();
                }
            });
        }
        return this.mniStati;
    }

    private void openAnaStati() {
        VcIfrAnaStati iframe = new VcIfrAnaStati(this);
        if (!this.isJitOpen(iframe.getClass())) {
            this.addTab(Messages.getString("VcMainFrame.tabState"), iframe);
            this.selectTab(iframe);
        } else {
            iframe.hide();
        }
    }

    private JMenuItem getMniModelli() {
        if (this.mniModelli == null) {
            this.mniModelli = new JMenuItem();
            this.mniModelli.setText(Messages.getString("VcMainFrame.mnuModels"));
            this.mniModelli.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcMainFrame.this.openAnaModelli();
                }
            });
        }
        return this.mniModelli;
    }

    private void openAnaModelli() {
        VcIfrAnaModelli iframe = new VcIfrAnaModelli(this);
        if (!this.isJitOpen(iframe.getClass())) {
            this.addTab(Messages.getString("VcMainFrame.tabModels"), iframe);
            this.selectTab(iframe);
        } else {
            iframe.hide();
        }
    }

    private JMenuItem getMniTipoOggetto() {
        if (this.mniTipoOggetto == null) {
            this.mniTipoOggetto = new JMenuItem();
            this.mniTipoOggetto.setText(Messages.getString("VcMainFrame.mnuTypeObj"));
            this.mniTipoOggetto.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcMainFrame.this.openAnaTipoOggetto();
                }
            });
        }
        return this.mniTipoOggetto;
    }

    private void openAnaTipoOggetto() {
        VcIfrAnaTipoOggetto iframe = new VcIfrAnaTipoOggetto(this);
        if (!this.isJitOpen(iframe.getClass())) {
            this.addTab(Messages.getString("VcMainFrame.tabTypeObj"), iframe);
            this.selectTab(iframe);
        } else {
            iframe.hide();
        }
    }

    private JMenuItem getMniMarche() {
        if (this.mniMarche == null) {
            this.mniMarche = new JMenuItem();
            this.mniMarche.setText(Messages.getString("VcMainFrame.mnuBrands"));
            this.mniMarche.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcMainFrame.this.openAnaMarche();
                }
            });
        }
        return this.mniMarche;
    }

    private void openAnaMarche() {
        VcIfrAnaMarche iframe = new VcIfrAnaMarche(this);
        if (!this.isJitOpen(iframe.getClass())) {
            this.addTab(Messages.getString("VcMainFrame.tabBrands"), iframe);
            this.selectTab(iframe);
        } else {
            iframe.hide();
        }
    }

    private JMenuItem getMniAnaClienti() {
        if (this.mniAnaClienti == null) {
            this.mniAnaClienti = new JMenuItem();
            this.mniAnaClienti.setText(Messages.getString("VcMainFrame.mnuCustomers"));
            this.mniAnaClienti.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcMainFrame.this.openAnaClienti();
                }
            });
        }
        return this.mniAnaClienti;
    }

    private void openAnaClienti() {
        this.anaClienti = new VcIfrAnaClienti(this);
        if (!this.isJitOpen(this.anaClienti.getClass())) {
            this.getTbpMain().addTab(Messages.getString("VcMainFrame.tabCustomers"), this.anaClienti);
            this.getTbpMain().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (VcMainFrame.this.checking) {
                        VcMainFrame.this.checking = false;
                    } else {
                        if (VcMainFrame.this.getTbpMain().getSelectedIndex() != -1) {
                            if (VcMainFrame.this.anaClienti.checkCompleteUpdate()) {
                                VcMainFrame.this.lastSelectedIndex = VcMainFrame.this.getTbpMain().getSelectedIndex();
                            } else {
                                VcMainFrame.this.checking = true;
                                VcMainFrame.this.getTbpMain().setSelectedIndex(VcMainFrame.this.lastSelectedIndex);
                            }
                        } else {
                            VcMainFrame.this.lastSelectedIndex = VcMainFrame.this.getTbpMain().getSelectedIndex();
                        }
                        VcMainFrame.this.checking = false;
                    }
                }
            });
            this.selectTab(this.anaClienti);
        } else {
            this.anaClienti.hide();
        }
    }

    private JMenuItem getMniTipoRip() {
        if (this.mniTipoRip == null) {
            this.mniTipoRip = new JMenuItem();
            this.mniTipoRip.setText(Messages.getString("VcMainFrame.mnuRepairsType"));
            this.mniTipoRip.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcMainFrame.this.openAnaTipoRip();
                }
            });
        }
        return this.mniTipoRip;
    }

    private void openAnaTipoRip() {
        VcIfrAnaTipoRip iframe = new VcIfrAnaTipoRip(this);
        if (!this.isJitOpen(iframe.getClass())) {
            this.addTab(Messages.getString("VcMainFrame.tabRepairsType"), iframe);
            this.selectTab(iframe);
        } else {
            iframe.hide();
        }
    }

    private JMenuItem getMniTipoDatiAcq() {
        if (this.mniTipoDatiAcq == null) {
            this.mniTipoDatiAcq = new JMenuItem();
            this.mniTipoDatiAcq.setText(Messages.getString("VcMainFrame.mnuPurchasingData"));
            this.mniTipoDatiAcq.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcMainFrame.this.openAnaTipoDatiAcq();
                }
            });
        }
        return this.mniTipoDatiAcq;
    }

    private void openAnaTipoDatiAcq() {
        VcIfrAnaTipoDatiAcq iframe = new VcIfrAnaTipoDatiAcq(this);
        if (!this.isJitOpen(iframe.getClass())) {
            this.addTab(Messages.getString("VcMainFrame.tabPurchasingData"), iframe);
            this.selectTab(iframe);
        } else {
            iframe.hide();
        }
    }

    private JMenuItem getMniSchedeDeleted() {
        if (this.mniSchedeDeleted == null) {
            this.mniSchedeDeleted = new JMenuItem();
            this.mniSchedeDeleted.setText(Messages.getString("VcMainFrame.mnuTrashSheet"));
            this.mniSchedeDeleted.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/trashcan_full.png")));
            this.mniSchedeDeleted.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcMainFrame.this.openSchedeDeleted();
                }
            });
        }
        return this.mniSchedeDeleted;
    }

    private void openSchedeDeleted() {
        VcIfrDeletedSchede iframe = new VcIfrDeletedSchede(this);
        if (!this.isJitOpen(iframe.getClass())) {
            this.addTab(Messages.getString("VcMainFrame.tabTrashSheet"), iframe);
            this.selectTab(iframe);
        } else {
            iframe.hide();
        }
    }

    private JMenuItem getMniSupportRequest() {
        if (this.mniSupportRequest == null) {
            this.mniSupportRequest = new JMenuItem();
            this.mniSupportRequest.setText(Messages.getString("VcMainFrame.mnuSupport"));
            this.mniSupportRequest.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LinksUtils.openUrl(VcMainFrame.this.mniSupportRequest.getParent(), EnvConstants.LINK_SUPPORT_REQUEST);
                }
            });
        }
        return this.mniSupportRequest;
    }

    private JMenuItem getMnuBugs() {
        if (this.mnuBugs == null) {
            this.mnuBugs = new JMenuItem();
            this.mnuBugs.setText(Messages.getString("VcMainFrame.mnuBugs"));
            this.mnuBugs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LinksUtils.openUrl(VcMainFrame.this.mnuBugs.getParent(), EnvConstants.LINK_BUG_REPORT);
                }
            });
        }
        return this.mnuBugs;
    }

    private JMenuItem getMniWebSite() {
        if (this.mniWebSite == null) {
            this.mniWebSite = new JMenuItem();
            this.mniWebSite.setText(Messages.getString("VcMainFrame.mniWebSite"));
            this.mniWebSite.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LinksUtils.openUrl(VcMainFrame.this.mniWebSite.getParent(), EnvConstants.LINK_WEBSITE);
                }
            });
        }
        return this.mniWebSite;
    }

    private JMenuItem getMniHelpContent() {
        if (this.mniHelpContent == null) {
            this.mniHelpContent = new JMenuItem();
            this.mniHelpContent.setText(Messages.getString("VcMainFrame.mniHelpContent"));
            this.mniHelpContent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EnvProperties.getInstance().getProperty(EnvProperties.LANGUAGE).equalsIgnoreCase("it")) {
                        LinksUtils.openFile(VcMainFrame.this.mniHelpContent.getParent(), "site" + File.separator + "documents" + File.separator + "RepairsLabUserManual-it.pdf");
                    } else {
                        LinksUtils.openFile(VcMainFrame.this.mniHelpContent.getParent(), "site" + File.separator + "documents" + File.separator + "RepairsLabUserGuide-en.pdf");
                    }
                }
            });
        }
        return this.mniHelpContent;
    }
}

