/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip.ui;

import it.f2.gestRip.control.DbSchedaAction;
import it.f2.gestRip.model.BinCliente;
import it.f2.gestRip.model.BinScheda;
import it.f2.gestRip.ui.VcDlgDetailScheda;
import it.f2.gestRip.ui.VcDlgSelezionaCliente;
import it.f2.gestRip.ui.messages.Messages;
import it.f2.util.ui.WindowUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class VcPnlDatiCLiente
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel lblMail = null;
    private JLabel lblCognome = null;
    private JLabel lblNome = null;
    private JTextField txfAzienda = null;
    private JTextField txfCitta = null;
    private JLabel lblCitta = null;
    private JTextField txfTelefono = null;
    private JTextField txfCognome = null;
    private JTextField txfNome = null;
    private JLabel lblIndirizzo = null;
    private JLabel lblAzienda = null;
    private JTextField txfEmail = null;
    private JTextField txfPiva = null;
    private JLabel lblPiva = null;
    private JTextField txfIndirizzo = null;
    private JLabel lblTelefono = null;
    private JTextField txfMobile = null;
    private JLabel lblMobile = null;
    private VcDlgDetailScheda.mode modality = null;
    private BinScheda scheda = null;
    private JDialog dialog = null;
    private JButton btnSelezionaCliente = null;
    private JButton btnInserisciCliente = null;
    private JButton btnEditCliente = null;
    private JButton btnOk = null;
    private JButton btnCanc = null;
    private int newIdClienteAppo = 0;
    private modeCliente modalityCliente = modeCliente.view;
    private Connection con = null;

    public VcPnlDatiCLiente(VcDlgDetailScheda.mode modality, BinScheda scheda, JDialog dialog, Connection con) {
        Logger.getRootLogger().debug((Object)"VcPnlDatiCLiente constructor...");
        this.modality = modality;
        this.scheda = scheda;
        this.dialog = dialog;
        this.con = con;
        this.initialize();
    }

    private void initialize() {
        this.setSize(759, 511);
        this.setLayout(null);
        int aPoint = 100;
        this.lblMobile = new JLabel();
        this.lblMobile.setBounds(new Rectangle(aPoint, 160, aPoint, 16));
        this.lblMobile.setHorizontalAlignment(4);
        this.lblMobile.setText(Messages.getString("VcPnlDatiCLiente.lblMobile"));
        this.lblTelefono = new JLabel();
        this.lblTelefono.setBounds(new Rectangle(aPoint, 130, aPoint, 16));
        this.lblTelefono.setHorizontalAlignment(4);
        this.lblTelefono.setText(Messages.getString("VcPnlDatiCLiente.lblPhone"));
        this.lblPiva = new JLabel();
        this.lblPiva.setBounds(new Rectangle(aPoint, 310, aPoint, 16));
        this.lblPiva.setHorizontalAlignment(4);
        this.lblPiva.setText(Messages.getString("VcPnlDatiCLiente.lblVat"));
        this.lblAzienda = new JLabel();
        this.lblAzienda.setBounds(new Rectangle(aPoint, 280, aPoint, 16));
        this.lblAzienda.setHorizontalAlignment(4);
        this.lblAzienda.setText(Messages.getString("VcPnlDatiCLiente.lblCompany"));
        this.lblIndirizzo = new JLabel();
        this.lblIndirizzo.setBounds(new Rectangle(aPoint, 190, aPoint, 16));
        this.lblIndirizzo.setHorizontalAlignment(4);
        this.lblIndirizzo.setText(Messages.getString("VcPnlDatiCLiente.lblAddress"));
        this.lblCitta = new JLabel();
        this.lblCitta.setBounds(new Rectangle(aPoint, 220, aPoint, 16));
        this.lblCitta.setHorizontalAlignment(4);
        this.lblCitta.setText(Messages.getString("VcPnlDatiCLiente.lblCity"));
        this.lblNome = new JLabel();
        this.lblNome.setBounds(new Rectangle(aPoint, 70, aPoint, 16));
        this.lblNome.setHorizontalAlignment(4);
        this.lblNome.setText(Messages.getString("VcPnlDatiCLiente.lblName"));
        this.lblCognome = new JLabel();
        this.lblCognome.setBounds(new Rectangle(aPoint, 100, aPoint, 16));
        this.lblCognome.setHorizontalAlignment(4);
        this.lblCognome.setText(Messages.getString("VcPnlDatiCLiente.lblSur"));
        this.lblMail = new JLabel();
        this.lblMail.setBounds(new Rectangle(aPoint, 250, aPoint, 16));
        this.lblMail.setHorizontalAlignment(4);
        this.lblMail.setText(Messages.getString("VcPnlDatiCLiente.lblEmail"));
        this.add((Component)this.getTxfNome(), null);
        this.add((Component)this.getTxfCognome(), null);
        this.add((Component)this.lblMail, null);
        this.add((Component)this.lblCognome, null);
        this.add((Component)this.lblNome, null);
        this.add((Component)this.getTxfAzienda(), null);
        this.add((Component)this.getTxfCitta(), null);
        this.add((Component)this.lblCitta, null);
        this.add((Component)this.getTxfTelefono(), null);
        this.add((Component)this.lblIndirizzo, null);
        this.add((Component)this.lblAzienda, null);
        this.add((Component)this.getTxfEmail(), null);
        this.add((Component)this.getTxfPiva(), null);
        this.add((Component)this.lblPiva, null);
        this.add((Component)this.getTxfIndirizzo(), null);
        this.add((Component)this.lblTelefono, null);
        this.add((Component)this.getTxfMobile(), null);
        this.add((Component)this.lblMobile, null);
        this.add((Component)this.getBtnSelezionaCliente(), null);
        this.add((Component)this.getBtnInserisciCliente(), null);
        this.add((Component)this.getBtnEditCliente(), null);
        this.add((Component)this.getBtnOk(), null);
        this.add((Component)this.getBtnCanc(), null);
    }

    private JTextField getTxfAzienda() {
        if (this.txfAzienda == null) {
            this.txfAzienda = new JTextField();
            this.txfAzienda.setText(this.scheda.getBinCliente().getAzienda());
            this.txfAzienda.setBounds(new Rectangle(220, 275, 300, 25));
            this.txfAzienda.setEditable(false);
        }
        return this.txfAzienda;
    }

    private JTextField getTxfCitta() {
        if (this.txfCitta == null) {
            this.txfCitta = new JTextField();
            this.txfCitta.setText(this.scheda.getBinCliente().getCity());
            this.txfCitta.setBounds(new Rectangle(220, 215, 300, 25));
            this.txfCitta.setEditable(false);
        }
        return this.txfCitta;
    }

    private JTextField getTxfTelefono() {
        if (this.txfTelefono == null) {
            this.txfTelefono = new JTextField();
            this.txfTelefono.setText(this.scheda.getBinCliente().getPhone());
            this.txfTelefono.setBounds(new Rectangle(220, 125, 300, 25));
            this.txfTelefono.setEditable(false);
        }
        return this.txfTelefono;
    }

    private JTextField getTxfCognome() {
        if (this.txfCognome == null) {
            this.txfCognome = new JTextField();
            this.txfCognome.setText(this.scheda.getBinCliente().getCognome());
            this.txfCognome.setBounds(new Rectangle(220, 95, 300, 25));
            this.txfCognome.setEditable(false);
            this.txfCognome.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    VcPnlDatiCLiente.this.existCliente();
                }
            });
        }
        return this.txfCognome;
    }

    private JTextField getTxfNome() {
        if (this.txfNome == null) {
            this.txfNome = new JTextField();
            this.txfNome.setText(this.scheda.getBinCliente().getNome());
            this.txfNome.setBounds(new Rectangle(220, 65, 300, 25));
            this.txfNome.setEditable(false);
            this.txfNome.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    VcPnlDatiCLiente.this.existCliente();
                }
            });
        }
        return this.txfNome;
    }

    private void existCliente() {
        if (this.modalityCliente != modeCliente.view) {
            try {
                Logger.getRootLogger().debug((Object)"existCliente...");
                int idCliente = DbSchedaAction.existCliente(this.con, this.getTxfNome().getText(), this.getTxfCognome().getText());
                if (idCliente > 0) {
                    int confirm = JOptionPane.showConfirmDialog(this.getParent(), Messages.getString("VcPnlDatiCLiente.msgCustomerExixt"), Messages.getString("VcPnlDatiCLiente.msgTitleInfo"), 0);
                    if (confirm == 0) {
                        this.selezionaCliente(idCliente);
                    } else if (confirm == 1) {
                        this.getTxfNome().setText("");
                        this.getTxfCognome().setText("");
                    }
                }
            }
            catch (SQLException e) {
                Logger.getRootLogger().error((Object)("Exception existCliente \n" + e + "\n"));
            }
        }
    }

    private JTextField getTxfEmail() {
        if (this.txfEmail == null) {
            this.txfEmail = new JTextField();
            this.txfEmail.setText(this.scheda.getBinCliente().getEmail());
            this.txfEmail.setBounds(new Rectangle(220, 245, 300, 25));
            this.txfEmail.setEditable(false);
        }
        return this.txfEmail;
    }

    private JTextField getTxfPiva() {
        if (this.txfPiva == null) {
            this.txfPiva = new JTextField();
            this.txfPiva.setText(this.scheda.getBinCliente().getPIva());
            this.txfPiva.setBounds(new Rectangle(220, 305, 300, 25));
            this.txfPiva.setEditable(false);
        }
        return this.txfPiva;
    }

    private JTextField getTxfIndirizzo() {
        if (this.txfIndirizzo == null) {
            this.txfIndirizzo = new JTextField();
            this.txfIndirizzo.setText(this.scheda.getBinCliente().getIndirizzo());
            this.txfIndirizzo.setBounds(new Rectangle(220, 185, 300, 25));
            this.txfIndirizzo.setEditable(false);
        }
        return this.txfIndirizzo;
    }

    private JTextField getTxfMobile() {
        if (this.txfMobile == null) {
            this.txfMobile = new JTextField();
            this.txfMobile.setText(this.scheda.getBinCliente().getMobilePhone());
            this.txfMobile.setBounds(new Rectangle(220, 155, 300, 25));
            this.txfMobile.setEditable(false);
        }
        return this.txfMobile;
    }

    private JButton getBtnSelezionaCliente() {
        if (this.btnSelezionaCliente == null) {
            this.btnSelezionaCliente = new JButton();
            this.btnSelezionaCliente.setBounds(new Rectangle(560, 120, 160, 30));
            this.btnSelezionaCliente.setText(Messages.getString("VcPnlDatiCLiente.btnSelectCustomer"));
            this.btnSelezionaCliente.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/openterm.png")));
            if (this.modality == VcDlgDetailScheda.mode.view) {
                this.btnSelezionaCliente.setEnabled(false);
            }
            this.btnSelezionaCliente.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcPnlDatiCLiente.this.openDlgSelezionaCliente();
                }
            });
        }
        return this.btnSelezionaCliente;
    }

    private void openDlgSelezionaCliente() {
        VcDlgSelezionaCliente dlg = new VcDlgSelezionaCliente(this.dialog, this, this.con);
        WindowUtil.centerWindow((JDialog)dlg);
        dlg.setVisible(true);
    }

    public void selezionaCliente(int idCliente) {
        DbSchedaAction dbSchedaAction = new DbSchedaAction();
        try {
            Logger.getRootLogger().debug((Object)"Selecting cliente...");
            BinCliente binCliente = dbSchedaAction.getCliente(this.con, idCliente);
            this.scheda.setBinCliente(binCliente);
            this.refreshData(this.scheda.getBinCliente());
            this.setViewMode();
        }
        catch (SQLException e) {
            Logger.getRootLogger().error((Object)("Exception Selecting cliente \n" + e + "\n"));
        }
    }

    private void refreshData(BinCliente binCliente) {
        this.getTxfNome().setText(binCliente.getNome());
        this.getTxfCognome().setText(binCliente.getCognome());
        this.getTxfTelefono().setText(binCliente.getPhone());
        this.getTxfMobile().setText(binCliente.getMobilePhone());
        this.getTxfIndirizzo().setText(binCliente.getIndirizzo());
        this.getTxfCitta().setText(binCliente.getCity());
        this.getTxfEmail().setText(binCliente.getEmail());
        this.getTxfAzienda().setText(binCliente.getAzienda());
        this.getTxfPiva().setText(binCliente.getPIva());
    }

    private JButton getBtnInserisciCliente() {
        if (this.btnInserisciCliente == null) {
            this.btnInserisciCliente = new JButton();
            this.btnInserisciCliente.setBounds(new Rectangle(560, 165, 160, 30));
            this.btnInserisciCliente.setText(Messages.getString("VcPnlDatiCLiente.btnInsCustomer"));
            this.btnInserisciCliente.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/edit_add.png")));
            if (this.modality == VcDlgDetailScheda.mode.view) {
                this.btnInserisciCliente.setEnabled(false);
            }
            this.btnInserisciCliente.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcPnlDatiCLiente.this.inserisciCliente();
                }
            });
        }
        return this.btnInserisciCliente;
    }

    private void setUpdateMode() {
        this.modalityCliente = modeCliente.update;
        this.getBtnOk().setEnabled(true);
        this.getBtnCanc().setEnabled(true);
        this.getBtnSelezionaCliente().setEnabled(false);
        this.getBtnInserisciCliente().setEnabled(false);
        this.getBtnEditCliente().setEnabled(false);
        this.getTxfTelefono().setEditable(true);
        this.getTxfMobile().setEditable(true);
        this.getTxfIndirizzo().setEditable(true);
        this.getTxfCitta().setEditable(true);
        this.getTxfEmail().setEditable(true);
        this.getTxfAzienda().setEditable(true);
        this.getTxfPiva().setEditable(true);
    }

    private void setInsertMode() {
        this.modalityCliente = modeCliente.insert;
        this.getBtnOk().setEnabled(true);
        this.getBtnCanc().setEnabled(true);
        this.getBtnSelezionaCliente().setEnabled(false);
        this.getBtnInserisciCliente().setEnabled(false);
        this.getBtnEditCliente().setEnabled(false);
        this.getTxfTelefono().setEditable(true);
        this.getTxfMobile().setEditable(true);
        this.getTxfIndirizzo().setEditable(true);
        this.getTxfCitta().setEditable(true);
        this.getTxfEmail().setEditable(true);
        this.getTxfAzienda().setEditable(true);
        this.getTxfPiva().setEditable(true);
        this.getTxfNome().setEditable(true);
        this.getTxfCognome().setEditable(true);
        this.getTxfNome().requestFocus();
    }

    private void setViewMode() {
        this.modalityCliente = modeCliente.view;
        this.getBtnOk().setEnabled(false);
        this.getBtnCanc().setEnabled(false);
        this.getBtnSelezionaCliente().setEnabled(true);
        this.getBtnInserisciCliente().setEnabled(true);
        if (this.scheda.getBinCliente().getId() != 0) {
            this.btnEditCliente.setEnabled(true);
        }
        this.getTxfNome().setEditable(false);
        this.getTxfCognome().setEditable(false);
        this.getTxfTelefono().setEditable(false);
        this.getTxfMobile().setEditable(false);
        this.getTxfIndirizzo().setEditable(false);
        this.getTxfCitta().setEditable(false);
        this.getTxfEmail().setEditable(false);
        this.getTxfAzienda().setEditable(false);
        this.getTxfPiva().setEditable(false);
    }

    private void inserisciCliente() {
        try {
            Logger.getRootLogger().debug((Object)"Inserting Cliente...");
            BinCliente binCliente = DbSchedaAction.addCliente(this.con);
            this.newIdClienteAppo = binCliente.getId();
            this.refreshData(binCliente);
            this.setInsertMode();
        }
        catch (SQLException e) {
            Logger.getRootLogger().error((Object)("Exception in Inserting Cliente \n" + e + "\n"));
        }
    }

    private void modificaCliente() {
        this.setUpdateMode();
    }

    private JButton getBtnEditCliente() {
        if (this.btnEditCliente == null) {
            this.btnEditCliente = new JButton();
            this.btnEditCliente.setBounds(new Rectangle(560, 210, 160, 30));
            this.btnEditCliente.setText(Messages.getString("VcPnlDatiCLiente.btnUpdCustomer"));
            this.btnEditCliente.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/edit.png")));
            if (this.modality == VcDlgDetailScheda.mode.view || this.scheda.getBinCliente().getId() == 0) {
                this.btnEditCliente.setEnabled(false);
            }
            this.btnEditCliente.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcPnlDatiCLiente.this.modificaCliente();
                }
            });
        }
        return this.btnEditCliente;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setBounds(new Rectangle(249, 357, 85, 30));
            this.btnOk.setEnabled(false);
            this.btnOk.setText(Messages.getString("VcPnlDatiCLiente.btnOk"));
            this.btnOk.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/button_ok.png")));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcPnlDatiCLiente.this.save();
                }
            });
        }
        return this.btnOk;
    }

    public void save() {
        this.scheda.getBinCliente().setNome(this.getTxfNome().getText());
        this.scheda.getBinCliente().setCognome(this.getTxfCognome().getText());
        this.scheda.getBinCliente().setPhone(this.getTxfTelefono().getText());
        this.scheda.getBinCliente().setMobilePhone(this.getTxfMobile().getText());
        this.scheda.getBinCliente().setIndirizzo(this.getTxfIndirizzo().getText());
        this.scheda.getBinCliente().setCity(this.getTxfCitta().getText());
        this.scheda.getBinCliente().setEmail(this.getTxfEmail().getText());
        this.scheda.getBinCliente().setAzienda(this.getTxfAzienda().getText());
        this.scheda.getBinCliente().setPIva(this.getTxfPiva().getText());
        if (this.modalityCliente == modeCliente.insert) {
            this.scheda.getBinCliente().setId(this.newIdClienteAppo);
            try {
                Logger.getRootLogger().debug((Object)"getBtnOk ins...");
                DbSchedaAction.insCliente(this.con, this.scheda.getBinCliente());
            }
            catch (SQLException e1) {
                Logger.getRootLogger().error((Object)("Exception getBtnOk ins \n" + e1 + "\n"));
            }
        } else if (this.modalityCliente == modeCliente.update) {
            try {
                Logger.getRootLogger().debug((Object)"getBtnOk upd...");
                DbSchedaAction.saveCliente(this.con, this.scheda.getBinCliente());
            }
            catch (SQLException e1) {
                Logger.getRootLogger().error((Object)("Exception getBtnOk upd \n" + e1 + "\n"));
            }
        }
        this.setViewMode();
        this.refreshData(this.scheda.getBinCliente());
    }

    private JButton getBtnCanc() {
        if (this.btnCanc == null) {
            this.btnCanc = new JButton();
            this.btnCanc.setBounds(new Rectangle(345, 357, 85, 30));
            this.btnCanc.setEnabled(false);
            this.btnCanc.setText(Messages.getString("VcPnlDatiCLiente.btnCanc"));
            this.btnCanc.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/button_cancel.png")));
            this.btnCanc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcPnlDatiCLiente.this.setViewMode();
                    VcPnlDatiCLiente.this.refreshData(VcPnlDatiCLiente.this.scheda.getBinCliente());
                }
            });
        }
        return this.btnCanc;
    }

    public modeCliente getModalityCliente() {
        return this.modalityCliente;
    }

    public static enum modeCliente {
        insert,
        update,
        view;

    }
}

