/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip.ui.anagraf;

import it.f2.gestRip.control.CommonMetodBin;
import it.f2.gestRip.control.QryUtil;
import it.f2.gestRip.ui.VcMainFrame;
import it.f2.gestRip.ui.messages.Messages;
import it.f2.gestRip.util.VcJDBCTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.apache.log4j.Logger;

public class VcIfrAnaClienti
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private VcMainFrame parent = null;
    private VcJDBCTablePanel pnlTableAnaMarche = null;
    private Connection con = null;

    public VcIfrAnaClienti(VcMainFrame parent) {
        Logger.getRootLogger().debug((Object)"VcIfrAnaClienti constructor...");
        this.parent = parent;
        this.con = CommonMetodBin.getConn();
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setClosable(true);
        this.setTitle(Messages.getString("VcIfrAnaClienti.titleCustomers"));
        this.setContentPane(this.getJContentPane());
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                try {
                    Logger.getRootLogger().debug((Object)"Closing...");
                    VcIfrAnaClienti.this.close();
                }
                catch (Exception e1) {
                    Logger.getRootLogger().error((Object)("Exception in Closing \n" + e1 + "\n"));
                }
            }
        });
    }

    private void close() {
        CommonMetodBin.closeConn(this.con);
        if (this.checkCompleteUpdate()) {
            this.parent.closeTab(this);
        }
    }

    public boolean checkCompleteUpdate() {
        boolean result = false;
        if (this.getPnlTableAnaClienti().getModality() == VcJDBCTablePanel.mode.update) {
            int confirm = JOptionPane.showConfirmDialog(this.getParent(), Messages.getString("VcIfrAnaClienti.msgSave"), Messages.getString("VcIfrAnaClienti.msgTitleInfo"), 1);
            if (confirm == 0) {
                this.getPnlTableAnaClienti().commit();
                result = true;
            } else if (confirm == 1) {
                this.getPnlTableAnaClienti().rollback();
                result = true;
            } else if (confirm == 2) {
                result = false;
            }
        } else {
            result = true;
        }
        return result;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getPnlTableAnaClienti(), "Center");
        }
        return this.jContentPane;
    }

    private VcJDBCTablePanel getPnlTableAnaClienti() {
        if (this.pnlTableAnaMarche == null) {
            this.pnlTableAnaMarche = new VcJDBCTablePanel(this.con, QryUtil.QRY_ANA_CLIENTI, true){
                private static final long serialVersionUID = 1L;

                @Override
                protected void onDelete() {
                    boolean referenziato = false;
                    try {
                        Logger.getRootLogger().debug((Object)"Deleting...");
                        Statement smtp = VcIfrAnaClienti.this.con.createStatement();
                        String query = "select count(*) from schede where idCliente = " + this.getValueAt(this.currentRow(), 0);
                        ResultSet rs = smtp.executeQuery(query);
                        while (rs.next()) {
                            int fk = rs.getInt(1);
                            if (fk <= 0) continue;
                            referenziato = true;
                        }
                        rs.close();
                        smtp.close();
                        if (referenziato) {
                            JOptionPane.showMessageDialog(this.getParent(), Messages.getString("VcIfrAnaClienti.msgReferenced"), Messages.getString("VcIfrAnaClienti.msgTitleError"), 0);
                        } else {
                            this.deleteRow(this.currentRow());
                        }
                    }
                    catch (SQLException e) {
                        Logger.getRootLogger().error((Object)("Exception in Deleting \n" + e + "\n"));
                    }
                }
            };
            this.pnlTableAnaMarche.setColumnLabel(0, Messages.getString("VcIfrAnaClienti.qryId"));
            this.pnlTableAnaMarche.setColumnLabel(1, Messages.getString("VcIfrAnaClienti.qryNome"));
            this.pnlTableAnaMarche.setColumnLabel(2, Messages.getString("VcIfrAnaClienti.qryCognome"));
            this.pnlTableAnaMarche.setColumnLabel(3, Messages.getString("VcIfrAnaClienti.qryPiva"));
            this.pnlTableAnaMarche.setColumnLabel(4, Messages.getString("VcIfrAnaClienti.qryAzienda"));
            this.pnlTableAnaMarche.setColumnLabel(5, Messages.getString("VcIfrAnaClienti.qryPhone"));
            this.pnlTableAnaMarche.setColumnLabel(6, Messages.getString("VcIfrAnaClienti.qryMobilePhone"));
            this.pnlTableAnaMarche.setColumnLabel(7, Messages.getString("VcIfrAnaClienti.qryEmail"));
            this.pnlTableAnaMarche.setColumnLabel(8, Messages.getString("VcIfrAnaClienti.qryIndirizzo"));
            this.pnlTableAnaMarche.setColumnLabel(9, Messages.getString("VcIfrAnaClienti.qryCity"));
            this.pnlTableAnaMarche.createControlPanel();
        }
        return this.pnlTableAnaMarche;
    }
}

