/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip.ui.anagraf;

import it.f2.gestRip.control.CommonMetodBin;
import it.f2.gestRip.control.QryUtil;
import it.f2.gestRip.ui.VcMainFrame;
import it.f2.gestRip.ui.messages.Messages;
import it.f2.gestRip.util.VcJDBCTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.apache.log4j.Logger;

public class VcIfrAnaModelli
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private VcMainFrame parent = null;
    private VcJDBCTablePanel pnlTableAnaModelli = null;
    private Connection con = null;

    public VcIfrAnaModelli(VcMainFrame parent) {
        Logger.getRootLogger().debug((Object)"VcIfrAnaModelli constructor...");
        this.parent = parent;
        this.con = CommonMetodBin.getConn();
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setClosable(true);
        this.setTitle(Messages.getString("VcIfrAnaModelli.titleModels"));
        this.setContentPane(this.getJContentPane());
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                try {
                    Logger.getRootLogger().debug((Object)"Closing...");
                    VcIfrAnaModelli.this.close();
                }
                catch (Exception e1) {
                    Logger.getRootLogger().error((Object)("Exception in Set modality \n" + e1 + "\n"));
                }
            }
        });
    }

    private void close() {
        this.parent.closeTab(this);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getPnlTableAnaModelli(), "Center");
        }
        return this.jContentPane;
    }

    private VcJDBCTablePanel getPnlTableAnaModelli() {
        if (this.pnlTableAnaModelli == null) {
            this.pnlTableAnaModelli = new VcJDBCTablePanel(this.con, QryUtil.QRY_ANA_MODELLI, true){
                private static final long serialVersionUID = 1L;

                @Override
                protected void onDelete() {
                    Logger.getRootLogger().debug((Object)"Deleting...");
                    try {
                        Statement smtp = VcIfrAnaModelli.this.con.createStatement();
                        String query = "select count(*) from schede where idModello = " + this.getValueAt(this.currentRow(), 0);
                        ResultSet rs = smtp.executeQuery(query);
                        while (rs.next()) {
                            int fk = rs.getInt(1);
                            if (fk > 0) {
                                System.out.println(fk);
                                JOptionPane.showMessageDialog(this.getParent(), Messages.getString("VcIfrAnaModelli.msgReferenced"), Messages.getString("VcIfrAnaModelli.msgTitleError"), 0);
                                continue;
                            }
                            this.deleteRow(this.currentRow());
                        }
                        rs.close();
                        smtp.close();
                    }
                    catch (SQLException e) {
                        Logger.getRootLogger().error((Object)("Exception in Deleting \n" + e + "\n"));
                        e.printStackTrace();
                    }
                }
            };
            this.pnlTableAnaModelli.setColumnLabel(0, Messages.getString("VcIfrAnaModelli.qryId"));
            this.pnlTableAnaModelli.setColumnLabel(1, Messages.getString("VcIfrAnaModelli.qryName"));
            this.pnlTableAnaModelli.setColumnLabel(2, Messages.getString("VcIfrAnaModelli.qryDesc"));
            this.pnlTableAnaModelli.setColumnLabel(3, Messages.getString("VcIfrAnaModelli.qryIdMarchi"));
            this.pnlTableAnaModelli.setColumnLabel(4, Messages.getString("VcIfrAnaModelli.qryIdTipoApp"));
            this.pnlTableAnaModelli.setColumnLabel(5, Messages.getString("VcIfrAnaModelli.qryFlag"));
            this.pnlTableAnaModelli.createControlPanel();
            this.pnlTableAnaModelli.setCheckBoxColumn(5, "S", "N");
            String qryLovModelli = "select id,nome,descrizione from marchi where flagAttivo = 'S'";
            String qryRenderModelli = "select nome from marchi where id = ";
            this.pnlTableAnaModelli.setLovColumn(3, qryLovModelli, qryRenderModelli, "id", "nome", 50);
            String qryLovTipoApp = "select id,nome,descrizione from tipoapparecchiature where flagAttivo = 'S'";
            String qryRenderTipoApp = "select nome from tipoapparecchiature where id = ";
            this.pnlTableAnaModelli.setLovColumn(4, qryLovTipoApp, qryRenderTipoApp, "id", "nome", 50);
        }
        return this.pnlTableAnaModelli;
    }
}

