/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip.util;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class AutocompletingCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    JTextField editorComponent;
    String[] choices;
    String prefix;

    public AutocompletingCellEditor(String[] suggestions) {
        this.choices = suggestions;
        this.createUI();
    }

    private void createUI() {
        this.editorComponent = new JTextField();
        this.editorComponent.setBorder(null);
        this.editorComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\b') {
                    AutocompletingCellEditor.this.deleteSelection();
                } else {
                    AutocompletingCellEditor.this.suggest();
                }
            }
        });
    }

    private void deleteSelection() {
        int selectionStart = this.editorComponent.getSelectionStart();
        String text = this.editorComponent.getText();
        text = text.substring(0, selectionStart);
        this.editorComponent.setSelectionStart(0);
        this.editorComponent.setSelectionEnd(0);
        this.editorComponent.setText(text);
    }

    private void suggest() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutocompletingCellEditor.this.suggest(AutocompletingCellEditor.this.findSuggestion());
            }
        });
    }

    private String findSuggestion() {
        this.prefix = this.editorComponent.getText();
        int selectionStart = this.editorComponent.getSelectionStart();
        if (selectionStart != -1) {
            this.prefix = this.prefix.substring(0, selectionStart);
        }
        System.out.println("findSuggestion(): prefix=" + this.prefix);
        if (this.prefix.length() > 0) {
            String[] stringArray = this.choices;
            int n = this.choices.length;
            int n2 = 0;
            while (n2 < n) {
                String choice = stringArray[n2];
                if (choice.startsWith(this.prefix)) {
                    return choice;
                }
                ++n2;
            }
        }
        return "";
    }

    private void suggest(String suggestion) {
        System.out.println("suggest(): suggestion=" + suggestion);
        if (suggestion.length() > 0) {
            this.editorComponent.setText(suggestion);
            this.editorComponent.setSelectionStart(this.prefix.length());
            this.editorComponent.setSelectionEnd(suggestion.length());
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.editorComponent.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.editorComponent.setText((String)value);
        return this.editorComponent;
    }
}

