/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip.util;

import java.awt.Color;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;

public class CheckBoxCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    protected JCheckBox checkBox;
    private Object value;
    private Object chechedValue;
    private Object unchechedValue;

    public CheckBoxCellEditor() {
        new CheckBoxCellEditor(Boolean.TRUE, Boolean.FALSE);
    }

    public CheckBoxCellEditor(Object chechedValue, Object unchechedValue) {
        this.checkBox = new JCheckBox();
        this.checkBox.setHorizontalAlignment(0);
        this.checkBox.setBackground(Color.white);
        this.checkBox.setBorder(new LineBorder(Color.black, 2));
        this.chechedValue = chechedValue;
        this.unchechedValue = unchechedValue;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = value;
        if (value != null) {
            if (value.getClass() == Boolean.class) {
                this.checkBox.setSelected((Boolean)value);
            } else if (value.getClass() == String.class) {
                if (value.equals(this.chechedValue)) {
                    this.checkBox.setSelected(true);
                } else {
                    this.checkBox.setSelected(false);
                    value = this.unchechedValue;
                }
            } else if (value.getClass() == Integer.class || value.getClass() == Long.class || value.getClass() == Number.class) {
                if (value == this.chechedValue) {
                    this.checkBox.setSelected(true);
                } else {
                    this.checkBox.setSelected(false);
                    value = this.unchechedValue;
                }
            }
        } else {
            value = this.unchechedValue;
            this.checkBox.setSelected(false);
        }
        Component c = table.getDefaultRenderer(String.class).getTableCellRendererComponent(table, value, isSelected, false, row, column);
        if (c != null) {
            this.checkBox.setBackground(c.getBackground());
        }
        return this.checkBox;
    }

    @Override
    public Object getCellEditorValue() {
        this.value = this.checkBox.isSelected() ? this.chechedValue : this.unchechedValue;
        return this.value;
    }
}

