/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip.util;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class CheckBoxCellRenderer
extends JCheckBox
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected JCheckBox checkBox;
    private Object chechedValue;
    private Object unchechedValue;

    public CheckBoxCellRenderer(Color background) {
        new CheckBoxCellRenderer(background, Boolean.TRUE, Boolean.FALSE);
    }

    public CheckBoxCellRenderer(Color background, Object chechedValue, Object unchechedValue) {
        this.checkBox = new JCheckBox();
        this.checkBox.setHorizontalAlignment(0);
        this.checkBox.setBackground(background);
        this.chechedValue = chechedValue;
        this.unchechedValue = unchechedValue;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value != null) {
            if (value.getClass() == Boolean.class) {
                this.checkBox.setSelected((Boolean)value);
            } else if (value.getClass() == String.class) {
                if (value.equals(this.chechedValue)) {
                    this.checkBox.setSelected(true);
                } else {
                    this.checkBox.setSelected(false);
                    value = this.unchechedValue;
                }
            } else if (value.getClass() == Integer.class || value.getClass() == Long.class || value.getClass() == Number.class) {
                if (value == this.chechedValue) {
                    this.checkBox.setSelected(true);
                } else {
                    this.checkBox.setSelected(false);
                    value = this.unchechedValue;
                }
            }
        } else {
            value = this.unchechedValue;
            this.checkBox.setSelected(false);
        }
        Component c = table.getDefaultRenderer(String.class).getTableCellRendererComponent(table, value, isSelected, false, row, column);
        if (c != null) {
            this.checkBox.setBackground(c.getBackground());
        }
        return this.checkBox;
    }
}

