/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip.util;

import it.f2.gestRip.util.NamedParameterStatement;
import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class JDBCTableModel
extends AbstractTableModel {
    static final long serialVersionUID = 2487661888487685951L;
    private Connection con = null;
    private String query = null;
    private ResultSet set = null;
    private int size = 0;
    private boolean updateable = false;
    private Component parent = null;
    private NamedParameterStatement statement = null;
    private String[] updatableColumn = null;
    private ArrayList<Object[]> params = null;

    public JDBCTableModel(Connection con, String query, boolean updateable, String[] updatableColumn, ArrayList<Object[]> params) throws SQLException {
        this.con = con;
        this.query = query;
        this.updateable = updateable;
        this.updatableColumn = updatableColumn;
        this.params = params;
        this.refresh();
    }

    public ResultSet getResultSet() {
        return this.set;
    }

    public Statement getStatement() {
        return this.statement.getStatement();
    }

    public void refresh() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
        }
        if (this.set != null) {
            this.set.close();
        }
        this.size = 0;
        this.statement = new NamedParameterStatement(this.con, this.query, this.updateable);
        if (this.params != null) {
            for (Object[] param : this.params) {
                if (param[1] != null && param[1].getClass() == Date.class) {
                    param[1] = new java.sql.Date(((Date)param[1]).getTime());
                }
                this.statement.setObject((String)param[0], param[1]);
            }
        }
        this.set = this.statement.executeQuery();
        while (this.set.next()) {
            ++this.size;
        }
        this.set.beforeFirst();
        this.fireTableDataChanged();
    }

    public void setParameters(ArrayList<Object[]> params) {
        this.params = params;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean isEditable() {
        return this.updateable;
    }

    public void setEditable(boolean flag) {
        this.updateable = flag;
        this.fireTableDataChanged();
    }

    public void setParentComponent(Component parent) {
        this.parent = parent;
    }

    public Component getParentComponent() {
        return this.parent;
    }

    @Override
    public int getRowCount() {
        return this.updateable ? this.size + 1 : this.size;
    }

    @Override
    public int getColumnCount() {
        try {
            return this.set.getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row == this.size) {
            return null;
        }
        try {
            this.set.absolute(row + 1);
            return this.set.getObject(column + 1);
        }
        catch (SQLException e) {
            Logger.getRootLogger().error((Object)("Exception in getValueAt \n" + e + "\n"));
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getColumnName(int column) {
        try {
            return this.set.getMetaData().getColumnLabel(column + 1);
        }
        catch (SQLException ex) {
            Logger.getRootLogger().error((Object)("Exception in getColumnName \n" + ex + "\n"));
            return super.getColumnName(column);
        }
    }

    public String getColumnNameOrig(int column) {
        try {
            return this.set.getMetaData().getColumnName(column + 1);
        }
        catch (SQLException ex) {
            Logger.getRootLogger().error((Object)("Exception in getColumnNameOrig \n" + ex + "\n"));
            return super.getColumnName(column);
        }
    }

    public int getColumnPrecision(int column) {
        try {
            return this.set.getMetaData().getColumnDisplaySize(column + 1);
        }
        catch (SQLException ex) {
            Logger.getRootLogger().error((Object)("Exception in getColumnPrecision \n" + ex + "\n"));
            return 0;
        }
    }

    @Override
    public Class<?> getColumnClass(int column) {
        try {
            return Class.forName(this.set.getMetaData().getColumnClassName(column + 1));
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.updatableColumn == null) {
            return this.updateable;
        }
        String[] stringArray = this.updatableColumn;
        int n = this.updatableColumn.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.equalsIgnoreCase(this.getColumnName(column))) {
                return this.updateable;
            }
            if (element.equalsIgnoreCase(this.getColumnNameOrig(column))) {
                return this.updateable;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (this.updateable) {
            try {
                try {
                    if (row == this.size) {
                        this.set.moveToInsertRow();
                        this.set.updateObject(column + 1, value);
                        this.set.insertRow();
                        this.set.moveToCurrentRow();
                        ++this.size;
                        this.fireTableRowsInserted(row, row + 1);
                    } else {
                        this.set.absolute(row + 1);
                        this.set.updateObject(column + 1, value);
                        this.set.updateRow();
                        this.fireTableRowsUpdated(row, row + 1);
                    }
                }
                catch (SQLException ex) {
                    Logger.getRootLogger().error((Object)("Exception in setValueAt \n" + ex + "\n"));
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this.parent, ex.getMessage(), ex.getClass().getName(), 0, null);
                    try {
                        this.refresh();
                    }
                    catch (SQLException ex2) {
                        Logger.getRootLogger().error((Object)("Exception in setValueAt \n" + ex2 + "\n"));
                        throw new RuntimeException(ex2);
                    }
                }
                catch (Exception ex) {
                    Logger.getRootLogger().error((Object)("Exception in setValueAt \n" + ex + "\n"));
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this.parent, ex.getMessage(), ex.getClass().getName(), 0, null);
                    try {
                        this.refresh();
                    }
                    catch (SQLException ex3) {
                        Logger.getRootLogger().error((Object)("Exception in setValueAt \n" + ex3 + "\n"));
                        throw new RuntimeException(ex3);
                    }
                }
            }
            finally {
                try {
                    this.refresh();
                }
                catch (SQLException ex) {
                    Logger.getRootLogger().error((Object)("Exception in setValueAt \n" + ex + "\n"));
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public void deleteRow(int row) {
        try {
            try {
                this.set.absolute(row + 1);
                this.set.deleteRow();
            }
            catch (SQLException ex) {
                Logger.getRootLogger().error((Object)("Exception in deleteRow \n" + ex + "\n"));
                JOptionPane.showMessageDialog(this.parent, ex.getMessage(), ex.getClass().getName(), 0, null);
                try {
                    this.refresh();
                }
                catch (SQLException ex2) {
                    Logger.getRootLogger().error((Object)("Exception in deleteRow \n" + ex2 + "\n"));
                    throw new RuntimeException(ex2);
                }
            }
            catch (Exception ex) {
                Logger.getRootLogger().error((Object)("Exception in deleteRow \n" + ex + "\n"));
                JOptionPane.showMessageDialog(this.parent, ex.getMessage(), ex.getClass().getName(), 0, null);
                try {
                    this.refresh();
                }
                catch (SQLException ex3) {
                    Logger.getRootLogger().error((Object)("Exception in deleteRow \n" + ex3 + "\n"));
                    throw new RuntimeException(ex3);
                }
            }
        }
        finally {
            try {
                this.refresh();
            }
            catch (SQLException ex) {
                Logger.getRootLogger().error((Object)("Exception in deleteRow \n" + ex + "\n"));
                throw new RuntimeException(ex);
            }
        }
    }

    public void close() throws SQLException {
        this.statement.close();
        this.con.close();
    }

    protected void finalize() throws Exception {
        this.close();
    }
}

