/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip.util;

import it.f2.gestRip.util.NamedParameterStatement;
import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class JDBCTableModel_old
extends AbstractTableModel {
    static final long serialVersionUID = 2487661888487685951L;
    private Connection con = null;
    private String query = null;
    private ResultSet set = null;
    private int size = 0;
    private boolean updateable = false;
    private Component parent = null;
    private Statement statement = null;
    private String[] updatableColumn = null;

    public JDBCTableModel_old(Connection con, String query) throws SQLException {
        this(con, query, false, null);
    }

    public JDBCTableModel_old(Connection con, String query, boolean updateable) throws SQLException {
        this(con, query, updateable, null);
    }

    public JDBCTableModel_old(Connection con, String query, boolean updateable, String[] updatableColumn) throws SQLException {
        this.con = con;
        this.query = query;
        this.updateable = updateable;
        this.updatableColumn = updatableColumn;
        this.refresh();
    }

    public ResultSet getResultSet() {
        return this.set;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void refresh() throws SQLException {
        this.refresh(new ArrayList<Object[]>(), null);
    }

    public void refresh(ArrayList<Object[]> params, String queryParameter) throws SQLException {
        if (this.statement != null) {
            this.statement.close();
        }
        if (this.set != null) {
            this.set.close();
        }
        this.size = 0;
        NamedParameterStatement npStatement = new NamedParameterStatement(this.con, this.query, this.updateable);
        for (Object[] param : params) {
            if (param[1] != null && param[1].getClass() == Date.class) {
                param[1] = new java.sql.Date(((Date)param[1]).getTime());
            }
            npStatement.setObject((String)param[0], param[1]);
        }
        this.statement = npStatement.getStatement();
        this.set = npStatement.executeQuery();
        while (this.set.next()) {
            ++this.size;
        }
        this.set.beforeFirst();
        this.fireTableDataChanged();
    }

    public boolean isEditable() {
        return this.updateable;
    }

    public void setEditable(boolean flag) {
        this.updateable = flag;
        this.fireTableDataChanged();
    }

    public void setParentComponent(Component parent) {
        this.parent = parent;
    }

    public Component getParentComponent() {
        return this.parent;
    }

    @Override
    public int getRowCount() {
        return this.updateable ? this.size + 1 : this.size;
    }

    @Override
    public int getColumnCount() {
        try {
            return this.set.getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row == this.size) {
            return null;
        }
        try {
            this.set.absolute(row + 1);
            return this.set.getObject(column + 1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getColumnName(int column) {
        try {
            return this.set.getMetaData().getColumnLabel(column + 1);
        }
        catch (SQLException ex) {
            return super.getColumnName(column);
        }
    }

    public String getColumnNameOrig(int column) {
        try {
            return this.set.getMetaData().getColumnName(column + 1);
        }
        catch (SQLException ex) {
            return super.getColumnName(column);
        }
    }

    public int getColumnPrecision(int column) {
        try {
            return this.set.getMetaData().getColumnDisplaySize(column + 1);
        }
        catch (SQLException ex) {
            return 0;
        }
    }

    @Override
    public Class<?> getColumnClass(int column) {
        try {
            return Class.forName(this.set.getMetaData().getColumnClassName(column + 1));
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.updatableColumn == null) {
            return this.updateable;
        }
        int i = 0;
        while (i < this.updatableColumn.length) {
            if (this.updatableColumn[i].equalsIgnoreCase(this.getColumnName(column))) {
                return this.updateable;
            }
            if (this.updatableColumn[i].equalsIgnoreCase(this.getColumnNameOrig(column))) {
                return this.updateable;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (this.updateable) {
            try {
                try {
                    if (row == this.size) {
                        this.set.moveToInsertRow();
                        this.set.updateObject(column + 1, value);
                        this.set.insertRow();
                        this.set.moveToCurrentRow();
                        ++this.size;
                        this.fireTableRowsInserted(row, row + 1);
                    } else {
                        this.set.absolute(row + 1);
                        this.set.updateObject(column + 1, value);
                        this.set.updateRow();
                        this.fireTableRowsUpdated(row, row + 1);
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this.parent, ex.getMessage(), ex.getClass().getName(), 0, null);
                    try {
                        this.refresh();
                    }
                    catch (SQLException ex2) {
                        ex2.printStackTrace();
                        throw new RuntimeException(ex2);
                    }
                }
                catch (Exception ex) {
                    System.err.println("debug: " + value);
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this.parent, ex.getMessage(), ex.getClass().getName(), 0, null);
                    try {
                        this.refresh();
                    }
                    catch (SQLException ex3) {
                        ex3.printStackTrace();
                        throw new RuntimeException(ex3);
                    }
                }
            }
            finally {
                try {
                    this.refresh();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public void deleteRow(int row) {
        try {
            try {
                this.set.absolute(row + 1);
                this.set.deleteRow();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this.parent, ex.getMessage(), ex.getClass().getName(), 0, null);
                try {
                    this.refresh();
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                    throw new RuntimeException(ex2);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this.parent, ex.getMessage(), ex.getClass().getName(), 0, null);
                try {
                    this.refresh();
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                    throw new RuntimeException(ex3);
                }
            }
        }
        finally {
            try {
                this.refresh();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }
    }

    public void close() throws SQLException {
        this.statement.close();
        this.con.close();
    }

    protected void finalize() throws Exception {
        this.close();
    }
}

