/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip.util;

import it.f2.gestRip.util.LovChooser;
import it.f2.gestRip.util.VcJDBCTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class LovDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private VcJDBCTablePanel pnlQuery = null;
    private String query;
    private JPanel pnlControls = null;
    private JButton btnOk = null;
    private JButton btnCancel = null;
    private LovChooser lovChoser = null;
    private String colValue = null;
    private String colLabel = null;
    private Connection con = null;

    public LovDialog(Frame owner, LovChooser lovChoser, String query, String colValue, String colLabel, Connection con) {
        super(owner, true);
        this.query = query;
        this.lovChoser = lovChoser;
        this.colValue = colValue;
        this.colLabel = colLabel;
        this.con = con;
        this.initialize();
    }

    private void initialize() {
        this.setSize(400, 300);
        this.setTitle("LOV...");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getPnlQuery(), "Center");
            this.jContentPane.add((Component)this.getPnlControls(), "South");
        }
        return this.jContentPane;
    }

    private VcJDBCTablePanel getPnlQuery() {
        if (this.pnlQuery == null) {
            this.pnlQuery = new VcJDBCTablePanel(this.con, this.query, false);
            this.pnlQuery.createControlPanel();
        }
        return this.pnlQuery;
    }

    private JPanel getPnlControls() {
        if (this.pnlControls == null) {
            this.pnlControls = new JPanel();
            this.pnlControls.setLayout(new GridBagLayout());
            this.pnlControls.add((Component)this.getBtnOk(), new GridBagConstraints());
            this.pnlControls.add((Component)this.getBtnCancel(), new GridBagConstraints());
        }
        return this.pnlControls;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setText("Ok");
            this.btnOk.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/button_ok.png")));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int iColValue = LovDialog.this.getPnlQuery().getIdxFromColName(LovDialog.this.colValue);
                    int iColLabel = LovDialog.this.getPnlQuery().getIdxFromColName(LovDialog.this.colLabel);
                    Object value = LovDialog.this.getPnlQuery().getValueAt(LovDialog.this.getPnlQuery().currentRow(), iColValue);
                    Object label = LovDialog.this.getPnlQuery().getValueAt(LovDialog.this.getPnlQuery().currentRow(), iColLabel);
                    LovDialog.this.lovChoser.setResults(value, label);
                    LovDialog.this.setVisible(false);
                }
            });
        }
        return this.btnOk;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText("Cancel");
            this.btnCancel.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/button_cancel.png")));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LovDialog.this.setVisible(false);
                }
            });
        }
        return this.btnCancel;
    }
}

