/*
 * Decompiled with CFR 0.152.
 */
package it.f2.gestRip.util;

import com.toedter.calendar.JDateChooserCellEditor;
import it.f2.gestRip.util.CheckBoxCellEditor;
import it.f2.gestRip.util.CheckBoxCellRenderer;
import it.f2.gestRip.util.JDBCTableModel;
import it.f2.gestRip.util.LovCellEditor;
import it.f2.gestRip.util.LovCellRenderer;
import it.f2.gestRip.util.LovResultsBin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.apache.log4j.Logger;

public class VcJDBCTablePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane scpJDBCTable = null;
    private JTable tblJDBCTable = null;
    private JPanel pnlContols = null;
    private JLabel lblRec = null;
    private JButton btnPageUp = null;
    private JButton btnRecUp = null;
    private JFormattedTextField txfRecNum = null;
    private JButton btnRecDown = null;
    private JButton btnPageDown = null;
    private JButton btnRefresh = null;
    private JDBCTableModel jtmJDBCTm = null;
    private JButton btnEdit = null;
    private JLabel lblPageNum = null;
    private JToolBar tlbEditTable = null;
    private JButton btnOk = null;
    private JButton btnDelete = null;
    private JButton btnRollback = null;
    private Connection con;
    private String query;
    private boolean updatable;
    private String[] updatableColumn;
    private mode modality = null;
    private ArrayList<Object[]> params;

    public VcJDBCTablePanel(Connection con, String query, boolean updatable, String[] updatableColumn, ArrayList<Object[]> params) {
        this.con = con;
        this.query = query;
        this.updatable = updatable;
        this.updatableColumn = updatableColumn;
        this.params = params;
        this.modality = mode.view;
        this.initialize();
    }

    public VcJDBCTablePanel(Connection con, String query, boolean updatable) {
        this(con, query, updatable, null, null);
    }

    public VcJDBCTablePanel(Connection con, String query) {
        this(con, query, false, null, null);
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getScpJDBCTable(), "Center");
        this.add((Component)this.getPnlContols(), "South");
        this.add((Component)this.getTlbEditTable(), "West");
    }

    public void createControlPanel() {
        this.getPnlContols().setVisible(true);
    }

    private JScrollPane getScpJDBCTable() {
        if (this.scpJDBCTable == null) {
            this.scpJDBCTable = new JScrollPane();
            this.scpJDBCTable.setViewportView(this.getTblJDBCTable());
            this.scpJDBCTable.setSize(10, 10);
        }
        return this.scpJDBCTable;
    }

    private JDBCTableModel getJtmJDBCTm() {
        if (this.jtmJDBCTm == null) {
            try {
                Logger.getRootLogger().debug((Object)"Calling JDBCTableModel...");
                this.jtmJDBCTm = new JDBCTableModel(this.con, this.query, false, this.updatableColumn, this.params);
            }
            catch (SQLException e) {
                Logger.getRootLogger().error((Object)("Exception in Calling JDBCTableModel \n" + e + "\n"));
            }
        }
        return this.jtmJDBCTm;
    }

    public void setCheckBoxColumn(int col, String checkValue, String uncheckValue) {
        this.getTblJDBCTable().getColumnModel().getColumn(col).setCellRenderer(new CheckBoxCellRenderer(this.getTblJDBCTable().getBackground(), checkValue, uncheckValue));
        this.getTblJDBCTable().getColumnModel().getColumn(col).setCellEditor(new CheckBoxCellEditor(checkValue, uncheckValue));
        this.getTblJDBCTable().revalidate();
    }

    public void setLovColumn(int col, String queryLov, String queryRender, String colValue, String colLabel, int colPrecision) {
        LovResultsBin lrb = new LovResultsBin();
        this.getTblJDBCTable().getColumnModel().getColumn(col).setCellRenderer(new LovCellRenderer(this.getTblJDBCTable().getBackground(), lrb, queryRender, colValue, this.con));
        this.getTblJDBCTable().getColumnModel().getColumn(col).setCellEditor(new LovCellEditor(lrb, queryLov, colValue, colLabel, this.con));
        TableColumn tblCol = this.getTblJDBCTable().getColumnModel().getColumn(col);
        tblCol.setWidth(colPrecision);
        tblCol.setPreferredWidth(colPrecision);
        this.getTblJDBCTable().revalidate();
    }

    public void setColPrecision(int col, int colPrecision) {
        TableColumn tblCol = this.getTblJDBCTable().getColumnModel().getColumn(col);
        tblCol.setWidth(colPrecision);
        tblCol.setPreferredWidth(colPrecision);
    }

    public void setTableHeaderHeight(int height) {
        Dimension d = new Dimension(this.getTblJDBCTable().getTableHeader().getWidth(), height);
        this.getTblJDBCTable().getTableHeader().setSize(d);
        this.getTblJDBCTable().getTableHeader().setPreferredSize(d);
        if (height == 0) {
            this.getTblJDBCTable().getTableHeader().setVisible(false);
        }
    }

    public int getIdxFromColName(String colName) {
        int result = 0;
        int i = 0;
        while (i < this.getJtmJDBCTm().getColumnCount()) {
            TableColumn tblCol = this.getTblJDBCTable().getColumnModel().getColumn(i);
            if (((String)tblCol.getHeaderValue()).equalsIgnoreCase(colName)) {
                result = i;
                return i;
            }
            ++i;
        }
        return result;
    }

    public void setColumnLabel(int column, String value) {
        try {
            TableColumn tblCol = this.tblJDBCTable.getColumnModel().getColumn(column);
            tblCol.setHeaderValue(value);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Logger.getRootLogger().debug((Object)"Non valid column header...");
        }
    }

    private JTable getTblJDBCTable() {
        if (this.tblJDBCTable == null) {
            this.tblJDBCTable = new JTable(this.getJtmJDBCTm());
            this.tblJDBCTable.setRowSorter(new TableRowSorter<JDBCTableModel>(this.getJtmJDBCTm()));
            this.tblJDBCTable.setSelectionMode(0);
            this.tblJDBCTable.setRowHeight(25);
            int i = 0;
            while (i < this.getJtmJDBCTm().getColumnCount()) {
                int colPrecision = this.getJtmJDBCTm().getColumnPrecision(i);
                TableColumn tblCol = this.tblJDBCTable.getColumnModel().getColumn(i);
                Class<?> colClass = this.getJtmJDBCTm().getColumnClass(i);
                tblCol.setWidth(colPrecision);
                tblCol.setPreferredWidth(colPrecision);
                if (colClass.equals(Date.class) || colClass.equals(java.util.Date.class)) {
                    tblCol.setCellEditor((TableCellEditor)new JDateChooserCellEditor());
                }
                ++i;
            }
            this.tblJDBCTable.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    Point p = e.getPoint();
                    int hitColumnIndex = VcJDBCTablePanel.this.tblJDBCTable.columnAtPoint(p);
                    int hitRowIndex = VcJDBCTablePanel.this.tblJDBCTable.rowAtPoint(p);
                    if (hitColumnIndex != -1 && hitRowIndex != -1) {
                        Object obj = VcJDBCTablePanel.this.getJtmJDBCTm().getValueAt(VcJDBCTablePanel.this.tblJDBCTable.convertRowIndexToModel(hitRowIndex), VcJDBCTablePanel.this.tblJDBCTable.convertColumnIndexToModel(hitColumnIndex));
                        String tip = null;
                        if (obj != null) {
                            tip = obj.toString();
                        }
                        VcJDBCTablePanel.this.tblJDBCTable.setToolTipText(tip);
                    }
                }
            });
            this.tblJDBCTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent arg0) {
                    VcJDBCTablePanel.this.getTxfRecNum().setText("" + (VcJDBCTablePanel.this.getTblJDBCTable().getSelectedRow() + 1));
                }
            });
            this.getTblJDBCTable().getSelectionModel().setSelectionInterval(0, 0);
        }
        return this.tblJDBCTable;
    }

    private JPanel getPnlContols() {
        if (this.pnlContols == null) {
            this.lblPageNum = new JLabel();
            this.lblRec = new JLabel();
            this.lblRec.setText("Record: ");
            this.pnlContols = new JPanel();
            this.pnlContols.setVisible(false);
            this.pnlContols.setLayout(new FlowLayout());
            this.pnlContols.add((Component)this.lblRec, null);
            this.pnlContols.add((Component)this.getBtnPageUp(), null);
            this.pnlContols.add((Component)this.getBtnRecUp(), null);
            this.pnlContols.add((Component)this.getTxfRecNum(), null);
            this.pnlContols.add((Component)this.getBtnRecDown(), null);
            this.pnlContols.add((Component)this.getBtnPageDown(), null);
            this.pnlContols.add((Component)this.lblPageNum, null);
            this.pnlContols.add((Component)this.getBtnRefresh(), null);
            this.lblPageNum.setText("of " + this.getJtmJDBCTm().getRowCount());
        }
        return this.pnlContols;
    }

    private JButton getBtnPageUp() {
        if (this.btnPageUp == null) {
            this.btnPageUp = new JButton();
            this.btnPageUp.setToolTipText("First Record");
            this.btnPageUp.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/2leftarrow.png")));
            this.btnPageUp.setMargin(new Insets(2, 2, 2, 3));
            this.btnPageUp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcJDBCTablePanel.this.getTblJDBCTable().getSelectionModel().setSelectionInterval(0, 0);
                }
            });
        }
        return this.btnPageUp;
    }

    private JButton getBtnRecUp() {
        if (this.btnRecUp == null) {
            this.btnRecUp = new JButton();
            this.btnRecUp.setToolTipText("Previous Record");
            this.btnRecUp.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/previous.png")));
            this.btnRecUp.setMargin(new Insets(2, 2, 2, 3));
            this.btnRecUp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selRow = VcJDBCTablePanel.this.getTblJDBCTable().getSelectedRow();
                    if (selRow != -1 && selRow > 0) {
                        VcJDBCTablePanel.this.getTblJDBCTable().getSelectionModel().setSelectionInterval(selRow - 1, selRow - 1);
                    }
                }
            });
        }
        return this.btnRecUp;
    }

    private JFormattedTextField getTxfRecNum() {
        if (this.txfRecNum == null) {
            this.txfRecNum = new JFormattedTextField(NumberFormat.getIntegerInstance());
            this.txfRecNum.setHorizontalAlignment(4);
            this.txfRecNum.setPreferredSize(new Dimension(50, 20));
            this.txfRecNum.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rowCount = VcJDBCTablePanel.this.getTblJDBCTable().getModel().getRowCount();
                    int goTo = Integer.parseInt(VcJDBCTablePanel.this.getTxfRecNum().getText());
                    if (goTo > 0 && goTo < rowCount) {
                        VcJDBCTablePanel.this.getTblJDBCTable().getSelectionModel().setSelectionInterval(goTo - 1, goTo - 1);
                    } else if (goTo <= 0) {
                        VcJDBCTablePanel.this.getTblJDBCTable().getSelectionModel().setSelectionInterval(0, 0);
                    } else if (goTo > rowCount - 1) {
                        VcJDBCTablePanel.this.getTblJDBCTable().getSelectionModel().setSelectionInterval(rowCount - 1, rowCount - 1);
                    }
                }
            });
        }
        return this.txfRecNum;
    }

    private JButton getBtnRecDown() {
        if (this.btnRecDown == null) {
            this.btnRecDown = new JButton();
            this.btnRecDown.setToolTipText("Next Record");
            this.btnRecDown.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/next.png")));
            this.btnRecDown.setMargin(new Insets(2, 2, 2, 3));
            this.btnRecDown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selRow = VcJDBCTablePanel.this.getTblJDBCTable().getSelectedRow();
                    int rowCount = VcJDBCTablePanel.this.getTblJDBCTable().getModel().getRowCount();
                    if (selRow != -1 && selRow < rowCount - 1) {
                        VcJDBCTablePanel.this.getTblJDBCTable().getSelectionModel().setSelectionInterval(selRow + 1, selRow + 1);
                    }
                }
            });
        }
        return this.btnRecDown;
    }

    private JButton getBtnPageDown() {
        if (this.btnPageDown == null) {
            this.btnPageDown = new JButton();
            this.btnPageDown.setToolTipText("Last Record");
            this.btnPageDown.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/2rightarrow.png")));
            this.btnPageDown.setMargin(new Insets(2, 2, 2, 3));
            this.btnPageDown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rowCount = VcJDBCTablePanel.this.getTblJDBCTable().getModel().getRowCount();
                    VcJDBCTablePanel.this.getTblJDBCTable().getSelectionModel().setSelectionInterval(rowCount - 1, rowCount - 1);
                }
            });
        }
        return this.btnPageDown;
    }

    private JButton getBtnRefresh() {
        if (this.btnRefresh == null) {
            this.btnRefresh = new JButton();
            this.btnRefresh.setToolTipText("Refresh");
            this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/rebuild.png")));
            this.btnRefresh.setMargin(new Insets(2, 2, 2, 3));
            this.btnRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcJDBCTablePanel.this.refresh();
                }
            });
        }
        return this.btnRefresh;
    }

    public void refresh() {
        try {
            Logger.getRootLogger().debug((Object)"refreshing...");
            int selRow = this.currentRow();
            this.getJtmJDBCTm().refresh();
            this.getTblJDBCTable().getSelectionModel().setSelectionInterval(selRow, selRow);
        }
        catch (Exception e1) {
            Logger.getRootLogger().error((Object)("Exception in Srefreshing \n" + e1 + "\n"));
        }
    }

    public void setParameters(ArrayList<Object[]> params) {
        this.params = params;
        this.getJtmJDBCTm().setParameters(params);
    }

    public void setQuery(String query) {
        this.query = query;
        this.getJtmJDBCTm().setQuery(query);
    }

    private JButton getBtnEdit() {
        if (this.btnEdit == null) {
            this.btnEdit = new JButton();
            this.btnEdit.setToolTipText("Edit");
            this.btnEdit.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/edit.png")));
            this.btnEdit.setMargin(new Insets(2, 2, 2, 3));
            if (!this.updatable) {
                this.btnEdit.setEnabled(false);
            }
            this.btnEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcJDBCTablePanel.this.modality = mode.update;
                    int selRow = VcJDBCTablePanel.this.getTblJDBCTable().getSelectedRow();
                    VcJDBCTablePanel.this.getJtmJDBCTm().setEditable(true);
                    VcJDBCTablePanel.this.btnEdit.setEnabled(false);
                    VcJDBCTablePanel.this.getBtnOk().setEnabled(true);
                    VcJDBCTablePanel.this.getBtnDelete().setEnabled(true);
                    VcJDBCTablePanel.this.getBtnRollback().setEnabled(true);
                    try {
                        Logger.getRootLogger().debug((Object)"Editing...");
                        VcJDBCTablePanel.this.getJtmJDBCTm().refresh();
                    }
                    catch (SQLException e1) {
                        Logger.getRootLogger().error((Object)("Exception in Editing \n" + e + "\n"));
                    }
                    VcJDBCTablePanel.this.getTblJDBCTable().getSelectionModel().setSelectionInterval(selRow, selRow);
                }
            });
        }
        return this.btnEdit;
    }

    private JToolBar getTlbEditTable() {
        if (this.tlbEditTable == null) {
            this.tlbEditTable = new JToolBar();
            this.tlbEditTable.setVisible(this.updatable);
            this.tlbEditTable.setOrientation(1);
            this.tlbEditTable.add(this.getBtnEdit());
            this.tlbEditTable.add(this.getBtnDelete());
            this.tlbEditTable.add(this.getBtnOk());
            this.tlbEditTable.add(this.getBtnRollback());
        }
        return this.tlbEditTable;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setEnabled(false);
            this.btnOk.setToolTipText("Save");
            this.btnOk.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/filesave.png")));
            this.btnOk.setMargin(new Insets(2, 2, 2, 3));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcJDBCTablePanel.this.commit();
                }
            });
        }
        return this.btnOk;
    }

    public void commit() {
        if (this.modality == mode.update) {
            int selRow = this.getTblJDBCTable().getSelectedRow();
            try {
                this.getTblJDBCTable().getCellEditor().stopCellEditing();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.getJtmJDBCTm().setEditable(false);
            this.getBtnEdit().setEnabled(true);
            this.getBtnRollback().setEnabled(false);
            this.btnOk.setEnabled(false);
            this.getBtnDelete().setEnabled(false);
            this.getBtnRollback().setEnabled(false);
            try {
                Logger.getRootLogger().debug((Object)"Committing...");
                this.con.commit();
                this.getJtmJDBCTm().refresh();
            }
            catch (SQLException e1) {
                Logger.getRootLogger().error((Object)("Exception in Committing \n" + e1 + "\n"));
            }
            this.getTblJDBCTable().getSelectionModel().setSelectionInterval(selRow, selRow);
            this.modality = mode.view;
        }
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton();
            this.btnDelete.setToolTipText("Delete Row");
            this.btnDelete.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/delete_table_row.png")));
            this.btnDelete.setMargin(new Insets(2, 2, 2, 3));
            this.btnDelete.setEnabled(false);
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcJDBCTablePanel.this.onDelete();
                }
            });
        }
        return this.btnDelete;
    }

    protected void onDelete() {
        this.deleteRow(this.currentRow());
    }

    public void deleteRow(int rowToDelete) {
        this.getJtmJDBCTm().deleteRow(rowToDelete);
        try {
            Logger.getRootLogger().debug((Object)"Deleting...");
            this.getJtmJDBCTm().refresh();
        }
        catch (SQLException e) {
            Logger.getRootLogger().error((Object)("Exception in Deleting \n" + e + "\n"));
        }
        this.getTblJDBCTable().getSelectionModel().setSelectionInterval(rowToDelete, rowToDelete);
    }

    public int currentRow() {
        return this.getTblJDBCTable().getSelectedRow();
    }

    public Object getValueAt(int row, int col) {
        return this.getTblJDBCTable().getValueAt(row, col);
    }

    private JButton getBtnRollback() {
        if (this.btnRollback == null) {
            this.btnRollback = new JButton();
            this.btnRollback.setToolTipText("Save");
            this.btnRollback.setIcon(new ImageIcon(this.getClass().getResource("/it/f2/gestRip/ui/img/undo.png")));
            this.btnRollback.setMargin(new Insets(2, 2, 2, 3));
            this.btnRollback.setEnabled(false);
            this.btnRollback.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcJDBCTablePanel.this.rollback();
                }
            });
        }
        return this.btnRollback;
    }

    public void rollback() {
        if (this.modality == mode.update) {
            int selRow = this.getTblJDBCTable().getSelectedRow();
            try {
                this.getTblJDBCTable().getCellEditor().stopCellEditing();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.getJtmJDBCTm().setEditable(false);
            this.getBtnEdit().setEnabled(true);
            this.getBtnOk().setEnabled(false);
            this.getBtnDelete().setEnabled(false);
            this.getBtnRollback().setEnabled(false);
            try {
                Logger.getRootLogger().debug((Object)"Rolbacking...");
                this.con.rollback();
                this.getJtmJDBCTm().refresh();
            }
            catch (SQLException e1) {
                Logger.getRootLogger().error((Object)("Exception in Rolbacking \n" + e1 + "\n"));
            }
            this.getTblJDBCTable().getSelectionModel().setSelectionInterval(selRow, selRow);
        }
        this.modality = mode.view;
    }

    public mode getModality() {
        return this.modality;
    }

    public static enum mode {
        update,
        view;

    }
}

