/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.displayejs;

import java.awt.Color;
import org.colos.ejs.library.control.displayejs.ControlInteractiveElement;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveCursor;

public class ControlCursor
extends ControlInteractiveElement {
    private static final int CURSOR_ADDED = 0;
    private static final int MY_STYLE = 14;
    private static final int MY_SECONDARY_COLOR = 19;

    public ControlCursor() {
        this.enabledEjsEdit = true;
    }

    protected Drawable createDrawable() {
        InteractiveCursor interactiveCursor = new InteractiveCursor();
        interactiveCursor.setEnabled(0, true);
        return interactiveCursor;
    }

    protected int getPropertiesDisplacement() {
        return 0;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("style")) {
            return "CursorShape|int";
        }
        return super.getPropertyInfo(string);
    }

    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("CursorShape") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("crosshair")) {
                return new IntegerValue(2);
            }
            if (string2.equals("horizontal")) {
                return new IntegerValue(0);
            }
            if (string2.equals("vertical")) {
                return new IntegerValue(1);
            }
        }
        return super.parseConstant(string, string2);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 14: {
                ((InteractiveCursor)this.myElement).setType(value.getInteger());
                break;
            }
            case 19: {
                if (value instanceof IntegerValue) {
                    this.myElement.getStyle().setEdgeColor(DisplayColors.getLineColor(value.getInteger()));
                    break;
                }
                this.myElement.getStyle().setEdgeColor((Color)value.getObject());
                break;
            }
            default: {
                super.setValue(n - 0, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 14: {
                ((InteractiveCursor)this.myElement).setType(2);
                break;
            }
            case 19: {
                this.myElement.getStyle().setEdgeColor(Color.black);
                break;
            }
            default: {
                super.setDefaultValue(n - 0);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 14: {
                return "CROSSHAIR";
            }
            case 19: {
                return "BLACK";
            }
        }
        return super.getDefaultValueString(n - 0);
    }

    public Value getValue(int n) {
        return super.getValue(n - 0);
    }
}

