/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AbstractAxes;
import org.opensourcephysics.display.axes.CartesianAxes;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display.axes.YAxis;

public class CartesianType2
extends AbstractAxes
implements CartesianAxes {
    XAxis xaxis;
    YAxis yaxis;
    boolean xlog = false;
    boolean ylog = false;

    public CartesianType2(PlottingPanel plottingPanel) {
        super(plottingPanel);
        this.defaultLeftGutter = 50;
        this.defaultTopGutter = 25;
        this.defaultRightGutter = 25;
        this.defaultBottomGutter = 50;
        this.titleLine.setJustification(0);
        this.titleLine.setFont(this.titleFont);
        this.xaxis = new XAxis();
        this.yaxis = new YAxis();
        this.xaxis.setLocationType(1);
        this.yaxis.setLocationType(1);
        if (plottingPanel == null) {
            return;
        }
        plottingPanel.setPreferredGutters(this.defaultLeftGutter, this.defaultTopGutter, this.defaultRightGutter, this.defaultBottomGutter);
        plottingPanel.setCoordinateStringBuilder(CoordinateStringBuilder.createCartesian());
        plottingPanel.setAxes(this);
    }

    public void setXLabel(String string, String string2) {
        this.xaxis.setTitle(string, string2);
    }

    public void setYLabel(String string, String string2) {
        this.yaxis.setTitle(string, string2);
    }

    public String getXLabel() {
        return this.xaxis.axisLabel.getText();
    }

    public String getYLabel() {
        return this.yaxis.axisLabel.getText();
    }

    public String getTitle() {
        return this.titleLine.getText();
    }

    public void setTitle(String string, String string2) {
        this.titleLine.setText(string);
        if (string2 == null || string2.equals("")) {
            return;
        }
        this.titleLine.setFont(Font.decode(string2));
    }

    public void setXLog(boolean bl) {
        this.xlog = bl;
        if (bl) {
            this.xaxis.setAxisType(1);
        } else {
            this.xaxis.setAxisType(0);
        }
    }

    public void setYLog(boolean bl) {
        this.ylog = bl;
        if (bl) {
            this.yaxis.setAxisType(1);
        } else {
            this.yaxis.setAxisType(0);
        }
    }

    public boolean isXLog() {
        return this.xlog;
    }

    public boolean isYLog() {
        return this.ylog;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.interiorColor != null) {
            graphics.setColor(this.interiorColor);
            int n = drawingPanel.getLeftGutter() + drawingPanel.getRightGutter();
            int n2 = drawingPanel.getTopGutter() + drawingPanel.getBottomGutter();
            graphics.fillRect(drawingPanel.getLeftGutter(), drawingPanel.getTopGutter(), drawingPanel.getWidth() - n, drawingPanel.getHeight() - n2);
            graphics.setColor(Color.lightGray);
            graphics.drawRect(drawingPanel.getLeftGutter(), drawingPanel.getTopGutter(), drawingPanel.getWidth() - n - 1, drawingPanel.getHeight() - n2 - 1);
        }
        this.xaxis.draw(drawingPanel, graphics);
        this.yaxis.draw(drawingPanel, graphics);
        this.titleLine.setX((drawingPanel.getXMax() + drawingPanel.getXMin()) / 2.0);
        if (drawingPanel.getTopGutter() > 20) {
            this.titleLine.setY(drawingPanel.getYMax() + 5.0 / drawingPanel.getYPixPerUnit());
        } else {
            this.titleLine.setY(drawingPanel.getYMax() - 25.0 / drawingPanel.getYPixPerUnit());
        }
        this.titleLine.setColor(drawingPanel.getForeground());
        this.titleLine.draw(drawingPanel, graphics);
    }

    public void setInteriorBackground(Color color) {
        this.interiorColor = color;
    }

    public void setShowMajorXGrid(boolean bl) {
        this.xaxis.setShowMajorGrid(bl);
        if (!bl) {
            this.setShowMinorXGrid(bl);
        }
    }

    public void setShowMinorXGrid(boolean bl) {
    }

    public void setShowMajorYGrid(boolean bl) {
        this.yaxis.setShowMajorGrid(bl);
        if (!bl) {
            this.setShowMinorYGrid(bl);
        }
    }

    public void setShowMinorYGrid(boolean bl) {
    }

    public void setX(double d) {
    }

    public void setY(double d) {
    }

    public double getX() {
        return 0.0;
    }

    public double getY() {
        return 0.0;
    }
}

