/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoRecorder;
import org.opensourcephysics.media.core.VideoType;

public abstract class ScratchVideoRecorder
implements VideoRecorder {
    protected static JFileChooser chooser;
    protected static JTextComponent chooserField;
    protected static String ext;
    protected static boolean ignoreChooser;
    protected static String tempDirectory;
    protected static String tempFilePrefix;
    protected VideoType videoType;
    protected Dimension dim;
    protected Image frameImage;
    protected double frameDuration = 100.0;
    protected int frameCount;
    protected String scratchName;
    protected int scratchNumber = 0;
    protected File scratchFile;
    protected boolean canRecord;
    protected boolean hasContent;
    protected boolean isSaved;
    protected File saveFile = null;
    protected boolean saveChanges = false;
    protected String tempFileBasePath;
    protected String tempFileType = "png";
    protected ArrayList<File> tempFiles = new ArrayList();
    protected String suggestedFileName;

    static {
        tempFilePrefix = "osp_";
        tempDirectory = System.getProperty("java.io.tmpdir");
    }

    public ScratchVideoRecorder(VideoType videoType) {
        this.videoType = videoType;
        ext = this.videoType.getDefaultExtension();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ssSSS");
        this.scratchName = String.valueOf(tempFilePrefix) + simpleDateFormat.format(new Date());
        ShutdownHook shutdownHook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        try {
            this.createScratch();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (chooser == null) {
            chooser = new JFileChooser(new File(OSPRuntime.chooserDir));
            chooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    VideoFileFilter videoFileFilter;
                    String string;
                    FileFilter fileFilter;
                    if (!ignoreChooser && (fileFilter = (FileFilter)propertyChangeEvent.getNewValue()) instanceof VideoFileFilter && (string = (videoFileFilter = (VideoFileFilter)fileFilter).getDefaultExtension()) != null) {
                        ScratchVideoRecorder.setChooserExtension(string);
                    }
                }
            });
            String string = "untitled.tmp";
            chooser.setSelectedFile(new File(string));
            chooserField = this.getTextComponent(chooser, string);
        }
    }

    public void createVideo() throws IOException {
        if (this.scratchFile == null) {
            this.createScratch();
            if (this.scratchFile == null) {
                OSPLog.severe("No scratch file");
                return;
            }
        }
        if (this.scratchFile != null && this.hasContent) {
            String string;
            int n;
            if (this.saveChanges && !this.isSaved && (n = JOptionPane.showConfirmDialog(null, string = MediaRes.getString("ScratchVideoRecorder.Dialog.SaveVideo.Message"), MediaRes.getString("ScratchVideoRecorder.Dialog.SaveVideo.Title"), 0)) == 0) {
                this.saveVideo();
            }
            this.createScratch();
            this.saveFile = null;
            this.dim = null;
        }
    }

    public void createVideo(String string) throws IOException {
        File file = null;
        if (string == null) {
            file = this.selectFile();
            if (file == null) {
                return;
            }
        } else {
            file = new File(string);
        }
        this.createVideo();
        this.saveFile = file;
    }

    public void setSize(Dimension dimension) {
        this.dim = dimension;
    }

    public void setFrameDuration(double d) {
        this.frameDuration = d;
    }

    public void addFrame(Image image) throws IOException {
        if (image == null) {
            return;
        }
        this.frameImage = image;
        if (this.scratchFile == null || this.hasContent && this.isSaved) {
            this.createVideo();
        }
        if (this.scratchFile == null) {
            return;
        }
        if (!this.canRecord) {
            this.canRecord = this.startRecording();
            this.isSaved = false;
            this.hasContent = false;
        }
        if (this.canRecord && this.append(image)) {
            this.hasContent = true;
            ++this.frameCount;
        }
    }

    public Video getVideo() throws IOException {
        if (this.isSaved && this.saveFile != null) {
            return this.videoType.getVideo(this.saveFile.getAbsolutePath());
        }
        this.saveScratch();
        return this.videoType.getVideo(this.scratchFile.getAbsolutePath());
    }

    public String saveVideo() throws IOException {
        if (this.saveFile != null) {
            return this.saveVideo(this.saveFile.getAbsolutePath());
        }
        return this.saveVideoAs();
    }

    public String saveVideo(String string) throws IOException {
        if (this.scratchFile == null) {
            return null;
        }
        if (string == null) {
            return this.saveVideoAs();
        }
        this.setFileName(string);
        if (this.saveFile == null) {
            throw new IOException("could not write to read-only file");
        }
        this.saveScratch();
        int n = 8192;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        FileInputStream fileInputStream = new FileInputStream(this.scratchFile);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        FileOutputStream fileOutputStream = new FileOutputStream(this.saveFile);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        while ((n2 = ((InputStream)bufferedInputStream).read(byArray, 0, n)) != -1) {
            ((OutputStream)bufferedOutputStream).write(byArray, 0, n2);
            n3 += n2;
        }
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
        ((InputStream)bufferedInputStream).close();
        this.isSaved = true;
        OSPLog.fine("copied " + n3 + " bytes from " + this.scratchFile.getName() + " to " + this.saveFile.getAbsolutePath());
        this.scratchFile.delete();
        return this.saveFile.getAbsolutePath();
    }

    public String saveVideoAs() throws IOException {
        File file = this.selectFile();
        if (file != null) {
            return this.saveVideo(file.getAbsolutePath());
        }
        return null;
    }

    public String getFileName() {
        return this.saveFile == null ? null : this.saveFile.getAbsolutePath();
    }

    public void setFileName(String string) {
        if (this.saveFile != null && this.saveFile.getAbsolutePath().equals(string)) {
            return;
        }
        File file = new File(string);
        this.saveFile = file.exists() && !file.canWrite() ? null : file;
    }

    public void suggestFileName(String string) {
        this.suggestedFileName = string;
    }

    public void reset() {
        if (this.scratchFile != null) {
            try {
                this.saveScratch();
            }
            catch (IOException iOException) {}
            this.scratchFile.delete();
        }
        this.hasContent = false;
    }

    private static void setChooserExtension(String string) {
        if (string != null) {
            ext = string;
        }
        if (ext != null && chooser != null && chooser.isVisible()) {
            final String string2 = chooserField == null ? "*." + ext : String.valueOf(XML.stripExtension(chooserField.getText())) + "." + ext;
            Runnable runnable = new Runnable(){

                public void run() {
                    if (chooserField != null) {
                        chooserField.setText(string2);
                    } else {
                        File file = chooser.getCurrentDirectory();
                        String string = XML.getResolvedPath(string2, file.getAbsolutePath());
                        chooser.setSelectedFile(new File(string));
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected void createScratch() throws IOException {
        if (this.hasContent || this.scratchFile == null) {
            String string = this.scratchName;
            if (this.hasContent) {
                string = String.valueOf(string) + "-" + this.scratchNumber++;
            }
            this.reset();
            string = String.valueOf(string) + this.getScratchExtension();
            if (tempDirectory != null) {
                string = String.valueOf(tempDirectory) + "/" + string;
            }
            this.scratchFile = new File(string);
            this.hasContent = false;
            this.canRecord = false;
            OSPLog.finest(this.scratchFile.getAbsolutePath());
        }
    }

    protected String getScratchExtension() {
        return ".tmp";
    }

    protected File selectFile() {
        int n;
        Object object;
        ignoreChooser = true;
        File file = null;
        chooser.setDialogTitle(MediaRes.getString("VideoIO.Dialog.SaveVideoAs.Title"));
        chooser.resetChoosableFileFilters();
        VideoFileFilter[] videoFileFilterArray = this.videoType.getFileFilters();
        if (videoFileFilterArray != null && videoFileFilterArray.length > 0) {
            object = this.videoType.getDefaultFileFilter();
            if (object == null) {
                object = videoFileFilterArray[0];
            }
            chooser.setAcceptAllFileFilterUsed(false);
            n = 0;
            while (n < videoFileFilterArray.length) {
                chooser.addChoosableFileFilter(videoFileFilterArray[n]);
                ++n;
            }
            chooser.setFileFilter((FileFilter)object);
            ext = ((VideoFileFilter)object).getDefaultExtension();
        } else {
            chooser.setAcceptAllFileFilterUsed(true);
        }
        object = this.suggestedFileName;
        if (object == null) {
            object = MediaRes.getString("VideoIO.FileName.Untitled");
        }
        if (ext != null) {
            object = String.valueOf(object) + "." + ext;
        }
        chooser.setSelectedFile(new File((String)object));
        chooserField.setText((String)object);
        ignoreChooser = false;
        n = chooser.showDialog(null, MediaRes.getString("Dialog.Button.Save"));
        if (n == 0) {
            file = chooser.getSelectedFile();
            if ((file = this.getFileToBeSaved(file)).exists()) {
                if (file.canWrite()) {
                    int n2 = JOptionPane.showConfirmDialog(null, " \"" + file.getName() + "\" " + MediaRes.getString("VideoIO.Dialog.FileExists.Message"), MediaRes.getString("VideoIO.Dialog.FileExists.Title"), 1);
                    if (n2 != 0) {
                        file = null;
                    }
                } else {
                    JOptionPane.showMessageDialog(null, ControlsRes.getString("Dialog.ReadOnly.Message"), ControlsRes.getString("Dialog.ReadOnly.Title"), -1);
                    file = null;
                }
            }
        }
        return file;
    }

    protected File getFileToBeSaved(File file) {
        return file;
    }

    protected void finalize() {
        this.deleteTempFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteTempFiles() {
        if (this.tempFiles == null) {
            return;
        }
        ArrayList<File> arrayList = this.tempFiles;
        synchronized (arrayList) {
            for (File file : this.tempFiles) {
                file.delete();
            }
            this.tempFiles.clear();
        }
    }

    private JTextComponent getTextComponent(Container container, String string) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            JTextComponent jTextComponent;
            if (componentArray[n] instanceof JTextComponent && string.equals(((JTextComponent)componentArray[n]).getText())) {
                return (JTextComponent)componentArray[n];
            }
            if (componentArray[n] instanceof Container && (jTextComponent = this.getTextComponent((Container)componentArray[n], string)) != null) {
                return jTextComponent;
            }
            ++n;
        }
        return null;
    }

    protected abstract void saveScratch() throws IOException;

    protected abstract boolean startRecording();

    protected abstract boolean append(Image var1);

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        public void run() {
            if (ScratchVideoRecorder.this.scratchFile != null) {
                try {
                    ScratchVideoRecorder.this.saveScratch();
                }
                catch (Exception exception) {}
                ScratchVideoRecorder.this.scratchFile.delete();
            }
            ScratchVideoRecorder.this.deleteTempFiles();
        }
    }
}

