/*
 * Decompiled with CFR 0.152.
 */
package users.dav.wc.qm.SchroedingerNumerovEigensystem_pkg;

import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.TranslatorUtil;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.dav.wc.qm.SchroedingerNumerovEigensystem_pkg.SchroedingerNumerovEigensystemSimulation;
import users.dav.wc.qm.SchroedingerNumerovEigensystem_pkg.SchroedingerNumerovEigensystemView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchroedingerNumerovEigensystem
extends Model {
    public SchroedingerNumerovEigensystemSimulation _simulation = null;
    public SchroedingerNumerovEigensystemView _view = null;
    public SchroedingerNumerovEigensystem _model = this;
    private static Map<String, Set<HtmlPageInfo>> __htmlPagesMap;
    public int N = 201;
    public double[][] V;
    public double[][] A;
    public double[][] B;
    public double[][] eigenFunctions;
    public double[] E;
    public double[] x;
    public double[] offsetPsi;
    public double[] normPsi;
    public double[] normRho;
    public int n = 1;
    public String fStr = "x*x/2";
    public double xmin = -5.0;
    public double xmax = 5.0;
    public double ymin = 0.0;
    public double ymax;
    public double range = this.ymax = 2.0;
    public double sidebarW = (this.xmax - this.xmin) / 20.0;
    public double sidebarH;
    public double cursory;
    public String msg = "Drag the energy cursor to change levels.";
    public boolean showPsiFrame;
    public boolean showRho;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_initialization2 = true;

    public static void _addHtmlPageInfo(String string, String string2, String string3, String string4) {
        LocaleItem localeItem;
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            set = new HashSet<HtmlPageInfo>();
            __htmlPagesMap.put(string, set);
        }
        if ((localeItem = LocaleItem.getLocaleItem(string2)) != null) {
            set.add(new HtmlPageInfo(localeItem, string3, string4));
        }
    }

    public static HtmlPageInfo _getHtmlPageClassInfo(String string, LocaleItem localeItem) {
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            return null;
        }
        HtmlPageInfo htmlPageInfo = null;
        for (HtmlPageInfo htmlPageInfo2 : set) {
            if (htmlPageInfo2.getLocaleItem().isDefaultItem()) {
                htmlPageInfo = htmlPageInfo2;
            }
            if (!htmlPageInfo2.getLocaleItem().equals(localeItem)) continue;
            return htmlPageInfo2;
        }
        return htmlPageInfo;
    }

    @Override
    public HtmlPageInfo _getHtmlPageInfo(String string, LocaleItem localeItem) {
        return SchroedingerNumerovEigensystem._getHtmlPageClassInfo(string, localeItem);
    }

    public static String _getEjsModel() {
        return "/users/dav/wc/qm/SchroedingerNumerovEigensystem.xml";
    }

    public static String _getModelDirectory() {
        return "users/dav/wc/qm/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(509, 412);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("/users/dav/wc/qm/SchroedingerNumerovEigensystem/SchroedingerNumerovEigensystem.html");
        hashSet.add("/users/dav/wc/qm/SchroedingerNumerovEigensystem/schroedinger_au.gif");
        hashSet.add("/users/dav/wc/qm/SchroedingerNumerovEigensystem/wavefunction.jpg");
        hashSet.add("/users/dav/wc/qm/SchroedingerNumerovEigensystem/SchroedingerNumerovEigensystem.html");
        return hashSet;
    }

    public static boolean _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/dav/wc/qm/");
        n = 0;
        boolean bl2 = false;
        try {
            if ("true".equals(System.getProperty("org.osp.launcher"))) {
                OSPRuntime.setLauncherMode(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (System.getProperty("osp_ejs") != null) {
                bl2 = true;
                Simulation.setPathToLibrary("C:/Users/wc/ejs/EJS_4.3.7/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("C:/Users/wc/ejs/EJS_4.3.7/bin/config/");
        }
        SchroedingerNumerovEigensystem._addHtmlPageInfo("Schroedinger Numerov Eigensystem", "_default_", "Schroedinger Numerov Eigensystem", "/users/dav/wc/qm/SchroedingerNumerovEigensystem/SchroedingerNumerovEigensystem.html");
        if (!bl2) {
            // empty if block
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (!SchroedingerNumerovEigensystem._common_initialization(stringArray)) {
            if (OSPRuntime.isLauncherMode()) {
                return;
            }
            System.exit(-1);
        }
        SchroedingerNumerovEigensystem schroedingerNumerovEigensystem = new SchroedingerNumerovEigensystem(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        if (!SchroedingerNumerovEigensystem._common_initialization(stringArray)) {
            return null;
        }
        SchroedingerNumerovEigensystem schroedingerNumerovEigensystem = new SchroedingerNumerovEigensystem("mainFrame", jFrame, null, null, stringArray, true);
        return (JComponent)schroedingerNumerovEigensystem._getView().getComponent("mainFrame");
    }

    public SchroedingerNumerovEigensystem() {
        this(null, null, null, null, null, false);
    }

    public SchroedingerNumerovEigensystem(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public SchroedingerNumerovEigensystem(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        ControlWindow.setKeepHidden(true);
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new SchroedingerNumerovEigensystemSimulation(this, string, frame, uRL, bl);
        this._view = (SchroedingerNumerovEigensystemView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
        ControlWindow.setKeepHidden(false);
    }

    @Override
    public String _getClassEjsModel() {
        return SchroedingerNumerovEigensystem._getEjsModel();
    }

    @Override
    public Set<String> _getClassEjsResources() {
        return SchroedingerNumerovEigensystem._getEjsResources();
    }

    @Override
    public String _getClassModelDirectory() {
        return SchroedingerNumerovEigensystem._getModelDirectory();
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        this._isEnabled_initialization1 = true;
        this._isEnabled_initialization2 = true;
        this.N = 201;
        this.V = new double[this.N][this.N];
        this.A = new double[this.N][this.N];
        this.B = new double[this.N][this.N];
        this.eigenFunctions = new double[this.N][this.N];
        this.E = new double[this.N];
        this.x = new double[this.N];
        this.offsetPsi = new double[this.N];
        this.normPsi = new double[this.N];
        this.normRho = new double[this.N];
        this.n = 1;
        this.fStr = "x*x/2";
        this.xmin = -5.0;
        this.xmax = 5.0;
        this.ymin = 0.0;
        this.range = this.ymax = 2.0;
        this.sidebarW = (this.xmax - this.xmin) / 20.0;
        this.msg = "Drag the energy cursor to change levels.";
    }

    public void _initializeSolvers() {
    }

    @Override
    public void _initializeModel() {
        this.__shouldBreak = false;
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
        if (this.__shouldBreak) {
            return;
        }
        if (this._isEnabled_initialization2) {
            this._initialization2();
        }
        if (this.__shouldBreak) {
            return;
        }
        this._initializeSolvers();
    }

    @Override
    public void _automaticResetSolvers() {
    }

    @Override
    public void _resetSolvers() {
    }

    @Override
    public void _stepModel() {
        this.__shouldBreak = false;
    }

    @Override
    public void _updateModel() {
        this.__shouldBreak = false;
    }

    @Override
    public void _freeMemory() {
        this.getSimulation().setEnded();
        this.V = null;
        this.A = null;
        this.B = null;
        this.eigenFunctions = null;
        this.E = null;
        this.x = null;
        this.offsetPsi = null;
        this.normPsi = null;
        this.normRho = null;
        System.gc();
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Initialize".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("Compute eigensystem".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization2 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        int n;
        double d = this.xmin;
        double d2 = (this.xmax - this.xmin) / (double)(this.N - 1);
        double d3 = d2 * d2;
        this._view.potentialTrail.clear();
        for (n = 0; n < this.N; ++n) {
            double d4 = this._view.function.evaluate(d);
            this._view.potentialTrail.addPoint(d, d4);
            this.V[n][n] = d4;
            this.B[n][n] = 0.8333333333333334;
            this.A[n][n] = 1.0 / d3;
            this.x[n] = d;
            d += d2;
        }
        this.V[0][0] = 1.0E12;
        this.V[this.N - 1][this.N - 1] = 1.0E12;
        for (n = 1; n < this.N; ++n) {
            this.B[n - 1][n] = 0.08333333333333333;
            this.A[n - 1][n] = -0.5 / d3;
            this.B[n][n - 1] = 0.08333333333333333;
            this.A[n][n - 1] = -0.5 / d3;
        }
    }

    public void _initialization2() {
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(this.B);
        RealMatrix realMatrix = new LUDecomposition(array2DRowRealMatrix).getSolver().getInverse();
        RealMatrix realMatrix2 = realMatrix.multiply(new Array2DRowRealMatrix(this.A));
        RealMatrix realMatrix3 = realMatrix2.add(new Array2DRowRealMatrix(this.V));
        EigenDecomposition eigenDecomposition = new EigenDecomposition(realMatrix3, 0.0);
        this.E = eigenDecomposition.getRealEigenvalues();
        this.eigenFunctions = eigenDecomposition.getVT().getData();
        this.displayPsi();
    }

    public void displayPsi() {
        double d;
        this.ymin = this.ymax = this._view.function.evaluate(this.x[0]);
        double[] dArray = this.eigenFunctions[this.N - this.n];
        double d2 = d = dArray[0];
        double d3 = d * d;
        for (int i = 1; i < this.N; ++i) {
            double d4 = this._view.function.evaluate(this.x[i]);
            this.ymin = Math.min(d4, this.ymin);
            this.ymax = Math.max(d4, this.ymax);
            d = Math.min(dArray[i], d);
            d2 = Math.max(dArray[i], d2);
            d3 += dArray[i] * dArray[i];
        }
        d3 *= (this.xmax - this.xmin) / (double)(this.N - 1);
        d3 = Math.sqrt(d3);
        double d5 = 0.15 * Math.max(this.range, this.ymax - this.ymin) / (d2 - d);
        if (Math.abs(d2) < Math.abs(d)) {
            d3 = -d3;
            d5 = -d5;
        }
        for (int i = 0; i < this.N; ++i) {
            this.normPsi[i] = dArray[i] / d3;
            this.normRho[i] = this.normPsi[i] * this.normPsi[i];
            this.offsetPsi[i] = dArray[i] * d5;
        }
        this.cursory = this.E[this.N - this.n];
        this.sidebarH = Math.abs(this.E[0] - this.E[this.N - 1]);
    }

    public void adjustCursor() {
        double d = Math.abs(this.cursory - this.E[this.N - 1]);
        this.n = 1;
        for (int i = 0; i < this.N; ++i) {
            if (!(Math.abs(this.cursory - this.E[i]) < d)) continue;
            this.n = this.N - i;
            d = Math.abs(this.cursory - this.E[i]);
        }
        this.displayPsi();
    }

    public double _method_for_levelsGroup_x() {
        return this.xmax - this.sidebarW;
    }

    public void _method_for_energyCursor_dragaction() {
        this.msg = null;
        this.adjustCursor();
    }

    public void _method_for_energyCursor_action() {
        this.adjustCursor();
    }

    public double _method_for_energyOffset_y() {
        return this.E[this.N - this.n];
    }

    public void _method_for_resetButton_action() {
        this._reset();
    }

    public void _method_for_function_action() {
        this._initialize();
    }

    public void _method_for_xminField_action() {
        this._initialize();
    }

    public void _method_for_xmaxField_action() {
        this._initialize();
    }

    public boolean _method_for_psiTrail_visible() {
        return !this.showRho;
    }

    public boolean _method_for_psiTrail_measured() {
        return !this.showRho;
    }

    public void _method_for_nField_action() {
        this.n = Math.min(this.n, (this.N - 1) / 4);
        this.n = Math.max(this.n, 1);
        this.msg = null;
        this.displayPsi();
    }

    public double _method_for_EField_variable() {
        return this.E[this.N - this.n];
    }

    static {
        __translatorUtil = new TranslatorUtil();
        __htmlPagesMap = new HashMap<String, Set<HtmlPageInfo>>();
    }
}

