CREATE TABLE [tb_GE_ColumnCaption] (
	[ColumnIndex] LONG NOT NULL,
	[ColumnCaption] TEXT(50) ,
	[GridID] LONG NOT NULL
) 
GO
CREATE TABLE [tb_GE_Combo] (
	[ComboID] AUTOINCREMENT,
	[ComboType] TEXT(50) WITH COMPRESSION,
	[ComboValue] TEXT(50) WITH COMPRESSION
) 
GO
CREATE TABLE [tb_GE_CompanyProfile] (
	[CompanyID] AUTOINCREMENT,
	[Name] TEXT(50) WITH COMPRESSION,
	[Address] TEXT(255) WITH COMPRESSION,
	[Phone] TEXT(100) WITH COMPRESSION,
	[Fax] TEXT(100) WITH COMPRESSION,
	[EMail] TEXT(100) WITH COMPRESSION,
	[WebSite] TEXT(100) WITH COMPRESSION,
	[Logo] LongBinary NULL,
	[BudgetStart] SMALLINT,
	[Sunday] LONG,
	[Monday] LONG,
	[Tuesday] LONG,
	[Wednesday] LONG,
	[Thursday] LONG,
	[Friday] LONG,
	[Saturday] LONG,
	[City] TEXT(50) WITH COMPRESSION,
	[State] TEXT(255) WITH COMPRESSION,
	[Zip] TEXT(100) WITH COMPRESSION,
	[Country] TEXT(100) WITH COMPRESSION,
	CONSTRAINT [PrimaryKey] PRIMARY KEY ([CompanyID])
) 
GO
CREATE TABLE [tb_GE_Employee] (
	[EmployeeID] LONG NOT NULL,
	[EnrollNumber] LONG,
	[EmployeeCode] TEXT(50) WITH COMPRESSION,
	[EmployeeName] TEXT(200) WITH COMPRESSION,
	[DOE] DATETIME,
	[LocationID] LONG,
	[DesignationID] LONG,
	[DOR] DATETIME,
	[LoginPassword] TEXT(50) WITH COMPRESSION,
	[IsLeaveAdmin] BIT NOT NULL,
	[Email] TEXT(100) WITH COMPRESSION,
	[Photo] LongBinary NULL,
	CONSTRAINT [PrimaryKey] PRIMARY KEY ([EmployeeID])
) 
GO
CREATE TABLE [tb_GE_EmployeeCustomData] (
	[EmployeeID] LONG NOT NULL,
	[EmployeeCustomFieldID] LONG NOT NULL,
	[FieldValue] TEXT(200) WITH COMPRESSION
) 
GO
CREATE TABLE [tb_GE_EmployeeCustomField] (
	[EmployeeCustomFieldID] LONG NOT NULL,
	[EmployeeCustomFieldName] TEXT(50) WITH COMPRESSION,
	[SrNo] LONG,
	CONSTRAINT [PrimaryKey] PRIMARY KEY ([EmployeeCustomFieldID])
) 
GO
CREATE TABLE [tb_GE_EventLogs] (
	[LogType] TEXT(20) WITH COMPRESSION NOT NULL,
	[LogDateTime] DATETIME NOT NULL,
	[Source] TEXT(50) WITH COMPRESSION,
	[LogMessage] TEXT(200) WITH COMPRESSION,
	[ErrMessage] MEMO WITH COMPRESSION
) 
GO
CREATE TABLE [tb_GE_Location] (
	[LocationID] LONG NOT NULL,
	[ParentID] LONG NOT NULL,
	[CompanyID] LONG NOT NULL,
	[Description] TEXT(50) WITH COMPRESSION,
	CONSTRAINT [PrimaryKey] PRIMARY KEY ([LocationID])
) 
GO
CREATE TABLE [tb_GE_ReportConfig] (
	[SYSID] LONG,
	[FileName] MEMO WITH COMPRESSION,
	[Name] TEXT(100) WITH COMPRESSION,
	[ClassName] TEXT(100) WITH COMPRESSION,
	[HeightVal] LONG,
	[EmVisable] BIT NOT NULL
) 
GO
CREATE TABLE [tb_GE_Setting] (
	[KeyName] TEXT(50) WITH COMPRESSION NOT NULL,
	[Description] TEXT(100) WITH COMPRESSION,
	[KeyValue] MEMO WITH COMPRESSION
) 
GO
CREATE TABLE [tb_GE_SystemUser] (
	[SysID] AUTOINCREMENT,
	[UserID] TEXT(50) WITH COMPRESSION,
	[UserName] TEXT(255) WITH COMPRESSION,
	[Password] TEXT(50) WITH COMPRESSION,
	[UserLevelID] LONG,
	[Remark] TEXT(100) WITH COMPRESSION,
	CONSTRAINT [PrimaryKey] PRIMARY KEY ([SysID])
) 
GO
CREATE TABLE [tb_GE_UserEmployee] (
	[UserLevelID] LONG NOT NULL,
	[EmployeeID] LONG NOT NULL
) 
GO
CREATE TABLE [tb_GE_UserLevel] (
	[SysID] LONG NOT NULL,
	[UserLevel] TEXT(50) WITH COMPRESSION,
	[Description] TEXT(50) WITH COMPRESSION,
	[IsAdministrator] BIT NOT NULL,
	[Remark] TEXT(100) WITH COMPRESSION,
	CONSTRAINT [PrimaryKey] PRIMARY KEY ([SysID])
) 
GO
CREATE TABLE [tb_GE_UserMenu] (
	[MenuID] TEXT(50) WITH COMPRESSION NOT NULL,
	[MenuName] TEXT(100) WITH COMPRESSION
) 
GO
CREATE TABLE [tb_IO_AttendanceMessage] (
	[EmployeeID] LONG NOT NULL,
	[PersonalMessage] TEXT(200) WITH COMPRESSION
) 
GO
CREATE TABLE [tb_IO_FingerTemplateTestech] (
	[TemplateID] AUTOINCREMENT,
	[EmployeeID] LONG,
	[FingerID] LONG,
	[Template] LongBinary NULL,
	[UserType] LONG,
	CONSTRAINT [PrimaryKey] PRIMARY KEY ([TemplateID])
)
GO
CREATE TABLE [tb_IO_FingerTemplateVerifinger] (
	[TemplateID] AUTOINCREMENT,
	[EmployeeID] LONG,
	[FingerID] LONG,
	[Template] LongBinary NULL ,
	CONSTRAINT [PrimaryKey] PRIMARY KEY ([TemplateID])
) 
GO
CREATE TABLE [tb_IO_FingerTemplateZK] (
	[TemplateID] AUTOINCREMENT,
	[EmployeeID] LONG,
	[FingerID] LONG,
	[Template] LongBinary NULL,
	[UserType] LONG,
	CONSTRAINT [PrimaryKey] PRIMARY KEY ([TemplateID])
)
GO
CREATE TABLE [tb_IO_FPMachine] (
	[MachineID] LONG NOT NULL,
	[Description] TEXT(20) WITH COMPRESSION NOT NULL,
	[DeviceNo] LONG,
	[ConnectionType] LONG,
	[Port] LONG,
	[BaudRate] LONG,
	[IPAddress] TEXT(50) WITH COMPRESSION,
	CONSTRAINT [PrimaryKey] PRIMARY KEY ([MachineID])
)
GO
CREATE TABLE [tb_IOTA_AttendanceComment] (
	[EmployeeID] LONG NOT NULL,
	[AttDate] DATETIME NOT NULL,
	[Comment] TEXT(255) WITH COMPRESSION NOT NULL
)
GO
CREATE TABLE [tb_IOTA_EmployeeLog] (
	[EmployeeID] LONG NOT NULL,
	[Press_Time] DATETIME NOT NULL,
	[MachineID] LONG NOT NULL,
	[Is_In] BIT NOT NULL,
	[Inactive] BIT NOT NULL
)
GO
CREATE TABLE [tb_TA_AttendanceDaily] (
	[EmployeeID] LONG NOT NULL,
	[CalculatedDate] DATETIME NOT NULL,
	[ShiftCode] TEXT(5) WITH COMPRESSION,
	[ShiftName] TEXT(100) WITH COMPRESSION,
	[DutyIn] DATETIME,
	[DutyOut] DATETIME,
	[ActualIn] DATETIME,
	[ActualOut] DATETIME,
	[LeaveName] TEXT(50) WITH COMPRESSION,
	[LeaveType] LONG ,
	[LeaveDay] DECIMAL(2, 1),
	[OffDay] DECIMAL(2, 1),
	[Absent] DECIMAL(2, 1),
	[AttendanceDay] DECIMAL(2, 1)
)
GO
CREATE TABLE [tb_TA_AttendanceDailyBreakTime] (
	[EmployeeID] LONG NOT NULL,
	[CalculatedDate] DATETIME NOT NULL,
	[BreakTimeName] TEXT(100) WITH COMPRESSION,
	[BreakOut] DATETIME,
	[BreakIn] DATETIME,
	[ActualOut] DATETIME,
	[ActualIn] DATETIME,
	[IsIncludeInWorkingHour] BIT NOT NULL
)
GO
CREATE TABLE [tb_TA_AttendanceDailyFormula] (
	[EmployeeID] LONG,
	[CalculatedDate] DATETIME,
	[FormulaName] TEXT(100) WITH COMPRESSION,
	[CalculatedValue] DECIMAL(18, 2),
	[FormulaType] TEXT(50) WITH COMPRESSION,
	[Unit] LONG
)
GO
CREATE TABLE [tb_TA_AttendanceFormulaPolicy] (
	[FormulaID] LONG NOT NULL,
	[Description] TEXT(100) WITH COMPRESSION,
	[FromTime] TEXT(100) WITH COMPRESSION,
	[AdjustFrom] DECIMAL(18, 2),
	[ToTime] TEXT(100) WITH COMPRESSION,
	[AdjustTo] DECIMAL(18, 2),
	[AdjustAll] DECIMAL(18, 0),
	[MaxValue] DECIMAL(18, 2),
	[MaxReturnValue] DECIMAL(18, 2),
	[Unit] LONG,
	[RoundType] LONG,
	[RoundValue] DECIMAL(18, 2),
	[ShiftID] LONG,
	[FormulaType] LONG,
	[isDefault] BIT NOT NULL,
	[IncludeInHoliday] LONG,
	CONSTRAINT [PrimaryKey] PRIMARY KEY ([FormulaID])
)
GO
CREATE TABLE [tb_TA_BreakTimePolicy] (
	[BreakTimeID] LONG NOT NULL,
	[Description] TEXT(100) WITH COMPRESSION,
	[BreakOut] TEXT(50) WITH COMPRESSION,
	[BreakIn] TEXT(50) WITH COMPRESSION,
	[Alert] BIT NOT NULL,
	[IncludeInWorkingHour] BIT NOT NULL,
	[ShiftID] LONG NOT NULL,
	CONSTRAINT [PrimaryKey] PRIMARY KEY ([BreakTimeID])
) 
GO
CREATE TABLE [tb_TA_DutyRoster] (
	[EmployeeID] LONG,
	[ShiftDate] DATETIME,
	[ShiftID] LONG,
	[IsOff] LONG,
	[LeaveID] LONG,
	[LeaveType] LONG
)
GO
CREATE TABLE [tb_TA_EmployeeAutoShift] (
	[EmployeeID] LONG NOT NULL,
	[ShiftID] LONG NOT NULL
)
GO
CREATE TABLE [tb_TA_EmployeePolicy] (
	[EmployeeID] LONG NOT NULL,
	[Sunday] LONG,
	[Monday] LONG,
	[Tuesday] LONG,
	[Wednesday] LONG,
	[Thursday] LONG,
	[Friday] LONG,
	[Saturday] LONG,
	[ShiftID] LONG,
	[LeavePolicyGroupID] LONG
) 
GO
CREATE TABLE [tb_TA_Gazette] (
	[GDate] DATETIME NOT NULL,
	[Description] TEXT(100) WITH COMPRESSION
) 
GO
CREATE TABLE [tb_TA_LeaveItem] (
	[LeaveID] AUTOINCREMENT,
	[LeaveName] TEXT(50) WITH COMPRESSION,
	[Color] LONG,
	[ShortCode] TEXT(5) WITH COMPRESSION NOT NULL,
	CONSTRAINT [PrimaryKey] PRIMARY KEY ([LeaveID])
) 
GO
CREATE TABLE [tb_TA_LeaveOpening] (
	[EntryDate] DATETIME NOT NULL,
	[EmployeeID] LONG NOT NULL,
	[LeaveID] LONG NOT NULL,
	[OpeningBalance] DECIMAL(18, 2)
) 
GO
CREATE TABLE [tb_TA_LeavePolicy] (
	[LeavePolicyGroupID] LONG NOT NULL,
	[LeaveID] LONG NOT NULL,
	[MaxDay] LONG,
	[DurationAmount] LONG,
	[AllowDuration] LONG,
	[AllowCarry] BIT NOT NULL
) 
GO
CREATE TABLE [tb_TA_LeavePolicyGroup] (
	[LeavePolicyGroupID] AUTOINCREMENT,
	[Description] TEXT(50) WITH COMPRESSION,
	[isdefault] BIT NOT NULL,
	CONSTRAINT [PrimaryKey] PRIMARY KEY ([LeavePolicyGroupID])
) 
GO
CREATE TABLE [tb_TA_LeaveRequest] (
	[LeaveRequestID] AUTOINCREMENT,
	[EmployeeID] LONG NOT NULL,
	[LeaveID] LONG NOT NULL,
	[FromDate] DATETIME NOT NULL,
	[ToDate] DATETIME NOT NULL,
	[Remark] TEXT(200) WITH COMPRESSION,
	[AdminID] LONG,
	[Status] LONG,
	CONSTRAINT [PrimaryKey] PRIMARY KEY ([LeaveRequestID])
) 
GO
CREATE TABLE [tb_TA_ShiftPolicy] (
	[ShiftID] AUTOINCREMENT,
	[Description] TEXT(100) WITH COMPRESSION,
	[DutyIn] TEXT(50) WITH COMPRESSION,
	[DutyOut] TEXT(50) WITH COMPRESSION,
	[ShortCode] TEXT(5) WITH COMPRESSION,
	[EarlyOT] TEXT(50) WITH COMPRESSION,
	[Late] TEXT(50) WITH COMPRESSION,
	[EarlyOut] TEXT(50) WITH COMPRESSION,
	[OTStart] TEXT(50) WITH COMPRESSION,
	[isdefault] BIT NOT NULL,
	CONSTRAINT [PrimaryKey] PRIMARY KEY ([ShiftID])
) 
GO
CREATE TABLE [tmpDutyRoster] (
	[EmployeeID] LONG,
	[ShiftDate] DATETIME,
	[ShiftID] LONG,
	[OffDay] LONG,
	[LeaveID] LONG,
	[LeaveType] LONG,
	[SessionID] TEXT(36) WITH COMPRESSION
)
GO
CREATE TABLE [tb_GE_KeyGenerate] (
	[GenerateKeyType] TEXT(20) WITH COMPRESSION,
	[GenerateFormat] TEXT(50) WITH COMPRESSION,
	[GenerateID] DECIMAL(19, 0)
)
GO
CREATE INDEX [tb_GE_SystemUserSysID]
	ON [tb_GE_SystemUser] ([SysID])
GO
ALTER TABLE [tb_GE_Employee]
	ADD CONSTRAINT [tb_GE_Locationtb_GE_Employee]
	FOREIGN KEY ([LocationID]) REFERENCES
		[tb_GE_Location] ([LocationID])
GO
ALTER TABLE [tb_GE_EmployeeCustomData]
	ADD CONSTRAINT [tb_GE_EmployeeCustomFieldtb_GE_EmployeeCustomData]
	FOREIGN KEY ([EmployeeCustomFieldID]) REFERENCES
		[tb_GE_EmployeeCustomField] ([EmployeeCustomFieldID])
	ON DELETE CASCADE
GO
ALTER TABLE [tb_GE_EmployeeCustomData]
	ADD CONSTRAINT [tb_GE_Employeetb_GE_EmployeeCustomData]
	FOREIGN KEY ([EmployeeID]) REFERENCES
		[tb_GE_Employee] ([EmployeeID])
	ON DELETE CASCADE
GO
ALTER TABLE [tb_GE_Location]
	ADD CONSTRAINT [tb_GE_CompanyProfiletb_GE_Location]
	FOREIGN KEY ([CompanyID]) REFERENCES
		[tb_GE_CompanyProfile] ([CompanyID])
GO
ALTER TABLE [tb_GE_SystemUser]
	ADD CONSTRAINT [tb_GE_UserLeveltb_GE_SystemUser]
	FOREIGN KEY ([UserLevelID]) REFERENCES
		[tb_GE_UserLevel] ([SysID])
GO
ALTER TABLE [tb_GE_UserEmployee]
	ADD CONSTRAINT [tb_GE_UserLeveltb_GE_UserEmployee]
	FOREIGN KEY ([UserLevelID]) REFERENCES
		[tb_GE_UserLevel] ([SysID])
	ON DELETE CASCADE
GO
ALTER TABLE [tb_IOTA_AttendanceComment]
	ADD CONSTRAINT [tb_GE_Employeetb_IOTA_AttendanceComment]
	FOREIGN KEY ([EmployeeID]) REFERENCES
		[tb_GE_Employee] ([EmployeeID])
	ON DELETE CASCADE
GO
ALTER TABLE [tb_IOTA_EmployeeLog]
	ADD CONSTRAINT [tb_GE_Employeetb_IOTA_EmployeeLog]
	FOREIGN KEY ([EmployeeID]) REFERENCES
		[tb_GE_Employee] ([EmployeeID])
	ON DELETE CASCADE
GO
ALTER TABLE [tb_TA_AttendanceDailyFormula]
	ADD CONSTRAINT [tb_GE_Employeetb_TA_AttendanceDailyFormula]
	FOREIGN KEY ([EmployeeID]) REFERENCES
		[tb_GE_Employee] ([EmployeeID])
	ON DELETE CASCADE
GO
ALTER TABLE [tb_TA_AttendanceFormulaPolicy]
	ADD CONSTRAINT [tb_TA_ShiftPolicytb_TA_AttendanceFormulaPolicy]
	FOREIGN KEY ([ShiftID]) REFERENCES
		[tb_TA_ShiftPolicy] ([ShiftID])
	ON DELETE CASCADE
GO
ALTER TABLE [tb_TA_BreakTimePolicy]
	ADD CONSTRAINT [tb_TA_ShiftPolicytb_TA_BreakTimePolicy]
	FOREIGN KEY ([ShiftID]) REFERENCES
		[tb_TA_ShiftPolicy] ([ShiftID])
	ON DELETE CASCADE
GO
ALTER TABLE [tb_TA_DutyRoster]
	ADD CONSTRAINT [tb_GE_Employeetb_TA_DutyRoster]
	FOREIGN KEY ([EmployeeID]) REFERENCES
		[tb_GE_Employee] ([EmployeeID])
	ON DELETE CASCADE
GO
ALTER TABLE [tb_TA_DutyRoster]
	ADD CONSTRAINT [tb_TA_LeaveItemtb_TA_DutyRoster]
	FOREIGN KEY ([LeaveID]) REFERENCES
		[tb_TA_LeaveItem] ([LeaveID])
GO
ALTER TABLE [tb_TA_DutyRoster]
	ADD CONSTRAINT [tb_TA_ShiftPolicytb_TA_DutyRoster]
	FOREIGN KEY ([ShiftID]) REFERENCES
		[tb_TA_ShiftPolicy] ([ShiftID])
GO
ALTER TABLE [tb_TA_EmployeeAutoShift]
	ADD CONSTRAINT [tb_GE_Employeetb_TA_EmployeeAutoShift]
	FOREIGN KEY ([EmployeeID]) REFERENCES
		[tb_GE_Employee] ([EmployeeID])
	ON DELETE CASCADE
GO
ALTER TABLE [tb_TA_EmployeeAutoShift]
	ADD CONSTRAINT [tb_TA_ShiftPolicytb_TA_EmployeeAutoShift]
	FOREIGN KEY ([ShiftID]) REFERENCES
		[tb_TA_ShiftPolicy] ([ShiftID])
	ON DELETE CASCADE
GO
ALTER TABLE [tb_TA_EmployeePolicy]
	ADD CONSTRAINT [tb_GE_Employeetb_TA_EmployeePolicy]
	FOREIGN KEY ([EmployeeID]) REFERENCES
		[tb_GE_Employee] ([EmployeeID])
	ON DELETE CASCADE
GO
ALTER TABLE [tb_TA_EmployeePolicy]
	ADD CONSTRAINT [tb_TA_LeavePolicyGrouptb_TA_EmployeePolicy]
	FOREIGN KEY ([LeavePolicyGroupID]) REFERENCES
		[tb_TA_LeavePolicyGroup] ([LeavePolicyGroupID])
GO
ALTER TABLE [tb_TA_EmployeePolicy]
	ADD CONSTRAINT [tb_TA_ShiftPolicytb_TA_EmployeePolicy]
	FOREIGN KEY ([ShiftID]) REFERENCES
		[tb_TA_ShiftPolicy] ([ShiftID])
GO
ALTER TABLE [tb_TA_LeaveOpening]
	ADD CONSTRAINT [tb_GE_Employeetb_TA_LeaveOpening]
	FOREIGN KEY ([EmployeeID]) REFERENCES
		[tb_GE_Employee] ([EmployeeID])
	ON DELETE CASCADE
GO
ALTER TABLE [tb_TA_LeaveOpening]
	ADD CONSTRAINT [tb_TA_LeaveItemtb_TA_LeaveOpening]
	FOREIGN KEY ([LeaveID]) REFERENCES
		[tb_TA_LeaveItem] ([LeaveID])
	ON DELETE CASCADE
GO
ALTER TABLE [tb_TA_LeavePolicy]
	ADD CONSTRAINT [tb_TA_LeaveItemtb_TA_LeavePolicy]
	FOREIGN KEY ([LeaveID]) REFERENCES
		[tb_TA_LeaveItem] ([LeaveID])
	ON DELETE CASCADE
GO
ALTER TABLE [tb_TA_LeavePolicy]
	ADD CONSTRAINT [tb_TA_LeavePolicyGrouptb_TA_LeavePolicy]
	FOREIGN KEY ([LeavePolicyGroupID]) REFERENCES
		[tb_TA_LeavePolicyGroup] ([LeavePolicyGroupID])
	ON DELETE CASCADE
GO
ALTER TABLE [tb_IO_AttendanceMessage]
	ADD CONSTRAINT [tb_GE_Employeetb_IO_AttendanceMessage]
	FOREIGN KEY ([EmployeeID]) REFERENCES
		[tb_GE_Employee] ([EmployeeID])
	ON DELETE CASCADE
GO
CREATE VIEW [viw_TA_DutyRoster] AS SELECT T.EmployeeID, E.EmployeeCode, E.EmployeeName, S.Description, S.ShortCode, T.ShiftDate, T.ShiftID, T.OffDay, E.LocationID,  IIF(ISNULL(T.LeaveID), 0, T.LeaveID) AS LeaveID, T.LeaveType, L.ShortCode AS LeaveCode, T.SessionID
FROM ((tmpDutyRoster AS T LEFT JOIN tb_TA_ShiftPolicy AS S ON T.ShiftID=S.ShiftID) LEFT JOIN tb_GE_Employee AS E ON T.EmployeeID = E.EmployeeID) LEFT JOIN tb_TA_LeaveItem AS L ON T.LeaveID = L.LeaveID
GO
INSERT INTO tb_TA_ShiftPolicy (Description, DutyIn, DutyOut, ShortCode, EarlyOT, Late, EarlyOut, OTStart, isdefault) VALUES ('Default Shift', '9:00', '17:00', 'DFT', '', '', '', '', 1)
GO
INSERT INTO tb_GE_UserLevel (SysID,UserLevel, Description, IsAdministrator, Remark) VALUES (1,'Administrator', 'Administrator', 1, 'Built In Administrator Level')
GO
INSERT INTO tb_GE_SystemUser (UserID, UserName, [Password], UserLevelID, Remark) VALUES ('Administrator', 'Administrator', '975H4RAcGAw=', 1, 'Built In Administrator Account')
GO
INSERT INTO tb_TA_LeavePolicyGroup (Description, isdefault) VALUES ('Default', 1)
GO
INSERT INTO tb_GE_KeyGenerate (GenerateKeyType, GenerateFormat, GenerateID) VALUES ('UserLevel', '0', 1)
GO
INSERT INTO tb_GE_Setting VALUES ('ClearLog', 'ClearLog Older than days', '60')
GO
INSERT INTO tb_GE_Setting VALUES ('DateFormat', 'Date Format', 'MM/dd/yyyy')
GO
INSERT INTO tb_GE_Setting VALUES ('TimeFormat', 'Time Format', 'HH:mm')
GO
INSERT INTO tb_GE_Setting VALUES ('FirstDay', 'FirstDay', '1')
GO
INSERT INTO tb_GE_Setting VALUES ('TimeRecorder', 'TimeRecorder', '1')
GO
INSERT INTO tb_GE_Setting VALUES ('InOutMode', 'InOutMode', '1')
GO