/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.mbox;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class ContentLengthUpdater
extends FilterOutputStream {
    private String contentLength;
    private boolean inHeader = true;
    private boolean sawContentLength = false;
    private int lastb1 = -1;
    private int lastb2 = -1;
    private StringBuffer line = new StringBuffer();

    public ContentLengthUpdater(OutputStream os, long contentLength) {
        super(os);
        this.contentLength = "Content-Length: " + contentLength;
    }

    public void write(int b) throws IOException {
        if (this.inHeader) {
            String eol = "\n";
            if (b == 13) {
                if (this.lastb1 == 13) {
                    this.inHeader = false;
                    eol = "\r";
                } else if (this.lastb1 == 10 && this.lastb2 == 13) {
                    this.inHeader = false;
                    eol = "\r\n";
                }
            } else if (b == 10 && this.lastb1 == 10) {
                this.inHeader = false;
                eol = "\n";
            }
            if (!this.inHeader && !this.sawContentLength) {
                this.out.write(this.contentLength.getBytes("iso-8859-1"));
                this.out.write(eol.getBytes("iso-8859-1"));
            }
            if (b == 13 || b == 10 && this.lastb1 != 13) {
                if (this.line.toString().regionMatches(true, 0, "content-length:", 0, 15)) {
                    this.sawContentLength = true;
                    this.out.write(this.contentLength.getBytes("iso-8859-1"));
                } else {
                    this.out.write(this.line.toString().getBytes("iso-8859-1"));
                }
                this.line.setLength(0);
            }
            if (b == 13 || b == 10) {
                this.out.write(b);
            } else {
                this.line.append((char)b);
            }
            this.lastb2 = this.lastb1;
            this.lastb1 = b;
        } else {
            this.out.write(b);
        }
    }

    public void write(byte[] b) throws IOException {
        if (this.inHeader) {
            this.write(b, 0, b.length);
        } else {
            this.out.write(b);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.inHeader) {
            int i = 0;
            while (i < len) {
                this.write(b[off + i]);
                ++i;
            }
        } else {
            this.out.write(b, off, len);
        }
    }

    public static void main(String[] argv) throws Exception {
        int b;
        ContentLengthUpdater os = new ContentLengthUpdater(System.out, Long.parseLong(argv[0]));
        while ((b = System.in.read()) >= 0) {
            os.write(b);
        }
        os.flush();
    }
}

