/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import com.sun.mail.util.MailSSLSocketFactory;
import com.sun.mail.util.PropUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SocketFetcher {
    private static boolean debug = PropUtil.getBooleanSystemProperty("mail.socket.debug", false);

    private SocketFetcher() {
    }

    public static Socket getSocket(String host, int port, Properties props, String prefix, boolean useSSL) throws IOException {
        int to;
        boolean idCheck;
        int localport;
        InetAddress localaddr;
        Socket socket;
        int cto;
        block19: {
            if (debug) {
                System.out.println("DEBUG SocketFetcher: getSocket, host " + host + ", port " + port + ", prefix " + prefix + ", useSSL " + useSSL);
            }
            if (prefix == null) {
                prefix = "socket";
            }
            if (props == null) {
                props = new Properties();
            }
            cto = PropUtil.getIntProperty(props, String.valueOf(prefix) + ".connectiontimeout", -1);
            socket = null;
            String localaddrstr = props.getProperty(String.valueOf(prefix) + ".localaddress", null);
            localaddr = null;
            if (localaddrstr != null) {
                localaddr = InetAddress.getByName(localaddrstr);
            }
            localport = PropUtil.getIntProperty(props, String.valueOf(prefix) + ".localport", 0);
            boolean fb = PropUtil.getBooleanProperty(props, String.valueOf(prefix) + ".socketFactory.fallback", true);
            idCheck = PropUtil.getBooleanProperty(props, String.valueOf(prefix) + ".ssl.checkserveridentity", false);
            int sfPort = -1;
            String sfErr = "unknown socket factory";
            try {
                String sfClass;
                Object sfo;
                SocketFactory sf = null;
                String sfPortName = null;
                if (useSSL) {
                    sfo = props.get(String.valueOf(prefix) + ".ssl.socketFactory");
                    if (sfo instanceof SocketFactory) {
                        sf = (SocketFactory)sfo;
                        sfErr = "SSL socket factory instance " + sf;
                    }
                    if (sf == null) {
                        sfClass = props.getProperty(String.valueOf(prefix) + ".ssl.socketFactory.class");
                        sf = SocketFetcher.getSocketFactory(sfClass);
                        sfErr = "SSL socket factory class " + sfClass;
                    }
                    sfPortName = ".ssl.socketFactory.port";
                }
                if (sf == null) {
                    sfo = props.get(String.valueOf(prefix) + ".socketFactory");
                    if (sfo instanceof SocketFactory) {
                        sf = (SocketFactory)sfo;
                        sfErr = "socket factory instance " + sf;
                    }
                    if (sf == null) {
                        sfClass = props.getProperty(String.valueOf(prefix) + ".socketFactory.class");
                        sf = SocketFetcher.getSocketFactory(sfClass);
                        sfErr = "socket factory class " + sfClass;
                    }
                    sfPortName = ".socketFactory.port";
                }
                if (sf != null) {
                    sfPort = PropUtil.getIntProperty(props, String.valueOf(prefix) + sfPortName, -1);
                    if (sfPort == -1) {
                        sfPort = port;
                    }
                    socket = SocketFetcher.createSocket(localaddr, localport, host, sfPort, cto, sf, useSSL, idCheck);
                }
            }
            catch (SocketTimeoutException sex) {
                throw sex;
            }
            catch (Exception ex) {
                Throwable t;
                if (fb) break block19;
                if (ex instanceof InvocationTargetException && (t = ((InvocationTargetException)ex).getTargetException()) instanceof Exception) {
                    ex = (Exception)t;
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                IOException ioex = new IOException("Couldn't connect using " + sfErr + " to host, port: " + host + ", " + sfPort + "; Exception: " + ex);
                ioex.initCause(ex);
                throw ioex;
            }
        }
        if (socket == null) {
            socket = SocketFetcher.createSocket(localaddr, localport, host, port, cto, null, useSSL, idCheck);
        }
        if ((to = PropUtil.getIntProperty(props, String.valueOf(prefix) + ".timeout", -1)) >= 0) {
            socket.setSoTimeout(to);
        }
        SocketFetcher.configureSSLSocket(socket, props, prefix);
        return socket;
    }

    public static Socket getSocket(String host, int port, Properties props, String prefix) throws IOException {
        return SocketFetcher.getSocket(host, port, props, prefix, false);
    }

    private static Socket createSocket(InetAddress localaddr, int localport, String host, int port, int cto, SocketFactory sf, boolean useSSL, boolean idCheck) throws IOException {
        MailSSLSocketFactory msf;
        Socket socket;
        if (sf != null) {
            socket = sf.createSocket();
        } else if (useSSL) {
            sf = SSLSocketFactory.getDefault();
            socket = sf.createSocket();
        } else {
            socket = new Socket();
        }
        if (localaddr != null) {
            socket.bind(new InetSocketAddress(localaddr, localport));
        }
        if (cto >= 0) {
            socket.connect(new InetSocketAddress(host, port), cto);
        } else {
            socket.connect(new InetSocketAddress(host, port));
        }
        if (idCheck && socket instanceof SSLSocket) {
            SocketFetcher.checkServerIdentity(host, (SSLSocket)socket);
        }
        if (sf instanceof MailSSLSocketFactory && !(msf = (MailSSLSocketFactory)sf).isServerTrusted(host, (SSLSocket)socket)) {
            try {
                socket.close();
            }
            catch (Throwable throwable) {}
            throw new IOException("Server is not trusted");
        }
        return socket;
    }

    private static SocketFactory getSocketFactory(String sfClass) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (sfClass == null || sfClass.length() == 0) {
            return null;
        }
        ClassLoader cl = SocketFetcher.getContextClassLoader();
        Class<?> clsSockFact = null;
        if (cl != null) {
            try {
                clsSockFact = cl.loadClass(sfClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clsSockFact == null) {
            clsSockFact = Class.forName(sfClass);
        }
        Method mthGetDefault = clsSockFact.getMethod("getDefault", new Class[0]);
        SocketFactory sf = (SocketFactory)mthGetDefault.invoke(new Object(), new Object[0]);
        return sf;
    }

    public static Socket startTLS(Socket socket) throws IOException {
        return SocketFetcher.startTLS(socket, new Properties(), "socket");
    }

    public static Socket startTLS(Socket socket, Properties props, String prefix) throws IOException {
        InetAddress a = socket.getInetAddress();
        String host = a.getHostName();
        return SocketFetcher.startTLS(socket, host, props, prefix);
    }

    public static Socket startTLS(Socket socket, String host, Properties props, String prefix) throws IOException {
        int port = socket.getPort();
        if (debug) {
            System.out.println("DEBUG SocketFetcher: startTLS host " + host + ", port " + port);
        }
        String sfErr = "unknown socket factory";
        try {
            MailSSLSocketFactory msf;
            String sfClass;
            SSLSocketFactory ssf = null;
            SocketFactory sf = null;
            Object sfo = props.get(String.valueOf(prefix) + ".ssl.socketFactory");
            if (sfo instanceof SocketFactory) {
                sf = (SocketFactory)sfo;
                sfErr = "SSL socket factory instance " + sf;
            }
            if (sf == null) {
                sfClass = props.getProperty(String.valueOf(prefix) + ".ssl.socketFactory.class");
                sf = SocketFetcher.getSocketFactory(sfClass);
                sfErr = "SSL socket factory class " + sfClass;
            }
            if (sf != null && sf instanceof SSLSocketFactory) {
                ssf = (SSLSocketFactory)sf;
            }
            if (ssf == null) {
                sfo = props.get(String.valueOf(prefix) + ".socketFactory");
                if (sfo instanceof SocketFactory) {
                    sf = (SocketFactory)sfo;
                    sfErr = "socket factory instance " + sf;
                }
                if (sf == null) {
                    sfClass = props.getProperty(String.valueOf(prefix) + ".socketFactory.class");
                    sf = SocketFetcher.getSocketFactory(sfClass);
                    sfErr = "socket factory class " + sfClass;
                }
                if (sf != null && sf instanceof SSLSocketFactory) {
                    ssf = (SSLSocketFactory)sf;
                }
            }
            if (ssf == null) {
                ssf = (SSLSocketFactory)SSLSocketFactory.getDefault();
                sfErr = "default SSL socket factory";
            }
            socket = ssf.createSocket(socket, host, port, true);
            boolean idCheck = PropUtil.getBooleanProperty(props, String.valueOf(prefix) + ".ssl.checkserveridentity", false);
            if (idCheck) {
                SocketFetcher.checkServerIdentity(host, (SSLSocket)socket);
            }
            if (ssf instanceof MailSSLSocketFactory && !(msf = (MailSSLSocketFactory)ssf).isServerTrusted(host, (SSLSocket)socket)) {
                try {
                    socket.close();
                }
                catch (Throwable throwable) {}
                throw new IOException("Server is not trusted");
            }
            SocketFetcher.configureSSLSocket(socket, props, prefix);
        }
        catch (Exception ex) {
            Throwable t;
            if (ex instanceof InvocationTargetException && (t = ((InvocationTargetException)ex).getTargetException()) instanceof Exception) {
                ex = (Exception)t;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            IOException ioex = new IOException("Exception in startTLS using " + sfErr + ": host, port: " + host + ", " + port + "; Exception: " + ex);
            ioex.initCause(ex);
            throw ioex;
        }
        return socket;
    }

    private static void configureSSLSocket(Socket socket, Properties props, String prefix) {
        if (!(socket instanceof SSLSocket)) {
            return;
        }
        SSLSocket sslsocket = (SSLSocket)socket;
        String protocols = props.getProperty(String.valueOf(prefix) + ".ssl.protocols", null);
        if (protocols != null) {
            sslsocket.setEnabledProtocols(SocketFetcher.stringArray(protocols));
        } else {
            sslsocket.setEnabledProtocols(new String[]{"TLSv1"});
        }
        String ciphers = props.getProperty(String.valueOf(prefix) + ".ssl.ciphersuites", null);
        if (ciphers != null) {
            sslsocket.setEnabledCipherSuites(SocketFetcher.stringArray(ciphers));
        }
        if (debug) {
            System.out.println("DEBUG SocketFetcher: SSL protocols after " + Arrays.asList(sslsocket.getEnabledProtocols()));
            System.out.println("DEBUG SocketFetcher: SSL ciphers after " + Arrays.asList(sslsocket.getEnabledCipherSuites()));
        }
    }

    private static void checkServerIdentity(String server, SSLSocket sslSocket) throws IOException {
        try {
            Certificate[] certChain = sslSocket.getSession().getPeerCertificates();
            if (certChain != null && certChain.length > 0 && certChain[0] instanceof X509Certificate && SocketFetcher.matchCert(server, (X509Certificate)certChain[0])) {
                return;
            }
        }
        catch (SSLPeerUnverifiedException e) {
            sslSocket.close();
            IOException ioex = new IOException("Can't verify identity of server: " + server);
            ioex.initCause(e);
            throw ioex;
        }
        sslSocket.close();
        throw new IOException("Can't verify identity of server: " + server);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean matchCert(String server, X509Certificate cert) {
        if (debug) {
            System.out.println("DEBUG SocketFetcher: matchCert server " + server + ", cert " + cert);
        }
        try {
            Class<?> hnc = Class.forName("sun.security.util.HostnameChecker");
            Method getInstance = hnc.getMethod("getInstance", Byte.TYPE);
            Object hostnameChecker = getInstance.invoke(new Object(), new Byte(2));
            if (debug) {
                System.out.println("DEBUG SocketFetcher: using sun.security.util.HostnameChecker");
            }
            Method match2 = hnc.getMethod("match", String.class, X509Certificate.class);
            try {
                match2.invoke(hostnameChecker, server, cert);
                return true;
            }
            catch (InvocationTargetException cex) {
                if (!debug) return false;
                System.out.println("DEBUG SocketFetcher: FAIL: " + cex);
                return false;
            }
        }
        catch (Exception ex) {
            Matcher m;
            Pattern p;
            if (debug) {
                System.out.println("DEBUG SocketFetcher: NO sun.security.util.HostnameChecker: " + ex);
            }
            try {
                Collection<List<?>> names = cert.getSubjectAlternativeNames();
                p = Pattern.compile("CN=([^,]*)");
                m = p.matcher(cert.getSubjectX500Principal().getName());
                if (names == null) return m.find() && SocketFetcher.matchServer(server, m.group(1).trim());
                boolean foundName = false;
                Iterator<List<?>> it = names.iterator();
                while (true) {
                    if (!it.hasNext()) {
                        if (!foundName) return m.find() && SocketFetcher.matchServer(server, m.group(1).trim());
                        return false;
                    }
                    List<?> nameEnt = it.next();
                    Integer type = (Integer)nameEnt.get(0);
                    if (type != 2) continue;
                    foundName = true;
                    String name = (String)nameEnt.get(1);
                    if (debug) {
                        System.out.println("DEBUG SocketFetcher: found name: " + name);
                    }
                    if (SocketFetcher.matchServer(server, name)) return true;
                }
            }
            catch (CertificateParsingException names) {
                // empty catch block
                p = Pattern.compile("CN=([^,]*)");
                m = p.matcher(cert.getSubjectX500Principal().getName());
                return m.find() && SocketFetcher.matchServer(server, m.group(1).trim());
            }
        }
    }

    private static boolean matchServer(String server, String name) {
        if (debug) {
            System.out.println("DEBUG SocketFetcher: match server " + server + " with " + name);
        }
        if (name.startsWith("*.")) {
            String tail = name.substring(2);
            if (tail.length() == 0) {
                return false;
            }
            int off = server.length() - tail.length();
            if (off < 1) {
                return false;
            }
            return server.charAt(off - 1) == '.' && server.regionMatches(true, off, tail, 0, tail.length());
        }
        return server.equalsIgnoreCase(name);
    }

    private static String[] stringArray(String s) {
        StringTokenizer st = new StringTokenizer(s);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return cl;
            }
        });
    }
}

