/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.LineOutputStream;
import com.sun.mail.util.PropUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.MultipartDataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.SharedInputStream;
import javax.mail.internet.UniqueValue;

public class MimeMultipart
extends Multipart {
    protected DataSource ds = null;
    protected boolean parsed = true;
    private boolean complete = true;
    private String preamble = null;
    private boolean ignoreMissingEndBoundary = true;
    private boolean ignoreMissingBoundaryParameter = true;
    private boolean ignoreExistingBoundaryParameter = false;
    private boolean allowEmpty = false;
    private boolean bmparse = true;

    public MimeMultipart() {
        this("mixed");
    }

    public MimeMultipart(String subtype) {
        String boundary = UniqueValue.getUniqueBoundaryValue();
        ContentType cType = new ContentType("multipart", subtype, null);
        cType.setParameter("boundary", boundary);
        this.contentType = cType.toString();
    }

    public MimeMultipart(DataSource ds) throws MessagingException {
        if (ds instanceof MessageAware) {
            MessageContext mc = ((MessageAware)ds).getMessageContext();
            this.setParent(mc.getPart());
        }
        if (ds instanceof MultipartDataSource) {
            this.setMultipartDataSource((MultipartDataSource)ds);
            return;
        }
        this.parsed = false;
        this.ds = ds;
        this.contentType = ds.getContentType();
    }

    public synchronized void setSubType(String subtype) throws MessagingException {
        ContentType cType = new ContentType(this.contentType);
        cType.setSubType(subtype);
        this.contentType = cType.toString();
    }

    public synchronized int getCount() throws MessagingException {
        this.parse();
        return super.getCount();
    }

    public synchronized BodyPart getBodyPart(int index) throws MessagingException {
        this.parse();
        return super.getBodyPart(index);
    }

    public synchronized BodyPart getBodyPart(String CID) throws MessagingException {
        this.parse();
        int count = this.getCount();
        int i = 0;
        while (i < count) {
            MimeBodyPart part = (MimeBodyPart)this.getBodyPart(i);
            String s = part.getContentID();
            if (s != null && s.equals(CID)) {
                return part;
            }
            ++i;
        }
        return null;
    }

    public boolean removeBodyPart(BodyPart part) throws MessagingException {
        this.parse();
        return super.removeBodyPart(part);
    }

    public void removeBodyPart(int index) throws MessagingException {
        this.parse();
        super.removeBodyPart(index);
    }

    public synchronized void addBodyPart(BodyPart part) throws MessagingException {
        this.parse();
        super.addBodyPart(part);
    }

    public synchronized void addBodyPart(BodyPart part, int index) throws MessagingException {
        this.parse();
        super.addBodyPart(part, index);
    }

    public synchronized boolean isComplete() throws MessagingException {
        this.parse();
        return this.complete;
    }

    public synchronized String getPreamble() throws MessagingException {
        this.parse();
        return this.preamble;
    }

    public synchronized void setPreamble(String preamble) throws MessagingException {
        this.preamble = preamble;
    }

    protected synchronized void updateHeaders() throws MessagingException {
        int i = 0;
        while (i < this.parts.size()) {
            ((MimeBodyPart)this.parts.elementAt(i)).updateHeaders();
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void writeTo(OutputStream os) throws IOException, MessagingException {
        this.parse();
        String boundary = "--" + new ContentType(this.contentType).getParameter("boundary");
        LineOutputStream los = new LineOutputStream(os);
        if (this.preamble != null) {
            byte[] pb = ASCIIUtility.getBytes(this.preamble);
            los.write(pb);
            if (pb.length > 0 && pb[pb.length - 1] != 13 && pb[pb.length - 1] != 10) {
                los.writeln();
            }
        }
        if (this.parts.size() == 0) {
            if (!this.allowEmpty) throw new MessagingException("Empty multipart: " + this.contentType);
            los.writeln(boundary);
            los.writeln();
        } else {
            int i = 0;
            while (i < this.parts.size()) {
                los.writeln(boundary);
                ((MimeBodyPart)this.parts.elementAt(i)).writeTo(os);
                los.writeln();
                ++i;
            }
        }
        los.writeln(String.valueOf(boundary) + "--");
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized void parse() throws MessagingException {
        if (this.parsed) {
            return;
        }
        this.ignoreMissingEndBoundary = PropUtil.getBooleanSystemProperty("mail.mime.multipart.ignoremissingendboundary", true);
        this.ignoreMissingBoundaryParameter = PropUtil.getBooleanSystemProperty("mail.mime.multipart.ignoremissingboundaryparameter", true);
        this.ignoreExistingBoundaryParameter = PropUtil.getBooleanSystemProperty("mail.mime.multipart.ignoreexistingboundaryparameter", false);
        this.allowEmpty = PropUtil.getBooleanSystemProperty("mail.mime.multipart.allowempty", false);
        this.bmparse = PropUtil.getBooleanSystemProperty("mail.mime.multipart.bmparse", true);
        if (this.bmparse) {
            this.parsebm();
            return;
        }
        in = null;
        sin = null;
        start = 0L;
        end = 0L;
        try {
            in = this.ds.getInputStream();
            if (!(in instanceof ByteArrayInputStream || in instanceof BufferedInputStream || in instanceof SharedInputStream)) {
                in = new BufferedInputStream(in);
            }
        }
        catch (Exception ex) {
            throw new MessagingException("No inputstream from datasource", ex);
        }
        if (in instanceof SharedInputStream) {
            sin = (SharedInputStream)in;
        }
        cType = new ContentType(this.contentType);
        boundary = null;
        if (!this.ignoreExistingBoundaryParameter && (bp = cType.getParameter("boundary")) != null) {
            boundary = "--" + bp;
        }
        if (boundary == null && !this.ignoreMissingBoundaryParameter && !this.ignoreExistingBoundaryParameter) {
            throw new MessagingException("Missing boundary parameter");
        }
        try {
            lin = new LineInputStream(in);
            preamblesb = null;
            lineSeparator = null;
            while ((line = lin.readLine()) != null) {
                i = line.length() - 1;
                while (i >= 0) {
                    c = line.charAt(i);
                    if (c != ' ' && c != '\t') break;
                    --i;
                }
                line = line.substring(0, i + 1);
                if (boundary != null) {
                    if (line.equals(boundary)) break;
                    if (line.length() == boundary.length() + 2 && line.startsWith(boundary) && line.endsWith("--")) {
                        line = null;
                        break;
                    }
                } else if (line.startsWith("--") && !line.endsWith("--")) {
                    boundary = line;
                    break;
                }
                if (line.length() <= 0) continue;
                if (lineSeparator == null) {
                    try {
                        lineSeparator = System.getProperty("line.separator", "\n");
                    }
                    catch (SecurityException ex) {
                        lineSeparator = "\n";
                    }
                }
                if (preamblesb == null) {
                    preamblesb = new StringBuffer(line.length() + 2);
                }
                preamblesb.append(line).append(lineSeparator);
            }
            if (preamblesb != null) {
                this.preamble = preamblesb.toString();
            }
            if (line != null) ** GOTO lbl70
            if (this.allowEmpty) {
                return;
            }
            try {
                throw new MessagingException("Missing start boundary");
lbl70:
                // 1 sources

                bndbytes = ASCIIUtility.getBytes(boundary);
                bl = bndbytes.length;
                done = false;
                while (!done) {
                    headers = null;
                    if (sin != null) {
                        start = sin.getPosition();
                        while ((line = lin.readLine()) != null && line.length() > 0) {
                        }
                        if (line == null) {
                            if (!this.ignoreMissingEndBoundary) {
                                throw new MessagingException("missing multipart end boundary");
                            }
                            this.complete = false;
                            break;
                        }
                    } else {
                        headers = this.createInternetHeaders(in);
                    }
                    if (!in.markSupported()) {
                        throw new MessagingException("Stream doesn't support mark");
                    }
                    buf = null;
                    if (sin == null) {
                        buf = new ByteArrayOutputStream();
                    } else {
                        end = sin.getPosition();
                    }
                    bol = true;
                    eol1 = -1;
                    eol2 = -1;
                    while (true) {
                        block53: {
                            block54: {
                                if (!bol) break block53;
                                in.mark(bl + 4 + 1000);
                                i = 0;
                                while (i < bl) {
                                    if (in.read() != (bndbytes[i] & 255)) break;
                                    ++i;
                                }
                                if (i != bl) break block54;
                                b2 = in.read();
                                if (b2 != 45 || in.read() != 45) ** GOTO lbl111
                                this.complete = true;
                                done = true;
                                break;
lbl-1000:
                                // 1 sources

                                {
                                    b2 = in.read();
lbl111:
                                    // 2 sources

                                    ** while (b2 == 32 || b2 == 9)
                                }
lbl112:
                                // 1 sources

                                if (b2 == 10) break;
                                if (b2 == 13) {
                                    in.mark(1);
                                    if (in.read() == 10) break;
                                    in.reset();
                                    break;
                                }
                            }
                            in.reset();
                            if (buf != null && eol1 != -1) {
                                buf.write(eol1);
                                if (eol2 != -1) {
                                    buf.write(eol2);
                                }
                                eol2 = -1;
                                eol1 = -1;
                            }
                        }
                        if ((b = in.read()) < 0) {
                            if (!this.ignoreMissingEndBoundary) {
                                throw new MessagingException("missing multipart end boundary");
                            }
                            this.complete = false;
                            done = true;
                            break;
                        }
                        if (b == 13 || b == 10) {
                            bol = true;
                            if (sin != null) {
                                end = sin.getPosition() - 1L;
                            }
                            eol1 = b;
                            if (b != 13) continue;
                            in.mark(1);
                            b = in.read();
                            if (b == 10) {
                                eol2 = b;
                                continue;
                            }
                            in.reset();
                            continue;
                        }
                        bol = false;
                        if (buf == null) continue;
                        buf.write(b);
                    }
                    part = sin != null ? this.createMimeBodyPart(sin.newStream(start, end)) : this.createMimeBodyPart(headers, buf.toByteArray());
                    super.addBodyPart(part);
                }
            }
            catch (IOException ioex) {
                throw new MessagingException("IO Error", ioex);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException var25_17) {}
        }
        this.parsed = true;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void parsebm() throws MessagingException {
        if (this.parsed) {
            return;
        }
        in = null;
        sin = null;
        start = 0L;
        end = 0L;
        try {
            in = this.ds.getInputStream();
            if (!(in instanceof ByteArrayInputStream || in instanceof BufferedInputStream || in instanceof SharedInputStream)) {
                in = new BufferedInputStream(in);
            }
        }
        catch (Exception ex) {
            throw new MessagingException("No inputstream from datasource", ex);
        }
        if (in instanceof SharedInputStream) {
            sin = (SharedInputStream)in;
        }
        cType = new ContentType(this.contentType);
        boundary = null;
        if (!this.ignoreExistingBoundaryParameter && (bp = cType.getParameter("boundary")) != null) {
            boundary = "--" + bp;
        }
        if (boundary == null && !this.ignoreMissingBoundaryParameter && !this.ignoreExistingBoundaryParameter) {
            throw new MessagingException("Missing boundary parameter");
        }
        try {
            lin = new LineInputStream(in);
            preamblesb = null;
            lineSeparator = null;
            while ((line = lin.readLine()) != null) {
                i = line.length() - 1;
                while (i >= 0) {
                    c = line.charAt(i);
                    if (c != ' ' && c != '\t') break;
                    --i;
                }
                line = line.substring(0, i + 1);
                if (boundary != null) {
                    if (line.equals(boundary)) break;
                    if (line.length() == boundary.length() + 2 && line.startsWith(boundary) && line.endsWith("--")) {
                        line = null;
                        break;
                    }
                } else if (line.startsWith("--") && !line.endsWith("--")) {
                    boundary = line;
                    break;
                }
                if (line.length() <= 0) continue;
                if (lineSeparator == null) {
                    try {
                        lineSeparator = System.getProperty("line.separator", "\n");
                    }
                    catch (SecurityException ex) {
                        lineSeparator = "\n";
                    }
                }
                if (preamblesb == null) {
                    preamblesb = new StringBuffer(line.length() + 2);
                }
                preamblesb.append(line).append(lineSeparator);
            }
            if (preamblesb != null) {
                this.preamble = preamblesb.toString();
            }
            if (line != null) ** GOTO lbl62
            if (this.allowEmpty) {
                return;
            }
            try {
                throw new MessagingException("Missing start boundary");
lbl62:
                // 1 sources

                bndbytes = ASCIIUtility.getBytes(boundary);
                bl = bndbytes.length;
                bcs = new int[256];
                i = 0;
                while (i < bl) {
                    bcs[bndbytes[i]] = i + 1;
                    ++i;
                }
                gss = new int[bl];
                i = bl;
                while (i > 0) {
                    block65: {
                        j = bl - 1;
                        while (j >= i) {
                            if (bndbytes[j] == bndbytes[j - i]) {
                                gss[j - 1] = i;
                                --j;
                                continue;
                            }
                            break block65;
                        }
                        while (j > 0) {
                            gss[--j] = i;
                        }
                    }
                    --i;
                }
                gss[bl - 1] = 1;
                done = false;
                while (!done) {
                    headers = null;
                    if (sin != null) {
                        start = sin.getPosition();
                        while ((line = lin.readLine()) != null && line.length() > 0) {
                        }
                        if (line == null) {
                            if (!this.ignoreMissingEndBoundary) {
                                throw new MessagingException("missing multipart end boundary");
                            }
                            this.complete = false;
                            break;
                        }
                    } else {
                        headers = this.createInternetHeaders(in);
                    }
                    if (!in.markSupported()) {
                        throw new MessagingException("Stream doesn't support mark");
                    }
                    buf = null;
                    if (sin == null) {
                        buf = new ByteArrayOutputStream();
                    } else {
                        end = sin.getPosition();
                    }
                    inbuf = new byte[bl];
                    previnbuf = new byte[bl];
                    inSize = 0;
                    prevSize = 0;
                    first = true;
                    while (true) {
                        block67: {
                            block68: {
                                in.mark(bl + 4 + 1000);
                                eolLen = 0;
                                inSize = MimeMultipart.readFully(in, inbuf, 0, bl);
                                if (inSize < bl) {
                                    if (!this.ignoreMissingEndBoundary) {
                                        throw new MessagingException("missing multipart end boundary");
                                    }
                                    if (sin != null) {
                                        end = sin.getPosition();
                                    }
                                    this.complete = false;
                                    done = true;
                                    break;
                                }
                                i = bl - 1;
                                while (i >= 0) {
                                    if (inbuf[i] != bndbytes[i]) break;
                                    --i;
                                }
                                if (i >= 0) break block67;
                                eolLen = 0;
                                if (!(first || (b = previnbuf[prevSize - 1]) != 13 && b != 10)) {
                                    eolLen = 1;
                                    if (b == 10 && prevSize >= 2 && (b = previnbuf[prevSize - 2]) == 13) {
                                        eolLen = 2;
                                    }
                                }
                                if (!first && eolLen <= 0) break block68;
                                if (sin != null) {
                                    end = sin.getPosition() - (long)bl - (long)eolLen;
                                }
                                if ((b2 = in.read()) != 45 || in.read() != 45) ** GOTO lbl144
                                this.complete = true;
                                done = true;
                                break;
lbl-1000:
                                // 1 sources

                                {
                                    b2 = in.read();
lbl144:
                                    // 2 sources

                                    ** while (b2 == 32 || b2 == 9)
                                }
lbl145:
                                // 1 sources

                                if (b2 == 10) break;
                                if (b2 == 13) {
                                    in.mark(1);
                                    if (in.read() == 10) break;
                                    in.reset();
                                    break;
                                }
                            }
                            i = 0;
                        }
                        if ((skip = Math.max(i + 1 - bcs[inbuf[i] & 127], gss[i])) < 2) {
                            if (sin == null && prevSize > 1) {
                                buf.write(previnbuf, 0, prevSize - 1);
                            }
                            in.reset();
                            this.skipFully(in, 1L);
                            if (prevSize >= 1) {
                                previnbuf[0] = previnbuf[prevSize - 1];
                                previnbuf[1] = inbuf[0];
                                prevSize = 2;
                            } else {
                                previnbuf[0] = inbuf[0];
                                prevSize = 1;
                            }
                        } else {
                            if (prevSize > 0 && sin == null) {
                                buf.write(previnbuf, 0, prevSize);
                            }
                            prevSize = skip;
                            in.reset();
                            this.skipFully(in, prevSize);
                            tmp = inbuf;
                            inbuf = previnbuf;
                            previnbuf = tmp;
                        }
                        first = false;
                    }
                    if (sin != null) {
                        part = this.createMimeBodyPart(sin.newStream(start, end));
                    } else {
                        if (prevSize - eolLen > 0) {
                            buf.write(previnbuf, 0, prevSize - eolLen);
                        }
                        if (!this.complete && inSize > 0) {
                            buf.write(inbuf, 0, inSize);
                        }
                        part = this.createMimeBodyPart(headers, buf.toByteArray());
                    }
                    super.addBodyPart(part);
                }
            }
            catch (IOException ioex) {
                throw new MessagingException("IO Error", ioex);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException var31_17) {}
        }
        this.parsed = true;
    }

    private static int readFully(InputStream in, byte[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int total = 0;
        while (len > 0) {
            int bsize = in.read(buf, off, len);
            if (bsize <= 0) break;
            off += bsize;
            total += bsize;
            len -= bsize;
        }
        return total > 0 ? total : -1;
    }

    private void skipFully(InputStream in, long offset) throws IOException {
        while (offset > 0L) {
            long cur = in.skip(offset);
            if (cur <= 0L) {
                throw new EOFException("can't skip");
            }
            offset -= cur;
        }
    }

    protected InternetHeaders createInternetHeaders(InputStream is) throws MessagingException {
        return new InternetHeaders(is);
    }

    protected MimeBodyPart createMimeBodyPart(InternetHeaders headers, byte[] content) throws MessagingException {
        return new MimeBodyPart(headers, content);
    }

    protected MimeBodyPart createMimeBodyPart(InputStream is) throws MessagingException {
        return new MimeBodyPart(is);
    }
}

