/*
 * Decompiled with CFR 0.152.
 */
package local.ua;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import local.ua.AMap;
import local.ua.DialOutRuleSet;
import local.ua.SkypeUA;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthMap {
    private Vector<DialOutRuleSet> skypeOutRules = null;
    private Vector<DialOutRuleSet> sipOutRules = null;
    private Vector sipSkypeAuthMap = null;
    private Hashtable skypeSipAuthMap = null;
    private Logger log = Logger.getLogger(this.getClass());
    private String RulePairSplitDelim = ":";

    public static void main(String[] args) {
        PropertyConfigurator.configure("log.properties");
        AuthMap test = new AuthMap("SipToSkypeAuth.props", "SkypeToSipAuth.props", "SkypeOutDialingRules.props", "SipOutDialingRules.props");
        test.test();
    }

    public AuthMap(String argSipToSkypeFile, String argSkypeToSipFile, String argSkypeOutDialingRules, String argSipOutDialingRules) {
        this.sipSkypeAuthMap = this.loadSipSkypeAuthMap(argSipToSkypeFile);
        this.sipOutRules = this.loadSipOutRules(argSipOutDialingRules);
        this.skypeSipAuthMap = this.loadSkypeSipAuthMap(argSkypeToSipFile);
        this.skypeOutRules = this.loadSkypeOutRules(argSkypeOutDialingRules);
    }

    private void test() {
        this.log = Logger.getLogger(this.getClass().getName());
        this.sipSkypeAuthMap = this.loadSipSkypeAuthMap("SipToSkypeAuth.props");
        String dest = this.getSkypeDest("sip:<15615555553@sipphone.com>", "192.168.1.220", "sip:<11@192.168.0.4>");
        this.log.info("Dest=" + dest);
        this.log.info("FilteredDest=" + this.skypeOutFilter(dest) + "\n");
        dest = this.getSkypeDest("sip:<15615555554@sipphone.com>", "192.168.1.220", "sip:<11@192.168.0.4>");
        this.log.info("Dest=" + dest);
        this.log.info("FilteredDest=" + this.skypeOutFilter(dest) + "\n");
        dest = this.getSkypeDest("sip:<15615555555@sipphone.com>", "192.168.1.220", "sip:<11@192.168.0.4>");
        this.log.info("Dest=" + dest);
        this.log.info("FilteredDest=" + this.skypeOutFilter(dest) + "\n");
        dest = this.getSkypeDest("sip:<15615555556@sipphone.com>", "192.168.1.220", "sip:<11@192.168.0.4>");
        this.log.info("Dest=" + dest);
        this.log.info("FilteredDest=" + this.skypeOutFilter(dest) + "\n");
        dest = this.getSkypeDest("sip:<1561555321@sipphone.com>", "192.168.1.220", "sip:<11@192.168.0.4>");
        this.log.info("Dest=" + dest);
        this.log.info("FilteredDest=" + this.skypeOutFilter(dest) + "\n");
        dest = this.getSkypeDest("sip:<1561555321@sipphone.com>", "192.168.2.220", "sip:<11@192.168.0.4>");
        this.log.info("Dest=" + dest);
        this.log.info("FilteredDest=" + this.skypeOutFilter(dest) + "\n");
        dest = this.getSkypeDest("sip:<15614443333@sip.vonics.net>", "192.168.1.220", "sip:<13@192.168.0.4>");
        this.log.info("Dest=" + dest);
        this.log.info("FilteredDest=" + this.skypeOutFilter(dest) + "\n");
        dest = this.getSkypeDest("sip:<15614443333@sip.vonics.net>", "192.168.1.220", "sip:<01234567@192.168.0.4>");
        this.log.info("Dest=" + dest);
        this.log.info("FilteredDest=" + this.skypeOutFilter(dest) + "\n");
        dest = this.getSkypeDest("sip:<15614443333@sip.vonics.net>", "192.168.1.220", "sip:<05611234567@192.168.0.4>");
        this.log.info("Dest=" + dest);
        this.log.info("FilteredDest=" + this.skypeOutFilter(dest) + "\n");
        dest = this.getSkypeDest("sip:<15614443333@sip.vonics.net>", "192.168.1.220", "sip:<015611234567@192.168.0.4>");
        this.log.info("Dest=" + dest);
        this.log.info("FilteredDest=" + this.skypeOutFilter(dest) + "\n");
        dest = this.getSkypeDest("sip:<15614443333@sip.vonics.net>", "192.168.1.220", "sip:<0244445555@192.168.0.4>");
        this.log.info("Dest=" + dest);
        this.log.info("FilteredDest=" + this.skypeOutFilter(dest) + "\n");
        dest = "55";
        this.log.info("Dest=" + dest);
        this.log.info("FilteredSIPDest=" + this.sipOutFilter(dest) + "\n");
        dest = "4325555";
        this.log.info("Dest=" + dest);
        this.log.info("FilteredSIPDest=" + this.sipOutFilter(dest) + "\n");
    }

    private Vector<AMap> loadSipSkypeAuthMap(String argMapFile) {
        Vector<AMap> map = new Vector<AMap>();
        try {
            String curLine;
            FileReader in = new FileReader(argMapFile);
            BufferedReader br = new BufferedReader(in);
            while ((curLine = br.readLine()) != null) {
                if (curLine.trim().length() <= 0 || curLine.startsWith("#")) continue;
                String[] parms = curLine.split(",", 4);
                try {
                    map.add(new AMap(parms[0].toLowerCase().replaceAll("\\x2a.*$", "").trim(), parms[1].toLowerCase().replaceAll("\\x2a.*$", "").trim(), parms[2].toLowerCase().replaceAll("\\x2a.*$", "").trim(), parms[3].replaceAll("//.*$", "").trim()));
                }
                catch (Exception e) {
                    this.log.error("loadSipSkypeAuthMap: Rule: \"" + curLine + "\" invalid - ", e);
                }
            }
            br.close();
            in.close();
            if (map.size() < 1) {
                throw new Exception("No SipToSkype Authorizations Found.");
            }
        }
        catch (Exception e) {
            this.log.fatal("Error with file:" + argMapFile, e);
            System.exit(SkypeUA.ExitCode.INITFAIL.code());
        }
        return map;
    }

    public String getSkypeDest(String callerSipCID, String sipCIP, String sipDest) {
        Pattern realmPat = Pattern.compile("@([^>:]+)\\b", 2);
        Pattern sipidPat = Pattern.compile("sip:<?([^@<]+)@", 2);
        Matcher cuidMat = sipidPat.matcher(callerSipCID);
        String callUID = null;
        if (!cuidMat.find()) {
            return null;
        }
        callUID = cuidMat.group(1);
        Matcher realmMat = realmPat.matcher(callerSipCID);
        String callRealm = null;
        if (!realmMat.find()) {
            return null;
        }
        callRealm = realmMat.group(1);
        this.log.debug("map SipCallerID=" + callUID + " realm:" + callRealm + " IP:" + sipCIP + " Dest:" + sipDest);
        String dest = null;
        for (AMap thisMap : this.sipSkypeAuthMap) {
            String[] tmp;
            int tmp2;
            boolean sipCIPisLocalNet = false;
            if (sipCIP.startsWith("10.") || sipCIP.startsWith("127.") || sipCIP.startsWith("192.168.") || sipCIP.startsWith("169.254.")) {
                sipCIPisLocalNet = true;
            } else if (sipCIP.startsWith("172.") && (tmp2 = Integer.parseInt((tmp = sipCIP.split("\\."))[1])) >= 16 && tmp2 <= 31) {
                sipCIPisLocalNet = true;
            }
            if (thisMap.callerUserId.length() != 0 && !thisMap.callerUserId.equals(callUID) || thisMap.realm.length() != 0 && !thisMap.realm.equals(callRealm) || thisMap.ip.length() != 0 && !sipCIP.startsWith(thisMap.ip) && (!thisMap.ip.equalsIgnoreCase("localnet") || !sipCIPisLocalNet)) continue;
            this.log.debug("match=" + thisMap.callerUserId + ":" + thisMap.realm + ":" + thisMap.ip);
            dest = thisMap.dest;
            if (dest.toLowerCase().equals("deny")) {
                this.log.debug("Blocked Caller");
                dest = null;
            } else if (dest.toLowerCase().equals("calleeid")) {
                Matcher duidMat = sipidPat.matcher(sipDest);
                if (!duidMat.find()) {
                    this.log.debug("No Destination");
                    dest = null;
                } else {
                    dest = duidMat.group(1);
                }
            } else if (dest.length() == 0) {
                this.log.debug("No Destination");
                dest = null;
            }
            return dest;
        }
        this.log.debug("UnAuthorized Caller");
        return null;
    }

    private Hashtable<String, String> loadSkypeSipAuthMap(String argMapFile) {
        Hashtable<String, String> map = new Hashtable<String, String>();
        try {
            String curLine;
            FileReader in = new FileReader(argMapFile);
            BufferedReader br = new BufferedReader(in);
            while ((curLine = br.readLine()) != null) {
                if (curLine.trim().length() <= 0 || curLine.startsWith("#")) continue;
                String[] parms = curLine.split(",");
                String key = parms[0].toLowerCase().trim();
                map.put(key, parms[1].replaceAll("//.*$", "").trim());
            }
            br.close();
            in.close();
            if (map.size() < 1) {
                throw new Exception("No SkypeToSip Authorizations Found.");
            }
        }
        catch (Exception e) {
            this.log.fatal("Error with file:" + argMapFile, e);
            System.exit(SkypeUA.ExitCode.INITFAIL.code());
        }
        return map;
    }

    public String getSipDest(String callerSkypeId) {
        this.log.debug("mapSkypeCaller=" + callerSkypeId);
        String dest = null;
        String[] keys = new String[2];
        int s = 0;
        keys[s++] = callerSkypeId;
        keys[s++] = "*";
        int k = 0;
        while (k < keys.length) {
            if (this.skypeSipAuthMap.containsKey(keys[k])) {
                dest = this.skypeSipAuthMap.get(keys[k]).toString();
                if (dest.toLowerCase().equals("deny")) {
                    this.log.info("Blocked Caller");
                    return null;
                }
                return dest;
            }
            ++k;
        }
        this.log.info("UnAuthorized Caller");
        return null;
    }

    private Vector<DialOutRuleSet> loadSkypeOutRules(String argRulesFile) {
        Vector<DialOutRuleSet> retvar = new Vector<DialOutRuleSet>();
        try {
            String curLine;
            FileReader in = new FileReader(argRulesFile);
            BufferedReader br = new BufferedReader(in);
            while ((curLine = br.readLine()) != null) {
                if (curLine.trim().length() <= 0 || curLine.startsWith("#")) continue;
                String[] rulePair = curLine.split(this.RulePairSplitDelim);
                try {
                    DialOutRuleSet rs = new DialOutRuleSet(Pattern.compile(rulePair[0].trim()), rulePair[1].trim());
                    retvar.add(rs);
                }
                catch (Exception e) {
                    this.log.error("loadSkypeOutRules: Rule: \"" + curLine + "\" invalid - ", e);
                }
            }
            br.close();
            in.close();
        }
        catch (Exception e) {
            this.log.fatal("Error with file:" + argRulesFile, e);
            System.exit(SkypeUA.ExitCode.INITFAIL.code());
        }
        return retvar;
    }

    public String skypeOutFilter(String dest) {
        int r = 0;
        while (r < this.skypeOutRules.size()) {
            DialOutRuleSet rs = this.skypeOutRules.get(r);
            Matcher mat = rs.pattern.matcher(dest);
            if (mat.find()) {
                dest = mat.replaceAll(rs.replacement);
                break;
            }
            ++r;
        }
        return dest;
    }

    private Vector<DialOutRuleSet> loadSipOutRules(String argRulesFile) {
        Vector<DialOutRuleSet> retvar = new Vector<DialOutRuleSet>();
        try {
            String curLine;
            FileReader in = new FileReader(argRulesFile);
            BufferedReader br = new BufferedReader(in);
            while ((curLine = br.readLine()) != null) {
                if (curLine.trim().length() <= 0 || curLine.startsWith("#")) continue;
                String[] rulePair = this.parmSplitter(curLine);
                try {
                    DialOutRuleSet rs = new DialOutRuleSet(Pattern.compile(rulePair[0].trim()), rulePair[1].trim());
                    retvar.add(rs);
                }
                catch (Exception e) {
                    this.log.error("loadSipOutRules: Rule: \"" + curLine + "\" invalid - ", e);
                }
            }
            br.close();
            in.close();
        }
        catch (Exception e) {
            this.log.fatal("Error with file:" + argRulesFile, e);
            System.exit(SkypeUA.ExitCode.INITFAIL.code());
        }
        return retvar;
    }

    private String[] parmSplitter(String curLine) {
        int pos = curLine.indexOf(this.RulePairSplitDelim);
        String[] retvar = new String[]{"", ""};
        retvar[0] = curLine.substring(0, pos);
        retvar[1] = curLine.substring(pos + 1);
        return retvar;
    }

    public String sipOutFilter(String dest) {
        int r = 0;
        while (r < this.sipOutRules.size()) {
            DialOutRuleSet rs = this.sipOutRules.get(r);
            Matcher mat = rs.pattern.matcher(dest);
            if (mat.find()) {
                dest = mat.replaceAll(rs.replacement);
                break;
            }
            ++r;
        }
        return dest;
    }
}

