/*
 * Decompiled with CFR 0.152.
 */
package local.ua;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import local.ua.SkypeUA;

public class BasicInstaller {
    private String configFiles = "siptosis.cfg,SipToSkypeAuth.props,SkypeToSipAuth.props,SkypeOutDialingRules.props,SipOutDialingRules.props";
    private String configSrcFiles = "siptosis.cfg,SipToSkypeAuth.props,SkypeToSipAuth.props,SkypeOutDialingRules.props,SipOutDialingRules.props";
    private String fileSrcSizes = "-1,-1,-1,-1,-1";
    BufferedWriter logStream = null;

    BasicInstaller(int bitSize) {
        String osName = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        if (osName.indexOf("windows") >= 0) {
            this.configFiles = String.valueOf(this.configFiles) + ",skype.dll";
            if (bitSize == 64) {
                this.configSrcFiles = String.valueOf(this.configSrcFiles) + ",skype_x64.dll";
                this.fileSrcSizes = String.valueOf(this.fileSrcSizes) + "," + new File("samples/skype_x64.dll").length();
            } else {
                this.configSrcFiles = String.valueOf(this.configSrcFiles) + ",skype.dll";
                this.fileSrcSizes = String.valueOf(this.fileSrcSizes) + "," + new File("samples/skype.dll").length();
            }
        } else if (osName.indexOf("linux") >= 0) {
            this.configFiles = String.valueOf(this.configFiles) + ",libskype.so";
            if (bitSize == 64) {
                if (arch.startsWith("amd")) {
                    this.configSrcFiles = String.valueOf(this.configSrcFiles) + ",libskype_x64.so";
                    this.fileSrcSizes = String.valueOf(this.fileSrcSizes) + ",-1";
                } else {
                    this.configSrcFiles = String.valueOf(this.configSrcFiles) + ",libskype_x64.so";
                    this.fileSrcSizes = String.valueOf(this.fileSrcSizes) + ",-1";
                }
            } else {
                this.configSrcFiles = String.valueOf(this.configSrcFiles) + ",libskype.so";
                this.fileSrcSizes = String.valueOf(this.fileSrcSizes) + ",-1";
            }
        } else if (osName.indexOf("mac os x") >= 0) {
            this.configFiles = String.valueOf(this.configFiles) + ",libskype.jnilib";
            this.configSrcFiles = String.valueOf(this.configSrcFiles) + ",libskype.jnilib";
            this.fileSrcSizes = String.valueOf(this.fileSrcSizes) + ",-1";
        } else {
            this.log("Unsupported platform: " + osName);
            System.exit(1);
        }
        if (!this.installed()) {
            this.log("Performing basic installation for: " + osName + " " + bitSize + " bit system.");
            if (osName.indexOf("mac os x") >= 0) {
                this.doCommand("cp -r -u samples/osx_framework/Skype.framework /Skype.framework");
            }
            if (!this.doInstall()) {
                System.exit(SkypeUA.ExitCode.STARTERROR.code());
            }
        }
        this.closeLog();
    }

    private boolean installed() {
        String[] checkList = this.configFiles.split(",");
        String[] srcSizeList = this.fileSrcSizes.split(",");
        int i = 0;
        while (i < checkList.length) {
            File file = new File(checkList[i]);
            int chkSize = Integer.parseInt(srcSizeList[i]);
            if (!file.exists() || chkSize > 0 && file.length() != (long)chkSize) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean doInstall() {
        String[] checkList = this.configFiles.split(",");
        String[] srcList = this.configSrcFiles.split(",");
        String[] srcSizeList = this.fileSrcSizes.split(",");
        int i = 0;
        while (i < checkList.length) {
            File file = new File(checkList[i]);
            int chkSize = Integer.parseInt(srcSizeList[i]);
            if (!file.exists() || chkSize > 0 && file.length() != (long)chkSize) {
                if (!this.copyFile("samples/" + srcList[i], "./" + checkList[i])) {
                    this.log("Failed to copy: samples/" + srcList[i] + " to: ./" + checkList[i]);
                } else {
                    this.log("Copied: samples/" + srcList[i] + " to: ./" + checkList[i]);
                }
            }
            ++i;
        }
        return true;
    }

    private boolean copyFile(String srcFile, String destFile) {
        try {
            int theChar;
            File sourceFile = new File(srcFile);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile), 4096);
            File targetFile = new File(destFile);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(targetFile), 4096);
            while ((theChar = bis.read()) != -1) {
                bos.write(theChar);
            }
            bos.close();
            bis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private void log(String msg) {
        System.out.println(msg);
        try {
            if (this.logStream == null) {
                this.logStream = new BufferedWriter(new FileWriter("install.log"));
                this.logStream.write(String.valueOf(new Date().toString()) + "\r\n");
            }
            this.logStream.write(String.valueOf(msg) + "\r\n");
        }
        catch (Exception e) {
            System.exit(SkypeUA.ExitCode.FATALERROR.code());
        }
    }

    private void closeLog() {
        try {
            if (this.logStream != null) {
                this.logStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean doCommand(String strCmd) {
        BufferedReader br = null;
        try {
            String line;
            String[] myArgs = strCmd.split(" ");
            ProcessBuilder processB = new ProcessBuilder(myArgs);
            processB.redirectErrorStream(true);
            Process process = processB.start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            StringBuffer lineBuf = new StringBuffer();
            while ((line = br.readLine()) != null) {
                if (lineBuf.length() > 0) {
                    lineBuf.append("\r\n");
                }
                lineBuf.append(line);
            }
            if (lineBuf.length() > 0) {
                if (lineBuf.toString().contains("An unexpected error")) {
                    this.log("An unexpected error occurred");
                } else {
                    this.log(lineBuf.toString());
                }
            }
            br.close();
            process.waitFor();
            if (process.exitValue() == 0) {
                return true;
            }
        }
        catch (Exception err) {
            try {
                br.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            err.printStackTrace();
            this.log("Error running command");
        }
        return false;
    }
}

