/*
 * Decompiled with CFR 0.152.
 */
package local.ua;

import com.skype.Call;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CallHistoryEntry {
    Call.Type callType;
    String callId;
    String callTo;
    String callFrom;
    Date startTime;
    long durationSeconds = 0L;
    String callCost;

    CallHistoryEntry() {
    }

    CallHistoryEntry(CallHistoryEntry src) {
        this.callType = src.callType;
        this.callId = src.callId;
        this.callFrom = src.callFrom;
        this.callTo = src.callTo;
        this.startTime = src.startTime;
        this.durationSeconds = src.durationSeconds;
        this.callCost = src.callCost;
    }

    CallHistoryEntry(Call.Type argCallType, String argCallId, String argCallFrom, String argCallTo, Date argStartTime, int argDurationSeconds, String argCallCost) {
        this.callType = argCallType;
        this.callId = argCallId;
        this.callFrom = argCallFrom;
        this.callTo = argCallTo;
        this.startTime = argStartTime;
        this.durationSeconds = argDurationSeconds;
        this.callCost = argCallCost;
    }

    CallHistoryEntry(String csvEntry) throws Exception {
        String tmp = String.valueOf(csvEntry) + " ";
        String[] entry = tmp.split(",");
        this.callType = Call.Type.valueOf(entry[0]);
        this.callId = entry[1];
        this.callFrom = entry[2];
        this.callTo = entry[3];
        this.startTime = new SimpleDateFormat("yyyyMMdd HH:mm:ss").parse(entry[4]);
        this.durationSeconds = Long.parseLong(entry[5]);
        this.callCost = entry[6].trim();
    }

    public String toString() {
        String tmpTime = "";
        if (this.startTime != null) {
            tmpTime = new SimpleDateFormat("yyyyMMdd HH:mm:ss").format(this.startTime);
        }
        return String.valueOf(this.callType.toString()) + "," + this.callId + "," + this.callFrom.replaceAll(",", "") + "," + this.callTo.replaceAll(",", "") + "," + tmpTime + "," + this.durationSeconds + "," + this.callCost;
    }
}

